/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.IBinder;
import android.os.NetworkOnMainThreadException;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.measurement.zzcm;
import com.google.android.gms.internal.measurement.zzco;
import com.google.android.gms.internal.measurement.zzcq;
import com.google.android.gms.internal.measurement.zzcr;
import com.google.android.gms.internal.measurement.zzda;
import com.google.android.gms.internal.measurement.zzdf;
import com.google.android.gms.internal.measurement.zzdh;
import com.google.android.gms.internal.measurement.zzdi;
import com.google.android.gms.internal.measurement.zzdj;
import com.google.android.gms.internal.measurement.zzdk;
import com.google.android.gms.internal.measurement.zzdl;
import com.google.android.gms.internal.measurement.zzdm;
import com.google.android.gms.internal.measurement.zzdn;
import com.google.android.gms.internal.measurement.zzdo;
import com.google.android.gms.internal.measurement.zzdp;
import com.google.android.gms.internal.measurement.zzdq;
import com.google.android.gms.internal.measurement.zzdr;
import com.google.android.gms.internal.measurement.zzds;
import com.google.android.gms.internal.measurement.zzdt;
import com.google.android.gms.internal.measurement.zzdv;
import com.google.android.gms.internal.measurement.zzdw;
import com.google.android.gms.internal.measurement.zzdx;
import com.google.android.gms.internal.measurement.zzdy;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzea;
import com.google.android.gms.internal.measurement.zzeb;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzed;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzeg;
import com.google.android.gms.internal.measurement.zzeh;
import com.google.android.gms.internal.measurement.zzei;
import com.google.android.gms.internal.measurement.zzej;
import com.google.android.gms.internal.measurement.zzek;
import com.google.android.gms.internal.measurement.zzel;
import com.google.android.gms.internal.measurement.zzem;
import com.google.android.gms.internal.measurement.zzen;
import com.google.android.gms.internal.measurement.zzeo;
import com.google.android.gms.internal.measurement.zzep;
import com.google.android.gms.internal.measurement.zzeq;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzes;
import com.google.android.gms.internal.measurement.zzfa;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import com.google.android.gms.measurement.internal.zzhu;
import com.google.android.gms.measurement.internal.zzjp;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzlt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class zzfb {
    private static volatile zzfb zzc;
    private final String zzd;
    protected final Clock zza;
    protected final ExecutorService zzb;
    private final AppMeasurementSdk zze;
    @GuardedBy(value="listenerList")
    private final List zzf;
    private int zzg;
    private boolean zzh;
    private final String zzi;
    private volatile zzcr zzj;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static zzfb zza(Context context, Bundle bundle) {
        Preconditions.checkNotNull((Object)context);
        if (zzc != null) return zzc;
        Class<zzfb> clazz = zzfb.class;
        synchronized (clazz) {
            zzfb zzfb2 = zzc;
            if (zzfb2 != null) return zzc;
            zzc = new zzfb(context, bundle);
            return zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final AppMeasurementSdk zzb() {
        return this.zze;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected zzfb(Context context, Bundle bundle) {
        block5: {
            this.zzd = "FA";
            this.zza = DefaultClock.getInstance();
            zzcm.zza();
            Object object = new zzed(this);
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)object);
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            this.zzb = Executors.unconfigurableExecutorService(threadPoolExecutor);
            this.zze = new AppMeasurementSdk(this);
            this.zzf = new ArrayList();
            try {
                object = zzhu.zza((Context)context);
                object = zzlt.zza((Context)context, (String)"google_app_id", (String)object);
                if (object == null) break block5;
            }
            catch (IllegalStateException illegalStateException) {}
            try {
                Class.forName("com.google.firebase.analytics.FirebaseAnalytics", false, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.zzi = null;
                this.zzh = true;
                Log.w((String)this.zzd, (String)"Disabling data collection. Found google_app_id in strings.xml but Google Analytics for Firebase is missing. Add Google Analytics for Firebase to resume data collection.");
                return;
            }
        }
        this.zzi = "fa";
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzdr(zzfb2, context, bundle));
        context = (Application)context.getApplicationContext();
        if (context == null) {
            Log.w((String)this.zzd, (String)"Unable to register lifecycle notifications. Application null.");
            return;
        }
        context.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzfa(this));
    }

    private final void zzS(zzeq zzeq2) {
        this.zzb.execute(zzeq2);
    }

    /*
     * Unable to fully structure code
     */
    protected final zzcr zzc(Context var1_1, boolean var2_3) {
        if (var2_3) {
            var2_4 = DynamiteModule.PREFER_HIGHEST_OR_LOCAL_VERSION;
lbl4:
            // 2 sources

            while (true) {
                var1_1 = DynamiteModule.load((Context)var1_1, (DynamiteModule.VersionPolicy)var2_4, (String)"com.google.android.gms.measurement.dynamite").instantiate("com.google.android.gms.measurement.internal.AppMeasurementDynamiteService");
                this = zzcq.asInterface((IBinder)var1_1);
                return this;
            }
        }
        try {
            var2_4 = DynamiteModule.PREFER_LOCAL;
            ** continue;
        }
        catch (DynamiteModule.LoadingException var1_2) {
            this.zzT((Exception)var1_2, true, false);
            return null;
        }
    }

    private final void zzT(Exception exception, boolean bl, boolean bl2) {
        this.zzh |= bl;
        if (bl) {
            Log.w((String)this.zzd, (String)"Data collection startup failed. No data will be collected.", (Throwable)exception);
            return;
        }
        String string = "Error with data collection. Data lost.";
        if (bl2) {
            this.zzD(5, string, exception, null, null);
        }
        Log.w((String)this.zzd, (String)string, (Throwable)exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzd(zzjp zzjp2) {
        zzer zzer2 = new zzer(zzjp2);
        if (this.zzj != null) {
            try {
                this.zzj.setEventInterceptor((zzda)zzer2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzd, (String)"Failed to set event interceptor on calling thread. Trying again on the dynamite thread.");
            }
        }
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzel(zzfb2, zzer2));
    }

    public final void zze(Intent intent) {
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzem(zzfb2, intent));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzf(zzjq zzjq2) {
        int n;
        Preconditions.checkNotNull((Object)zzjq2);
        List list = this.zzf;
        // MONITORENTER : list
        for (int i = 0; i < (n = list.size()); ++i) {
            n = zzjq2.equals(((Pair)list.get((int)i)).first) ? 1 : 0;
            if (n == 0) continue;
            Log.w((String)this.zzd, (String)"OnEventListener already registered.");
            // MONITOREXIT : list
            return;
        }
        zzes zzes2 = new zzes(zzjq2);
        list.add(new Pair((Object)zzjq2, (Object)zzes2));
        // MONITOREXIT : list
        if (this.zzj != null) {
            try {
                this.zzj.registerOnMeasurementEventListener((zzda)zzes2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzd, (String)"Failed to register event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzen(zzfb2, zzes2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzg(zzjq object) {
        List list;
        block8: {
            int n;
            Preconditions.checkNotNull((Object)object);
            list = this.zzf;
            // MONITORENTER : list
            for (int i = 0; i < (n = list.size()); ++i) {
                n = object.equals(((Pair)list.get((int)i)).first) ? 1 : 0;
                if (n == 0) continue;
                object = (Pair)list.get(i);
                break block8;
            }
            object = null;
        }
        if (object == null) {
            Log.w((String)this.zzd, (String)"OnEventListener had not been registered.");
            // MONITOREXIT : list
            return;
        }
        list.remove(object);
        object = (zzes)((Object)object.second);
        // MONITOREXIT : list
        if (this.zzj != null) {
            try {
                this.zzj.unregisterOnMeasurementEventListener((zzda)object);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzd, (String)"Failed to unregister event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzeo(zzfb2, (zzes)((Object)object)));
    }

    public final void zzh(@NonNull String string, Bundle bundle) {
        this.zzU(null, string, bundle, false, true, null);
    }

    public final void zzi(String string, String string2, Bundle bundle) {
        this.zzU(string, string2, bundle, true, true, null);
    }

    public final void zzj(String string, String string2, Bundle bundle, long l) {
        this.zzU(string, string2, bundle, true, false, l);
    }

    private final void zzU(String string, String string2, Bundle bundle, boolean bl, boolean bl2, Long l) {
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzep(zzfb2, l, string, string2, bundle, bl, bl2));
    }

    public final void zzk(String string, String string2, Object object, boolean bl) {
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzdh(zzfb2, string, string2, object, bl));
    }

    public final void zzl(Bundle bundle) {
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzdi(zzfb2, bundle));
    }

    public final void zzm(String string, String string2, Bundle bundle) {
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzdj(zzfb2, string, string2, bundle));
    }

    public final List zzn(String string, String string2) {
        zzco zzco2 = new zzco();
        zzfb zzfb2 = list;
        zzfb2.zzS(new zzdk(zzfb2, string, string2, zzco2));
        List list = (List)zzco.zzf((Bundle)zzco2.zze(5000L), List.class);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public final void zzo(String string) {
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzdl(zzfb2, string));
    }

    public final void zzp(zzdf zzdf2, String string, String string2) {
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzdm(zzfb2, zzdf2, string, string2));
    }

    public final void zzq(Boolean bl) {
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzdn(zzfb2, bl));
    }

    public final void zzr(Bundle bundle) {
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzdo(zzfb2, bundle));
    }

    public final void zzs() {
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzdp(zzfb2));
    }

    public final void zzt(long l) {
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzdq(zzfb2, l));
    }

    public final void zzu(String string) {
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzds(zzfb2, string));
    }

    public final void zzv(String string) {
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzdt(zzfb2, string));
    }

    public final void zzw(Runnable runnable) {
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzdv(zzfb2, runnable));
    }

    public final String zzx() {
        zzco zzco2 = new zzco();
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzdw(zzfb2, zzco2));
        return zzco2.zzc(500L);
    }

    public final String zzy() {
        zzco zzco2 = new zzco();
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzdx(zzfb2, zzco2));
        return zzco2.zzc(50L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final long zzz() {
        Object object = new zzco();
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzdy(zzfb2, (zzco)object));
        object = object.zzd(500L);
        if (object != null) return (Long)object;
        object = this.zza;
        return new Random(System.nanoTime() ^ object.currentTimeMillis()).nextLong() + (long)(++this.zzg);
    }

    public final String zzA() {
        zzco zzco2 = new zzco();
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzdz(zzfb2, zzco2));
        return zzco2.zzc(500L);
    }

    public final String zzB() {
        zzco zzco2 = new zzco();
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzea(zzfb2, zzco2));
        return zzco2.zzc(500L);
    }

    public final Map zzC(String hashMap, String object, boolean bl) {
        Object object2 = new zzco();
        zzfb zzfb2 = zzfb3;
        zzfb2.zzS(new zzeb(zzfb2, (String)((Object)hashMap), (String)object, bl, (zzco)object2));
        zzfb zzfb3 = object2.zze(5000L);
        if (zzfb3 == null || zzfb3.size() == 0) {
            return Collections.emptyMap();
        }
        hashMap = new HashMap<String, zzco>(zzfb3.size());
        for (String string : zzfb3.keySet()) {
            object2 = zzfb3.get(string);
            if (!(object2 instanceof Double) && !(object2 instanceof Long) && !(object2 instanceof String)) continue;
            hashMap.put(string, (zzco)object2);
        }
        return hashMap;
    }

    public final void zzD(int n, String string, Object object, Object object2, Object object3) {
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzec(zzfb2, false, 5, string, object, null, null));
    }

    public final Bundle zzE(Bundle bundle, boolean bl) {
        zzco zzco2 = new zzco();
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzee(zzfb2, bundle, zzco2));
        if (bl) {
            return zzco2.zze(5000L);
        }
        return null;
    }

    public final int zzF(String string) {
        zzco zzco2 = new zzco();
        zzfb zzfb2 = n;
        zzfb2.zzS(new zzef(zzfb2, string, zzco2));
        Integer n = (Integer)zzco.zzf((Bundle)zzco2.zze(10000L), Integer.class);
        if (n == null) {
            return 25;
        }
        return n;
    }

    @WorkerThread
    public final String zzG() {
        zzco zzco2 = new zzco();
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzeg(zzfb2, zzco2));
        return zzco2.zzc(120000L);
    }

    @WorkerThread
    public final Long zzH() {
        zzco zzco2 = new zzco();
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzeh(zzfb2, zzco2));
        return zzco2.zzd(120000L);
    }

    public final String zzI() {
        return this.zzi;
    }

    public final Object zzJ(int n) {
        zzco zzco2 = new zzco();
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzei(zzfb2, zzco2, n));
        return zzco.zzf((Bundle)zzco2.zze(15000L), Object.class);
    }

    public final void zzK(boolean bl) {
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzej(zzfb2, bl));
    }

    public final void zzL(Bundle bundle) {
        zzfb zzfb2 = this;
        zzfb2.zzS(new zzek(zzfb2, bundle));
    }

    final /* synthetic */ void zzM(zzeq zzeq2) {
        this.zzS(zzeq2);
    }

    final /* synthetic */ void zzN(Exception exception, boolean bl, boolean bl2) {
        this.zzT(exception, bl, bl2);
    }

    final /* synthetic */ String zzO() {
        return this.zzd;
    }

    final /* synthetic */ boolean zzP() {
        return this.zzh;
    }

    final /* synthetic */ zzcr zzQ() {
        return this.zzj;
    }

    final /* synthetic */ void zzR(zzcr zzcr2) {
        this.zzj = zzcr2;
    }
}

