/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.sqlite.SQLiteException;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzbk;
import com.google.android.gms.internal.measurement.zzbq;
import com.google.android.gms.internal.measurement.zzbv;
import com.google.android.gms.internal.measurement.zzbw;
import com.google.android.gms.internal.measurement.zzbx;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzgk;
import com.google.android.gms.internal.measurement.zzil;
import com.google.android.gms.internal.measurement.zzio;
import com.google.android.gms.internal.measurement.zziw;
import com.google.android.gms.measurement.internal.zzef;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzu;
import com.google.android.gms.measurement.internal.zzx;
import java.io.IOException;
import java.util.Map;

public final class zzfd
extends zzjh
implements zzu {
    @VisibleForTesting
    private static int zznk = 65535;
    @VisibleForTesting
    private static int zznl = 2;
    private final Map<String, Map<String, String>> zznm = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zznn = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zzno = new ArrayMap();
    private final Map<String, zzbw> zznp = new ArrayMap();
    private final Map<String, Map<String, Integer>> zznq;
    private final Map<String, String> zznr = new ArrayMap();

    zzfd(zzjg zzjg2) {
        super(zzjg2);
        this.zznq = new ArrayMap();
    }

    @WorkerThread
    private final void zzav(String string) {
        this.zzbi();
        this.zzo();
        Preconditions.checkNotEmpty((String)string);
        if (this.zznp.get(string) == null) {
            byte[] byArray = ((zzje)this).zzgy().zzad(string);
            if (byArray == null) {
                this.zznm.put(string, null);
                this.zznn.put(string, null);
                this.zzno.put(string, null);
                this.zznp.put(string, null);
                this.zznr.put(string, null);
                this.zznq.put(string, null);
                return;
            }
            zzbw zzbw2 = this.zza(string, byArray);
            this.zznm.put(string, zzfd.zza(zzbw2));
            this.zza(string, zzbw2);
            this.zznp.put(string, zzbw2);
            this.zznr.put(string, null);
        }
    }

    @WorkerThread
    protected final zzbw zzaw(String string) {
        this.zzbi();
        this.zzo();
        Preconditions.checkNotEmpty((String)string);
        this.zzav(string);
        return this.zznp.get(string);
    }

    @WorkerThread
    protected final String zzax(String string) {
        this.zzo();
        return this.zznr.get(string);
    }

    @WorkerThread
    protected final void zzay(String string) {
        this.zzo();
        this.zznr.put(string, null);
    }

    @WorkerThread
    final void zzaz(String string) {
        this.zzo();
        this.zznp.remove(string);
    }

    @WorkerThread
    final boolean zzba(String string) {
        this.zzo();
        zzbw zzbw2 = this.zzaw(string);
        if (zzbw2 == null) {
            return false;
        }
        Boolean bl = zzbw2.zzzq;
        if (bl == null) {
            return false;
        }
        return bl;
    }

    @WorkerThread
    public final String zzb(String string, String string2) {
        this.zzo();
        this.zzav(string);
        Map<String, String> map = this.zznm.get(string);
        if (map != null) {
            return map.get(string2);
        }
        return null;
    }

    private static Map<String, String> zza(zzbw zzbw2) {
        ArrayMap arrayMap = new ArrayMap();
        if (zzbw2 != null && zzbw2.zzzm != null) {
            zzbq.zza[] zzaArray = zzbw2.zzzm;
            int n = zzbw2.zzzm.length;
            for (int i = 0; i < n; ++i) {
                zzbq.zza zza2 = zzaArray[i];
                if (zza2 == null) continue;
                arrayMap.put(zza2.getKey(), zza2.getValue());
            }
        }
        return arrayMap;
    }

    private final void zza(String string, zzbw zzbw2) {
        ArrayMap arrayMap = new ArrayMap();
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        if (zzbw2 != null && zzbw2.zzzn != null) {
            zzbx[] zzbxArray = zzbw2.zzzn;
            int n = zzbw2.zzzn.length;
            for (int i = 0; i < n; ++i) {
                zzbx zzbx2 = zzbxArray[i];
                if (TextUtils.isEmpty((CharSequence)zzbx2.name)) {
                    this.zzab().zzgn().zzao("EventConfig contained null event name");
                    continue;
                }
                String string2 = zzgj.zzbe((String)zzbx2.name);
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    zzbx2.name = string2;
                }
                arrayMap.put(zzbx2.name, zzbx2.zzzs);
                arrayMap2.put(zzbx2.name, zzbx2.zzzt);
                if (zzbx2.zzzu == null) continue;
                if (zzbx2.zzzu < zznl || zzbx2.zzzu > zznk) {
                    this.zzab().zzgn().zza("Invalid sampling rate. Event name, sample rate", (Object)zzbx2.name, (Object)zzbx2.zzzu);
                    continue;
                }
                arrayMap3.put(zzbx2.name, zzbx2.zzzu);
            }
        }
        this.zznn.put(string, (Map<String, Boolean>)arrayMap);
        this.zzno.put(string, (Map<String, Boolean>)arrayMap2);
        this.zznq.put(string, (Map<String, Integer>)arrayMap3);
    }

    @WorkerThread
    protected final boolean zza(String string, byte[] byArray, String string2) {
        this.zzbi();
        this.zzo();
        Preconditions.checkNotEmpty((String)string);
        zzbw zzbw2 = this.zza(string, byArray);
        if (zzbw2 == null) {
            return false;
        }
        this.zza(string, zzbw2);
        this.zznp.put(string, zzbw2);
        this.zznr.put(string, string2);
        this.zznm.put(string, zzfd.zza(zzbw2));
        Object[] objectArray = zzbw2.zzzo;
        String string3 = string;
        Object object = ((zzje)this).zzgx();
        Preconditions.checkNotNull((Object)objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2;
            zzgk zzgk2;
            int n;
            zzbv zzbv2 = objectArray[i];
            if (zzbv2.zzzh != null) {
                for (n = 0; n < zzbv2.zzzh.length; ++n) {
                    zzgk2 = (zzbk.zza.zza)zzbv2.zzzh[n].zzuj();
                    object2 = (zzbk.zza.zza)((zzey.zza)zzgk2.clone());
                    boolean bl = false;
                    String string4 = zzgj.zzbe((String)zzgk2.zzjz());
                    if (string4 != null) {
                        ((zzbk.zza.zza)((Object)object2)).zzbs(string4);
                        bl = true;
                    }
                    for (int j = 0; j < zzgk2.zzka(); ++j) {
                        zzbk.zzb zzb2 = zzgk2.zze(j);
                        String string5 = zzgi.zzbe((String)zzb2.zzkr());
                        if (string5 == null) continue;
                        zzbk.zzb zzb3 = (zzbk.zzb)((zzey)((zzbk.zzb.zza)zzb2.zzuj()).zzbu(string5).zzug());
                        ((zzbk.zza.zza)((Object)object2)).zza(j, zzb3);
                        bl = true;
                    }
                    if (!bl) continue;
                    zzbv2.zzzh[n] = (zzbk.zza)((zzey)object2.zzug());
                }
            }
            if (zzbv2.zzzg == null) continue;
            for (n = 0; n < zzbv2.zzzg.length; ++n) {
                zzgk2 = zzbv2.zzzg[n];
                object2 = zzgl.zzbe((String)zzgk2.getPropertyName());
                if (object2 == null) continue;
                zzbv2.zzzg[n] = (zzbk.zzd)((zzey)((zzbk.zzd.zza)zzgk2.zzuj()).zzbw((String)object2).zzug());
            }
        }
        ((zzje)((Object)object)).zzgy().zza(string3, (zzbv[])objectArray);
        try {
            zzbw2.zzzo = null;
            byte[] byArray2 = new byte[zzbw2.zzuk()];
            object = byArray2;
            zzio zzio2 = zzio.zzk(byArray2, 0, ((zzp)object).length);
            ((zziw)zzbw2).zza(zzio2);
            byArray = byArray2;
        }
        catch (IOException iOException) {
            this.zzab().zzgn().zza("Unable to serialize reduced-size config. Storing full config instead. appId", zzef.zzam((String)string), (Object)iOException);
        }
        objectArray = byArray;
        string3 = string;
        object = ((zzje)this).zzgy();
        Preconditions.checkNotEmpty((String)string3);
        object.zzo();
        ((zzjh)((Object)object)).zzbi();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", (byte[])objectArray);
        try {
            if ((long)((zzx)((Object)object)).getWritableDatabase().update("apps", contentValues, "app_id = ?", new String[]{string3}) == 0L) {
                object.zzab().zzgk().zza("Failed to update remote config (got 0). appId", zzef.zzam((String)string3));
            }
        }
        catch (SQLiteException sQLiteException) {
            object.zzab().zzgk().zza("Error storing remote config. appId", zzef.zzam((String)string3), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    final boolean zzk(String string, String string2) {
        this.zzo();
        this.zzav(string);
        if (this.zzbc(string) && zzjs.zzbq((String)string2)) {
            return true;
        }
        if (this.zzbd(string) && zzjs.zzbk((String)string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zznn.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final boolean zzl(String string, String string2) {
        this.zzo();
        this.zzav(string);
        if ("ecommerce_purchase".equals(string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzno.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final int zzm(String string, String string2) {
        this.zzo();
        this.zzav(string);
        Map<String, Integer> map = this.zznq.get(string);
        if (map != null) {
            Integer n = map.get(string2);
            if (n == null) {
                return 1;
            }
            return n;
        }
        return 1;
    }

    @WorkerThread
    final long zzbb(String string) {
        String string2 = this.zzb(string, "measurement.account.time_zone_offset_minutes");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.zzab().zzgn().zza("Unable to parse timezone offset. appId", zzef.zzam((String)string), (Object)numberFormatException);
            }
        }
        return 0L;
    }

    @WorkerThread
    private final zzbw zza(String string, byte[] byArray) {
        if (byArray == null) {
            return new zzbw();
        }
        byte[] byArray2 = byArray;
        zzil zzil2 = zzil.zzj(byArray, 0, byArray2.length);
        zzbw zzbw2 = new zzbw();
        try {
            ((zziw)zzbw2).zza(zzil2);
            this.zzab().zzgs().zza("Parsed config. version, gmp_app_id", (Object)zzbw2.zzzk, (Object)zzbw2.zzcg);
        }
        catch (IOException iOException) {
            this.zzab().zzgn().zza("Unable to merge remote config. appId", zzef.zzam((String)string), (Object)iOException);
            return new zzbw();
        }
        return zzbw2;
    }

    final boolean zzbc(String string) {
        return "1".equals(this.zzb(string, "measurement.upload.blacklist_internal"));
    }

    final boolean zzbd(String string) {
        return "1".equals(this.zzb(string, "measurement.upload.blacklist_public"));
    }

    @Override
    protected final boolean zzbk() {
        return false;
    }
}

