/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzbs;
import com.google.android.gms.internal.measurement.zzbw;
import com.google.android.gms.internal.measurement.zzel;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzed;
import com.google.android.gms.measurement.internal.zzef;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzen;
import com.google.android.gms.measurement.internal.zzeo;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfc;
import com.google.android.gms.measurement.internal.zzfd;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzhp;
import com.google.android.gms.measurement.internal.zzjc;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzji;
import com.google.android.gms.measurement.internal.zzjj;
import com.google.android.gms.measurement.internal.zzjk;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzjo;
import com.google.android.gms.measurement.internal.zzjp;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzr;
import com.google.android.gms.measurement.internal.zzs;
import com.google.android.gms.measurement.internal.zzu;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzz;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzjg
implements zzgh {
    private static volatile zzjg zzsn;
    private zzfd zzso;
    private zzej zzsp;
    private zzx zzsq;
    private zzem zzsr;
    private zzjc zzss;
    private zzp zzst;
    private final zzjo zzsu;
    private zzhp zzsv;
    private final zzfj zzj;
    private boolean zzdh = false;
    private boolean zzsw;
    private boolean zzsx;
    @VisibleForTesting
    private long zzsy;
    private List<Runnable> zzsz;
    private int zzta;
    private int zztb;
    private boolean zztc;
    private boolean zztd;
    private boolean zzte;
    private FileLock zztf;
    private FileChannel zztg;
    private List<Long> zzth;
    private List<Long> zzti;
    private long zztj;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzjg zzm(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzsn != null) return zzsn;
        Class<zzjg> clazz = zzjg.class;
        synchronized (zzjg.class) {
            if (zzsn != null) return zzsn;
            zzjm zzjm2 = new zzjm(context);
            zzsn = new zzjg(zzjm2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzsn;
        }
    }

    private zzjg(zzjm zzjm2) {
        this(zzjm2, null);
    }

    private zzjg(zzjm zzjm2, zzfj zzfj2) {
        Preconditions.checkNotNull((Object)zzjm2);
        this.zzj = zzfj2 = zzfj.zza((Context)zzjm2.zzob, null);
        this.zztj = -1L;
        zzjg zzjg2 = this;
        zzjo zzjo2 = new zzjo(zzjg2);
        zzjo2.initialize();
        this.zzsu = zzjo2;
        zzjg2 = this;
        zzej zzej2 = new zzej(zzjg2);
        zzej2.initialize();
        this.zzsp = zzej2;
        zzjg2 = this;
        zzfd zzfd2 = new zzfd(zzjg2);
        zzfd2.initialize();
        this.zzso = zzfd2;
        this.zzj.zzaa().zza((Runnable)new zzjj(this, zzjm2));
    }

    @WorkerThread
    private final void zza(zzjm zzjm2) {
        this.zzj.zzaa().zzo();
        zzjg zzjg2 = this;
        zzx zzx2 = new zzx(zzjg2);
        zzx2.initialize();
        this.zzsq = zzx2;
        this.zzj.zzad().zza((zzu)this.zzso);
        zzjg2 = this;
        zzp zzp2 = new zzp(zzjg2);
        zzp2.initialize();
        this.zzst = zzp2;
        zzjg2 = this;
        zzhp zzhp2 = new zzhp(zzjg2);
        zzhp2.initialize();
        this.zzsv = zzhp2;
        zzjg2 = this;
        zzjc zzjc2 = new zzjc(zzjg2);
        zzjc2.initialize();
        this.zzss = zzjc2;
        zzjg2 = this;
        this.zzsr = new zzem(zzjg2);
        if (this.zzta != this.zztb) {
            this.zzj.zzab().zzgk().zza("Not all upload components initialized", (Object)this.zzta, (Object)this.zztb);
        }
        this.zzdh = true;
    }

    @WorkerThread
    protected final void start() {
        this.zzj.zzaa().zzo();
        this.zzgy().zzca();
        if (this.zzj.zzac().zzlj.get() == 0L) {
            this.zzj.zzac().zzlj.set(this.zzj.zzx().currentTimeMillis());
        }
        this.zzjn();
    }

    public final zzr zzae() {
        return this.zzj.zzae();
    }

    public final zzs zzad() {
        return this.zzj.zzad();
    }

    public final zzef zzab() {
        return this.zzj.zzab();
    }

    public final zzfc zzaa() {
        return this.zzj.zzaa();
    }

    public final zzfd zzgz() {
        zzjg.zza(this.zzso);
        return this.zzso;
    }

    public final zzej zzjf() {
        zzjg.zza(this.zzsp);
        return this.zzsp;
    }

    public final zzx zzgy() {
        zzjg.zza(this.zzsq);
        return this.zzsq;
    }

    private final zzem zzjg() {
        if (this.zzsr == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzsr;
    }

    private final zzjc zzjh() {
        zzjg.zza(this.zzss);
        return this.zzss;
    }

    public final zzp zzgx() {
        zzjg.zza(this.zzst);
        return this.zzst;
    }

    public final zzhp zzji() {
        zzjg.zza(this.zzsv);
        return this.zzsv;
    }

    public final zzjo zzgw() {
        zzjg.zza(this.zzsu);
        return this.zzsu;
    }

    public final zzed zzy() {
        return this.zzj.zzy();
    }

    public final Context getContext() {
        return this.zzj.getContext();
    }

    public final Clock zzx() {
        return this.zzj.zzx();
    }

    public final zzjs zzz() {
        return this.zzj.zzz();
    }

    @WorkerThread
    private final void zzo() {
        this.zzj.zzaa().zzo();
    }

    final void zzjj() {
        if (!this.zzdh) {
            throw new IllegalStateException("UploadController is not initialized");
        }
    }

    private static void zza(zzjh zzjh2) {
        if (zzjh2 == null) {
            throw new IllegalStateException("Upload Component not created");
        }
        if (!zzjh2.isInitialized()) {
            String string = String.valueOf(((Object)((Object)zzjh2)).getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    final void zze(zzn zzn2) {
        this.zzo();
        this.zzjj();
        Preconditions.checkNotEmpty((String)zzn2.packageName);
        this.zzg(zzn2);
    }

    private final long zzjk() {
        long l = this.zzj.zzx().currentTimeMillis();
        zzeo zzeo2 = this.zzj.zzac();
        zzeo2.zzbi();
        zzeo2.zzo();
        long l2 = zzeo2.zzln.get();
        if (l2 == 0L) {
            l2 = 1L + (long)zzeo2.zzz().zzjw().nextInt(86400000);
            zzeo2.zzln.set(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    final void zzd(zzai zzai2, String string) {
        zzf zzf2 = this.zzgy().zzab(string);
        if (zzf2 == null || TextUtils.isEmpty((CharSequence)zzf2.zzal())) {
            this.zzj.zzab().zzgr().zza("No app data available; dropping event", (Object)string);
            return;
        }
        Boolean bl = this.zzc(zzf2);
        if (bl == null) {
            if (!"_ui".equals(zzai2.name)) {
                this.zzj.zzab().zzgn().zza("Could not find package. appId", zzef.zzam((String)string));
            }
        } else if (!bl.booleanValue()) {
            this.zzj.zzab().zzgk().zza("App version does not match; dropping event. appId", zzef.zzam((String)string));
            return;
        }
        zzn zzn2 = new zzn(string, zzf2.getGmpAppId(), zzf2.zzal(), zzf2.zzam(), zzf2.zzan(), zzf2.zzao(), zzf2.zzap(), null, zzf2.isMeasurementEnabled(), false, zzf2.getFirebaseInstanceId(), zzf2.zzbd(), 0L, 0, zzf2.zzbe(), zzf2.zzbf(), false, zzf2.zzah(), zzf2.zzbg(), zzf2.zzaq(), zzf2.zzbh());
        this.zzc(zzai2, zzn2);
    }

    @WorkerThread
    final void zzc(zzai zzai2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzn2);
        Preconditions.checkNotEmpty((String)zzn2.packageName);
        this.zzo();
        this.zzjj();
        String string = zzn2.packageName;
        long l = zzai2.zzfu;
        if (!this.zzgw().zze(zzai2, zzn2)) {
            return;
        }
        if (!zzn2.zzcq) {
            this.zzg(zzn2);
            return;
        }
        if (this.zzj.zzad().zze(string, zzak.zzix) && zzn2.zzcw != null) {
            if (zzn2.zzcw.contains(zzai2.name)) {
                Bundle bundle = zzai2.zzfq.zzcv();
                bundle.putLong("ga_safelisted", 1L);
                zzai2 = new zzai(zzai2.name, new zzah(bundle), zzai2.origin, zzai2.zzfu);
            } else {
                this.zzj.zzab().zzgr().zza("Dropping non-safelisted event. appId, event name, origin", (Object)string, (Object)zzai2.name, (Object)zzai2.origin);
                return;
            }
        }
        this.zzgy().beginTransaction();
        try {
            zzq zzq2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzx zzx2 = this.zzgy();
            Preconditions.checkNotEmpty((String)string3);
            zzx2.zzo();
            zzx2.zzbi();
            if (l2 < 0L) {
                zzx2.zzab().zzgn().zza("Invalid time querying timed out conditional properties", zzef.zzam((String)string3), (Object)l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzx2.zzb(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzj.zzab().zzgr().zza("User property timed out", (Object)((zzq)object22).packageName, (Object)this.zzj.zzy().zzal(((zzq)object22).zzdw.name), ((zzq)object22).zzdw.getValue());
                if (((zzq)object22).zzdx != null) {
                    this.zzd(new zzai(((zzq)object22).zzdx, l), zzn2);
                }
                this.zzgy().zzg(string, ((zzq)object22).zzdw.name);
            }
            l2 = l;
            string3 = string;
            zzx2 = this.zzgy();
            Preconditions.checkNotEmpty((String)string3);
            zzx2.zzo();
            zzx2.zzbi();
            if (l2 < 0L) {
                zzx2.zzab().zzgn().zza("Invalid time querying expired conditional properties", zzef.zzam((String)string3), (Object)l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzx2.zzb(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzq)object4.next();
                if (object == null) continue;
                this.zzj.zzab().zzgr().zza("User property expired", (Object)((zzq)object).packageName, (Object)this.zzj.zzy().zzal(((zzq)object).zzdw.name), ((zzq)object).zzdw.getValue());
                this.zzgy().zzd(string, ((zzq)object).zzdw.name);
                if (((zzq)object).zzdz != null) {
                    object22.add(((zzq)object).zzdz);
                }
                this.zzgy().zzg(string, ((zzq)object).zzdw.name);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzai)e;
                this.zzd(new zzai((zzai)object, l), zzn2);
            }
            long l3 = l;
            String string4 = zzai2.name;
            string3 = string;
            zzx2 = this.zzgy();
            Preconditions.checkNotEmpty((String)string3);
            Preconditions.checkNotEmpty((String)string4);
            zzx2.zzo();
            zzx2.zzbi();
            if (l3 < 0L) {
                zzx2.zzab().zzgn().zza("Invalid time querying triggered conditional properties", zzef.zzam((String)string3), (Object)zzx2.zzy().zzaj(string4), (Object)l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzx2.zzb((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzq2 = (zzq)iterator.next();
                if (zzq2 == null) continue;
                zzjn zzjn2 = zzq2.zzdw;
                zzjp zzjp2 = new zzjp(zzq2.packageName, zzq2.origin, zzjn2.name, l, zzjn2.getValue());
                if (this.zzgy().zza(zzjp2)) {
                    this.zzj.zzab().zzgr().zza("User property triggered", (Object)zzq2.packageName, (Object)this.zzj.zzy().zzal(zzjp2.name), zzjp2.value);
                } else {
                    this.zzj.zzab().zzgk().zza("Too many active user properties, ignoring", zzef.zzam((String)zzq2.packageName), (Object)this.zzj.zzy().zzal(zzjp2.name), zzjp2.value);
                }
                if (zzq2.zzdy != null) {
                    object.add(zzq2.zzdy);
                }
                zzq2.zzdw = new zzjn(zzjp2);
                zzq2.active = true;
                this.zzgy().zza(zzq2);
            }
            this.zzd(zzai2, zzn2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzq2 = (zzai)e;
                this.zzd(new zzai((zzai)zzq2, l), zzn2);
            }
            this.zzgy().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzgy().endTransaction();
        }
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    private final void zzd(zzai var1_1, zzn var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.packageName);
        var3_3 = System.nanoTime();
        this.zzo();
        this.zzjj();
        var5_4 = var2_2.packageName;
        if (!this.zzgw().zze(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzcq) {
            this.zzg(var2_2);
            return;
        }
        if (this.zzgz().zzk(var5_4, var1_1.name)) {
            this.zzj.zzab().zzgn().zza("Dropping blacklisted event. appId", zzef.zzam((String)var5_4), (Object)this.zzj.zzy().zzaj(var1_1.name));
            var6_5 = this.zzgz().zzbc(var5_4) != false || this.zzgz().zzbd(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.name)) {
                this.zzj.zzz().zza(var5_4, 11, "_ev", var1_1.name, 0);
            }
            if (var6_5 && (var7_7 = this.zzgy().zzab(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzat(), var7_7.zzas());
                if (Math.abs(this.zzj.zzx().currentTimeMillis() - var8_9) > (Long)zzak.zzhe.get(null)) {
                    this.zzj.zzab().zzgr().zzao("Fetching config for blacklisted app");
                    this.zzb(var7_7);
                }
            }
            return;
        }
        if (this.zzj.zzab().isLoggable(2)) {
            this.zzj.zzab().zzgs().zza("Logging event", (Object)this.zzj.zzy().zzb(var1_1));
        }
        this.zzgy().beginTransaction();
        try {
            block70: {
                block71: {
                    block73: {
                        block77: {
                            block76: {
                                block74: {
                                    block75: {
                                        this.zzg(var2_2);
                                        if (!"_iap".equals(var1_1.name) && !"ecommerce_purchase".equals(var1_1.name)) break block73;
                                        var20_11 = var1_1;
                                        var19_15 = var5_4;
                                        var18_16 = this;
                                        var21_17 = var20_11.zzfq.getString("currency");
                                        if (!"ecommerce_purchase".equals(var20_11.name)) break block74;
                                        var24_18 = var20_11.zzfq.zzah("value") * 1000000.0;
                                        if (var24_18 == 0.0) {
                                            var24_18 = (double)var20_11.zzfq.getLong("value").longValue() * 1000000.0;
                                        }
                                        if (!(var24_18 <= 9.223372036854776E18) || !(var24_18 >= -9.223372036854776E18)) break block75;
                                        var22_21 = Math.round(var24_18);
                                        break block76;
                                    }
                                    var18_16.zzj.zzab().zzgn().zza("Data lost. Currency value is too big. appId", zzef.zzam((String)var19_15), (Object)var24_18);
                                    v0 = false;
                                    break block77;
                                }
                                var22_21 = var20_11.zzfq.getLong("value");
                            }
                            if (!TextUtils.isEmpty((CharSequence)var21_17) && (var21_17 = var21_17.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                                v1 = String.valueOf("_ltv_");
                                v2 = String.valueOf(var21_17);
                                var24_19 = v2.length() != 0 ? v1.concat(v2) : new String(v1);
                                var25_24 = var18_16.zzgy().zze(var19_15, var24_19);
                                if (var25_24 == null || !(var25_24.value instanceof Long)) {
                                    var29_27 = var19_15;
                                    var34_28 = var18_16.zzj.zzad().zzb(var29_27, zzak.zzhj) - 1;
                                    var33_29 = var19_15;
                                    var32_30 = var18_16.zzgy();
                                    Preconditions.checkNotEmpty((String)var33_29);
                                    var32_30.zzo();
                                    var32_30.zzbi();
                                    try {
                                        var32_30.getWritableDatabase().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{var33_29, var33_29, String.valueOf(var34_28)});
                                    }
                                    catch (SQLiteException var35_31) {
                                        var32_30.zzab().zzgk().zza("Error pruning currencies. appId", zzef.zzam((String)var33_29), (Object)var35_31);
                                    }
                                    var25_24 = new zzjp(var19_15, var20_11.origin, var24_19, var18_16.zzj.zzx().currentTimeMillis(), (Object)var22_21);
                                } else {
                                    var26_32 = (Long)var25_24.value;
                                    var25_24 = new zzjp(var19_15, var20_11.origin, var24_19, var18_16.zzj.zzx().currentTimeMillis(), (Object)(var26_32 + var22_21));
                                }
                                if (!var18_16.zzgy().zza(var25_24)) {
                                    var18_16.zzj.zzab().zzgk().zza("Too many unique user properties are set. Ignoring user property. appId", zzef.zzam((String)var19_15), (Object)var18_16.zzj.zzy().zzal(var25_24.name), var25_24.value);
                                    var18_16.zzj.zzz().zza(var19_15, 9, null, null, 0);
                                }
                            }
                            v0 = true;
                        }
                        if (!v0) {
                            this.zzgy().setTransactionSuccessful();
                            return;
                        }
                    }
                    var6_6 = zzjs.zzbk((String)var1_1.name);
                    var7_8 = "_err".equals(var1_1.name);
                    var8_10 = this.zzgy().zza(this.zzjk(), var5_4, true, var6_6, false, var7_8, false);
                    var9_34 = var8_10.zzeg - (long)((Integer)zzak.zzgp.get(null)).intValue();
                    if (var9_34 > 0L) {
                        if (var9_34 % 1000L == 1L) {
                            this.zzj.zzab().zzgk().zza("Data loss. Too many events logged. appId, count", zzef.zzam((String)var5_4), (Object)var8_10.zzeg);
                        }
                        this.zzgy().setTransactionSuccessful();
                        return;
                    }
                    if (var6_6 && (var9_34 = var8_10.zzef - (long)((Integer)zzak.zzgr.get(null)).intValue()) > 0L) {
                        if (var9_34 % 1000L == 1L) {
                            this.zzj.zzab().zzgk().zza("Data loss. Too many public events logged. appId, count", zzef.zzam((String)var5_4), (Object)var8_10.zzef);
                        }
                        this.zzj.zzz().zza(var5_4, 16, "_ev", var1_1.name, 0);
                        this.zzgy().setTransactionSuccessful();
                        return;
                    }
                    if (var7_8) {
                        var19_15 = var2_2.packageName;
                        var20_12 = this.zzj.zzad().zzb(var19_15, zzak.zzgq);
                        var9_34 = var8_10.zzei - (long)Math.max(0, var20_12 = Math.min(1000000, var20_12));
                        if (var9_34 > 0L) {
                            if (var9_34 == 1L) {
                                this.zzj.zzab().zzgk().zza("Too many error events logged. appId, count", zzef.zzam((String)var5_4), (Object)var8_10.zzei);
                            }
                            this.zzgy().setTransactionSuccessful();
                            return;
                        }
                    }
                    var11_35 = var1_1.zzfq.zzcv();
                    this.zzj.zzz().zza(var11_35, "_o", (Object)var1_1.origin);
                    if (this.zzj.zzz().zzbr(var5_4)) {
                        this.zzj.zzz().zza(var11_35, "_dbg", (Object)1L);
                        this.zzj.zzz().zza(var11_35, "_r", (Object)1L);
                    }
                    if ("_s".equals(var1_1.name) && this.zzj.zzad().zzw(var2_2.packageName) && (var12_36 = this.zzgy().zze(var2_2.packageName, "_sno")) != null && var12_36.value instanceof Long) {
                        this.zzj.zzz().zza(var11_35, "_sno", var12_36.value);
                    }
                    if ("_s".equals(var1_1.name) && this.zzj.zzad().zze(var2_2.packageName, zzak.zzif)) {
                        var19_15 = var2_2;
                        var18_16 = this;
                        if (!var18_16.zzj.zzad().zzw(var19_15.packageName)) {
                            var20_13 = new zzjn("_sno", 0L, null);
                            var18_16.zzc(var20_13, (zzn)var19_15);
                        }
                    }
                    if ((var12_37 = this.zzgy().zzac(var5_4)) > 0L) {
                        this.zzj.zzab().zzgn().zza("Data lost. Too many events stored on disk, deleted. appId", zzef.zzam((String)var5_4), (Object)var12_37);
                    }
                    var14_38 = new zzaf(this.zzj, var1_1.origin, var5_4, var1_1.name, var1_1.zzfu, 0L, var11_35);
                    var15_39 = this.zzgy().zzc(var5_4, var14_38.name);
                    if (var15_39 == null) {
                        if (this.zzgy().zzag(var5_4) >= 500L && var6_6) {
                            this.zzj.zzab().zzgk().zza("Too many event names used, ignoring event. appId, name, supported count", zzef.zzam((String)var5_4), (Object)this.zzj.zzy().zzaj(var14_38.name), (Object)500);
                            this.zzj.zzz().zza(var5_4, 8, null, null, 0);
                            return;
                        }
                        var16_40 = new zzae(var5_4, var14_38.name, 0L, 0L, var14_38.timestamp, 0L, null, null, null, null);
                    } else {
                        var14_38 = var14_38.zza(this.zzj, var15_39.zzfj);
                        var16_40 = var15_39.zzw(var14_38.timestamp);
                    }
                    this.zzgy().zza(var16_40);
                    var20_14 = var2_2;
                    var19_15 = var14_38;
                    var18_16 = this;
                    var18_16.zzo();
                    var18_16.zzjj();
                    Preconditions.checkNotNull((Object)var19_15);
                    Preconditions.checkNotNull((Object)var20_14);
                    Preconditions.checkNotEmpty((String)var19_15.zzce);
                    Preconditions.checkArgument((boolean)var19_15.zzce.equals(var20_14.packageName));
                    var21_17 = zzbs.zzg.zzpr().zzp(1).zzcc("android");
                    if (!TextUtils.isEmpty((CharSequence)var20_14.packageName)) {
                        var21_17.zzch(var20_14.packageName);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var20_14.zzco)) {
                        var21_17.zzcg(var20_14.zzco);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var20_14.zzcm)) {
                        var21_17.zzci(var20_14.zzcm);
                    }
                    if (var20_14.zzcn != -2147483648L) {
                        var21_17.zzv((int)var20_14.zzcn);
                    }
                    var21_17.zzas(var20_14.zzr);
                    if (!TextUtils.isEmpty((CharSequence)var20_14.zzcg)) {
                        var21_17.zzcm(var20_14.zzcg);
                    }
                    if (var18_16.zzj.zzad().zza(zzak.zzit)) {
                        if (TextUtils.isEmpty((CharSequence)var21_17.getGmpAppId()) && !TextUtils.isEmpty((CharSequence)var20_14.zzcu)) {
                            var21_17.zzcq(var20_14.zzcu);
                        }
                    } else if (!TextUtils.isEmpty((CharSequence)var20_14.zzcu)) {
                        var21_17.zzcq(var20_14.zzcu);
                    }
                    if (var20_14.zzcp != 0L) {
                        var21_17.zzau(var20_14.zzcp);
                    }
                    var21_17.zzax(var20_14.zzs);
                    if (var18_16.zzj.zzad().zze(var20_14.packageName, zzak.zzin) && (var22_22 = var18_16.zzgw().zzju()) != null) {
                        var21_17.zzd(var22_22);
                    }
                    if ((var22_23 = var18_16.zzj.zzac().zzap(var20_14.packageName)) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var22_23.first))) {
                        if (var20_14.zzcs) {
                            var21_17.zzcj((String)var22_23.first);
                            if (var22_23.second != null) {
                                var21_17.zzm((Boolean)var22_23.second);
                            }
                        }
                    } else if (!var18_16.zzj.zzw().zzj(var18_16.zzj.getContext()) && var20_14.zzct) {
                        var23_41 = Settings.Secure.getString((ContentResolver)var18_16.zzj.getContext().getContentResolver(), (String)"android_id");
                        if (var23_41 == null) {
                            var18_16.zzj.zzab().zzgn().zza("null secure ID. appId", zzef.zzam((String)var21_17.zzag()));
                            var23_41 = "null";
                        } else if (var23_41.isEmpty()) {
                            var18_16.zzj.zzab().zzgn().zza("empty secure ID. appId", zzef.zzam((String)var21_17.zzag()));
                        }
                        var21_17.zzco(var23_41);
                    }
                    var18_16.zzj.zzw().zzbi();
                    v3 = var21_17.zzce(Build.MODEL);
                    var18_16.zzj.zzw().zzbi();
                    v3.zzcd(Build.VERSION.RELEASE).zzt((int)var18_16.zzj.zzw().zzcq()).zzcf(var18_16.zzj.zzw().zzcr()).zzaw(var20_14.zzcr);
                    if (var18_16.zzj.isEnabled() && zzs.zzbv()) {
                        var21_17.zzag();
                        if (!TextUtils.isEmpty(null)) {
                            var21_17.zzcp(null);
                        }
                    }
                    if ((var23_41 = var18_16.zzgy().zzab(var20_14.packageName)) == null) {
                        var23_41 = new zzf(var18_16.zzj, var20_14.packageName);
                        var23_41.zza(var18_16.zzj.zzz().zzjy());
                        var23_41.zze(var20_14.zzci);
                        var23_41.zzb(var20_14.zzcg);
                        var23_41.zzd(var18_16.zzj.zzac().zzaq(var20_14.packageName));
                        var23_41.zzk(0L);
                        var23_41.zze(0L);
                        var23_41.zzf(0L);
                        var23_41.zzf(var20_14.zzcm);
                        var23_41.zzg(var20_14.zzcn);
                        var23_41.zzg(var20_14.zzco);
                        var23_41.zzh(var20_14.zzr);
                        var23_41.zzi(var20_14.zzcp);
                        var23_41.setMeasurementEnabled(var20_14.zzcq);
                        var23_41.zzt(var20_14.zzcr);
                        var23_41.zzj(var20_14.zzs);
                        var18_16.zzgy().zza((zzf)var23_41);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var23_41.getAppInstanceId())) {
                        var21_17.zzck(var23_41.getAppInstanceId());
                    }
                    if (!TextUtils.isEmpty((CharSequence)var23_41.getFirebaseInstanceId())) {
                        var21_17.zzcn(var23_41.getFirebaseInstanceId());
                    }
                    var24_20 = var18_16.zzgy().zzaa(var20_14.packageName);
                    for (var25_25 = 0; var25_25 < var24_20.size(); ++var25_25) {
                        var26_33 = zzbs.zzk.zzqu().zzdb(var24_20.get((int)var25_25).name).zzbk(var24_20.get((int)var25_25).zztr);
                        var18_16.zzgw().zza(var26_33, var24_20.get((int)var25_25).value);
                        var21_17.zza(var26_33);
                    }
                    try {
                        var25_26 = var18_16.zzgy().zza((zzbs.zzg)((zzey)var21_17.zzug()));
                    }
                    catch (IOException var27_42) {
                        var18_16.zzj.zzab().zzgk().zza("Data loss. Failed to insert raw event metadata. appId", zzef.zzam((String)var21_17.zzag()), (Object)var27_42);
                        break block70;
                    }
                    v4 = var18_16.zzgy();
                    var29_27 = var19_15;
                    var28_43 = var18_16;
                    if (var29_27.zzfq == null) ** GOTO lbl-1000
                    for (Object var31_46 : var29_27.zzfq) {
                        if (!"_r".equals(var31_46)) continue;
                        v5 = true;
                        break block71;
                    }
                    var30_45 = var28_43.zzgz().zzl(var29_27.zzce, var29_27.name);
                    var31_46 = var28_43.zzgy().zza(var28_43.zzjk(), var29_27.zzce, false, false, false, false, false);
                    if (var30_45 && var31_46.zzej < (long)var28_43.zzj.zzad().zzi(var29_27.zzce)) {
                        v5 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = false;
                    }
                }
                if (v4.zza((zzaf)var19_15, var25_26, v5)) {
                    var18_16.zzsy = 0L;
                }
            }
            this.zzgy().setTransactionSuccessful();
            if (this.zzj.zzab().isLoggable(2)) {
                this.zzj.zzab().zzgs().zza("Event recorded", (Object)this.zzj.zzy().zza(var14_38));
            }
        }
        finally {
            this.zzgy().endTransaction();
        }
        this.zzjn();
        this.zzj.zzab().zzgs().zza("Background event processing time, ms", (Object)((System.nanoTime() - var3_3 + 500000L) / 1000000L));
    }

    @WorkerThread
    final void zzjl() {
        this.zzo();
        this.zzjj();
        this.zzte = true;
        try {
            String string;
            zzr zzr2 = this.zzj.zzae();
            Boolean bl = this.zzj.zzs().zzit();
            if (bl == null) {
                this.zzj.zzab().zzgn().zzao("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzj.zzab().zzgk().zzao("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzsy > 0L) {
                this.zzjn();
                return;
            }
            zzgh zzgh2 = this;
            zzgh2.zzo();
            if (zzgh2.zzth != null) {
                this.zzj.zzab().zzgs().zzao("Uploading requested multiple times");
                return;
            }
            if (!this.zzjf().zzgv()) {
                this.zzj.zzab().zzgs().zzao("Network not connected, ignoring upload request");
                this.zzjn();
                return;
            }
            long l = this.zzj.zzx().currentTimeMillis();
            long l2 = l - zzs.zzbt();
            this.zzd(null, l2);
            long l3 = this.zzj.zzac().zzlj.get();
            if (l3 != 0L) {
                this.zzj.zzab().zzgr().zza("Uploading events. Elapsed time since last upload attempt (ms)", (Object)Math.abs(l - l3));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzgy().zzby()))) {
                if (this.zztj == -1L) {
                    this.zztj = this.zzgy().zzcf();
                }
                Object object = string;
                int n = this.zzj.zzad().zzb((String)object, zzak.zzgl);
                object = string;
                zzgh2 = this.zzj.zzad();
                int n2 = Math.max(0, zzgh2.zzb((String)object, zzak.zzgm));
                List<Pair<zzbs.zzg, Long>> list = this.zzgy().zza(string, n, n2);
                if (!list.isEmpty()) {
                    Object object2;
                    Object object3;
                    Object object4;
                    String string2 = null;
                    Object object5 = list.iterator();
                    while (object5.hasNext()) {
                        object4 = (zzbs.zzg)((Object)object5.next().first);
                        if (TextUtils.isEmpty((CharSequence)object4.zzot())) continue;
                        string2 = object4.zzot();
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            zzbs.zzg zzg2 = (zzbs.zzg)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)zzg2.zzot()) || zzg2.zzot().equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object5 = zzbs.zzf.zznj();
                    int n3 = list.size();
                    object4 = new ArrayList(list.size());
                    boolean bl2 = zzs.zzbv() && this.zzj.zzad().zzl(string);
                    for (int i = 0; i < n3; ++i) {
                        object3 = (zzbs.zzg.zza)((zzbs.zzg)((Object)list.get((int)i).first)).zzuj();
                        object4.add((Long)list.get((int)i).second);
                        zzr2 = this.zzj.zzae();
                        ((zzbs.zzg.zza)((Object)object3)).zzat(this.zzj.zzad().zzao()).zzan(l).zzn(false);
                        if (!bl2) {
                            ((zzbs.zzg.zza)((Object)object3)).zznw();
                        }
                        if (this.zzj.zzad().zze(string, zzak.zzis)) {
                            object2 = ((zzbs.zzg)((zzey)object3.zzug())).toByteArray();
                            ((zzbs.zzg.zza)((Object)object3)).zzay(this.zzgw().zza((byte[])object2));
                        }
                        ((zzbs.zzf.zza)((Object)object5)).zza((zzbs.zzg.zza)((Object)object3));
                    }
                    String string3 = null;
                    if (this.zzj.zzab().isLoggable(2)) {
                        string3 = this.zzgw().zza((zzbs.zzf)((zzey)object5.zzug()));
                    }
                    this.zzgw();
                    object3 = ((zzbs.zzf)((zzey)object5.zzug())).toByteArray();
                    object2 = (String)zzak.zzgv.get(null);
                    try {
                        URL uRL = new URL((String)object2);
                        object = object4;
                        zzgh2 = this;
                        Preconditions.checkArgument((!object.isEmpty() ? 1 : 0) != 0);
                        if (zzgh2.zzth != null) {
                            zzgh2.zzj.zzab().zzgk().zzao("Set uploading progress before finishing the previous upload");
                        } else {
                            zzgh2.zzth = new ArrayList<Long>((Collection<Long>)object);
                        }
                        this.zzj.zzac().zzlk.set(l);
                        String string4 = "?";
                        if (n3 > 0) {
                            string4 = ((zzbs.zzf.zza)((Object)object5)).zzo(0).zzag();
                        }
                        this.zzj.zzab().zzgs().zza("Uploading data. app, uncompressed size, data", (Object)string4, (Object)((Object)object3).length, (Object)string3);
                        this.zztd = true;
                        zzji zzji2 = new zzji(this, string);
                        Object object6 = object3;
                        URL uRL2 = uRL;
                        object = string;
                        zzgh2 = this.zzjf();
                        zzgh2.zzo();
                        zzgh2.zzbi();
                        Preconditions.checkNotNull((Object)uRL2);
                        Preconditions.checkNotNull((Object)object6);
                        Preconditions.checkNotNull((Object)zzji2);
                        zzgh2.zzaa().zzb((Runnable)new zzen((zzej)zzgh2, (String)object, uRL2, (byte[])object6, null, zzji2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzj.zzab().zzgk().zza("Failed to parse upload URL. Not uploading. appId", zzef.zzam((String)string), object2);
                    }
                }
            } else {
                zzf zzf2;
                this.zztj = -1L;
                String string5 = this.zzgy().zzu(l - zzs.zzbt());
                if (!TextUtils.isEmpty((CharSequence)string5) && (zzf2 = this.zzgy().zzab(string5)) != null) {
                    this.zzb(zzf2);
                }
            }
            return;
        }
        finally {
            this.zzte = false;
            this.zzjo();
        }
    }

    @WorkerThread
    private final boolean zzd(String string, long l) {
        this.zzgy().beginTransaction();
        try {
            block154: {
                int n;
                Object object;
                int n2;
                Object object3;
                Object object4;
                zza zza2;
                block152: {
                    zza2 = new zza(null);
                    object4 = zza2;
                    long l2 = this.zztj;
                    long l3 = l;
                    String string2 = null;
                    object3 = this.zzgy();
                    Preconditions.checkNotNull((Object)object4);
                    object3.zzo();
                    object3.zzbi();
                    try (Cursor cursor = null;){
                        String[] stringArray;
                        String string3;
                        String string4;
                        Object object5;
                        Object[] objectArray;
                        SQLiteDatabase sQLiteDatabase = object3.getWritableDatabase();
                        if (TextUtils.isEmpty(null)) {
                            objectArray = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            object5 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(object5).length()).append("select app_id, metadata_fingerprint from raw_events where ").append((String)object5).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), objectArray);
                            if (!cursor.moveToFirst()) break block152;
                            string2 = cursor.getString(0);
                            string4 = cursor.getString(1);
                            cursor.close();
                        } else {
                            objectArray = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            object5 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(object5).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append((String)object5).append(" order by rowid limit 1;").toString(), objectArray);
                            if (!cursor.moveToFirst()) break block152;
                            string4 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{string2, string4}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            object3.zzab().zzgk().zza("Raw event metadata record is missing. appId", zzef.zzam((String)string2));
                            break block152;
                        }
                        objectArray = cursor.getBlob(0);
                        try {
                            object5 = zzbs.zzg.zzd((byte[])objectArray, zzel.zztq());
                        }
                        catch (IOException iOException) {
                            object3.zzab().zzgk().zza("Data loss. Failed to merge raw event metadata. appId", zzef.zzam((String)string2), (Object)iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block152;
                        }
                        if (cursor.moveToNext()) {
                            object3.zzab().zzgn().zza("Get multiple raw event metadata records, expected one. appId", zzef.zzam((String)string2));
                        }
                        cursor.close();
                        object4.zzb((zzbs.zzg)((Object)object5));
                        if (l2 != -1L) {
                            string3 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{string2, string4, String.valueOf(l2)};
                        } else {
                            string3 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{string2, string4};
                        }
                        cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string3, stringArray, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            object3.zzab().zzgn().zza("Raw event data disappeared while in transaction. appId", zzef.zzam((String)string2));
                            break block152;
                        }
                        do {
                            zzbs.zzc.zza zza3;
                            long l4 = cursor.getLong(0);
                            objectArray = cursor.getBlob(3);
                            try {
                                zza3 = (zzbs.zzc.zza)zzbs.zzc.zzmq().zzf((byte[])objectArray, zzel.zztq());
                            }
                            catch (IOException iOException) {
                                object3.zzab().zzgk().zza("Data loss. Failed to merge raw event. appId", zzef.zzam((String)string2), (Object)iOException);
                                continue;
                            }
                            zza3.zzbx(cursor.getString(1)).zzag(cursor.getLong(2));
                            if (!object4.zza(l4, (zzbs.zzc)((zzey)zza3.zzug()))) break;
                        } while (cursor.moveToNext());
                    }
                }
                object3 = zza2;
                if (((zza)object3).zztp == null || ((zza)object3).zztp.isEmpty()) break block154;
                boolean bl = false;
                zzbs.zzg.zza zza4 = ((zzbs.zzg.zza)zza2.zztn.zzuj()).zznn();
                int n3 = 0;
                long l5 = 0L;
                boolean bl2 = this.zzj.zzad().zze(zza2.zztn.zzag(), zzak.zzii);
                zzbs.zzc.zza object6 = null;
                int n4 = -1;
                zzbs.zzc.zza object7 = null;
                int n5 = -1;
                for (n2 = 0; n2 < zza2.zztp.size(); ++n2) {
                    boolean bl3;
                    zzbs.zzc.zza object22;
                    block156: {
                        boolean bl4;
                        block155: {
                            boolean bl5;
                            bl4 = bl;
                            object22 = (zzbs.zzc.zza)zza2.zztp.get(n2).zzuj();
                            if (this.zzgz().zzk(zza2.zztn.zzag(), object22.getName())) {
                                this.zzj.zzab().zzgn().zza("Dropping blacklisted raw event. appId", zzef.zzam((String)zza2.zztn.zzag()), (Object)this.zzj.zzy().zzaj(object22.getName()));
                                if (this.zzgz().zzbc(zza2.zztn.zzag()) || this.zzgz().zzbd(zza2.zztn.zzag()) || "_err".equals(object22.getName())) continue;
                                this.zzj.zzz().zza(zza2.zztn.zzag(), 11, "_ev", object22.getName(), 0);
                                continue;
                            }
                            bl3 = this.zzgz().zzl(zza2.zztn.zzag(), object22.getName());
                            if (bl3) break block155;
                            this.zzgw();
                            object3 = object22.getName();
                            Preconditions.checkNotEmpty((String)object3);
                            switch (object3) {
                                case "_in": 
                                case "_ui": 
                                case "_ug": {
                                    bl5 = true;
                                    break;
                                }
                                default: {
                                    bl5 = false;
                                }
                            }
                            if (!bl5) break block156;
                        }
                        boolean l13 = false;
                        boolean bl6 = false;
                        for (int i = 0; i < object22.zzmk(); ++i) {
                            zzbs.zze zze2;
                            if ("_c".equals(object22.zzl(i).getName())) {
                                zze2 = (zzbs.zze)((zzey)((zzbs.zze.zza)object22.zzl(i).zzuj()).zzam(1L).zzug());
                                l13 = true;
                                object22.zza(i, zze2);
                                continue;
                            }
                            if (!"_r".equals(object22.zzl(i).getName())) continue;
                            zze2 = (zzbs.zze)((zzey)((zzbs.zze.zza)object22.zzl(i).zzuj()).zzam(1L).zzug());
                            bl6 = true;
                            object22.zza(i, zze2);
                        }
                        if (!l13 && bl3) {
                            this.zzj.zzab().zzgs().zza("Marking event as conversion", (Object)this.zzj.zzy().zzaj(object22.getName()));
                            object22.zza(zzbs.zze.zzng().zzbz("_c").zzam(1L));
                        }
                        if (!bl6) {
                            this.zzj.zzab().zzgs().zza("Marking event as real-time", (Object)this.zzj.zzy().zzaj(object22.getName()));
                            object22.zza(zzbs.zze.zzng().zzbz("_r").zzam(1L));
                        }
                        bl = true;
                        if (this.zzgy().zza((long)this.zzjk(), (String)zza2.zztn.zzag(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zzej > (long)this.zzj.zzad().zzi(zza2.zztn.zzag())) {
                            zzjg.zza(object22, "_r");
                            bl = bl4;
                        }
                        if (zzjs.zzbk((String)object22.getName()) && bl3) {
                            String string5 = zza2.zztn.zzag();
                            if (this.zzgy().zza((long)this.zzjk(), (String)zza2.zztn.zzag(), (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzeh > (long)this.zzj.zzad().zzb(string5, zzak.zzgs)) {
                                this.zzj.zzab().zzgn().zza("Too many conversions. Not logging as conversion. appId", zzef.zzam((String)zza2.zztn.zzag()));
                                boolean bl7 = false;
                                zzbs.zze.zza zza3 = null;
                                int n6 = -1;
                                for (int i = 0; i < object22.zzmk(); ++i) {
                                    object = object22.zzl(i);
                                    if ("_c".equals(object.getName())) {
                                        zza3 = (zzbs.zze.zza)object.zzuj();
                                        n6 = i;
                                        continue;
                                    }
                                    if (!"_err".equals(object.getName())) continue;
                                    bl7 = true;
                                }
                                if (bl7 && zza3 != null) {
                                    int n7 = n6;
                                    object22.zzm(n7);
                                } else if (zza3 != null) {
                                    zzbs.zze zze3 = (zzbs.zze)((zzey)((zzbs.zze.zza)((zzey.zza)zza3.clone())).zzbz("_err").zzam(10L).zzug());
                                    object22.zza(n6, zze3);
                                } else {
                                    this.zzj.zzab().zzgk().zza("Did not find conversion parameter. appId", zzef.zzam((String)zza2.zztn.zzag()));
                                }
                            }
                        }
                    }
                    if (this.zzj.zzad().zzs(zza2.zztn.zzag()) && bl3) {
                        zzbs.zzc.zza zzgk2 = object22;
                        object3 = this;
                        Object object8 = new ArrayList<zzbs.zze>(zzgk2.zzmj());
                        int n7 = -1;
                        int n9 = -1;
                        for (n = 0; n < object8.size(); ++n) {
                            if ("value".equals(((zzbs.zze)((Object)object8.get(n))).getName())) {
                                n7 = n;
                                continue;
                            }
                            if (!"currency".equals(((zzbs.zze)((Object)object8.get(n))).getName())) continue;
                            n9 = n;
                        }
                        if (n7 != -1) {
                            if (!((zzbs.zze)((Object)object8.get(n7))).zzna() && !((zzbs.zze)((Object)object8.get(n7))).zznd()) {
                                ((zzjg)object3).zzj.zzab().zzgp().zzao("Value must be specified with a numeric type.");
                                int n10 = n7;
                                zzgk2.zzm(n10);
                                zzjg.zza(zzgk2, "_c");
                                zzjg.zza(zzgk2, 18, "value");
                            } else {
                                n = 0;
                                if (n9 == -1) {
                                    n = 1;
                                } else {
                                    object4 = ((zzbs.zze)((Object)object8.get(n9))).zzmy();
                                    if (((String)object4).length() != 3) {
                                        n = 1;
                                    } else {
                                        int n11;
                                        for (int i = 0; i < ((String)object4).length(); i += Character.charCount(n11)) {
                                            n11 = ((String)object4).codePointAt(i);
                                            if (Character.isLetter(n11)) continue;
                                            n = 1;
                                            break;
                                        }
                                    }
                                }
                                if (n != 0) {
                                    ((zzjg)object3).zzj.zzab().zzgp().zzao("Value parameter discarded. You must also supply a 3-letter ISO_4217 currency code in the currency parameter.");
                                    int n12 = n7;
                                    zzgk2.zzm(n12);
                                    zzjg.zza(zzgk2, "_c");
                                    zzjg.zza(zzgk2, 19, "currency");
                                }
                            }
                        }
                    }
                    if (this.zzj.zzad().zze(zza2.zztn.zzag(), zzak.zzih)) {
                        if ("_e".equals(object22.getName())) {
                            this.zzgw();
                            if (zzjo.zza((zzbs.zzc)((zzey)object22.zzug()), "_fr") == null) {
                                if (object7 != null && Math.abs(object7.getTimestampMillis() - object22.getTimestampMillis()) <= 1000L) {
                                    zzbs.zzc.zza zza5 = (zzbs.zzc.zza)((zzey.zza)object7.clone());
                                    if (this.zza(object22, zza5)) {
                                        object6 = null;
                                        object7 = null;
                                        zza4.zza(n5, zza5);
                                    } else {
                                        object6 = object22;
                                        n4 = n3;
                                    }
                                } else {
                                    object6 = object22;
                                    n4 = n3;
                                }
                            }
                        } else if ("_vs".equals(object22.getName())) {
                            this.zzgw();
                            if (zzjo.zza((zzbs.zzc)((zzey)object22.zzug()), "_et") == null) {
                                if (object6 != null && Math.abs(object6.getTimestampMillis() - object22.getTimestampMillis()) <= 1000L) {
                                    zzbs.zzc.zza zza6 = (zzbs.zzc.zza)((zzey.zza)object6.clone());
                                    if (this.zza(zza6, object22)) {
                                        object6 = null;
                                        object7 = null;
                                        zza4.zza(n4, zza6);
                                    } else {
                                        object7 = object22;
                                        n5 = n3;
                                    }
                                } else {
                                    object7 = object22;
                                    n5 = n3;
                                }
                            }
                        }
                    }
                    if (!bl2 && "_e".equals(object22.getName())) {
                        if (object22.zzmk() == 0) {
                            this.zzj.zzab().zzgn().zza("Engagement event does not contain any parameters. appId", zzef.zzam((String)zza2.zztn.zzag()));
                        } else {
                            this.zzgw();
                            Long l2 = (Long)zzjo.zzb((zzbs.zzc)((zzey)object22.zzug()), "_et");
                            if (l2 == null) {
                                this.zzj.zzab().zzgn().zza("Engagement event does not include duration. appId", zzef.zzam((String)zza2.zztn.zzag()));
                            } else {
                                l5 += l2.longValue();
                            }
                        }
                    }
                    zza2.zztp.set(n2, (zzbs.zzc)((zzey)object22.zzug()));
                    ++n3;
                    zza4.zza(object22);
                }
                if (bl2) {
                    for (n2 = 0; n2 < n3; ++n2) {
                        Long l3;
                        zzbs.zzc zzc2 = zza4.zzq(n2);
                        if ("_e".equals(zzc2.getName())) {
                            this.zzgw();
                            if (zzjo.zza(zzc2, "_fr") != null) {
                                zza4.zzr(n2);
                                --n3;
                                --n2;
                                continue;
                            }
                        }
                        this.zzgw();
                        zzbs.zze zzbw2 = zzjo.zza(zzc2, "_et");
                        if (zzbw2 == null || (l3 = zzbw2.zzna() ? Long.valueOf(zzbw2.zznb()) : null) == null || l3 <= 0L) continue;
                        l5 += l3.longValue();
                    }
                }
                this.zza(zza4, l5, false);
                if (this.zzj.zzad().zze(zza4.zzag(), zzak.zzja)) {
                    n2 = 0;
                    for (zzbs.zzc zzc2 : zza4.zznl()) {
                        if (!"_s".equals(zzc2.getName())) continue;
                        n2 = 1;
                        break;
                    }
                    if (n2 != 0) {
                        this.zzgy().zzd(zza4.zzag(), "_se");
                    }
                    this.zza(zza4, l5, true);
                } else if (this.zzj.zzad().zze(zza4.zzag(), zzak.zzjb)) {
                    this.zzgy().zzd(zza4.zzag(), "_se");
                }
                if (this.zzj.zzad().zze(zza4.zzag(), zzak.zzij)) {
                    zzf zzf2;
                    zzbs.zzg.zza zza8 = zza4;
                    object3 = this.zzgw();
                    object3.zzab().zzgs().zzao("Checking account type status for ad personalization signals");
                    if (object3.zzgz().zzba(zza8.zzag()) && (zzf2 = object3.zzgy().zzab(zza8.zzag())) != null && zzf2.zzbe() && object3.zzw().zzcu()) {
                        object3.zzab().zzgr().zzao("Turning off ad personalization due to account type");
                        zzbs.zzk zzk2 = (zzbs.zzk)((zzey)zzbs.zzk.zzqu().zzdb("_npa").zzbk(object3.zzw().zzcs()).zzbl(1L).zzug());
                        boolean bl9 = false;
                        for (n = 0; n < zza8.zznp(); ++n) {
                            if (!"_npa".equals(zza8.zzs(n).getName())) continue;
                            zza8.zza(n, zzk2);
                            bl9 = true;
                            break;
                        }
                        if (!bl9) {
                            zza8.zza(zzk2);
                        }
                    }
                }
                zzbs.zzg.zza zza7 = zza4.zznv();
                List<zzbs.zzc> list = zza4.zznl();
                Object object9 = zza4.zzno();
                Object object10 = zza4.zzag();
                object3 = this;
                Preconditions.checkNotEmpty((String)object10);
                zza7.zzc(((zzjg)object3).zzgx().zza((String)object10, list, (List<zzbs.zzk>)object9));
                if (this.zzj.zzad().zzm(zza2.zztn.zzag())) {
                    HashMap<String, zzae> hashMap = new HashMap<String, zzae>();
                    ArrayList<zzbs.zzc> arrayList = new ArrayList<zzbs.zzc>();
                    SecureRandom secureRandom = this.zzj.zzz().zzjw();
                    for (int i = 0; i < zza4.zznm(); ++i) {
                        boolean bl8;
                        int n8;
                        long l4;
                        long l6;
                        zzbs.zzc.zza zza8;
                        block153: {
                            zza8 = (zzbs.zzc.zza)zza4.zzq(i).zzuj();
                            if (zza8.getName().equals("_ep")) {
                                this.zzgw();
                                String string2 = (String)zzjo.zzb((zzbs.zzc)((zzey)zza8.zzug()), "_en");
                                zzae zzae2 = (zzae)hashMap.get(string2);
                                if (zzae2 == null) {
                                    zzae2 = this.zzgy().zzc(zza2.zztn.zzag(), string2);
                                    hashMap.put(string2, zzae2);
                                }
                                if (zzae2.zzfm == null) {
                                    if (zzae2.zzfn > 1L) {
                                        this.zzgw();
                                        zzjo.zza(zza8, "_sr", zzae2.zzfn);
                                    }
                                    if (zzae2.zzfo != null && zzae2.zzfo.booleanValue()) {
                                        this.zzgw();
                                        zzjo.zza(zza8, "_efs", 1L);
                                    }
                                    arrayList.add((zzbs.zzc)((zzey)zza8.zzug()));
                                }
                                zza4.zza(i, zza8);
                                continue;
                            }
                            l6 = this.zzgz().zzbb(zza2.zztn.zzag());
                            this.zzj.zzz();
                            l4 = zzjs.zzc((long)zza8.getTimestampMillis(), (long)l6);
                            n8 = 1;
                            object9 = 1L;
                            object10 = "_dbg";
                            object3 = (zzbs.zzc)((zzey)zza8.zzug());
                            if (TextUtils.isEmpty((CharSequence)object10) || object9 == null) {
                                bl8 = false;
                            } else {
                                for (zzbs.zze zze4 : ((zzbs.zzc)((Object)object3)).zzmj()) {
                                    if (!((String)object10).equals(zze4.getName())) continue;
                                    bl8 = object9 instanceof Long && object9.equals(zze4.zznb()) || object9 instanceof String && object9.equals(zze4.zzmy()) || object9 instanceof Double && object9.equals(zze4.zzne());
                                    break block153;
                                }
                                bl8 = false;
                            }
                        }
                        if (!bl8) {
                            n8 = this.zzgz().zzm(zza2.zztn.zzag(), zza8.getName());
                        }
                        if (n8 <= 0) {
                            this.zzj.zzab().zzgn().zza("Sample rate must be positive. event, rate", (Object)zza8.getName(), (Object)n8);
                            arrayList.add((zzbs.zzc)((zzey)zza8.zzug()));
                            zza4.zza(i, zza8);
                            continue;
                        }
                        zzae zzae3 = (zzae)hashMap.get(zza8.getName());
                        if (zzae3 == null && (zzae3 = this.zzgy().zzc(zza2.zztn.zzag(), zza8.getName())) == null) {
                            this.zzj.zzab().zzgn().zza("Event being bundled has no eventAggregate. appId, eventName", (Object)zza2.zztn.zzag(), (Object)zza8.getName());
                            zzae3 = this.zzj.zzad().zze(zza2.zztn.zzag(), zzak.zziz) ? new zzae(zza2.zztn.zzag(), zza8.getName(), 1L, 1L, 1L, zza8.getTimestampMillis(), 0L, null, null, null, null) : new zzae(zza2.zztn.zzag(), zza8.getName(), 1L, 1L, zza8.getTimestampMillis(), 0L, null, null, null, null);
                        }
                        this.zzgw();
                        Long l7 = (Long)zzjo.zzb((zzbs.zzc)((zzey)zza8.zzug()), "_eid");
                        object = l7 != null;
                        if (n8 == 1) {
                            arrayList.add((zzbs.zzc)((zzey)zza8.zzug()));
                            if (((Boolean)object).booleanValue() && (zzae3.zzfm != null || zzae3.zzfn != null || zzae3.zzfo != null)) {
                                zzae3 = zzae3.zza(null, null, null);
                                hashMap.put(zza8.getName(), zzae3);
                            }
                            zza4.zza(i, zza8);
                            continue;
                        }
                        if (secureRandom.nextInt(n8) == 0) {
                            this.zzgw();
                            zzjo.zza(zza8, "_sr", n8);
                            arrayList.add((zzbs.zzc)((zzey)zza8.zzug()));
                            if (((Boolean)object).booleanValue()) {
                                zzae3 = zzae3.zza(null, Long.valueOf(n8), null);
                            }
                            hashMap.put(zza8.getName(), zzae3.zza(zza8.getTimestampMillis(), l4));
                        } else {
                            boolean bl9;
                            long l8;
                            if (this.zzj.zzad().zzu(zza2.zztn.zzag())) {
                                if (zzae3.zzfl != null) {
                                    l8 = zzae3.zzfl;
                                } else {
                                    this.zzj.zzz();
                                    l8 = zzjs.zzc((long)zza8.zzmm(), (long)l6);
                                }
                                bl9 = l8 != l4;
                            } else {
                                l8 = zzae3.zzfk;
                                boolean bl10 = bl9 = Math.abs(zza8.getTimestampMillis() - l8) >= 86400000L;
                            }
                            if (bl9) {
                                this.zzgw();
                                zzjo.zza(zza8, "_efs", 1L);
                                this.zzgw();
                                zzjo.zza(zza8, "_sr", n8);
                                arrayList.add((zzbs.zzc)((zzey)zza8.zzug()));
                                if (((Boolean)object).booleanValue()) {
                                    zzae3 = zzae3.zza(null, Long.valueOf(n8), Boolean.valueOf(true));
                                }
                                hashMap.put(zza8.getName(), zzae3.zza(zza8.getTimestampMillis(), l4));
                            } else if (((Boolean)object).booleanValue()) {
                                hashMap.put(zza8.getName(), zzae3.zza(l7, null, null));
                            }
                        }
                        zza4.zza(i, zza8);
                    }
                    if (arrayList.size() < zza4.zznm()) {
                        zza4.zznn().zza(arrayList);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        this.zzgy().zza((zzae)entry.getValue());
                    }
                }
                zza4.zzao(Long.MAX_VALUE).zzap(Long.MIN_VALUE);
                for (int i = 0; i < zza4.zznm(); ++i) {
                    zzbs.zzc zzc3 = zza4.zzq(i);
                    if (zzc3.getTimestampMillis() < zza4.zznq()) {
                        zza4.zzao(zzc3.getTimestampMillis());
                    }
                    if (zzc3.getTimestampMillis() <= zza4.zznr()) continue;
                    zza4.zzap(zzc3.getTimestampMillis());
                }
                String string7 = zza2.zztn.zzag();
                zzf zzf3 = this.zzgy().zzab(string7);
                if (zzf3 == null) {
                    this.zzj.zzab().zzgk().zza("Bundling raw events w/o app info. appId", zzef.zzam((String)zza2.zztn.zzag()));
                } else if (zza4.zznm() > 0) {
                    long l9 = zzf3.zzak();
                    if (l9 != 0L) {
                        zza4.zzar(l9);
                    } else {
                        zza4.zznt();
                    }
                    long l10 = zzf3.zzaj();
                    if (l10 == 0L) {
                        l10 = l9;
                    }
                    if (l10 != 0L) {
                        zza4.zzaq(l10);
                    } else {
                        zza4.zzns();
                    }
                    zzf3.zzau();
                    zza4.zzu((int)zzf3.zzar());
                    zzf3.zze(zza4.zznq());
                    zzf3.zzf(zza4.zznr());
                    String string3 = zzf3.zzbc();
                    if (string3 != null) {
                        zza4.zzcl(string3);
                    } else {
                        zza4.zznu();
                    }
                    this.zzgy().zza(zzf3);
                }
                if (zza4.zznm() > 0) {
                    zzr zzr2 = this.zzj.zzae();
                    zzbw zzbw2 = this.zzgz().zzaw(zza2.zztn.zzag());
                    if (zzbw2 == null || zzbw2.zzzk == null) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zztn.getGmpAppId())) {
                            zza4.zzav(-1L);
                        } else {
                            this.zzj.zzab().zzgn().zza("Did not find measurement config or missing version info. appId", zzef.zzam((String)zza2.zztn.zzag()));
                        }
                    } else {
                        zza4.zzav(zzbw2.zzzk);
                    }
                    this.zzgy().zza((zzbs.zzg)((zzey)zza4.zzug()), bl);
                }
                object10 = zza2.zzto;
                object3 = this.zzgy();
                Preconditions.checkNotNull((Object)object10);
                object3.zzo();
                object3.zzbi();
                object9 = new StringBuilder("rowid in (");
                for (int i = 0; i < object10.size(); ++i) {
                    if (i != 0) {
                        ((StringBuilder)object9).append(",");
                    }
                    ((StringBuilder)object9).append((Long)object10.get(i));
                }
                ((StringBuilder)object9).append(")");
                int n14 = object3.getWritableDatabase().delete("raw_events", ((StringBuilder)object9).toString(), null);
                if (n14 != object10.size()) {
                    object3.zzab().zzgk().zza("Deleted fewer rows from raw events table than expected", (Object)n14, (Object)object10.size());
                }
                object10 = string7;
                object3 = this.zzgy();
                object9 = object3.getWritableDatabase();
                try {
                    object9.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{object10, object10});
                }
                catch (SQLiteException sQLiteException) {
                    object3.zzab().zzgk().zza("Failed to remove unused event metadata. appId", zzef.zzam((String)object10), (Object)sQLiteException);
                }
                this.zzgy().setTransactionSuccessful();
                return true;
            }
            this.zzgy().setTransactionSuccessful();
            return false;
        }
        finally {
            this.zzgy().endTransaction();
        }
    }

    @VisibleForTesting
    private final void zza(zzbs.zzg.zza zza2, long l, boolean bl) {
        zzjp zzjp2;
        String string = "_lte";
        if (bl) {
            string = "_se";
        }
        zzjp2 = (zzjp2 = this.zzgy().zze(zza2.zzag(), string)) == null || zzjp2.value == null ? new zzjp(zza2.zzag(), "auto", string, this.zzj.zzx().currentTimeMillis(), (Object)l) : new zzjp(zza2.zzag(), "auto", string, this.zzj.zzx().currentTimeMillis(), (Object)((Long)zzjp2.value + l));
        zzbs.zzk zzk2 = (zzbs.zzk)((zzey)zzbs.zzk.zzqu().zzdb(string).zzbk(this.zzj.zzx().currentTimeMillis()).zzbl((Long)zzjp2.value).zzug());
        boolean bl2 = false;
        for (int i = 0; i < zza2.zznp(); ++i) {
            if (!string.equals(zza2.zzs(i).getName())) continue;
            zza2.zza(i, zzk2);
            bl2 = true;
            break;
        }
        if (!bl2) {
            zza2.zza(zzk2);
        }
        if (l > 0L) {
            this.zzgy().zza(zzjp2);
            String string2 = "lifetime";
            if (bl) {
                string2 = "session-scoped";
            }
            this.zzj.zzab().zzgr().zza("Updated engagement user property. scope, value", (Object)string2, zzjp2.value);
        }
    }

    private final boolean zza(zzbs.zzc.zza zza2, zzbs.zzc.zza zza3) {
        Preconditions.checkArgument((boolean)"_e".equals(zza2.getName()));
        this.zzgw();
        zzbs.zze zze2 = zzjo.zza((zzbs.zzc)((zzey)zza2.zzug()), "_sc");
        String string = zze2 == null ? null : zze2.zzmy();
        this.zzgw();
        zzbs.zze zze3 = zzjo.zza((zzbs.zzc)((zzey)zza3.zzug()), "_pc");
        String string2 = zze3 == null ? null : zze3.zzmy();
        if (string2 != null && string2.equals(string)) {
            this.zzgw();
            zzbs.zze zze4 = zzjo.zza((zzbs.zzc)((zzey)zza2.zzug()), "_et");
            if (!zze4.zzna() || zze4.zznb() <= 0L) {
                return true;
            }
            long l = zze4.zznb();
            this.zzgw();
            zze4 = zzjo.zza((zzbs.zzc)((zzey)zza3.zzug()), "_et");
            if (zze4 != null && zze4.zznb() > 0L) {
                l += zze4.zznb();
            }
            this.zzgw();
            zzjo.zza(zza3, "_et", l);
            this.zzgw();
            zzjo.zza(zza2, "_fr", 1L);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    private static void zza(zzbs.zzc.zza zza2, @NonNull String string) {
        List<zzbs.zze> list = zza2.zzmj();
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(list.get(i).getName())) continue;
            int n = i;
            zza2.zzm(n);
            return;
        }
    }

    @VisibleForTesting
    private static void zza(zzbs.zzc.zza zza2, int n, String string) {
        List<zzbs.zze> list = zza2.zzmj();
        for (int i = 0; i < list.size(); ++i) {
            if (!"_err".equals(list.get(i).getName())) continue;
            return;
        }
        zzbs.zze zze2 = (zzbs.zze)((zzey)zzbs.zze.zzng().zzbz("_err").zzam(n).zzug());
        zzbs.zze zze3 = (zzbs.zze)((zzey)zzbs.zze.zzng().zzbz("_ev").zzca(string).zzug());
        zza2.zza(zze2).zza(zze3);
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(int n, Throwable throwable, byte[] byArray, String string) {
        this.zzo();
        this.zzjj();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzth;
            this.zzth = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzj.zzac().zzlj.set(this.zzj.zzx().currentTimeMillis());
                    this.zzj.zzac().zzlk.set(0L);
                    this.zzjn();
                    this.zzj.zzab().zzgs().zza("Successful upload. Got network response. code, size", (Object)n, (Object)byArray.length);
                    this.zzgy().beginTransaction();
                    try {
                        for (Long l : list) {
                            try {
                                long l2 = l;
                                zzx zzx2 = this.zzgy();
                                zzx2.zzo();
                                zzx2.zzbi();
                                SQLiteDatabase sQLiteDatabase = zzx2.getWritableDatabase();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                try {
                                    if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                    throw new SQLiteException("Deleted fewer rows from queue than expected");
                                }
                                catch (SQLiteException sQLiteException) {
                                    zzx2.zzab().zzgk().zza("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                    throw sQLiteException;
                                }
                            }
                            catch (SQLiteException sQLiteException) {
                                if (this.zzti != null && this.zzti.contains(l)) continue;
                                throw sQLiteException;
                            }
                        }
                        this.zzgy().setTransactionSuccessful();
                    }
                    finally {
                        this.zzgy().endTransaction();
                    }
                    this.zzti = null;
                    if (this.zzjf().zzgv() && this.zzjm()) {
                        this.zzjl();
                    } else {
                        this.zztj = -1L;
                        this.zzjn();
                    }
                    this.zzsy = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzj.zzab().zzgk().zza("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzsy = this.zzj.zzx().elapsedRealtime();
                    this.zzj.zzab().zzgs().zza("Disable upload, time", (Object)this.zzsy);
                }
            } else {
                this.zzj.zzab().zzgs().zza("Network upload failed. Will retry later. code, error", (Object)n, (Object)throwable);
                this.zzj.zzac().zzlk.set(this.zzj.zzx().currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzj.zzac().zzll.set(this.zzj.zzx().currentTimeMillis());
                }
                this.zzgy().zzb(list);
                this.zzjn();
            }
            return;
        }
        finally {
            this.zztd = false;
            this.zzjo();
        }
    }

    private final boolean zzjm() {
        this.zzo();
        this.zzjj();
        return this.zzgy().zzcd() || !TextUtils.isEmpty((CharSequence)this.zzgy().zzby());
    }

    @WorkerThread
    private final void zzb(zzf zzf2) {
        this.zzo();
        if (TextUtils.isEmpty((CharSequence)zzf2.getGmpAppId()) && (!zzs.zzbx() || TextUtils.isEmpty((CharSequence)zzf2.zzah()))) {
            this.zzb(zzf2.zzag(), 204, null, null, null);
            return;
        }
        Object object = zzf2;
        Object object2 = this.zzj.zzad();
        Object object3 = new Uri.Builder();
        String string = object.getGmpAppId();
        if (TextUtils.isEmpty((CharSequence)string) && zzs.zzbx()) {
            string = object.zzah();
        }
        String string2 = String.valueOf(string);
        object3.scheme((String)zzak.zzgj.get(null)).encodedAuthority((String)zzak.zzgk.get(null)).path(string2.length() != 0 ? "config/app/".concat(string2) : new String("config/app/")).appendQueryParameter("app_instance_id", object.getAppInstanceId()).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", String.valueOf(object2.zzao()));
        String string3 = object3.build().toString();
        try {
            URL uRL = new URL(string3);
            this.zzj.zzab().zzgs().zza("Fetching remote configuration", (Object)zzf2.zzag());
            zzbw zzbw2 = this.zzgz().zzaw(zzf2.zzag());
            ArrayMap arrayMap = null;
            String string4 = this.zzgz().zzax(zzf2.zzag());
            if (zzbw2 != null && !TextUtils.isEmpty((CharSequence)string4)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string4);
            }
            this.zztc = true;
            zzjl zzjl2 = new zzjl(this);
            string = arrayMap;
            object3 = uRL;
            object = zzf2.zzag();
            object2 = this.zzjf();
            object2.zzo();
            ((zzjh)((Object)object2)).zzbi();
            Preconditions.checkNotNull((Object)object3);
            Preconditions.checkNotNull((Object)zzjl2);
            object2.zzaa().zzb((Runnable)new zzen((zzej)((Object)object2), (String)object, (URL)object3, null, (Map)((Object)string), zzjl2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzj.zzab().zzgk().zza("Failed to parse config URL. Not fetching. appId", zzef.zzam((String)zzf2.zzag()), (Object)string3);
            return;
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzo();
        this.zzjj();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzj.zzab().zzgs().zza("onConfigFetched. Response size", (Object)byArray.length);
            this.zzgy().beginTransaction();
            try {
                boolean bl;
                zzf zzf2 = this.zzgy().zzab(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzf2 == null) {
                    this.zzj.zzab().zzgn().zza("App does not exist in onConfigFetched. appId", zzef.zzam((String)string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzgz().zzaw(string) == null && !this.zzgz().zza(string, null, null) : !this.zzgz().zza(string, byArray, string2)) {
                        return;
                    }
                    zzf2.zzl(this.zzj.zzx().currentTimeMillis());
                    this.zzgy().zza(zzf2);
                    if (n == 404) {
                        this.zzj.zzab().zzgp().zza("Config not found. Using empty config. appId", (Object)string);
                    } else {
                        this.zzj.zzab().zzgs().zza("Successfully fetched config. Got network response. code, size", (Object)n, (Object)byArray.length);
                    }
                    if (this.zzjf().zzgv() && this.zzjm()) {
                        this.zzjl();
                    } else {
                        this.zzjn();
                    }
                } else {
                    zzf2.zzm(this.zzj.zzx().currentTimeMillis());
                    this.zzgy().zza(zzf2);
                    this.zzj.zzab().zzgs().zza("Fetching config failed. code, error", (Object)n, (Object)throwable);
                    this.zzgz().zzay(string);
                    this.zzj.zzac().zzlk.set(this.zzj.zzx().currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzj.zzac().zzll.set(this.zzj.zzx().currentTimeMillis());
                    }
                    this.zzjn();
                }
                this.zzgy().setTransactionSuccessful();
            }
            finally {
                this.zzgy().endTransaction();
            }
            return;
        }
        finally {
            this.zztc = false;
            this.zzjo();
        }
    }

    @WorkerThread
    private final void zzjn() {
        long l;
        long l2;
        long l3;
        block15: {
            String string;
            this.zzo();
            this.zzjj();
            if (!this.zzjr() && !this.zzj.zzad().zza(zzak.zzim)) {
                return;
            }
            if (this.zzsy > 0L) {
                l3 = this.zzj.zzx().elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzsy);
                if (l2 > 0L) {
                    this.zzj.zzab().zzgs().zza("Upload has been suspended. Will update scheduling later in approximately ms", (Object)l2);
                    this.zzjg().unregister();
                    this.zzjh().cancel();
                    return;
                }
                this.zzsy = 0L;
            }
            if (!this.zzj.zzie() || !this.zzjm()) {
                this.zzj.zzab().zzgs().zzao("Nothing to upload or uploading impossible");
                this.zzjg().unregister();
                this.zzjh().cancel();
                return;
            }
            zzjg zzjg2 = this;
            long l4 = zzjg2.zzj.zzx().currentTimeMillis();
            long l5 = Math.max(0L, (Long)zzak.zzhf.get(null));
            boolean bl = zzjg2.zzgy().zzce() || zzjg2.zzgy().zzbz();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzjg2.zzj.zzad().zzbu())) && !".none.".equals(string) ? Math.max(0L, (Long)zzak.zzha.get(null)) : Math.max(0L, (Long)zzak.zzgz.get(null))) : Math.max(0L, (Long)zzak.zzgy.get(null));
            long l7 = zzjg2.zzj.zzac().zzlj.get();
            long l8 = zzjg2.zzj.zzac().zzlk.get();
            long l9 = zzjg2.zzgy().zzcb();
            long l10 = zzjg2.zzgy().zzcc();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzjg2.zzgw().zzb(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < Math.min(20, Math.max(0, (Integer)zzak.zzhh.get(null))); ++i) {
                        long l15 = 1L << i;
                        if ((l14 += Math.max(0L, (Long)zzak.zzhg.get(null)) * l15) <= l8) continue;
                        l = l14;
                        break block15;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzj.zzab().zzgs().zzao("Next upload time is 0");
            this.zzjg().unregister();
            this.zzjh().cancel();
            return;
        }
        if (!this.zzjf().zzgv()) {
            this.zzj.zzab().zzgs().zzao("No network");
            this.zzjg().zzha();
            this.zzjh().cancel();
            return;
        }
        l2 = this.zzj.zzac().zzll.get();
        long l16 = Math.max(0L, (Long)zzak.zzgw.get(null));
        if (!this.zzgw().zzb(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzjg().unregister();
        long l17 = l3 - this.zzj.zzx().currentTimeMillis();
        if (l17 <= 0L) {
            l17 = Math.max(0L, (Long)zzak.zzhb.get(null));
            this.zzj.zzac().zzlj.set(this.zzj.zzx().currentTimeMillis());
        }
        this.zzj.zzab().zzgs().zza("Upload scheduled in approximately ms", (Object)l17);
        this.zzjh().zzv(l17);
    }

    @WorkerThread
    final void zzf(Runnable runnable) {
        this.zzo();
        if (this.zzsz == null) {
            this.zzsz = new ArrayList<Runnable>();
        }
        this.zzsz.add(runnable);
    }

    @WorkerThread
    private final void zzjo() {
        this.zzo();
        if (this.zztc || this.zztd || this.zzte) {
            this.zzj.zzab().zzgs().zza("Not stopping services. fetch, network, upload", (Object)this.zztc, (Object)this.zztd, (Object)this.zzte);
            return;
        }
        this.zzj.zzab().zzgs().zzao("Stopping uploading service(s)");
        if (this.zzsz == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzsz.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzsz.clear();
    }

    @WorkerThread
    private final Boolean zzc(zzf zzf2) {
        try {
            if (zzf2.zzam() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.zzj.getContext()).getPackageInfo((String)zzf2.zzag(), (int)0).versionCode;
                if (zzf2.zzam() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.zzj.getContext()).getPackageInfo((String)zzf2.zzag(), (int)0).versionName;
                if (zzf2.zzal() != null && zzf2.zzal().equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzjp() {
        this.zzo();
        if (this.zzj.zzad().zza(zzak.zzjh) && this.zztf != null && this.zztf.isValid()) {
            this.zzj.zzab().zzgs().zzao("Storage concurrent access okay");
            return true;
        }
        String string = "google_app_measurement.db";
        File file = this.zzj.getContext().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zztg = new RandomAccessFile(file2, "rw").getChannel();
            this.zztf = this.zztg.tryLock();
            if (this.zztf != null) {
                this.zzj.zzab().zzgs().zzao("Storage concurrent access okay");
                return true;
            }
            this.zzj.zzab().zzgk().zzao("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzj.zzab().zzgk().zza("Failed to acquire storage lock", (Object)fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzj.zzab().zzgk().zza("Failed to access storage lock file", (Object)iOException);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            this.zzj.zzab().zzgn().zza("Storage lock already acquired", (Object)overlappingFileLockException);
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        this.zzo();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj.zzab().zzgk().zzao("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzj.zzab().zzgn().zza("Unexpected data length. Bytes read", (Object)n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzj.zzab().zzgk().zza("Failed to read from channel", (Object)iOException);
        }
        return n;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        this.zzo();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj.zzab().zzgk().zzao("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzj.zzab().zzgk().zza("Error writing to channel. Bytes written", (Object)fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzj.zzab().zzgk().zza("Failed to write to channel", (Object)iOException);
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    final void zzjq() {
        block3: {
            block4: {
                this.zzo();
                this.zzjj();
                if (this.zzsx) break block3;
                this.zzsx = true;
                var1_1 = this;
                var1_1.zzo();
                var1_1.zzjj();
                if (!var1_1.zzj.zzad().zza(zzak.zzim) && !var1_1.zzjr() || !var1_1.zzjp()) break block3;
                var2_2 = var1_1.zza(var1_1.zztg);
                var6_4 = var3_3 = var1_1.zzj.zzr().zzgf();
                var5_5 = var2_2;
                var4_6 = var1_1;
                var4_6.zzo();
                if (var5_5 <= var6_4) break block4;
                var4_6.zzj.zzab().zzgk().zza("Panic: can't downgrade version. Previous, current version", (Object)var5_5, (Object)var6_4);
                v0 = false;
                break block3;
            }
            if (var5_5 >= var6_4) ** GOTO lbl25
            if (!var4_6.zza(var6_4, var4_6.zztg)) {
                var4_6.zzj.zzab().zzgk().zza("Storage version upgrade failed. Previous, current version", (Object)var5_5, (Object)var6_4);
                v0 = false;
            } else {
                var4_6.zzj.zzab().zzgs().zza("Storage version upgraded. Previous, current version", (Object)var5_5, (Object)var6_4);
lbl25:
                // 2 sources

                v0 = true;
            }
        }
        if (!this.zzsw && !this.zzj.zzad().zza(zzak.zzim)) {
            this.zzj.zzab().zzgq().zzao("This instance being marked as an uploader");
            this.zzsw = true;
            this.zzjn();
        }
    }

    @WorkerThread
    private final boolean zzjr() {
        this.zzo();
        this.zzjj();
        return this.zzsw;
        {
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zzd(zzn zzn2) {
        if (this.zzth != null) {
            this.zzti = new ArrayList<Long>();
            this.zzti.addAll(this.zzth);
        }
        String string = zzn2.packageName;
        zzx zzx2 = this.zzgy();
        Preconditions.checkNotEmpty((String)string);
        zzx2.zzo();
        zzx2.zzbi();
        try {
            SQLiteDatabase sQLiteDatabase = zzx2.getWritableDatabase();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray);
            if (n > 0) {
                zzx2.zzab().zzgs().zza("Reset analytics data. app, records", (Object)string, (Object)n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzx2.zzab().zzgk().zza("Error resetting analytics data. appId, error", zzef.zzam((String)string), (Object)sQLiteException);
        }
        zzn zzn3 = this.zza(this.zzj.getContext(), zzn2.packageName, zzn2.zzcg, zzn2.zzcq, zzn2.zzcs, zzn2.zzct, zzn2.zzdr, zzn2.zzcu);
        if (zzn2.zzcq) {
            this.zzf(zzn3);
        }
    }

    private final zzn zza(Context context, String string, String string2, boolean bl, boolean bl2, boolean bl3, long l, String string3) {
        String string4 = "Unknown";
        String string5 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string6 = "Unknown";
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            this.zzj.zzab().zzgk().zzao("PackageManager is null, can not log app install information");
            return null;
        }
        try {
            string4 = packageManager.getInstallerPackageName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzj.zzab().zzgk().zza("Error retrieving installer package name. appId", zzef.zzam((String)string));
        }
        if (string4 == null) {
            string4 = "manual_install";
        } else if ("com.android.vending".equals(string4)) {
            string4 = "";
        }
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(string, 0);
            if (packageInfo != null) {
                CharSequence charSequence = Wrappers.packageManager((Context)context).getApplicationLabel(string);
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    string6 = charSequence.toString();
                }
                string5 = packageInfo.versionName;
                n = packageInfo.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzj.zzab().zzgk().zza("Error retrieving newly installed package info. appId, appName", zzef.zzam((String)string), (Object)string6);
            return null;
        }
        long l2 = 0L;
        zzr zzr2 = this.zzj.zzae();
        long l3 = 0L;
        if (this.zzj.zzad().zzr(string)) {
            l3 = l;
        }
        return new zzn(string, string2, string5, (long)n, string4, this.zzj.zzad().zzao(), this.zzj.zzz().zzc(context, string), null, bl, false, "", l2, l3, 0, bl2, bl3, false, string3, null, 0L, null);
    }

    @WorkerThread
    final void zzb(zzjn zzjn2, zzn zzn2) {
        this.zzo();
        this.zzjj();
        if (TextUtils.isEmpty((CharSequence)zzn2.zzcg) && TextUtils.isEmpty((CharSequence)zzn2.zzcu)) {
            return;
        }
        if (!zzn2.zzcq) {
            this.zzg(zzn2);
            return;
        }
        int n = this.zzj.zzz().zzbm(zzjn2.name);
        if (n != 0) {
            this.zzj.zzz();
            String string = zzjs.zza((String)zzjn2.name, (int)24, (boolean)true);
            int n2 = zzjn2.name != null ? zzjn2.name.length() : 0;
            this.zzj.zzz().zza(zzn2.packageName, n, "_ev", string, n2);
            return;
        }
        n = this.zzj.zzz().zzc(zzjn2.name, zzjn2.getValue());
        if (n != 0) {
            this.zzj.zzz();
            String string = zzjs.zza((String)zzjn2.name, (int)24, (boolean)true);
            Object object = zzjn2.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzj.zzz().zza(zzn2.packageName, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzj.zzz().zzd(zzjn2.name, zzjn2.getValue());
        if (object == null) {
            return;
        }
        if ("_sid".equals(zzjn2.name) && this.zzj.zzad().zzw(zzn2.packageName)) {
            zzae zzae2;
            zzn zzn3 = zzn2;
            String string = zzjn2.origin;
            long l = zzjn2.zztr;
            zzjg zzjg2 = this;
            long l2 = 0L;
            zzjp zzjp2 = zzjg2.zzgy().zze(zzn3.packageName, "_sno");
            if (zzjp2 != null && zzjp2.value instanceof Long) {
                l2 = (Long)zzjp2.value;
            } else {
                if (zzjp2 != null) {
                    zzjg2.zzj.zzab().zzgn().zza("Retrieved last session number from database does not contain a valid (long) value", zzjp2.value);
                }
                if (zzjg2.zzj.zzad().zze(zzn3.packageName, zzak.zzie) && (zzae2 = zzjg2.zzgy().zzc(zzn3.packageName, "_s")) != null) {
                    l2 = zzae2.zzfg;
                    zzjg2.zzj.zzab().zzgs().zza("Backfill the session number. Last used session number", (Object)l2);
                }
            }
            zzae2 = new zzjn("_sno", l, (Object)(++l2), string);
            zzjg2.zzb((zzjn)zzae2, zzn3);
        }
        zzjp zzjp3 = new zzjp(zzn2.packageName, zzjn2.origin, zzjn2.name, zzjn2.zztr, object);
        this.zzj.zzab().zzgr().zza("Setting user property", (Object)this.zzj.zzy().zzal(zzjp3.name), object);
        this.zzgy().beginTransaction();
        try {
            this.zzg(zzn2);
            boolean bl = this.zzgy().zza(zzjp3);
            this.zzgy().setTransactionSuccessful();
            if (bl) {
                this.zzj.zzab().zzgr().zza("User property set", (Object)this.zzj.zzy().zzal(zzjp3.name), zzjp3.value);
            } else {
                this.zzj.zzab().zzgk().zza("Too many unique user properties are set. Ignoring user property", (Object)this.zzj.zzy().zzal(zzjp3.name), zzjp3.value);
                this.zzj.zzz().zza(zzn2.packageName, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zzgy().endTransaction();
        }
    }

    @WorkerThread
    final void zzc(zzjn zzjn2, zzn zzn2) {
        this.zzo();
        this.zzjj();
        if (TextUtils.isEmpty((CharSequence)zzn2.zzcg) && TextUtils.isEmpty((CharSequence)zzn2.zzcu)) {
            return;
        }
        if (!zzn2.zzcq) {
            this.zzg(zzn2);
            return;
        }
        if (this.zzj.zzad().zze(zzn2.packageName, zzak.zzij)) {
            if ("_npa".equals(zzjn2.name) && zzn2.zzcv != null) {
                this.zzj.zzab().zzgr().zzao("Falling back to manifest metadata value for ad personalization");
                zzjn zzjn3 = new zzjn("_npa", this.zzj.zzx().currentTimeMillis(), (Object)(zzn2.zzcv != false ? 1L : 0L), "auto");
                this.zzb(zzjn3, zzn2);
                return;
            }
            this.zzj.zzab().zzgr().zza("Removing user property", (Object)this.zzj.zzy().zzal(zzjn2.name));
            this.zzgy().beginTransaction();
            try {
                this.zzg(zzn2);
                this.zzgy().zzd(zzn2.packageName, zzjn2.name);
                this.zzgy().setTransactionSuccessful();
                this.zzj.zzab().zzgr().zza("User property removed", (Object)this.zzj.zzy().zzal(zzjn2.name));
                return;
            }
            finally {
                this.zzgy().endTransaction();
            }
        }
        this.zzj.zzab().zzgr().zza("Removing user property", (Object)this.zzj.zzy().zzal(zzjn2.name));
        this.zzgy().beginTransaction();
        try {
            this.zzg(zzn2);
            this.zzgy().zzd(zzn2.packageName, zzjn2.name);
            this.zzgy().setTransactionSuccessful();
            this.zzj.zzab().zzgr().zza("User property removed", (Object)this.zzj.zzy().zzal(zzjn2.name));
            return;
        }
        finally {
            this.zzgy().endTransaction();
        }
    }

    final void zzb(zzjh zzjh2) {
        ++this.zzta;
    }

    final void zzjs() {
        ++this.zztb;
    }

    final zzfj zzjt() {
        return this.zzj;
    }

    @WorkerThread
    final void zzf(zzn zzn2) {
        int n;
        this.zzo();
        this.zzjj();
        Preconditions.checkNotNull((Object)zzn2);
        Preconditions.checkNotEmpty((String)zzn2.packageName);
        if (TextUtils.isEmpty((CharSequence)zzn2.zzcg) && TextUtils.isEmpty((CharSequence)zzn2.zzcu)) {
            return;
        }
        zzf zzf2 = this.zzgy().zzab(zzn2.packageName);
        if (zzf2 != null && TextUtils.isEmpty((CharSequence)zzf2.getGmpAppId()) && !TextUtils.isEmpty((CharSequence)zzn2.zzcg)) {
            zzf2.zzl(0L);
            this.zzgy().zza(zzf2);
            this.zzgz().zzaz(zzn2.packageName);
        }
        if (!zzn2.zzcq) {
            this.zzg(zzn2);
            return;
        }
        long l = zzn2.zzdr;
        if (l == 0L) {
            l = this.zzj.zzx().currentTimeMillis();
        }
        if (this.zzj.zzad().zze(zzn2.packageName, zzak.zzij)) {
            this.zzj.zzw().zzct();
        }
        if ((n = zzn2.zzds) != 0 && n != 1) {
            this.zzj.zzab().zzgn().zza("Incorrect app type, assuming installed app. appId, appType", zzef.zzam((String)zzn2.packageName), (Object)n);
            n = 0;
        }
        this.zzgy().beginTransaction();
        try {
            zzai zzai2;
            Bundle bundle;
            zzjp zzjp2;
            if (this.zzj.zzad().zze(zzn2.packageName, zzak.zzij) && ((zzjp2 = this.zzgy().zze(zzn2.packageName, "_npa")) == null || "auto".equals(zzjp2.origin))) {
                zzjn zzjn2;
                if (zzn2.zzcv != null) {
                    zzjn2 = new zzjn("_npa", l, (Object)(zzn2.zzcv != false ? 1L : 0L), "auto");
                    if (zzjp2 == null || !zzjp2.value.equals(zzjn2.zzts)) {
                        this.zzb(zzjn2, zzn2);
                    }
                } else if (zzjp2 != null) {
                    zzjn2 = new zzjn("_npa", l, null, "auto");
                    this.zzc(zzjn2, zzn2);
                }
            }
            long l2 = l;
            zzn zzn3 = zzn2;
            zzjg zzjg2 = this;
            zzf zzf3 = zzjg2.zzgy().zzab(zzn3.packageName);
            if (zzf3 != null) {
                zzjg2.zzj.zzz();
                if (zzjs.zza((String)zzn3.zzcg, (String)zzf3.getGmpAppId(), (String)zzn3.zzcu, (String)zzf3.zzah())) {
                    zzjg2.zzj.zzab().zzgn().zza("New GMP App Id passed in. Removing cached database data. appId", zzef.zzam((String)zzf3.zzag()));
                    String string = zzf3.zzag();
                    zzx zzx2 = zzjg2.zzgy();
                    zzx2.zzbi();
                    zzx2.zzo();
                    Preconditions.checkNotEmpty((String)string);
                    try {
                        SQLiteDatabase sQLiteDatabase = zzx2.getWritableDatabase();
                        String[] stringArray = new String[]{string};
                        int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                        if (n2 > 0) {
                            zzx2.zzab().zzgs().zza("Deleted application data. app, records", (Object)string, (Object)n2);
                        }
                    }
                    catch (SQLiteException sQLiteException) {
                        zzx2.zzab().zzgk().zza("Error deleting application data. appId, error", zzef.zzam((String)string), (Object)sQLiteException);
                    }
                    zzf3 = null;
                }
            }
            if (zzf3 != null) {
                if (zzf3.zzam() != Integer.MIN_VALUE) {
                    if (zzf3.zzam() != zzn3.zzcn) {
                        bundle = new Bundle();
                        bundle.putString("_pv", zzf3.zzal());
                        zzai2 = new zzai("_au", new zzah(bundle), "auto", l2);
                        zzjg2.zzc(zzai2, zzn3);
                    }
                } else if (zzf3.zzal() != null && !zzf3.zzal().equals(zzn3.zzcm)) {
                    bundle = new Bundle();
                    bundle.putString("_pv", zzf3.zzal());
                    zzai2 = new zzai("_au", new zzah(bundle), "auto", l2);
                    zzjg2.zzc(zzai2, zzn3);
                }
            }
            this.zzg(zzn2);
            zzjp2 = null;
            if (n == 0) {
                zzjp2 = this.zzgy().zzc(zzn2.packageName, "_f");
            } else if (n == 1) {
                zzjp2 = this.zzgy().zzc(zzn2.packageName, "_v");
            }
            if (zzjp2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zzjn zzjn3;
                    zzjn zzjn4 = new zzjn("_fot", l, (Object)l3, "auto");
                    this.zzb(zzjn4, zzn2);
                    if (this.zzj.zzad().zzt(zzn2.zzcg)) {
                        zzn3 = zzn2;
                        zzjg2 = this;
                        zzjg2.zzo();
                        zzjg2.zzj.zzht().zzat(zzn3.packageName);
                    }
                    l2 = l;
                    zzn3 = zzn2;
                    zzjg2 = this;
                    zzjg2.zzo();
                    zzjg2.zzjj();
                    zzf3 = new Bundle();
                    zzf3.putLong("_c", 1L);
                    zzf3.putLong("_r", 1L);
                    zzf3.putLong("_uwa", 0L);
                    zzf3.putLong("_pfo", 0L);
                    zzf3.putLong("_sys", 0L);
                    zzf3.putLong("_sysu", 0L);
                    if (zzjg2.zzj.zzad().zzz(zzn3.packageName)) {
                        zzf3.putLong("_et", 1L);
                    }
                    if (zzn3.zzdt) {
                        zzf3.putLong("_dac", 1L);
                    }
                    if (zzjg2.zzj.getContext().getPackageManager() == null) {
                        zzjg2.zzj.zzab().zzgk().zza("PackageManager is null, first open report might be inaccurate. appId", zzef.zzam((String)zzn3.packageName));
                    } else {
                        zzai2 = null;
                        try {
                            zzai2 = Wrappers.packageManager((Context)zzjg2.zzj.getContext()).getPackageInfo(zzn3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzjg2.zzj.zzab().zzgk().zza("Package info is null, first open report might be inaccurate. appId", zzef.zzam((String)zzn3.packageName), (Object)nameNotFoundException);
                        }
                        if (zzai2 != null && zzai2.firstInstallTime != 0L) {
                            boolean bl = false;
                            if (zzai2.firstInstallTime != zzai2.lastUpdateTime) {
                                zzf3.putLong("_uwa", 1L);
                            } else {
                                bl = true;
                            }
                            zzjn3 = new zzjn("_fi", l2, (Object)(bl ? 1L : 0L), "auto");
                            zzjg2.zzb(zzjn3, zzn3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zzjg2.zzj.getContext()).getApplicationInfo(zzn3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzjg2.zzj.zzab().zzgk().zza("Application info is null, first open report might be inaccurate. appId", zzef.zzam((String)zzn3.packageName), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzf3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzf3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    String string = zzn3.packageName;
                    zzx zzx3 = zzjg2.zzgy();
                    Preconditions.checkNotEmpty((String)string);
                    zzx3.zzo();
                    zzx3.zzbi();
                    long l4 = zzx3.zzj(string, "first_open_count");
                    if (l4 >= 0L) {
                        zzf3.putLong("_pfo", l4);
                    }
                    zzjn3 = new zzai("_f", new zzah((Bundle)zzf3), "auto", l2);
                    zzjg2.zzc((zzai)zzjn3, zzn3);
                } else if (n == 1) {
                    zzjn zzjn5 = new zzjn("_fvt", l, (Object)l3, "auto");
                    this.zzb(zzjn5, zzn2);
                    l2 = l;
                    zzn3 = zzn2;
                    zzjg2 = this;
                    zzjg2.zzo();
                    zzjg2.zzjj();
                    zzf3 = new Bundle();
                    zzf3.putLong("_c", 1L);
                    zzf3.putLong("_r", 1L);
                    if (zzjg2.zzj.zzad().zzz(zzn3.packageName)) {
                        zzf3.putLong("_et", 1L);
                    }
                    if (zzn3.zzdt) {
                        zzf3.putLong("_dac", 1L);
                    }
                    bundle = new zzai("_v", new zzah((Bundle)zzf3), "auto", l2);
                    zzjg2.zzc((zzai)bundle, zzn3);
                }
                if (!this.zzj.zzad().zze(zzn2.packageName, zzak.zzii)) {
                    l2 = l;
                    zzn3 = zzn2;
                    zzjg2 = this;
                    zzf3 = new Bundle();
                    zzf3.putLong("_et", 1L);
                    if (zzjg2.zzj.zzad().zzz(zzn3.packageName)) {
                        zzf3.putLong("_fr", 1L);
                    }
                    bundle = new zzai("_e", new zzah((Bundle)zzf3), "auto", l2);
                    zzjg2.zzc((zzai)bundle, zzn3);
                }
            } else if (zzn2.zzdq) {
                l2 = l;
                zzn3 = zzn2;
                zzjg2 = this;
                zzf3 = new Bundle();
                bundle = new zzai("_cd", new zzah((Bundle)zzf3), "auto", l2);
                zzjg2.zzc((zzai)bundle, zzn3);
            }
            this.zzgy().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzgy().endTransaction();
        }
    }

    @WorkerThread
    private final zzn zzbi(String string) {
        zzf zzf2 = this.zzgy().zzab(string);
        if (zzf2 == null || TextUtils.isEmpty((CharSequence)zzf2.zzal())) {
            this.zzj.zzab().zzgr().zza("No app data available; dropping", (Object)string);
            return null;
        }
        Boolean bl = this.zzc(zzf2);
        if (bl != null && !bl.booleanValue()) {
            this.zzj.zzab().zzgk().zza("App version does not match; dropping. appId", zzef.zzam((String)string));
            return null;
        }
        return new zzn(string, zzf2.getGmpAppId(), zzf2.zzal(), zzf2.zzam(), zzf2.zzan(), zzf2.zzao(), zzf2.zzap(), null, zzf2.isMeasurementEnabled(), false, zzf2.getFirebaseInstanceId(), zzf2.zzbd(), 0L, 0, zzf2.zzbe(), zzf2.zzbf(), false, zzf2.zzah(), zzf2.zzbg(), zzf2.zzaq(), zzf2.zzbh());
    }

    @WorkerThread
    final void zze(zzq zzq2) {
        zzn zzn2 = this.zzbi(zzq2.packageName);
        if (zzn2 != null) {
            this.zzb(zzq2, zzn2);
        }
    }

    @WorkerThread
    final void zzb(zzq zzq2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzq2);
        Preconditions.checkNotEmpty((String)zzq2.packageName);
        Preconditions.checkNotNull((Object)zzq2.origin);
        Preconditions.checkNotNull((Object)zzq2.zzdw);
        Preconditions.checkNotEmpty((String)zzq2.zzdw.name);
        this.zzo();
        this.zzjj();
        if (TextUtils.isEmpty((CharSequence)zzn2.zzcg) && TextUtils.isEmpty((CharSequence)zzn2.zzcu)) {
            return;
        }
        if (!zzn2.zzcq) {
            this.zzg(zzn2);
            return;
        }
        zzq zzq3 = new zzq(zzq2);
        new zzq(zzq2).active = false;
        this.zzgy().beginTransaction();
        try {
            boolean bl = false;
            zzq zzq4 = this.zzgy().zzf(zzq3.packageName, zzq3.zzdw.name);
            if (zzq4 != null && !zzq4.origin.equals(zzq3.origin)) {
                this.zzj.zzab().zzgn().zza("Updating a conditional user property with different origin. name, origin, origin (from DB)", (Object)this.zzj.zzy().zzal(zzq3.zzdw.name), (Object)zzq3.origin, (Object)zzq4.origin);
            }
            if (zzq4 != null && zzq4.active) {
                zzq3.origin = zzq4.origin;
                zzq3.creationTimestamp = zzq4.creationTimestamp;
                zzq3.triggerTimeout = zzq4.triggerTimeout;
                zzq3.triggerEventName = zzq4.triggerEventName;
                zzq3.zzdy = zzq4.zzdy;
                zzq3.active = zzq4.active;
                zzq3.zzdw = new zzjn(zzq3.zzdw.name, zzq4.zzdw.zztr, zzq3.zzdw.getValue(), zzq4.zzdw.origin);
            } else if (TextUtils.isEmpty((CharSequence)zzq3.triggerEventName)) {
                zzq3.zzdw = new zzjn(zzq3.zzdw.name, zzq3.creationTimestamp, zzq3.zzdw.getValue(), zzq3.zzdw.origin);
                zzq3.active = true;
                bl = true;
            }
            if (zzq3.active) {
                zzjn zzjn2 = zzq3.zzdw;
                zzjp zzjp2 = new zzjp(zzq3.packageName, zzq3.origin, zzjn2.name, zzjn2.zztr, zzjn2.getValue());
                if (this.zzgy().zza(zzjp2)) {
                    this.zzj.zzab().zzgr().zza("User property updated immediately", (Object)zzq3.packageName, (Object)this.zzj.zzy().zzal(zzjp2.name), zzjp2.value);
                } else {
                    this.zzj.zzab().zzgk().zza("(2)Too many active user properties, ignoring", zzef.zzam((String)zzq3.packageName), (Object)this.zzj.zzy().zzal(zzjp2.name), zzjp2.value);
                }
                if (bl && zzq3.zzdy != null) {
                    zzai zzai2 = new zzai(zzq3.zzdy, zzq3.creationTimestamp);
                    this.zzd(zzai2, zzn2);
                }
            }
            if (this.zzgy().zza(zzq3)) {
                this.zzj.zzab().zzgr().zza("Conditional property added", (Object)zzq3.packageName, (Object)this.zzj.zzy().zzal(zzq3.zzdw.name), zzq3.zzdw.getValue());
            } else {
                this.zzj.zzab().zzgk().zza("Too many conditional properties, ignoring", zzef.zzam((String)zzq3.packageName), (Object)this.zzj.zzy().zzal(zzq3.zzdw.name), zzq3.zzdw.getValue());
            }
            this.zzgy().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzgy().endTransaction();
        }
    }

    @WorkerThread
    final void zzf(zzq zzq2) {
        zzn zzn2 = this.zzbi(zzq2.packageName);
        if (zzn2 != null) {
            this.zzc(zzq2, zzn2);
        }
    }

    @WorkerThread
    final void zzc(zzq zzq2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzq2);
        Preconditions.checkNotEmpty((String)zzq2.packageName);
        Preconditions.checkNotNull((Object)zzq2.zzdw);
        Preconditions.checkNotEmpty((String)zzq2.zzdw.name);
        this.zzo();
        this.zzjj();
        if (TextUtils.isEmpty((CharSequence)zzn2.zzcg) && TextUtils.isEmpty((CharSequence)zzn2.zzcu)) {
            return;
        }
        if (!zzn2.zzcq) {
            this.zzg(zzn2);
            return;
        }
        this.zzgy().beginTransaction();
        try {
            this.zzg(zzn2);
            zzq zzq3 = this.zzgy().zzf(zzq2.packageName, zzq2.zzdw.name);
            if (zzq3 != null) {
                this.zzj.zzab().zzgr().zza("Removing conditional user property", (Object)zzq2.packageName, (Object)this.zzj.zzy().zzal(zzq2.zzdw.name));
                this.zzgy().zzg(zzq2.packageName, zzq2.zzdw.name);
                if (zzq3.active) {
                    this.zzgy().zzd(zzq2.packageName, zzq2.zzdw.name);
                }
                if (zzq2.zzdz != null) {
                    Bundle bundle = null;
                    if (zzq2.zzdz.zzfq != null) {
                        bundle = zzq2.zzdz.zzfq.zzcv();
                    }
                    zzai zzai2 = this.zzj.zzz().zza(zzq2.packageName, zzq2.zzdz.name, bundle, zzq3.origin, zzq2.zzdz.zzfu, true, false);
                    this.zzd(zzai2, zzn2);
                }
            } else {
                this.zzj.zzab().zzgn().zza("Conditional user property doesn't exist", zzef.zzam((String)zzq2.packageName), (Object)this.zzj.zzy().zzal(zzq2.zzdw.name));
            }
            this.zzgy().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzgy().endTransaction();
        }
    }

    @WorkerThread
    private final zzf zzg(zzn zzn2) {
        this.zzo();
        this.zzjj();
        Preconditions.checkNotNull((Object)zzn2);
        Preconditions.checkNotEmpty((String)zzn2.packageName);
        zzf zzf2 = this.zzgy().zzab(zzn2.packageName);
        String string = this.zzj.zzac().zzaq(zzn2.packageName);
        boolean bl = false;
        if (zzf2 == null) {
            zzf2 = new zzf(this.zzj, zzn2.packageName);
            zzf2.zza(this.zzj.zzz().zzjy());
            zzf2.zzd(string);
            bl = true;
        } else if (!string.equals(zzf2.zzai())) {
            zzf2.zzd(string);
            zzf2.zza(this.zzj.zzz().zzjy());
            bl = true;
        }
        if (!TextUtils.equals((CharSequence)zzn2.zzcg, (CharSequence)zzf2.getGmpAppId())) {
            zzf2.zzb(zzn2.zzcg);
            bl = true;
        }
        if (!TextUtils.equals((CharSequence)zzn2.zzcu, (CharSequence)zzf2.zzah())) {
            zzf2.zzc(zzn2.zzcu);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzn2.zzci) && !zzn2.zzci.equals(zzf2.getFirebaseInstanceId())) {
            zzf2.zze(zzn2.zzci);
            bl = true;
        }
        if (zzn2.zzr != 0L && zzn2.zzr != zzf2.zzao()) {
            zzf2.zzh(zzn2.zzr);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzn2.zzcm) && !zzn2.zzcm.equals(zzf2.zzal())) {
            zzf2.zzf(zzn2.zzcm);
            bl = true;
        }
        if (zzn2.zzcn != zzf2.zzam()) {
            zzf2.zzg(zzn2.zzcn);
            bl = true;
        }
        if (zzn2.zzco != null && !zzn2.zzco.equals(zzf2.zzan())) {
            zzf2.zzg(zzn2.zzco);
            bl = true;
        }
        if (zzn2.zzcp != zzf2.zzap()) {
            zzf2.zzi(zzn2.zzcp);
            bl = true;
        }
        if (zzn2.zzcq != zzf2.isMeasurementEnabled()) {
            zzf2.setMeasurementEnabled(zzn2.zzcq);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzn2.zzdp) && !zzn2.zzdp.equals(zzf2.zzbb())) {
            zzf2.zzh(zzn2.zzdp);
            bl = true;
        }
        if (zzn2.zzcr != zzf2.zzbd()) {
            zzf2.zzt(zzn2.zzcr);
            bl = true;
        }
        if (zzn2.zzcs != zzf2.zzbe()) {
            zzf2.zzb(zzn2.zzcs);
            bl = true;
        }
        if (zzn2.zzct != zzf2.zzbf()) {
            zzf2.zzc(zzn2.zzct);
            bl = true;
        }
        if (this.zzj.zzad().zze(zzn2.packageName, zzak.zzij) && zzn2.zzcv != zzf2.zzbg()) {
            zzf2.zza(zzn2.zzcv);
            bl = true;
        }
        if (zzn2.zzs != 0L && zzn2.zzs != zzf2.zzaq()) {
            zzf2.zzj(zzn2.zzs);
            bl = true;
        }
        if (bl) {
            this.zzgy().zza(zzf2);
        }
        return zzf2;
    }

    final String zzh(zzn zzn2) {
        Future future = this.zzj.zzaa().zza((Callable)new zzjk(this, zzn2));
        try {
            return (String)future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzj.zzab().zzgk().zza("Failed to get app instance id. appId", zzef.zzam((String)zzn2.packageName), (Object)exception);
            return null;
        }
    }

    final void zzj(boolean bl) {
        this.zzjn();
    }

    static /* synthetic */ void zza(zzjg zzjg2, zzjm zzjm2) {
        zzjg2.zza(zzjm2);
    }

    static /* synthetic */ zzf zza(zzjg zzjg2, zzn zzn2) {
        return zzjg2.zzg(zzn2);
    }

    final class zza
    implements zzz {
        zzbs.zzg zztn;
        List<Long> zzto;
        List<zzbs.zzc> zztp;
        private long zztq;

        private zza() {
        }

        @Override
        public final void zzb(zzbs.zzg zzg2) {
            Preconditions.checkNotNull((Object)((Object)zzg2));
            this.zztn = zzg2;
        }

        @Override
        public final boolean zza(long l, zzbs.zzc zzc2) {
            Preconditions.checkNotNull((Object)((Object)zzc2));
            if (this.zztp == null) {
                this.zztp = new ArrayList<zzbs.zzc>();
            }
            if (this.zzto == null) {
                this.zzto = new ArrayList<Long>();
            }
            if (this.zztp.size() > 0 && zza.zza(this.zztp.get(0)) != zza.zza(zzc2)) {
                return false;
            }
            long l2 = this.zztq + (long)zzc2.zzuk();
            if (l2 >= (long)Math.max(0, (Integer)zzak.zzgn.get(null))) {
                return false;
            }
            this.zztq = l2;
            this.zztp.add(zzc2);
            this.zzto.add(l);
            return this.zztp.size() < Math.max(1, (Integer)zzak.zzgo.get(null));
        }

        private static long zza(zzbs.zzc zzc2) {
            return zzc2.getTimestampMillis() / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzjj zzjj2) {
            this();
        }
    }
}

