/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Parcelable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzbk;
import com.google.android.gms.internal.measurement.zzbs;
import com.google.android.gms.internal.measurement.zzbv;
import com.google.android.gms.internal.measurement.zzel;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzef;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzjp;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzs;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

final class zzx
extends zzjh {
    private static final String[] zzek = new String[]{"last_bundled_timestamp", "ALTER TABLE events ADD COLUMN last_bundled_timestamp INTEGER;", "last_bundled_day", "ALTER TABLE events ADD COLUMN last_bundled_day INTEGER;", "last_sampled_complex_event_id", "ALTER TABLE events ADD COLUMN last_sampled_complex_event_id INTEGER;", "last_sampling_rate", "ALTER TABLE events ADD COLUMN last_sampling_rate INTEGER;", "last_exempt_from_sampling", "ALTER TABLE events ADD COLUMN last_exempt_from_sampling INTEGER;", "current_session_count", "ALTER TABLE events ADD COLUMN current_session_count INTEGER;"};
    private static final String[] zzel = new String[]{"origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;"};
    private static final String[] zzem = new String[]{"app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;", "app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;", "gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;", "dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;", "measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;", "last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;", "day", "ALTER TABLE apps ADD COLUMN day INTEGER;", "daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;", "daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;", "daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;", "remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;", "config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;", "failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;", "app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;", "firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;", "daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;", "daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;", "health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;", "android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;", "adid_reporting_enabled", "ALTER TABLE apps ADD COLUMN adid_reporting_enabled INTEGER;", "ssaid_reporting_enabled", "ALTER TABLE apps ADD COLUMN ssaid_reporting_enabled INTEGER;", "admob_app_id", "ALTER TABLE apps ADD COLUMN admob_app_id TEXT;", "linked_admob_app_id", "ALTER TABLE apps ADD COLUMN linked_admob_app_id TEXT;", "dynamite_version", "ALTER TABLE apps ADD COLUMN dynamite_version INTEGER;", "safelisted_events", "ALTER TABLE apps ADD COLUMN safelisted_events TEXT;"};
    private static final String[] zzen = new String[]{"realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;"};
    private static final String[] zzeo = new String[]{"has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;", "retry_count", "ALTER TABLE queue ADD COLUMN retry_count INTEGER;"};
    private static final String[] zzep = new String[]{"session_scoped", "ALTER TABLE event_filters ADD COLUMN session_scoped BOOLEAN;"};
    private static final String[] zzeq = new String[]{"session_scoped", "ALTER TABLE property_filters ADD COLUMN session_scoped BOOLEAN;"};
    private static final String[] zzer = new String[]{"previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;"};
    private final zzy zzes;
    private final zzjd zzet = new zzjd(this.zzx());

    zzx(zzjg zzjg2) {
        super(zzjg2);
        String string = "google_app_measurement.db";
        this.zzes = new zzy(this, this.getContext(), string);
    }

    @Override
    protected final boolean zzbk() {
        return false;
    }

    @WorkerThread
    public final void beginTransaction() {
        this.zzbi();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public final void setTransactionSuccessful() {
        this.zzbi();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public final void endTransaction() {
        this.zzbi();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzab().zzgk().zza("Database error", (Object)string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray, long l) {
        long l2;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    long l3 = cursor.getLong(0);
                    return l3;
                }
                l2 = l;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return l2;
    }

    @VisibleForTesting
    @WorkerThread
    final SQLiteDatabase getWritableDatabase() {
        this.zzo();
        try {
            return this.zzes.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzab().zzgn().zza("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    @WorkerThread
    public final zzae zzc(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzo();
        this.zzbi();
        boolean bl = this.zzad().zze(string, zzak.zziz);
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("lifetime_count", "current_bundle_count", "last_fire_timestamp", "last_bundled_timestamp", "last_bundled_day", "last_sampled_complex_event_id", "last_sampling_rate", "last_exempt_from_sampling"));
        if (bl) {
            arrayList.add("current_session_count");
        }
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("events", arrayList.toArray(new String[0]), "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            long l4 = cursor.isNull(3) ? 0L : cursor.getLong(3);
            Long l5 = cursor.isNull(4) ? null : Long.valueOf(cursor.getLong(4));
            Long l6 = cursor.isNull(5) ? null : Long.valueOf(cursor.getLong(5));
            Long l7 = cursor.isNull(6) ? null : Long.valueOf(cursor.getLong(6));
            Boolean bl2 = null;
            if (!cursor.isNull(7)) {
                bl2 = cursor.getLong(7) == 1L;
            }
            long l8 = 0L;
            if (bl && !cursor.isNull(8)) {
                l8 = cursor.getLong(8);
            }
            zzae zzae2 = new zzae(string, string2, l, l2, l8, l3, l4, l5, l6, l7, bl2);
            if (cursor.moveToNext()) {
                this.zzab().zzgk().zza("Got multiple records for event aggregates, expected one. appId", zzef.zzam((String)string));
            }
            zzae zzae3 = zzae2;
            return zzae3;
        }
    }

    @WorkerThread
    public final void zza(zzae zzae2) {
        Preconditions.checkNotNull((Object)zzae2);
        this.zzo();
        this.zzbi();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzae2.zzce);
        contentValues.put("name", zzae2.name);
        contentValues.put("lifetime_count", Long.valueOf(zzae2.zzfg));
        contentValues.put("current_bundle_count", Long.valueOf(zzae2.zzfh));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzae2.zzfj));
        contentValues.put("last_bundled_timestamp", Long.valueOf(zzae2.zzfk));
        contentValues.put("last_bundled_day", zzae2.zzfl);
        contentValues.put("last_sampled_complex_event_id", zzae2.zzfm);
        contentValues.put("last_sampling_rate", zzae2.zzfn);
        if (this.zzad().zze(zzae2.zzce, zzak.zziz)) {
            contentValues.put("current_session_count", Long.valueOf(zzae2.zzfi));
        }
        Long l = null;
        if (zzae2.zzfo != null && zzae2.zzfo.booleanValue()) {
            l = 1L;
        }
        contentValues.put("last_exempt_from_sampling", l);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("events", null, contentValues, 5) == -1L) {
                this.zzab().zzgk().zza("Failed to insert/update event aggregates (got -1). appId", zzef.zzam((String)zzae2.zzce));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzab().zzgk().zza("Error storing event aggregates. appId", zzef.zzam((String)zzae2.zzce), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final void zzd(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzo();
        this.zzbi();
        try {
            int n = this.getWritableDatabase().delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzab().zzgs().zza("Deleted user attribute rows", (Object)n);
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzab().zzgk().zza("Error deleting user attribute. appId", zzef.zzam((String)string), (Object)this.zzy().zzal(string2), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final boolean zza(zzjp zzjp2) {
        Preconditions.checkNotNull((Object)zzjp2);
        this.zzo();
        this.zzbi();
        if (this.zze(zzjp2.zzce, zzjp2.name) == null && (zzjs.zzbk((String)zzjp2.name) ? this.zza("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzjp2.zzce}) >= 25L : (this.zzad().zze(zzjp2.zzce, zzak.zzij) ? !"_npa".equals(zzjp2.name) && this.zza("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzjp2.zzce, zzjp2.origin}) >= 25L : this.zza("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzjp2.zzce, zzjp2.origin}) >= 25L))) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzjp2.zzce);
        contentValues.put("origin", zzjp2.origin);
        contentValues.put("name", zzjp2.name);
        contentValues.put("set_timestamp", Long.valueOf(zzjp2.zztr));
        zzx.zza(contentValues, "value", zzjp2.value);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("user_attributes", null, contentValues, 5) == -1L) {
                this.zzab().zzgk().zza("Failed to insert/update user property (got -1). appId", zzef.zzam((String)zzjp2.zzce));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzab().zzgk().zza("Error storing user property. appId", zzef.zzam((String)zzjp2.zzce), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzjp zze(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzo();
        this.zzbi();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"set_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zza(cursor, 1);
            String string3 = cursor.getString(2);
            zzjp zzjp2 = new zzjp(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzab().zzgk().zza("Got multiple records for user property, expected one. appId", zzef.zzam((String)string));
            }
            zzjp zzjp3 = zzjp2;
            return zzjp3;
        }
    }

    @WorkerThread
    public final List<zzjp> zzaa(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzo();
        this.zzbi();
        ArrayList<zzjp> arrayList = new ArrayList<zzjp>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "origin", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", "1000");
            if (!cursor.moveToFirst()) {
                ArrayList<zzjp> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zza(cursor, 3);
                if (object2 == null) {
                    this.zzab().zzgk().zza("Read invalid user property value, ignoring it. appId", zzef.zzam((String)string));
                    continue;
                }
                zzjp zzjp2 = new zzjp(string, string2, (String)object, l, object2);
                arrayList.add(zzjp2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzjp> zza(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzo();
        this.zzbi();
        ArrayList<zzjp> arrayList = new ArrayList<zzjp>();
        try (Cursor cursor = null;){
            Object object;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            StringBuilder stringBuilder = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                stringBuilder.append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                arrayList2.add(String.valueOf(string3).concat("*"));
                stringBuilder.append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "set_timestamp", "value", "origin"}, stringBuilder.toString(), stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzjp> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzab().zzgk().zza("Read more than the max allowed user properties, ignoring excess", (Object)1000);
                    break;
                }
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zza(cursor, 2);
                string2 = cursor.getString(3);
                if (object2 == null) {
                    this.zzab().zzgk().zza("(2)Read invalid user property value, ignoring it", zzef.zzam((String)string), (Object)string2, (Object)string3);
                    continue;
                }
                zzjp zzjp2 = new zzjp(string, string2, (String)object, l, object2);
                arrayList.add(zzjp2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final boolean zza(zzq zzq2) {
        Preconditions.checkNotNull((Object)zzq2);
        this.zzo();
        this.zzbi();
        if (this.zze(zzq2.packageName, zzq2.zzdw.name) == null && this.zza("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{zzq2.packageName}) >= 1000L) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzq2.packageName);
        contentValues.put("origin", zzq2.origin);
        contentValues.put("name", zzq2.zzdw.name);
        zzx.zza(contentValues, "value", zzq2.zzdw.getValue());
        contentValues.put("active", Boolean.valueOf(zzq2.active));
        contentValues.put("trigger_event_name", zzq2.triggerEventName);
        contentValues.put("trigger_timeout", Long.valueOf(zzq2.triggerTimeout));
        this.zzz();
        contentValues.put("timed_out_event", zzjs.zza((Parcelable)zzq2.zzdx));
        contentValues.put("creation_timestamp", Long.valueOf(zzq2.creationTimestamp));
        this.zzz();
        contentValues.put("triggered_event", zzjs.zza((Parcelable)zzq2.zzdy));
        contentValues.put("triggered_timestamp", Long.valueOf(zzq2.zzdw.zztr));
        contentValues.put("time_to_live", Long.valueOf(zzq2.timeToLive));
        this.zzz();
        contentValues.put("expired_event", zzjs.zza((Parcelable)zzq2.zzdz));
        try {
            if (this.getWritableDatabase().insertWithOnConflict("conditional_properties", null, contentValues, 5) == -1L) {
                this.zzab().zzgk().zza("Failed to insert/update conditional user property (got -1)", zzef.zzam((String)zzq2.packageName));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzab().zzgk().zza("Error storing conditional user property", zzef.zzam((String)zzq2.packageName), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzq zzf(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzo();
        this.zzbi();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            Object object = this.zza(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzai zzai2 = (zzai)this.zzgw().zza(cursor.getBlob(5), zzai.CREATOR);
            long l2 = cursor.getLong(6);
            zzai zzai3 = (zzai)this.zzgw().zza(cursor.getBlob(7), zzai.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzai zzai4 = (zzai)this.zzgw().zza(cursor.getBlob(10), zzai.CREATOR);
            zzjn zzjn2 = new zzjn(string2, l3, object, string3);
            zzq zzq2 = new zzq(string, string3, zzjn2, l2, bl, string4, zzai2, l, zzai3, l4, zzai4);
            if (cursor.moveToNext()) {
                this.zzab().zzgk().zza("Got multiple records for conditional property, expected one", zzef.zzam((String)string), (Object)this.zzy().zzal(string2));
            }
            zzq zzq3 = zzq2;
            return zzq3;
        }
    }

    @WorkerThread
    public final int zzg(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzo();
        this.zzbi();
        try {
            return this.getWritableDatabase().delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzab().zzgk().zza("Error deleting conditional property", zzef.zzam((String)string), (Object)this.zzy().zzal(string2), (Object)sQLiteException);
            return 0;
        }
    }

    @WorkerThread
    public final List<zzq> zzb(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzo();
        this.zzbi();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            arrayList.add(String.valueOf(string3).concat("*"));
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zzb(stringBuilder.toString(), stringArray);
    }

    public final List<zzq> zzb(String string, String[] stringArray) {
        this.zzo();
        this.zzbi();
        ArrayList<zzq> arrayList = new ArrayList<zzq>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, string, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzq> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzab().zzgk().zza("Read more than the max allowed conditional properties, ignoring extra", (Object)1000);
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zza(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzai zzai2 = (zzai)this.zzgw().zza(cursor.getBlob(7), zzai.CREATOR);
                long l2 = cursor.getLong(8);
                zzai zzai3 = (zzai)this.zzgw().zza(cursor.getBlob(9), zzai.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzai zzai4 = (zzai)this.zzgw().zza(cursor.getBlob(12), zzai.CREATOR);
                zzjn zzjn2 = new zzjn(string3, l3, object2, string2);
                zzq zzq2 = new zzq((String)object, string2, zzjn2, l2, bl, string4, zzai2, l, zzai3, l4, zzai4);
                arrayList.add(zzq2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final zzf zzab(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzo();
        this.zzbi();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id", "adid_reporting_enabled", "ssaid_reporting_enabled", "admob_app_id", "dynamite_version", "safelisted_events"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzf zzf2 = new zzf(this.zzkz.zzjt(), string);
            zzf2.zza(cursor.getString(0));
            zzf2.zzb(cursor.getString(1));
            zzf2.zzd(cursor.getString(2));
            zzf2.zzk(cursor.getLong(3));
            zzf2.zze(cursor.getLong(4));
            zzf2.zzf(cursor.getLong(5));
            zzf2.zzf(cursor.getString(6));
            zzf2.zzg(cursor.getString(7));
            zzf2.zzh(cursor.getLong(8));
            zzf2.zzi(cursor.getLong(9));
            zzf2.setMeasurementEnabled(cursor.isNull(10) || cursor.getInt(10) != 0);
            zzf2.zzn(cursor.getLong(11));
            zzf2.zzo(cursor.getLong(12));
            zzf2.zzp(cursor.getLong(13));
            zzf2.zzq(cursor.getLong(14));
            zzf2.zzl(cursor.getLong(15));
            zzf2.zzm(cursor.getLong(16));
            zzf2.zzg(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzf2.zze(cursor.getString(18));
            zzf2.zzs(cursor.getLong(19));
            zzf2.zzr(cursor.getLong(20));
            zzf2.zzh(cursor.getString(21));
            zzf2.zzt(cursor.isNull(22) ? 0L : cursor.getLong(22));
            zzf2.zzb(cursor.isNull(23) || cursor.getInt(23) != 0);
            zzf2.zzc(cursor.isNull(24) || cursor.getInt(24) != 0);
            zzf2.zzc(cursor.getString(25));
            zzf2.zzj(cursor.isNull(26) ? 0L : cursor.getLong(26));
            if (!cursor.isNull(27)) {
                zzf2.zza(Arrays.asList(cursor.getString(27).split(",", -1)));
            }
            zzf2.zzaf();
            if (cursor.moveToNext()) {
                this.zzab().zzgk().zza("Got multiple records for app, expected one. appId", zzef.zzam((String)string));
            }
            zzf zzf3 = zzf2;
            return zzf3;
        }
    }

    @WorkerThread
    public final void zza(zzf zzf2) {
        Preconditions.checkNotNull((Object)zzf2);
        this.zzo();
        this.zzbi();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzf2.zzag());
        contentValues.put("app_instance_id", zzf2.getAppInstanceId());
        contentValues.put("gmp_app_id", zzf2.getGmpAppId());
        contentValues.put("resettable_device_id_hash", zzf2.zzai());
        contentValues.put("last_bundle_index", Long.valueOf(zzf2.zzar()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzf2.zzaj()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzf2.zzak()));
        contentValues.put("app_version", zzf2.zzal());
        contentValues.put("app_store", zzf2.zzan());
        contentValues.put("gmp_version", Long.valueOf(zzf2.zzao()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzf2.zzap()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzf2.isMeasurementEnabled()));
        contentValues.put("day", Long.valueOf(zzf2.zzav()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzf2.zzaw()));
        contentValues.put("daily_events_count", Long.valueOf(zzf2.zzax()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzf2.zzay()));
        contentValues.put("config_fetched_time", Long.valueOf(zzf2.zzas()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzf2.zzat()));
        contentValues.put("app_version_int", Long.valueOf(zzf2.zzam()));
        contentValues.put("firebase_instance_id", zzf2.getFirebaseInstanceId());
        contentValues.put("daily_error_events_count", Long.valueOf(zzf2.zzba()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzf2.zzaz()));
        contentValues.put("health_monitor_sample", zzf2.zzbb());
        contentValues.put("android_id", Long.valueOf(zzf2.zzbd()));
        contentValues.put("adid_reporting_enabled", Boolean.valueOf(zzf2.zzbe()));
        contentValues.put("ssaid_reporting_enabled", Boolean.valueOf(zzf2.zzbf()));
        contentValues.put("admob_app_id", zzf2.zzah());
        contentValues.put("dynamite_version", Long.valueOf(zzf2.zzaq()));
        if (zzf2.zzbh() != null) {
            if (zzf2.zzbh().size() == 0) {
                this.zzab().zzgn().zza("Safelisted events should not be an empty list. appId", (Object)zzf2.zzag());
            } else {
                contentValues.put("safelisted_events", TextUtils.join((CharSequence)",", (Iterable)zzf2.zzbh()));
            }
        }
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if ((long)sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{zzf2.zzag()}) == 0L && sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5) == -1L) {
                this.zzab().zzgk().zza("Failed to insert/update app (got -1). appId", zzef.zzam((String)zzf2.zzag()));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzab().zzgk().zza("Error storing app. appId", zzef.zzam((String)zzf2.zzag()), (Object)sQLiteException);
            return;
        }
    }

    public final long zzac(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzo();
        this.zzbi();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string2 = string;
            int n = this.zzad().zzb(string2, zzak.zzgu);
            n = Math.min(1000000, n);
            String string3 = String.valueOf(Math.max(0, n));
            return sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string3});
        }
        catch (SQLiteException sQLiteException) {
            this.zzab().zzgk().zza("Error deleting over the limit events. appId", zzef.zzam((String)string), (Object)sQLiteException);
            return 0L;
        }
    }

    @WorkerThread
    public final zzw zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Preconditions.checkNotEmpty((String)string);
        this.zzo();
        this.zzbi();
        String[] stringArray = new String[]{string};
        zzw zzw2 = new zzw();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzab().zzgn().zza("Not updating daily counts, app is not known. appId", zzef.zzam((String)string));
                zzw zzw3 = zzw2;
                return zzw3;
            }
            if (cursor.getLong(0) == l) {
                zzw2.zzeg = cursor.getLong(1);
                zzw2.zzef = cursor.getLong(2);
                zzw2.zzeh = cursor.getLong(3);
                zzw2.zzei = cursor.getLong(4);
                zzw2.zzej = cursor.getLong(5);
            }
            if (bl) {
                ++zzw2.zzeg;
            }
            if (bl2) {
                ++zzw2.zzef;
            }
            if (bl3) {
                ++zzw2.zzeh;
            }
            if (bl4) {
                ++zzw2.zzei;
            }
            if (bl5) {
                ++zzw2.zzej;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zzw2.zzef));
            contentValues.put("daily_events_count", Long.valueOf(zzw2.zzeg));
            contentValues.put("daily_conversions_count", Long.valueOf(zzw2.zzeh));
            contentValues.put("daily_error_events_count", Long.valueOf(zzw2.zzei));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zzw2.zzej));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zzw zzw4 = zzw2;
            return zzw4;
        }
    }

    @WorkerThread
    public final byte[] zzad(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzo();
        this.zzbi();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzab().zzgk().zza("Got multiple records for app config, expected one. appId", zzef.zzam((String)string));
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public final boolean zza(zzbs.zzg zzg2, boolean bl) {
        this.zzo();
        this.zzbi();
        Preconditions.checkNotNull((Object)((Object)zzg2));
        Preconditions.checkNotEmpty((String)zzg2.zzag());
        Preconditions.checkState((boolean)zzg2.zzof());
        this.zzca();
        long l = this.zzx().currentTimeMillis();
        if (zzg2.zznr() < l - zzs.zzbs() || zzg2.zznr() > l + zzs.zzbs()) {
            this.zzab().zzgn().zza("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzef.zzam((String)zzg2.zzag()), (Object)l, (Object)zzg2.zznr());
        }
        byte[] byArray = zzg2.toByteArray();
        try {
            byArray = this.zzgw().zzc(byArray);
        }
        catch (IOException iOException) {
            this.zzab().zzgk().zza("Data loss. Failed to serialize bundle. appId", zzef.zzam((String)zzg2.zzag()), (Object)iOException);
            return false;
        }
        this.zzab().zzgs().zza("Saving bundle, size", (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzg2.zzag());
        contentValues.put("bundle_end_timestamp", Long.valueOf(zzg2.zznr()));
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        if (zzg2.zzpn()) {
            contentValues.put("retry_count", Integer.valueOf(zzg2.zzpo()));
        }
        try {
            if (this.getWritableDatabase().insert("queue", null, contentValues) == -1L) {
                this.zzab().zzgk().zza("Failed to insert bundle (got -1). appId", zzef.zzam((String)zzg2.zzag()));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzab().zzgk().zza("Error storing bundle. appId", zzef.zzam((String)zzg2.zzag()), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final String zzby() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        Cursor cursor = null;
        try {
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzab().zzgk().zza("Database error getting next bundle app id", (Object)sQLiteException);
            return null;
        }
        if (cursor == null) return null;
        cursor.close();
        return null;
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public final boolean zzbz() {
        return this.zza("select count(1) > 0 from queue where has_realtime = 1", (String[])null) != 0L;
    }

    @WorkerThread
    public final List<Pair<zzbs.zzg, Long>> zza(String string, int n, int n2) {
        this.zzo();
        this.zzbi();
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((n2 > 0 ? 1 : 0) != 0);
        Preconditions.checkNotEmpty((String)string);
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("queue", new String[]{"rowid", "data", "retry_count"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzbs.zzg, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzbs.zzg, Long>> arrayList = new ArrayList<Pair<zzbs.zzg, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzgw().zzb((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzab().zzgk().zza("Failed to unzip queued bundle. appId", zzef.zzam((String)string), (Object)iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                try {
                    object = (Object)((zzbs.zzg.zza)zzbs.zzg.zzpr().zzf(byArray, com.google.android.gms.internal.measurement.zzel.zztq()));
                }
                catch (IOException iOException) {
                    this.zzab().zzgk().zza("Failed to merge queued bundle. appId", zzef.zzam((String)string), (Object)iOException);
                    continue;
                }
                if (!cursor.isNull(2)) {
                    ((zzbs.zzg.zza)((Object)object)).zzw(cursor.getInt(2));
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzbs.zzg, Long>)Pair.create((Object)((Object)((zzbs.zzg)((zzey)object.zzug()))), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzbs.zzg, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    final void zzca() {
        this.zzo();
        this.zzbi();
        if (!this.zzcg()) {
            return;
        }
        long l = this.zzac().zzlm.get();
        long l2 = this.zzx().elapsedRealtime();
        if (Math.abs(l2 - l) > (Long)zzak.zzhd.get(null)) {
            this.zzac().zzlm.set(l2);
            zzx zzx2 = this;
            zzx2.zzo();
            zzx2.zzbi();
            if (zzx2.zzcg()) {
                SQLiteDatabase sQLiteDatabase = zzx2.getWritableDatabase();
                String[] stringArray = new String[]{String.valueOf(zzx2.zzx().currentTimeMillis()), String.valueOf(zzs.zzbs())};
                int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
                if (n > 0) {
                    zzx2.zzab().zzgs().zza("Deleted stale rows. rowsDeleted", (Object)n);
                }
            }
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zzb(List<Long> list) {
        this.zzo();
        this.zzbi();
        Preconditions.checkNotNull(list);
        Preconditions.checkNotZero((int)list.size());
        if (!this.zzcg()) {
            return;
        }
        String string = TextUtils.join((CharSequence)",", list);
        String string2 = new StringBuilder(2 + String.valueOf(string).length()).append("(").append(string).append(")").toString();
        if (this.zza(new StringBuilder(80 + String.valueOf(string2).length()).append("SELECT COUNT(1) FROM queue WHERE rowid IN ").append(string2).append(" AND retry_count =  2147483647 LIMIT 1").toString(), (String[])null) > 0L) {
            this.zzab().zzgn().zzao("The number of upload retries exceeds the limit. Will remain unchanged.");
        }
        try {
            this.getWritableDatabase().execSQL(new StringBuilder(127 + String.valueOf(string2).length()).append("UPDATE queue SET retry_count = IFNULL(retry_count, 0) + 1 WHERE rowid IN ").append(string2).append(" AND (retry_count IS NULL OR retry_count < 2147483647)").toString());
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzab().zzgk().zza("Error incrementing retry count. error", (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    final void zza(String string, zzbv[] zzbvArray) {
        this.zzbi();
        this.zzo();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzbvArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            int n;
            String string2 = string;
            zzx zzx2 = this;
            zzx2.zzbi();
            zzx2.zzo();
            Preconditions.checkNotEmpty((String)string2);
            Object object = zzx2.getWritableDatabase();
            object.delete("property_filters", "app_id=?", new String[]{string2});
            object.delete("event_filters", "app_id=?", new String[]{string2});
            Object object2 = zzbvArray;
            int n2 = zzbvArray.length;
            block3: for (n = 0; n < n2; ++n) {
                zzbk.zza zza2;
                int n3;
                int n4;
                zzbv zzbv2 = object2[n];
                object = zzbv2;
                string2 = string;
                zzx2 = this;
                zzx2.zzbi();
                zzx2.zzo();
                Preconditions.checkNotEmpty((String)string2);
                Preconditions.checkNotNull((Object)object);
                Preconditions.checkNotNull((Object)object.zzzh);
                Preconditions.checkNotNull((Object)object.zzzg);
                if (object.zzzf == null) {
                    zzx2.zzab().zzgn().zza("Audience with no ID. appId", zzef.zzam((String)string2));
                    continue;
                }
                int n5 = object.zzzf;
                zzey[] zzeyArray = object.zzzh;
                int n6 = object.zzzh.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzeyArray[n4].zzkb()) continue;
                    zzx2.zzab().zzgn().zza("Event filter with no ID. Audience definition ignored. appId, audienceId", zzef.zzam((String)string2), (Object)object.zzzf);
                    continue block3;
                }
                zzeyArray = object.zzzg;
                n6 = object.zzzg.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzeyArray[n4].zzkb()) continue;
                    zzx2.zzab().zzgn().zza("Property filter with no ID. Audience definition ignored. appId, audienceId", zzef.zzam((String)string2), (Object)object.zzzf);
                    continue block3;
                }
                boolean bl = true;
                zzey[] zzeyArray2 = object.zzzh;
                n4 = object.zzzh.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    zza2 = zzeyArray2[n3];
                    if (zzx2.zza(string2, n5, zza2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    zzeyArray2 = object.zzzg;
                    n4 = object.zzzg.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        zza2 = zzeyArray2[n3];
                        if (zzx2.zza(string2, n5, (zzbk.zzd)((Object)zza2))) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                int n7 = n5;
                String string3 = string2;
                zzx zzx3 = zzx2;
                zzx3.zzbi();
                zzx3.zzo();
                Preconditions.checkNotEmpty((String)string3);
                SQLiteDatabase sQLiteDatabase2 = zzx3.getWritableDatabase();
                sQLiteDatabase2.delete("property_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
                sQLiteDatabase2.delete("event_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
            }
            object2 = new ArrayList();
            zzbv[] zzbvArray2 = zzbvArray;
            n = zzbvArray.length;
            for (int i = 0; i < n; ++i) {
                zzbv zzbv3 = zzbvArray2[i];
                object2.add(zzbv3.zzzf);
            }
            this.zza(string, (List<Integer>)object2);
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzbk.zza zza2) {
        this.zzbi();
        this.zzo();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zza2));
        if (TextUtils.isEmpty((CharSequence)zza2.zzjz())) {
            this.zzab().zzgn().zza("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzef.zzam((String)string), (Object)n, (Object)String.valueOf(zza2.zzkb() ? Integer.valueOf(zza2.getId()) : null));
            return false;
        }
        byte[] byArray = zza2.toByteArray();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zza2.zzkb() ? Integer.valueOf(zza2.getId()) : null);
        contentValues.put("event_name", zza2.zzjz());
        if (this.zzad().zze(string, zzak.zziy)) {
            contentValues.put("session_scoped", zza2.zzkh() ? Boolean.valueOf(zza2.zzki()) : null);
        }
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("event_filters", null, contentValues, 5) == -1L) {
                this.zzab().zzgk().zza("Failed to insert event filter (got -1). appId", zzef.zzam((String)string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzab().zzgk().zza("Error storing event filter. appId", zzef.zzam((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzbk.zzd zzd2) {
        this.zzbi();
        this.zzo();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zzd2));
        if (TextUtils.isEmpty((CharSequence)zzd2.getPropertyName())) {
            this.zzab().zzgn().zza("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzef.zzam((String)string), (Object)n, (Object)String.valueOf(zzd2.zzkb() ? Integer.valueOf(zzd2.getId()) : null));
            return false;
        }
        byte[] byArray = zzd2.toByteArray();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzd2.zzkb() ? Integer.valueOf(zzd2.getId()) : null);
        contentValues.put("property_name", zzd2.getPropertyName());
        if (this.zzad().zze(string, zzak.zziy)) {
            contentValues.put("session_scoped", zzd2.zzkh() ? Boolean.valueOf(zzd2.zzki()) : null);
        }
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("property_filters", null, contentValues, 5) == -1L) {
                this.zzab().zzgk().zza("Failed to insert property filter (got -1). appId", zzef.zzam((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzab().zzgk().zza("Error storing property filter. appId", zzef.zzam((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    final Map<Integer, List<zzbk.zza>> zzh(String string, String string2) {
        this.zzbi();
        this.zzo();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzbk.zza>> map = Collections.emptyMap();
                return map;
            }
            do {
                zzbk.zza zza2;
                byte[] byArray = cursor.getBlob(1);
                try {
                    zza2 = zzbk.zza.zza(byArray, com.google.android.gms.internal.measurement.zzel.zztq());
                }
                catch (IOException iOException) {
                    this.zzab().zzgk().zza("Failed to merge filter. appId", zzef.zzam((String)string), (Object)iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzbk.zza> arrayList = (ArrayList<zzbk.zza>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzbk.zza>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zza2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzbk.zzd>> zzi(String string, String string2) {
        this.zzbi();
        this.zzo();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzbk.zzd>> map = Collections.emptyMap();
                return map;
            }
            do {
                zzbk.zzd zzd2;
                byte[] byArray = cursor.getBlob(1);
                try {
                    zzd2 = zzbk.zzd.zzb(byArray, com.google.android.gms.internal.measurement.zzel.zztq());
                }
                catch (IOException iOException) {
                    this.zzab().zzgk().zza("Failed to merge filter", zzef.zzam((String)string), (Object)iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzbk.zzd> arrayList = (ArrayList<zzbk.zzd>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzbk.zzd>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzd2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<Integer>> zzae(String string) {
        this.zzbi();
        this.zzo();
        Preconditions.checkNotEmpty((String)string);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery("select audience_id, filter_id from event_filters where app_id = ? and session_scoped = 1 UNION select audience_id, filter_id from property_filters where app_id = ? and session_scoped = 1;", new String[]{string, string});
            if (!cursor.moveToFirst()) {
                Map<Integer, List<Integer>> map = Collections.emptyMap();
                return map;
            }
            do {
                int n;
                ArrayList<Integer> arrayList;
                if ((arrayList = (ArrayList<Integer>)arrayMap.get(n = cursor.getInt(0))) == null) {
                    arrayList = new ArrayList<Integer>();
                    arrayMap.put(n, arrayList);
                }
                int n2 = cursor.getInt(1);
                arrayList.add(n2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    private final boolean zza(String string, List<Integer> list) {
        Object object;
        long l;
        Preconditions.checkNotEmpty((String)string);
        this.zzbi();
        this.zzo();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            l = this.zza("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzab().zzgk().zza("Database error querying filters. appId", zzef.zzam((String)string), (Object)sQLiteException);
            return false;
        }
        String string2 = string;
        int n = this.zzad().zzb(string2, zzak.zzhk);
        n = Math.min(2000, n);
        int n2 = Math.max(0, n);
        if (l <= (long)n2) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (object == null || !(object instanceof Integer)) {
                return false;
            }
            arrayList.add(Integer.toString((Integer)object));
        }
        object = TextUtils.join((CharSequence)",", arrayList);
        String string3 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        return sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string3).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string3).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n2)}) > 0;
    }

    final Map<Integer, zzbs.zzi> zzaf(String string) {
        this.zzbi();
        this.zzo();
        Preconditions.checkNotEmpty((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                zzbs.zzi zzi2;
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                try {
                    zzi2 = zzbs.zzi.zze(byArray, com.google.android.gms.internal.measurement.zzel.zztq());
                }
                catch (IOException iOException) {
                    this.zzab().zzgk().zza("Failed to merge filter results. appId, audienceId, error", zzef.zzam((String)string), (Object)n, (Object)iOException);
                    continue;
                }
                arrayMap.put(n, zzi2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    private static void zza(ContentValues contentValues, String string, Object object) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
            return;
        }
        if (object instanceof Long) {
            contentValues.put(string, (Long)object);
            return;
        }
        if (object instanceof Double) {
            contentValues.put(string, (Double)object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @VisibleForTesting
    @WorkerThread
    private final Object zza(Cursor cursor, int n) {
        int n2 = n;
        Cursor cursor2 = cursor;
        int n3 = cursor2.getType(n2);
        switch (n3) {
            case 0: {
                this.zzab().zzgk().zzao("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzab().zzgk().zzao("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzab().zzgk().zza("Loaded invalid unknown value type, ignoring it", (Object)n3);
        return null;
    }

    @WorkerThread
    public final long zzcb() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    @VisibleForTesting
    protected final long zzj(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzo();
        this.zzbi();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues;
            l = this.zza(new StringBuilder(32 + String.valueOf(string2).length()).append("select ").append(string2).append(" from app2 where app_id=?").toString(), new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                if (sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5) == -1L) {
                    this.zzab().zzgk().zza("Failed to insert column (got -1). appId", zzef.zzam((String)string), (Object)string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            if ((long)sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string}) == 0L) {
                this.zzab().zzgk().zza("Failed to update column (got 0). appId", zzef.zzam((String)string), (Object)string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzab().zzgk().zza("Error inserting column. appId", zzef.zzam((String)string), (Object)string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public final long zzcc() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public final long zza(zzbs.zzg zzg2) throws IOException {
        this.zzo();
        this.zzbi();
        Preconditions.checkNotNull((Object)((Object)zzg2));
        Preconditions.checkNotEmpty((String)zzg2.zzag());
        byte[] byArray = zzg2.toByteArray();
        long l = this.zzgw().zza(byArray);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzg2.zzag());
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("metadata", byArray);
        try {
            this.getWritableDatabase().insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzab().zzgk().zza("Error storing raw event metadata. appId", zzef.zzam((String)zzg2.zzag()), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l;
    }

    public final boolean zzcd() {
        return this.zza("select count(1) > 0 from raw_events", (String[])null) != 0L;
    }

    public final boolean zzce() {
        return this.zza("select count(1) > 0 from raw_events where realtime = 1", (String[])null) != 0L;
    }

    public final long zzag(String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    public final String zzu(long l) {
        this.zzo();
        this.zzbi();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzab().zzgs().zzao("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    public final long zzcf() {
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    public final Pair<zzbs.zzc, Long> zza(String string, Long l) {
        this.zzo();
        this.zzbi();
        try (Cursor cursor = null;){
            zzbs.zzc zzc2;
            cursor = this.getWritableDatabase().rawQuery("select main_event, children_to_process from main_event_params where app_id=? and event_id=?", new String[]{string, String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzab().zzgs().zzao("Main event not found");
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            Long l2 = cursor.getLong(1);
            try {
                zzc2 = zzbs.zzc.zzc(byArray, com.google.android.gms.internal.measurement.zzel.zztq());
            }
            catch (IOException iOException) {
                this.zzab().zzgk().zza("Failed to merge main event. appId, eventId", zzef.zzam((String)string), (Object)l, (Object)iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return null;
            }
            Pair pair = Pair.create((Object)((Object)zzc2), (Object)l2);
            return pair;
        }
        return null;
    }

    public final boolean zza(String string, Long l, long l2, zzbs.zzc zzc2) {
        this.zzo();
        this.zzbi();
        Preconditions.checkNotNull((Object)((Object)zzc2));
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)l);
        byte[] byArray = zzc2.toByteArray();
        this.zzab().zzgs().zza("Saving complex main event, appId, data size", (Object)this.zzy().zzaj(string), (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("event_id", l);
        contentValues.put("children_to_process", Long.valueOf(l2));
        contentValues.put("main_event", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("main_event_params", null, contentValues, 5) == -1L) {
                this.zzab().zzgk().zza("Failed to insert complex main event (got -1). appId", zzef.zzam((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzab().zzgk().zza("Error storing complex main event. appId", zzef.zzam((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    public final boolean zza(zzaf zzaf2, long l, boolean bl) {
        String string2;
        this.zzo();
        this.zzbi();
        Preconditions.checkNotNull((Object)zzaf2);
        Preconditions.checkNotEmpty((String)zzaf2.zzce);
        zzbs.zzc.zza zza2 = zzbs.zzc.zzmq().zzah(zzaf2.zzfp);
        for (String string2 : zzaf2.zzfq) {
            zzbs.zze.zza zza3 = zzbs.zze.zzng().zzbz(string2);
            Object object = zzaf2.zzfq.get(string2);
            this.zzgw().zza(zza3, object);
            zza2.zza(zza3);
        }
        Object object = ((zzbs.zzc)((zzey)zza2.zzug())).toByteArray();
        this.zzab().zzgs().zza("Saving event, name, data size", (Object)this.zzy().zzaj(zzaf2.name), (Object)((Object)object).length);
        string2 = new ContentValues();
        string2.put("app_id", zzaf2.zzce);
        string2.put("name", zzaf2.name);
        string2.put("timestamp", Long.valueOf(zzaf2.timestamp));
        string2.put("metadata_fingerprint", Long.valueOf(l));
        string2.put("data", (byte[])object);
        string2.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("raw_events", null, (ContentValues)string2) == -1L) {
                this.zzab().zzgk().zza("Failed to insert raw event (got -1). appId", zzef.zzam((String)zzaf2.zzce));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzab().zzgk().zza("Error storing raw event. appId", zzef.zzam((String)zzaf2.zzce), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    private final boolean zzcg() {
        return this.getContext().getDatabasePath("google_app_measurement.db").exists();
    }

    static /* synthetic */ zzjd zza(zzx zzx2) {
        return zzx2.zzet;
    }

    static /* synthetic */ String[] zzch() {
        return zzek;
    }

    static /* synthetic */ String[] zzci() {
        return zzel;
    }

    static /* synthetic */ String[] zzcj() {
        return zzem;
    }

    static /* synthetic */ String[] zzck() {
        return zzeo;
    }

    static /* synthetic */ String[] zzcl() {
        return zzen;
    }

    static /* synthetic */ String[] zzcm() {
        return zzep;
    }

    static /* synthetic */ String[] zzcn() {
        return zzeq;
    }

    static /* synthetic */ String[] zzco() {
        return zzer;
    }
}

