/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzea;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzfq;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzjp;
import com.google.android.gms.measurement.internal.zzjw;
import com.google.android.gms.measurement.internal.zzjx;
import com.google.android.gms.measurement.internal.zzjy;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzq;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzfo
extends zzea {
    private final zzjp zza;
    private Boolean zzb;
    @Nullable
    private String zzc;

    public zzfo(zzjp zzjp2) {
        this(zzjp2, null);
    }

    private zzfo(zzjp zzjp2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzjp2);
        this.zza = zzjp2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzb(zzn zzn2) {
        this.zzb(zzn2, false);
        this.zza(new zzfr(this, zzn2));
    }

    @BinderThread
    public final void zza(zzai zzai2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzai2);
        this.zzb(zzn2, false);
        this.zza(new zzgb(this, zzai2, zzn2));
    }

    @VisibleForTesting
    final zzai zzb(zzai zzai2, zzn zzn2) {
        String string;
        zzn zzn3 = zzn2;
        zzai zzai3 = zzai2;
        zzfo zzfo2 = this;
        if (!"_cmp".equals(zzai3.zza) || zzai3.zzb == null || zzai3.zzb.zza() == 0 ? false : !TextUtils.isEmpty((CharSequence)(string = zzai3.zzb.zzd("_cis"))) && ("referrer broadcast".equals(string) || "referrer API".equals(string)) && zzfo2.zza.zzb().zzl(zzn3.zza)) {
            this.zza.zzr().zzv().zza("Event has been filtered ", (Object)zzai2.toString());
            return new zzai("_cmpx", zzai2.zzb, zzai2.zzc, zzai2.zzd);
        }
        return zzai2;
    }

    @BinderThread
    public final void zza(zzai zzai2, String string, String string2) {
        Preconditions.checkNotNull((Object)zzai2);
        Preconditions.checkNotEmpty((String)string);
        this.zza(string, true);
        this.zza(new zzga(this, zzai2, string));
    }

    @BinderThread
    public final byte[] zza(zzai zzai2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzai2);
        this.zza(string, true);
        this.zza.zzr().zzw().zza("Log and bundle. event", (Object)this.zza.zzi().zza(zzai2.zza));
        long l = this.zza.zzm().nanoTime() / 1000000L;
        Future future = this.zza.zzq().zzb((Callable)new zzgd(this, zzai2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zza.zzr().zzf().zza("Log and bundle returned null. appId", zzej.zza((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zza.zzm().nanoTime() / 1000000L;
            this.zza.zzr().zzw().zza("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzi().zza(zzai2.zza), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to log and bundle. appId, event, error", zzej.zza((String)string), (Object)this.zza.zzi().zza(zzai2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzjw zzjw2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzjw2);
        this.zzb(zzn2, false);
        if (zzjw2.zza() == null) {
            this.zza(new zzgc(this, zzjw2, zzn2));
            return;
        }
        this.zza(new zzgf(this, zzjw2, zzn2));
    }

    @BinderThread
    public final List<zzjw> zza(zzn zzn2, boolean bl) {
        this.zzb(zzn2, false);
        Future future = this.zza.zzq().zza((Callable)new zzge(this, zzn2));
        try {
            List list = (List)future.get();
            ArrayList<zzjw> arrayList = new ArrayList<zzjw>(list.size());
            for (zzjy zzjy2 : list) {
                if (!bl && zzjx.zze((String)zzjy2.zzc)) continue;
                arrayList.add(new zzjw(zzjy2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get user attributes. appId", zzej.zza((String)zzn2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzn zzn2) {
        this.zzb(zzn2, false);
        this.zza(new zzgh(this, zzn2));
    }

    @BinderThread
    private final void zzb(zzn zzn2, boolean bl) {
        Preconditions.checkNotNull((Object)zzn2);
        this.zza(zzn2.zza, false);
        this.zza.zzj().zzc(zzn2.zzb, zzn2.zzr);
    }

    @BinderThread
    private final void zza(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zza.zzr().zzf().zza("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzfo zzfo2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzfo2 = this;
                    if (!bl2) break block9;
                    if (zzfo2.zzb == null) {
                        zzfo2.zzb = "com.google.android.gms".equals(zzfo2.zzc) || UidVerifier.isGooglePlayServicesUid((Context)zzfo2.zza.zzn(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzfo2.zza.zzn()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzfo2.zzb.booleanValue()) break block10;
                }
                if (zzfo2.zzc == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzfo2.zza.zzn(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzfo2.zzc = string2;
                }
                if (!string2.equals(zzfo2.zzc)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zza.zzr().zzf().zza("Measurement Service called with invalid calling package. appId", zzej.zza((String)string));
            throw securityException;
        }
    }

    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zza(new zzgg(this, string2, string3, string, l));
    }

    @BinderThread
    public final String zzc(zzn zzn2) {
        this.zzb(zzn2, false);
        return this.zza.zzd(zzn2);
    }

    @BinderThread
    public final void zza(zzq zzq2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzq2);
        Preconditions.checkNotNull((Object)zzq2.zzc);
        this.zzb(zzn2, false);
        zzq zzq3 = new zzq(zzq2);
        new zzq(zzq2).zza = zzn2.zza;
        if (zzq2.zzc.zza() == null) {
            this.zza(new zzfq(this, zzq3, zzn2));
            return;
        }
        this.zza(new zzft(this, zzq3, zzn2));
    }

    @BinderThread
    public final void zza(zzq zzq2) {
        Preconditions.checkNotNull((Object)zzq2);
        Preconditions.checkNotNull((Object)zzq2.zzc);
        this.zza(zzq2.zza, true);
        zzq zzq3 = new zzq(zzq2);
        if (zzq2.zzc.zza() == null) {
            this.zza(new zzfs(this, zzq3));
            return;
        }
        this.zza(new zzfv(this, zzq3));
    }

    @BinderThread
    public final List<zzjw> zza(String string, String string2, boolean bl, zzn zzn2) {
        this.zzb(zzn2, false);
        Future future = this.zza.zzq().zza((Callable)new zzfu(this, zzn2, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzjw> arrayList = new ArrayList<zzjw>(list.size());
            for (zzjy zzjy2 : list) {
                if (!bl && zzjx.zze((String)zzjy2.zzc)) continue;
                arrayList.add(new zzjw(zzjy2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get user attributes. appId", zzej.zza((String)zzn2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzjw> zza(String string, String string2, String string3, boolean bl) {
        this.zza(string, true);
        Future future = this.zza.zzq().zza((Callable)new zzfx(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzjw> arrayList = new ArrayList<zzjw>(list.size());
            for (zzjy zzjy2 : list) {
                if (!bl && zzjx.zze((String)zzjy2.zzc)) continue;
                arrayList.add(new zzjw(zzjy2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get user attributes. appId", zzej.zza((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzq> zza(String string, String string2, zzn zzn2) {
        this.zzb(zzn2, false);
        Future future = this.zza.zzq().zza((Callable)new zzfw(this, zzn2, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzq> zza(String string, String string2, String string3) {
        this.zza(string, true);
        Future future = this.zza.zzq().zza((Callable)new zzfz(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final void zzd(zzn zzn2) {
        this.zza(zzn2.zza, false);
        this.zza(new zzfy(this, zzn2));
    }

    @VisibleForTesting
    private final void zza(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzq().zzg()) {
            runnable.run();
            return;
        }
        this.zza.zzq().zza(runnable);
    }

    static /* synthetic */ zzjp zza(zzfo zzfo2) {
        return zzfo2.zza;
    }
}

