/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzec;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzjx;
import com.google.android.gms.measurement.internal.zzjy;
import com.google.android.gms.measurement.internal.zzjz;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzfq
extends zzec {
    private final zzjq zza;
    private Boolean zzb;
    @Nullable
    private String zzc;

    public zzfq(zzjq zzjq2) {
        this(zzjq2, null);
    }

    private zzfq(zzjq zzjq2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzjq2);
        this.zza = zzjq2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzb(zzm zzm2) {
        this.zzb(zzm2, false);
        this.zza(new zzfp(this, zzm2));
    }

    @BinderThread
    public final void zza(zzak zzak2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzak2);
        this.zzb(zzm2, false);
        this.zza(new zzfz(this, zzak2, zzm2));
    }

    @VisibleForTesting
    final zzak zzb(zzak zzak2, zzm zzm2) {
        String string;
        zzm zzm3 = zzm2;
        zzak zzak3 = zzak2;
        zzfq zzfq2 = this;
        if (!"_cmp".equals(zzak3.zza) || zzak3.zzb == null || zzak3.zzb.zza() == 0 ? false : !TextUtils.isEmpty((CharSequence)(string = zzak3.zzb.zzd("_cis"))) && ("referrer broadcast".equals(string) || "referrer API".equals(string)) && zzfq2.zza.zzb().zzj(zzm3.zza)) {
            this.zza.zzr().zzv().zza("Event has been filtered ", (Object)zzak2.toString());
            return new zzak("_cmpx", zzak2.zzb, zzak2.zzc, zzak2.zzd);
        }
        return zzak2;
    }

    @BinderThread
    public final void zza(zzak zzak2, String string, String string2) {
        Preconditions.checkNotNull((Object)zzak2);
        Preconditions.checkNotEmpty((String)string);
        this.zza(string, true);
        this.zza(new zzgc(this, zzak2, string));
    }

    @BinderThread
    public final byte[] zza(zzak zzak2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzak2);
        this.zza(string, true);
        this.zza.zzr().zzw().zza("Log and bundle. event", (Object)this.zza.zzi().zza(zzak2.zza));
        long l = this.zza.zzm().nanoTime() / 1000000L;
        Future future = this.zza.zzq().zzb((Callable)new zzgb(this, zzak2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zza.zzr().zzf().zza("Log and bundle returned null. appId", zzeh.zza((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zza.zzm().nanoTime() / 1000000L;
            this.zza.zzr().zzw().zza("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzi().zza(zzak2.zza), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to log and bundle. appId, event, error", zzeh.zza((String)string), (Object)this.zza.zzi().zza(zzak2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzjx zzjx2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzjx2);
        this.zzb(zzm2, false);
        if (zzjx2.zza() == null) {
            this.zza(new zzge(this, zzjx2, zzm2));
            return;
        }
        this.zza(new zzgd(this, zzjx2, zzm2));
    }

    @BinderThread
    public final List<zzjx> zza(zzm zzm2, boolean bl) {
        this.zzb(zzm2, false);
        Future future = this.zza.zzq().zza((Callable)new zzgg(this, zzm2));
        try {
            List list = (List)future.get();
            ArrayList<zzjx> arrayList = new ArrayList<zzjx>(list.size());
            for (zzjz zzjz2 : list) {
                if (!bl && zzjy.zze((String)zzjz2.zzc)) continue;
                arrayList.add(new zzjx(zzjz2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get user attributes. appId", zzeh.zza((String)zzm2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzm zzm2) {
        this.zzb(zzm2, false);
        this.zza(new zzgf(this, zzm2));
    }

    @BinderThread
    private final void zzb(zzm zzm2, boolean bl) {
        Preconditions.checkNotNull((Object)zzm2);
        this.zza(zzm2.zza, false);
        this.zza.zzj().zzc(zzm2.zzb, zzm2.zzr);
    }

    @BinderThread
    private final void zza(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zza.zzr().zzf().zza("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzfq zzfq2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzfq2 = this;
                    if (!bl2) break block9;
                    if (zzfq2.zzb == null) {
                        zzfq2.zzb = "com.google.android.gms".equals(zzfq2.zzc) || UidVerifier.isGooglePlayServicesUid((Context)zzfq2.zza.zzn(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzfq2.zza.zzn()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzfq2.zzb.booleanValue()) break block10;
                }
                if (zzfq2.zzc == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzfq2.zza.zzn(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzfq2.zzc = string2;
                }
                if (!string2.equals(zzfq2.zzc)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zza.zzr().zzf().zza("Measurement Service called with invalid calling package. appId", zzeh.zza((String)string));
            throw securityException;
        }
    }

    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zza(new zzgi(this, string2, string3, string, l));
    }

    @BinderThread
    public final String zzc(zzm zzm2) {
        this.zzb(zzm2, false);
        return this.zza.zzd(zzm2);
    }

    @BinderThread
    public final void zza(zzs zzs2, zzm zzm2) {
        Preconditions.checkNotNull((Object)zzs2);
        Preconditions.checkNotNull((Object)zzs2.zzc);
        this.zzb(zzm2, false);
        zzs zzs3 = new zzs(zzs2);
        new zzs(zzs2).zza = zzm2.zza;
        if (zzs2.zzc.zza() == null) {
            this.zza(new zzfs(this, zzs3, zzm2));
            return;
        }
        this.zza(new zzfr(this, zzs3, zzm2));
    }

    @BinderThread
    public final void zza(zzs zzs2) {
        Preconditions.checkNotNull((Object)zzs2);
        Preconditions.checkNotNull((Object)zzs2.zzc);
        this.zza(zzs2.zza, true);
        zzs zzs3 = new zzs(zzs2);
        if (zzs2.zzc.zza() == null) {
            this.zza(new zzfu(this, zzs3));
            return;
        }
        this.zza(new zzft(this, zzs3));
    }

    @BinderThread
    public final List<zzjx> zza(String string, String string2, boolean bl, zzm zzm2) {
        this.zzb(zzm2, false);
        Future future = this.zza.zzq().zza((Callable)new zzfw(this, zzm2, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzjx> arrayList = new ArrayList<zzjx>(list.size());
            for (zzjz zzjz2 : list) {
                if (!bl && zzjy.zze((String)zzjz2.zzc)) continue;
                arrayList.add(new zzjx(zzjz2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get user attributes. appId", zzeh.zza((String)zzm2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzjx> zza(String string, String string2, String string3, boolean bl) {
        this.zza(string, true);
        Future future = this.zza.zzq().zza((Callable)new zzfv(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzjx> arrayList = new ArrayList<zzjx>(list.size());
            for (zzjz zzjz2 : list) {
                if (!bl && zzjy.zze((String)zzjz2.zzc)) continue;
                arrayList.add(new zzjx(zzjz2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get user attributes. appId", zzeh.zza((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzs> zza(String string, String string2, zzm zzm2) {
        this.zzb(zzm2, false);
        Future future = this.zza.zzq().zza((Callable)new zzfy(this, zzm2, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzs> zza(String string, String string2, String string3) {
        this.zza(string, true);
        Future future = this.zza.zzq().zza((Callable)new zzfx(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzr().zzf().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final void zzd(zzm zzm2) {
        this.zza(zzm2.zza, false);
        this.zza(new zzga(this, zzm2));
    }

    @VisibleForTesting
    private final void zza(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzq().zzg()) {
            runnable.run();
            return;
        }
        this.zza.zzq().zza(runnable);
    }

    static /* synthetic */ zzjq zza(zzfq zzfq2) {
        return zzfq2.zza;
    }
}

