/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzbr;
import com.google.android.gms.internal.measurement.zzfd;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzjo;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzju;
import com.google.android.gms.measurement.internal.zzjz;
import com.google.android.gms.measurement.internal.zzu;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class zzht
extends zzjn {
    public zzht(zzjq zzjq2) {
        super(zzjq2);
    }

    @Override
    protected final boolean zze() {
        return false;
    }

    @WorkerThread
    public final byte[] zza(@NonNull zzak zzak2, @Size(min=1L) String string) {
        this.zzd();
        this.zzw.zzae();
        Preconditions.checkNotNull((Object)zzak2);
        Preconditions.checkNotEmpty((String)string);
        if (!this.zzt().zze(string, zzam.zzbj)) {
            this.zzr().zzw().zza("Generating ScionPayload disabled. packageName", (Object)string);
            return new byte[0];
        }
        if (!"_iap".equals(zzak2.zza) && !"_iapx".equals(zzak2.zza)) {
            this.zzr().zzw().zza("Generating a payload for this event is not available. package_name, event_name", (Object)string, (Object)zzak2.zza);
            return null;
        }
        zzbr.zzf.zza zza2 = zzbr.zzf.zzb();
        this.zzi().zzf();
        try {
            long l;
            long l2;
            zzag zzag2;
            long l3;
            zzag zzag3;
            zzg zzg2 = this.zzi().zzb(string);
            if (zzg2 == null) {
                this.zzr().zzw().zza("Log and bundle not available. package_name", (Object)string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zzg2.zzp()) {
                this.zzr().zzw().zza("Log and bundle disabled. package_name", (Object)string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            zzbr.zzg.zza zza3 = zzbr.zzg.zzbe().zza(1).zza("android");
            if (!TextUtils.isEmpty((CharSequence)zzg2.zzb())) {
                zza3.zzf(zzg2.zzb());
            }
            if (!TextUtils.isEmpty((CharSequence)zzg2.zzl())) {
                zza3.zze(zzg2.zzl());
            }
            if (!TextUtils.isEmpty((CharSequence)zzg2.zzj())) {
                zza3.zzg(zzg2.zzj());
            }
            if (zzg2.zzk() != Integer.MIN_VALUE) {
                zza3.zzg((int)zzg2.zzk());
            }
            zza3.zzf(zzg2.zzm()).zzk(zzg2.zzo());
            if (!TextUtils.isEmpty((CharSequence)zzg2.zzd())) {
                zza3.zzk(zzg2.zzd());
            } else if (!TextUtils.isEmpty((CharSequence)zzg2.zze())) {
                zza3.zzo(zzg2.zze());
            }
            zza3.zzh(zzg2.zzn());
            if (this.zzw.zzab() && zzu.zzy() && this.zzt().zzd(zza3.zzj())) {
                zza3.zzj();
                if (!TextUtils.isEmpty(null)) {
                    zza3.zzn(null);
                }
            }
            Pair pair = this.zzs().zza(zzg2.zzb());
            if (zzg2.zzad() && pair != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
                try {
                    zza3.zzh(zzht.zza((String)pair.first, Long.toString(zzak2.zzd)));
                }
                catch (SecurityException securityException) {
                    this.zzr().zzw().zza("Resettable device id encryption failed", (Object)securityException.getMessage());
                    byte[] byArray = new byte[]{};
                    this.zzi().zzh();
                    return byArray;
                }
                if (pair.second != null) {
                    zza3.zza((Boolean)pair.second);
                }
            }
            this.zzl().zzaa();
            zzbr.zzg.zza zza4 = zza3.zzc(Build.MODEL);
            this.zzl().zzaa();
            zza4.zzb(Build.VERSION.RELEASE).zze((int)this.zzl().zzf()).zzd(this.zzl().zzg());
            try {
                zza3.zzi(zzht.zza(zzg2.zzc(), Long.toString(zzak2.zzd)));
            }
            catch (SecurityException securityException) {
                this.zzr().zzw().zza("app instance id encryption failed", (Object)securityException.getMessage());
                byte[] byArray = new byte[]{};
                this.zzi().zzh();
                return byArray;
            }
            if (!TextUtils.isEmpty((CharSequence)zzg2.zzg())) {
                zza3.zzl(zzg2.zzg());
            }
            zzg zzg3 = zzg2;
            zzht zzht2 = this;
            String string2 = zzg3.zzb();
            List<zzjz> list = zzht2.zzi().zza(string2);
            zzjz zzjz2 = null;
            for (zzjz zzjz3 : list) {
                if (!"_lte".equals(zzjz3.zzc)) continue;
                zzjz2 = zzjz3;
                break;
            }
            if (zzjz2 == null || zzjz2.zze == null) {
                zzjz2 = new zzjz(string2, "auto", "_lte", zzht2.zzm().currentTimeMillis(), (Object)0L);
                list.add(zzjz2);
                zzht2.zzi().zza(zzjz2);
            }
            if (zzht2.zzt().zze(string2, zzam.zzbe)) {
                List<zzjz> list2 = list;
                zzg zzg4 = zzg3;
                zzju zzju2 = zzht2.zzg();
                zzju2.zzr().zzx().zza("Checking account type status for ad personalization signals");
                if (zzju2.zzl().zzj()) {
                    String string3 = zzg4.zzb();
                    if (zzg4.zzad() && ((zzjo)zzju2).zzj().zze(string3)) {
                        zzjz zzjz4;
                        zzju2.zzr().zzw().zza("Turning off ad personalization due to account type");
                        Iterator<zzjz> iterator = list2.iterator();
                        while (iterator.hasNext()) {
                            zzjz4 = iterator.next();
                            if (!"_npa".equals(zzjz4.zzc)) continue;
                            iterator.remove();
                            break;
                        }
                        zzjz4 = new zzjz(string3, "auto", "_npa", zzju2.zzm().currentTimeMillis(), (Object)1L);
                        list2.add(zzjz4);
                    }
                }
            }
            zzbr.zzk[] zzkArray = new zzbr.zzk[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                zzbr.zzk.zza zza5 = zzbr.zzk.zzj().zza(list.get((int)i).zzc).zza(list.get((int)i).zzd);
                zzht2.zzg().zza(zza5, list.get((int)i).zze);
                zzkArray[i] = (zzbr.zzk)((zzfd)zza5.zzu());
            }
            zza3.zzb(Arrays.asList(zzkArray));
            Bundle bundle = zzak2.zzb.zzb();
            bundle.putLong("_c", 1L);
            this.zzr().zzw().zza("Marking in-app purchase as real-time");
            bundle.putLong("_r", 1L);
            bundle.putString("_o", zzak2.zzc);
            if (this.zzp().zzf(zza3.zzj())) {
                this.zzp().zza(bundle, "_dbg", (Object)1L);
                this.zzp().zza(bundle, "_r", (Object)1L);
            }
            if ((zzag3 = this.zzi().zza(string, zzak2.zza)) == null) {
                l3 = 0L;
                zzag2 = new zzag(string, zzak2.zza, 0L, 0L, zzak2.zzd, 0L, null, null, null, null);
            } else {
                l3 = zzag3.zzf;
                zzag2 = zzag3.zza(zzak2.zzd);
            }
            this.zzi().zza(zzag2);
            zzad zzad2 = new zzad(this.zzw, zzak2.zzc, string, zzak2.zza, zzak2.zzd, l3, bundle);
            zzbr.zzc.zza zza6 = zzbr.zzc.zzj().zza(zzad2.zzc).zza(zzad2.zzb).zzb(zzad2.zzd);
            for (String string4 : zzad2.zze) {
                zzbr.zze.zza zza7 = zzbr.zze.zzh().zza(string4);
                Object object = zzad2.zze.zza(string4);
                this.zzg().zza(zza7, object);
                zza6.zza(zza7);
            }
            zza3.zza(zza6).zza(zzbr.zzh.zza().zza(zzbr.zzd.zza().zza(zzag2.zzc).zza(zzak2.zza)));
            zza3.zzc(this.e_().zza(zzg2.zzb(), Collections.emptyList(), zza3.zzd(), zza6.zze()));
            if (zza6.zzd()) {
                zza3.zzb(zza6.zze()).zzc(zza6.zze());
            }
            if ((l2 = zzg2.zzi()) != 0L) {
                zza3.zze(l2);
            }
            if ((l = zzg2.zzh()) != 0L) {
                zza3.zzd(l);
            } else if (l2 != 0L) {
                zza3.zzd(l2);
            }
            zzg2.zzt();
            zza3.zzf((int)zzg2.zzq()).zzg(this.zzt().zzf()).zza(this.zzm().currentTimeMillis()).zzb(Boolean.TRUE);
            zza2.zza(zza3);
            zzg2.zza(zza3.zzf());
            zzg2.zzb(zza3.zzg());
            this.zzi().zza(zzg2);
            this.zzi().b_();
        }
        finally {
            this.zzi().zzh();
        }
        try {
            return this.zzg().zzc(((zzbr.zzf)((zzfd)zza2.zzu())).zzbh());
        }
        catch (IOException iOException) {
            this.zzr().zzf().zza("Data loss. Failed to bundle and serialize. appId", zzeh.zza((String)string), (Object)iOException);
            return null;
        }
    }

    private static String zza(String string, String string2) {
        throw new SecurityException("This implementation should not be used.");
    }
}

