/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzmj;
import com.google.android.gms.internal.measurement.zzny;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzki;
import com.google.android.gms.measurement.internal.zzkr;
import com.google.android.gms.measurement.internal.zzkt;
import com.google.android.gms.measurement.internal.zzkw;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzw;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzfw
extends zzei {
    private final zzki zza;
    private Boolean zzb;
    @Nullable
    private String zzc;

    public zzfw(zzki zzki2) {
        this(zzki2, null);
    }

    private zzfw(zzki zzki2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzki2);
        this.zza = zzki2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzb(zzn zzn2) {
        this.zzb(zzn2, false);
        this.zza(new zzfy(this, zzn2));
    }

    @BinderThread
    public final void zze(zzn zzn2) {
        if (zzmj.zzb() && this.zza.zzb().zza(zzat.zzci)) {
            Preconditions.checkNotEmpty((String)zzn2.zza);
            Preconditions.checkNotNull((Object)zzn2.zzw);
            zzgg zzgg2 = new zzgg(this, zzn2);
            zzfw zzfw2 = this;
            Preconditions.checkNotNull((Object)zzgg2);
            if (zzfw2.zza.zzp().zzf()) {
                zzgg2.run();
                return;
            }
            zzfw2.zza.zzp().zzb((Runnable)zzgg2);
        }
    }

    @BinderThread
    public final void zza(zzar zzar2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzar2);
        this.zzb(zzn2, false);
        this.zza(new zzgj(this, zzar2, zzn2));
    }

    @VisibleForTesting
    final zzar zzb(zzar zzar2, zzn zzn2) {
        String string;
        zzar zzar3 = zzar2;
        if (!"_cmp".equals(zzar3.zza) || zzar3.zzb == null || zzar3.zzb.zza() == 0 ? false : "referrer broadcast".equals(string = zzar3.zzb.zzd("_cis")) || "referrer API".equals(string)) {
            this.zza.zzq().zzu().zza("Event has been filtered ", (Object)zzar2.toString());
            return new zzar("_cmpx", zzar2.zzb, zzar2.zzc, zzar2.zzd);
        }
        return zzar2;
    }

    @BinderThread
    public final void zza(zzar zzar2, String string, String string2) {
        Preconditions.checkNotNull((Object)zzar2);
        Preconditions.checkNotEmpty((String)string);
        this.zza(string, true);
        this.zza(new zzgi(this, zzar2, string));
    }

    @BinderThread
    public final byte[] zza(zzar zzar2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzar2);
        this.zza(string, true);
        this.zza.zzq().zzv().zza("Log and bundle. event", (Object)this.zza.zzj().zza(zzar2.zza));
        long l = this.zza.zzl().nanoTime() / 1000000L;
        Future future = this.zza.zzp().zzb((Callable)new zzgl(this, zzar2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zza.zzq().zze().zza("Log and bundle returned null. appId", zzer.zza((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zza.zzl().nanoTime() / 1000000L;
            this.zza.zzq().zzv().zza("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzj().zza(zzar2.zza), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzq().zze().zza("Failed to log and bundle. appId, event, error", zzer.zza((String)string), (Object)this.zza.zzj().zza(zzar2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzkr zzkr2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzkr2);
        this.zzb(zzn2, false);
        this.zza(new zzgk(this, zzkr2, zzn2));
    }

    @BinderThread
    public final List<zzkr> zza(zzn zzn2, boolean bl) {
        this.zzb(zzn2, false);
        Future future = this.zza.zzp().zza((Callable)new zzgn(this, zzn2));
        try {
            List list = (List)future.get();
            ArrayList<zzkr> arrayList = new ArrayList<zzkr>(list.size());
            for (zzkt zzkt2 : list) {
                if (!bl && zzkw.zzd((String)zzkt2.zzc)) continue;
                arrayList.add(new zzkr(zzkt2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzq().zze().zza("Failed to get user properties. appId", zzer.zza((String)zzn2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzn zzn2) {
        this.zzb(zzn2, false);
        this.zza(new zzgm(this, zzn2));
    }

    @BinderThread
    private final void zzb(zzn zzn2, boolean bl) {
        Preconditions.checkNotNull((Object)zzn2);
        this.zza(zzn2.zza, false);
        this.zza.zzk().zza(zzn2.zzb, zzn2.zzr, zzn2.zzv);
    }

    @BinderThread
    private final void zza(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zza.zzq().zze().zza("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzfw zzfw2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzfw2 = this;
                    if (!bl2) break block9;
                    if (zzfw2.zzb == null) {
                        zzfw2.zzb = "com.google.android.gms".equals(zzfw2.zzc) || UidVerifier.isGooglePlayServicesUid((Context)zzfw2.zza.zzm(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzfw2.zza.zzm()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzfw2.zzb.booleanValue()) break block10;
                }
                if (zzfw2.zzc == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzfw2.zza.zzm(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzfw2.zzc = string2;
                }
                if (!string2.equals(zzfw2.zzc)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zza.zzq().zze().zza("Measurement Service called with invalid calling package. appId", zzer.zza((String)string));
            throw securityException;
        }
    }

    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zza(new zzgp(this, string2, string3, string, l));
    }

    @BinderThread
    public final void zza(Bundle bundle, zzn zzn2) {
        if (zzny.zzb() && this.zza.zzb().zza(zzat.zzbz)) {
            this.zzb(zzn2, false);
            this.zza(new zzfz(this, zzn2, bundle));
        }
    }

    @BinderThread
    public final String zzc(zzn zzn2) {
        this.zzb(zzn2, false);
        return this.zza.zzd(zzn2);
    }

    @BinderThread
    public final void zza(zzw zzw2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzw2);
        Preconditions.checkNotNull((Object)zzw2.zzc);
        this.zzb(zzn2, false);
        zzw zzw3 = new zzw(zzw2);
        new zzw(zzw2).zza = zzn2.zza;
        this.zza(new zzgb(this, zzw3, zzn2));
    }

    @BinderThread
    public final void zza(zzw zzw2) {
        Preconditions.checkNotNull((Object)zzw2);
        Preconditions.checkNotNull((Object)zzw2.zzc);
        this.zza(zzw2.zza, true);
        zzw zzw3 = new zzw(zzw2);
        this.zza(new zzga(this, zzw3));
    }

    @BinderThread
    public final List<zzkr> zza(String string, String string2, boolean bl, zzn zzn2) {
        this.zzb(zzn2, false);
        Future future = this.zza.zzp().zza((Callable)new zzgd(this, zzn2, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzkr> arrayList = new ArrayList<zzkr>(list.size());
            for (zzkt zzkt2 : list) {
                if (!bl && zzkw.zzd((String)zzkt2.zzc)) continue;
                arrayList.add(new zzkr(zzkt2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzq().zze().zza("Failed to query user properties. appId", zzer.zza((String)zzn2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzkr> zza(String string, String string2, String string3, boolean bl) {
        this.zza(string, true);
        Future future = this.zza.zzp().zza((Callable)new zzgc(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzkr> arrayList = new ArrayList<zzkr>(list.size());
            for (zzkt zzkt2 : list) {
                if (!bl && zzkw.zzd((String)zzkt2.zzc)) continue;
                arrayList.add(new zzkr(zzkt2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzq().zze().zza("Failed to get user properties as. appId", zzer.zza((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzw> zza(String string, String string2, zzn zzn2) {
        this.zzb(zzn2, false);
        Future future = this.zza.zzp().zza((Callable)new zzgf(this, zzn2, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzq().zze().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzw> zza(String string, String string2, String string3) {
        this.zza(string, true);
        Future future = this.zza.zzp().zza((Callable)new zzge(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzq().zze().zza("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final void zzd(zzn zzn2) {
        this.zza(zzn2.zza, false);
        this.zza(new zzgh(this, zzn2));
    }

    @VisibleForTesting
    private final void zza(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzp().zzf()) {
            runnable.run();
            return;
        }
        this.zza.zzp().zza(runnable);
    }

    final /* synthetic */ void zza(zzn zzn2, Bundle bundle) {
        this.zza.zze().zza(zzn2.zza, bundle);
    }

    static /* synthetic */ zzki zza(zzfw zzfw2) {
        return zzfw2.zza;
    }
}

