/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.measurement.zzg;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzkd;
import com.google.android.gms.measurement.internal.zzkg;
import com.google.android.gms.measurement.internal.zzko;
import com.google.android.gms.measurement.internal.zzkv;

public final class zzke
extends zzkg {
    private final AlarmManager zzb;
    private final zzal zzc;
    private Integer zzd;

    protected zzke(zzko zzko2) {
        super(zzko2);
        this.zzb = (AlarmManager)this.zzx.zzaw().getSystemService("alarm");
        zzkd zzkd2 = new zzkd(this, (zzgr)zzko2.zzR(), zzko2);
        this.zzc = zzkd2;
    }

    @Override
    protected final boolean zzaz() {
        this.zzb.cancel(this.zzi());
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzf();
        }
        return false;
    }

    @TargetApi(value=24)
    private final void zzf() {
        ((JobScheduler)this.zzx.zzaw().getSystemService("jobscheduler")).cancel(this.zzh());
    }

    public final void zzc(long l) {
        this.zzX();
        this.zzx.zzas();
        Context context = this.zzx.zzaw();
        if (!zzfm.zza((Context)context)) {
            this.zzx.zzat().zzj().zza("Receiver not registered/enabled");
        }
        if (!zzkv.zzP((Context)context, (boolean)false)) {
            this.zzx.zzat().zzj().zza("Service not registered/enabled");
        }
        this.zzd();
        this.zzx.zzat().zzk().zzb("Scheduling upload, millis", (Object)l);
        long l2 = this.zzx.zzax().elapsedRealtime() + l;
        this.zzx.zzc();
        if (l < Math.max(0L, (Long)zzeh.zzw.zzb(null)) && !this.zzc.zzc()) {
            this.zzc.zzb(l);
        }
        this.zzx.zzas();
        if (Build.VERSION.SDK_INT >= 24) {
            context = this.zzx.zzaw();
            ComponentName componentName = new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementJobService");
            int n = this.zzh();
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            JobInfo.Builder builder = new JobInfo.Builder(n, componentName);
            zzg.zza(context, builder.setMinimumLatency(l).setOverrideDeadline(l + l).setExtras(persistableBundle).build(), "com.google.android.gms", "UploadAlarm");
            return;
        }
        context = this.zzb;
        this.zzx.zzc();
        context.setInexactRepeating(2, l2, Math.max((Long)zzeh.zzr.zzb(null), l), this.zzi());
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int zzh() {
        if (this.zzd == null) {
            String string = String.valueOf(this.zzx.zzaw().getPackageName());
            String string2 = "measurement";
            string = string.length() != 0 ? string2.concat(string) : new String(string2);
            this.zzd = string.hashCode();
        }
        return this.zzd;
    }

    public final void zzd() {
        this.zzX();
        this.zzx.zzat().zzk().zza("Unscheduling upload");
        this.zzb.cancel(this.zzi());
        this.zzc.zzd();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzf();
            return;
        }
    }

    private final PendingIntent zzi() {
        zzke zzke2 = zzke2.zzx.zzaw();
        Intent intent = new Intent();
        return PendingIntent.getBroadcast((Context)zzke2, (int)0, (Intent)intent.setClassName((Context)zzke2, "com.google.android.gms.measurement.AppMeasurementReceiver").setAction("com.google.android.gms.measurement.UPLOAD"), (int)0);
    }
}

