/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzaf;
import com.google.android.gms.internal.measurement.zzah;
import com.google.android.gms.internal.measurement.zzan;
import com.google.android.gms.internal.measurement.zzap;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzau;
import com.google.android.gms.internal.measurement.zzbl;
import com.google.android.gms.internal.measurement.zzg;
import java.util.List;

public final class zzh {
    public static void zza(String string, int n, List<zzap> list) {
        if (list.size() != n) {
            Object[] objectArray = new Object[]{string, n, list.size()};
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.format("%s operation requires %s parameters found %s", objectArray));
            throw illegalArgumentException;
        }
    }

    public static void zzb(String string, int n, List<zzap> list) {
        if (list.size() < n) {
            Object[] objectArray = new Object[]{string, n, list.size()};
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.format("%s operation requires at least %s parameters found %s", objectArray));
            throw illegalArgumentException;
        }
    }

    public static void zzc(String string, int n, List<zzap> list) {
        if (list.size() > n) {
            Object[] objectArray = new Object[]{string, n, list.size()};
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.format("%s operation requires at most %s parameters found %s", objectArray));
            throw illegalArgumentException;
        }
    }

    public static boolean zzd(zzap object) {
        if (object == null) {
            return false;
        }
        return !((Double)(object = object.zzd())).isNaN() && (Double)object >= 0.0 && ((Double)object).equals(Math.floor((Double)object));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static zzbl zze(String string) {
        void var1_2;
        if (string != null) {
            if (!string.isEmpty()) {
                zzbl zzbl2 = zzbl.zza(Integer.parseInt(string));
            } else {
                Object var1_4 = null;
            }
        } else {
            Object var1_5 = null;
        }
        if (var1_2 == null) {
            Object[] objectArray = new Object[]{string};
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.format("Unsupported commandId %s", objectArray));
            throw illegalArgumentException;
        }
        return var1_2;
    }

    public static boolean zzf(zzap zzap2, zzap zzap3) {
        if (!zzap2.getClass().equals(zzap3.getClass())) {
            return false;
        }
        if (zzap2 instanceof zzau || zzap2 instanceof zzan) {
            return true;
        }
        if (zzap2 instanceof zzah) {
            if (Double.isNaN(zzap2.zzd()) || Double.isNaN(zzap3.zzd())) {
                return false;
            }
            return zzap2.zzd().equals(zzap3.zzd());
        }
        if (zzap2 instanceof zzat) {
            return zzap2.zzc().equals(zzap3.zzc());
        }
        if (zzap2 instanceof zzaf) {
            return zzap2.zze().equals(zzap3.zze());
        }
        return zzap2 == zzap3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int zzg(double d) {
        int n;
        if (Double.isNaN(d) || Double.isInfinite(d) || d == 0.0) {
            return 0;
        }
        if (d > 0.0) {
            n = 1;
            return (int)((double)n * Math.floor(Math.abs(d)) % 4.294967296E9);
        }
        n = -1;
        return (int)((double)n * Math.floor(Math.abs(d)) % 4.294967296E9);
    }

    public static long zzh(double d) {
        return (long)zzh.zzg(d) & 0xFFFFFFFFL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double zzi(double d) {
        int n;
        if (Double.isNaN(d)) {
            return 0.0;
        }
        if (Double.isInfinite(d) || d == 0.0 || d == 0.0) {
            return d;
        }
        if (d > 0.0) {
            n = 1;
            return (double)n * Math.floor(Math.abs(d));
        }
        n = -1;
        return (double)n * Math.floor(Math.abs(d));
    }

    public static Object zzj(zzap zzap2) {
        if (zzap.zzg.equals(zzap2)) {
            return null;
        }
        if (zzap.zzf.equals(zzap2)) {
            return "";
        }
        if (!zzap2.zzd().isNaN()) {
            return zzap2.zzd();
        }
        return zzap2.zzc();
    }

    public static int zzk(zzg object) {
        int n = zzh.zzg(((zzg)object).zzh("runtime.counter").zzd() + 1.0);
        if (n > 1000000) {
            object = new IllegalStateException("Instructions allowed exceeded");
            throw object;
        }
        zzah zzah2 = new zzah(Double.valueOf(n));
        ((zzg)object).zze("runtime.counter", zzah2);
        return n;
    }
}

