/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzaa;
import com.google.android.gms.internal.measurement.zzc;
import com.google.android.gms.internal.measurement.zzd;
import com.google.android.gms.internal.measurement.zzpl;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzdw;
import com.google.android.gms.measurement.internal.zzdy;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzkn;
import com.google.android.gms.measurement.internal.zzkp;
import com.google.android.gms.measurement.internal.zzkq;
import com.google.android.gms.measurement.internal.zzks;
import com.google.android.gms.measurement.internal.zzku;
import com.google.android.gms.measurement.internal.zzp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public final class zzgk
extends zzdy {
    private final zzkn zza;
    private Boolean zzb;
    private String zzc;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final zzat zzb(zzat zzat2, zzp object) {
        if (!"_cmp".equals(zzat2.zza)) return zzat2;
        zzar zzar2 = zzat2.zzb;
        if (zzar2 == null) return zzat2;
        if (zzar2.zza() == 0) {
            return zzat2;
        }
        String string = zzat2.zzb.zzg("_cis");
        if (!"referrer broadcast".equals(string)) {
            if (!"referrer API".equals(string)) return zzat2;
        }
        this.zza.zzay().zzi().zzb("Event has been filtered ", (Object)zzat2.toString());
        return new zzat("_cmpx", zzat2.zzb, zzat2.zzc, zzat2.zzd);
    }

    static /* bridge */ /* synthetic */ zzkn zzc(zzgk zzgk2) {
        return zzgk2.zza;
    }

    @BinderThread
    public final String zzd(zzp zzp2) {
        this.zzz(zzp2, false);
        return this.zza.zzx(zzp2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List<zzkq> zze(zzp zzp2, boolean bl) {
        this.zzz(zzp2, false);
        Iterator iterator = zzp2.zza;
        Preconditions.checkNotNull((Object)iterator);
        ArrayList<zzkq> arrayList = this.zza;
        arrayList = ((zzkn)((Object)arrayList)).zzaz();
        zzgh zzgh2 = new zzgh(this, (String)((Object)iterator));
        iterator = arrayList.zzh(zzgh2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzkq>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                zzgh2 = (zzks)iterator.next();
                if (!bl && (bl2 = zzku.zzag((String)((zzks)zzgh2).zzc))) continue;
                zzkq zzkq2 = new zzkq((zzks)zzgh2);
                arrayList.add(zzkq2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzc("Failed to get user properties. appId", zzei.zzn((String)zzp2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final List<zzab> zzf(String object, String string, zzp object2) {
        this.zzz((zzp)object2, false);
        object2 = object2.zza;
        Preconditions.checkNotNull((Object)object2);
        zzkn zzkn2 = this.zza;
        zzkn2 = zzkn2.zzaz();
        zzfy zzfy2 = new zzfy(this, (String)object2, (String)object, string);
        object = zzkn2.zzh(zzfy2);
        try {
            object = (List)object.get();
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzb("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzab> zzg(String object, String string, String string2) {
        this.zzA((String)object, true);
        zzkn zzkn2 = this.zza;
        zzkn2 = zzkn2.zzaz();
        zzfz zzfz2 = new zzfz(this, (String)object, string, string2);
        object = zzkn2.zzh(zzfz2);
        try {
            object = (List)object.get();
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzb("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List<zzkq> zzh(String iterator, String arrayList, boolean bl, zzp zzp2) {
        this.zzz(zzp2, false);
        String string = zzp2.zza;
        Preconditions.checkNotNull((Object)string);
        zzkn zzkn2 = this.zza;
        zzkn2 = zzkn2.zzaz();
        zzfw zzfw2 = new zzfw(this, string, (String)((Object)iterator), (String)((Object)arrayList));
        iterator = zzkn2.zzh(zzfw2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzkq>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                string = (zzks)iterator.next();
                if (!bl && (bl2 = zzku.zzag((String)((zzks)string).zzc))) continue;
                zzkq zzkq2 = new zzkq((zzks)string);
                arrayList.add(zzkq2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzc("Failed to query user properties. appId", zzei.zzn((String)zzp2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final List<zzkq> zzi(String string, String iterator, String arrayList, boolean bl) {
        this.zzA(string, true);
        zzkn zzkn2 = this.zza;
        zzkn2 = zzkn2.zzaz();
        zzfx zzfx2 = new zzfx(this, string, (String)((Object)iterator), (String)((Object)arrayList));
        iterator = zzkn2.zzh(zzfx2);
        try {
            iterator = (List)iterator.get();
            arrayList = new ArrayList<zzkq>(iterator.size());
            iterator = iterator.iterator();
            while (true) {
                boolean bl2;
                boolean bl3;
                if (!(bl3 = iterator.hasNext())) {
                    return arrayList;
                }
                zzkn2 = (zzks)iterator.next();
                if (!bl && (bl2 = zzku.zzag((String)((zzks)zzkn2).zzc))) continue;
                zzkq zzkq2 = new zzkq((zzks)zzkn2);
                arrayList.add(zzkq2);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzc("Failed to get user properties as. appId", zzei.zzn((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    static /* bridge */ /* synthetic */ void zzv(zzgk zzgk2, zzat zzat2, zzp zzp2) {
        zzgk2.zzB(zzat2, zzp2);
    }

    public zzgk(zzkn zzkn2, String string) {
        Preconditions.checkNotNull((Object)zzkn2);
        this.zza = zzkn2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzj(zzp zzp2) {
        this.zzz(zzp2, false);
        zzgi zzgi2 = new zzgi(this, zzp2);
        this.zzy(zzgi2);
    }

    @BinderThread
    private final void zzz(zzp zzp2, boolean bl) {
        Preconditions.checkNotNull((Object)zzp2);
        Preconditions.checkNotEmpty((String)zzp2.zza);
        this.zzA(zzp2.zza, false);
        this.zza.zzv().zzW(zzp2.zzb, zzp2.zzq, zzp2.zzu);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    private final void zzA(String string, boolean bl) {
        block12: {
            boolean bl2;
            boolean bl3;
            String string2;
            void var1_2;
            block11: {
                boolean bl4;
                block8: {
                    boolean bl5;
                    block10: {
                        block9: {
                            if (TextUtils.isEmpty((CharSequence)var1_2)) {
                                this.zza.zzay().zzd().zza("Measurement Service called without app package");
                                SecurityException securityException = new SecurityException("Measurement Service called without app package");
                                throw securityException;
                            }
                            if (!bl4) break block11;
                            try {
                                Boolean bl6 = this.zzb;
                                if (bl6 != null) break block8;
                                bl5 = "com.google.android.gms".equals(this.zzc);
                                if (bl5) break block9;
                                bl5 = UidVerifier.isGooglePlayServicesUid((Context)this.zza.zzau(), (int)Binder.getCallingUid());
                                bl5 = !bl5 ? (bl5 = GoogleSignatureVerifier.getInstance((Context)this.zza.zzau()).isUidGoogleSigned(Binder.getCallingUid())) : true;
                                break block10;
                            }
                            catch (SecurityException securityException) {
                                this.zza.zzay().zzd().zzb("Measurement Service called with invalid calling package. appId", zzei.zzn((String)var1_2));
                                throw securityException;
                            }
                        }
                        bl5 = true;
                    }
                    this.zzb = bl5;
                }
                if (bl4 = this.zzb.booleanValue()) break block12;
            }
            if ((string2 = this.zzc) == null && (bl3 = GooglePlayServicesUtilLight.uidHasPackageName((Context)this.zza.zzau(), (int)Binder.getCallingUid(), (String)var1_2))) {
                this.zzc = var1_2;
            }
            if (!(bl2 = var1_2.equals(this.zzc))) {
                Object[] objectArray = new Object[]{var1_2};
                SecurityException securityException = new SecurityException(String.format("Unknown calling package name '%s'.", objectArray));
                throw securityException;
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void zzw(zzat object, zzp zzp2) {
        block12: {
            void var3_5;
            block14: {
                block13: {
                    if (!this.zza.zzo().zzl(zzp2.zza)) {
                        this.zzB((zzat)object, zzp2);
                        return;
                    }
                    this.zza.zzay().zzj().zzb("EES config found for", (Object)zzp2.zza);
                    zzfj zzfj2 = this.zza.zzo();
                    String string = zzp2.zza;
                    zzpl.zzc();
                    if (zzfj2.zzs.zzf().zzs(null, zzdw.zzav)) {
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            Object var3_4 = null;
                        } else {
                            zzc zzc2 = (zzc)zzfj2.zza.get((Object)string);
                        }
                    } else {
                        Object var3_9 = null;
                    }
                    if (var3_5 == null) {
                        this.zza.zzay().zzj().zzb("EES not loaded for", (Object)zzp2.zza);
                        this.zzB((zzat)object, zzp2);
                        return;
                    }
                    try {
                        zzaa zzaa2;
                        boolean bl;
                        Map<String, Object> map = zzkp.zzt(((zzat)object).zzb.zzc(), true);
                        string = zzgp.zza((String)((zzat)object).zza);
                        if (string == null) {
                            string = ((zzat)object).zza;
                        }
                        if (!(bl = var3_5.zze(zzaa2 = new zzaa(string, ((zzat)object).zzd, map)))) break block12;
                        if (!var3_5.zzg()) break block13;
                    }
                    catch (zzd zzd2) {
                        this.zza.zzay().zzd().zzc("EES error. appId, eventName", (Object)zzp2.zzb, (Object)((zzat)object).zza);
                    }
                    this.zza.zzay().zzj().zzb("EES edited event", (Object)((zzat)object).zza);
                    this.zzB(zzkp.zzi(var3_5.zza().zzb()), zzp2);
                    break block14;
                }
                this.zzB((zzat)object, zzp2);
            }
            if (var3_5.zzf()) {
                for (zzaa zzaa3 : var3_5.zza().zzc()) {
                    this.zza.zzay().zzj().zzb("EES logging created event", (Object)zzaa3.zzd());
                    this.zzB(zzkp.zzi(zzaa3), zzp2);
                }
            }
            return;
        }
        this.zza.zzay().zzj().zzb("EES was not applied to event", (Object)((zzat)object).zza);
        this.zzB((zzat)object, zzp2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final /* synthetic */ void zzx(String string, Bundle object) {
        zzaj zzaj2 = ((zzgk)((Object)zzaj2)).zza.zzi();
        zzaj2.zzg();
        zzaj2.zzY();
        zzao zzao2 = new zzao(zzaj2.zzs, "", string, "dep", 0L, 0L, object);
        byte[] byArray = zzaj2.zzf.zzu().zzj(zzao2).zzbs();
        zzaj2.zzs.zzay().zzj().zzc("Saving default event parameters, appId, data size", (Object)zzaj2.zzs.zzj().zzc(string), (Object)byArray.length);
        zzao2 = new ContentValues();
        zzao2.put("app_id", string);
        zzao2.put("parameters", byArray);
        try {
            long l = zzaj2.zzh().insertWithOnConflict("default_event_params", null, (ContentValues)zzao2, 5);
            if (l != -1L) return;
        }
        catch (SQLiteException sQLiteException) {
            zzaj2.zzs.zzay().zzd().zzc("Error storing default event parameters. appId", zzei.zzn((String)string), (Object)sQLiteException);
            return;
        }
        zzei zzei2 = zzaj2.zzs.zzay();
        zzei2.zzd().zzb("Failed to insert default event parameters (got -1). appId", zzei.zzn((String)string));
    }

    @BinderThread
    public final void zzk(zzat zzat2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzat2);
        this.zzz(zzp2, false);
        zzgd zzgd2 = new zzgd(this, zzat2, zzp2);
        this.zzy(zzgd2);
    }

    @BinderThread
    public final void zzl(zzat zzat2, String string, String object) {
        Preconditions.checkNotNull((Object)zzat2);
        Preconditions.checkNotEmpty((String)string);
        this.zzA(string, true);
        object = new zzge(this, zzat2, string);
        this.zzy((Runnable)object);
    }

    private final void zzB(zzat zzat2, zzp zzp2) {
        this.zza.zzA();
        this.zza.zzD(zzat2, zzp2);
    }

    @BinderThread
    public final void zzm(zzp zzp2) {
        Preconditions.checkNotEmpty((String)zzp2.zza);
        this.zzA(zzp2.zza, false);
        zzga zzga2 = new zzga(this, zzp2);
        this.zzy(zzga2);
    }

    @VisibleForTesting
    final void zzy(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzaz().zzs()) {
            runnable.run();
            return;
        }
        this.zza.zzaz().zzp(runnable);
    }

    @BinderThread
    public final void zzn(zzab object, zzp zzp2) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkNotNull((Object)object.zzc);
        this.zzz(zzp2, false);
        zzab zzab2 = new zzab(object);
        zzab2.zza = zzp2.zza;
        object = new zzfu(this, zzab2, zzp2);
        this.zzy((Runnable)object);
    }

    @BinderThread
    public final void zzo(zzab object) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkNotNull((Object)object.zzc);
        Preconditions.checkNotEmpty((String)object.zza);
        this.zzA(object.zza, true);
        zzab zzab2 = new zzab(object);
        object = new zzfv(this, zzab2);
        this.zzy((Runnable)object);
    }

    @BinderThread
    public final void zzp(zzp zzp2) {
        Preconditions.checkNotEmpty((String)zzp2.zza);
        Preconditions.checkNotNull((Object)zzp2.zzv);
        zzgc zzgc2 = new zzgc(this, zzp2);
        Preconditions.checkNotNull((Object)zzgc2);
        if (this.zza.zzaz().zzs()) {
            zzgc2.run();
            return;
        }
        this.zza.zzaz().zzq((Runnable)zzgc2);
    }

    @BinderThread
    public final void zzq(long l, String string, String string2, String string3) {
        zzgj zzgj2 = new zzgj(this, string2, string3, string, l);
        this.zzy(zzgj2);
    }

    @BinderThread
    public final void zzr(Bundle bundle, zzp object) {
        this.zzz((zzp)object, false);
        object = object.zza;
        Preconditions.checkNotNull((Object)object);
        zzft zzft2 = new zzft(this, (String)object, bundle);
        this.zzy(zzft2);
    }

    @BinderThread
    public final void zzs(zzp zzp2) {
        this.zzz(zzp2, false);
        zzgb zzgb2 = new zzgb(this, zzp2);
        this.zzy(zzgb2);
    }

    @BinderThread
    public final void zzt(zzkq zzkq2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzkq2);
        this.zzz(zzp2, false);
        zzgg zzgg2 = new zzgg(this, zzkq2, zzp2);
        this.zzy(zzgg2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BinderThread
    public final byte[] zzu(zzat zzat2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzat2);
        this.zzA(string, true);
        this.zza.zzay().zzc().zzb("Log and bundle. event", (Object)this.zza.zzj().zzc(zzat2.zza));
        long l = this.zza.zzav().nanoTime() / 1000000L;
        Object object = this.zza;
        object = ((zzkn)object).zzaz();
        Object object2 = new zzgf(this, zzat2, string);
        object = object.zzi((Callable)object2);
        try {
            object = (byte[])object.get();
            if (object == null) {
                this.zza.zzay().zzd().zzb("Log and bundle returned null. appId", zzei.zzn((String)string));
                object = new byte[0];
            }
            object2 = this.zza;
            object2 = ((zzkn)object2).zzav();
            long l2 = object2.nanoTime();
            this.zza.zzay().zzc().zzd("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzj().zzc(zzat2.zza), (Object)((Object)object).length, (Object)(l2 / 1000000L - l));
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzay().zzd().zzd("Failed to log and bundle. appId, event, error", zzei.zzn((String)string), (Object)this.zza.zzj().zzc(zzat2.zza), (Object)exception);
            return null;
        }
    }
}

