/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.internal.measurement.zzaa;
import com.google.android.gms.internal.measurement.zzej;
import com.google.android.gms.internal.measurement.zzel;
import com.google.android.gms.internal.measurement.zzeq;
import com.google.android.gms.internal.measurement.zzes;
import com.google.android.gms.internal.measurement.zzex;
import com.google.android.gms.internal.measurement.zzfk;
import com.google.android.gms.internal.measurement.zzfm;
import com.google.android.gms.internal.measurement.zzfn;
import com.google.android.gms.internal.measurement.zzfo;
import com.google.android.gms.internal.measurement.zzfr;
import com.google.android.gms.internal.measurement.zzfs;
import com.google.android.gms.internal.measurement.zzfw;
import com.google.android.gms.internal.measurement.zzfx;
import com.google.android.gms.internal.measurement.zzfy;
import com.google.android.gms.internal.measurement.zzgd;
import com.google.android.gms.internal.measurement.zzgf;
import com.google.android.gms.internal.measurement.zzgg;
import com.google.android.gms.internal.measurement.zzgh;
import com.google.android.gms.internal.measurement.zzjl;
import com.google.android.gms.internal.measurement.zzkj;
import com.google.android.gms.internal.measurement.zzlf;
import com.google.android.gms.internal.measurement.zzoz;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzdw;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzkh;
import com.google.android.gms.measurement.internal.zzkr;
import com.google.android.gms.measurement.internal.zzky;
import com.google.android.gms.measurement.internal.zzp;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public final class zzkt
extends zzkh {
    static int zza(zzfx zzfx2, String string) {
        for (int i = 0; i < zzfx2.zzb(); ++i) {
            if (!string.equals(zzfx2.zzaj(i).zzf())) continue;
            return i;
        }
        return -1;
    }

    @WorkerThread
    final long zzd(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        this.zzs.zzv().zzg();
        MessageDigest messageDigest = zzky.zzE();
        if (messageDigest == null) {
            this.zzs.zzay().zzd().zza("Failed to get MD5");
            return 0L;
        }
        return zzky.zzp((byte[])messageDigest.digest(byArray));
    }

    final Bundle zzf(Map map, boolean bl) {
        Bundle bundle = new Bundle();
        for (String string : map.keySet()) {
            Object v = map.get(string);
            if (v == null) {
                bundle.putString(string, null);
                continue;
            }
            if (v instanceof Long) {
                bundle.putLong(string, ((Long)v).longValue());
                continue;
            }
            if (v instanceof Double) {
                bundle.putDouble(string, ((Double)v).doubleValue());
                continue;
            }
            if (v instanceof ArrayList) {
                int n;
                ArrayList<Bundle> arrayList;
                ArrayList arrayList2;
                if (!bl) continue;
                zzoz.zzc();
                if (this.zzs.zzf().zzs(null, zzdw.zzam)) {
                    arrayList2 = (ArrayList)v;
                    arrayList = new ArrayList<Bundle>();
                    n = arrayList2.size();
                    for (int i = 0; i < n; ++i) {
                        arrayList.add(this.zzf((Map)arrayList2.get(i), false));
                    }
                    bundle.putParcelableArray(string, arrayList.toArray(new Parcelable[0]));
                    continue;
                }
                arrayList2 = (ArrayList)v;
                arrayList = new ArrayList<Bundle>();
                n = arrayList2.size();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(this.zzf((Map)arrayList2.get(i), false));
                }
                bundle.putParcelableArrayList(string, arrayList);
                continue;
            }
            bundle.putString(string, v.toString());
        }
        return bundle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Parcelable zzh(byte[] object, Parcelable.Creator creator) {
        if (object == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall((byte[])object, 0, ((Object)object).length);
            parcel.setDataPosition(0);
            object = (Parcelable)creator.createFromParcel(parcel);
        }
        catch (SafeParcelReader.ParseException parseException) {
            try {
                zzkt zzkt2;
                zzkt2 = zzkt2.zzs.zzay();
                zzkt2.zzd().zza("Failed to load parcelable from buffer");
                return null;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                parcel.recycle();
            }
        }
        parcel.recycle();
        return object;
    }

    final zzau zzi(zzaa zzaa2) {
        Object object;
        Bundle bundle = object2.zzf(zzaa2.zze(), true);
        Object object2 = "app";
        if (bundle.containsKey("_o") && (object = bundle.get("_o")) != null) {
            object2 = object.toString();
        }
        if ((object = zzgq.zzb((String)zzaa2.zzd())) == null) {
            object = zzaa2.zzd();
        }
        zzas zzas2 = new zzas(bundle);
        zzau zzau2 = new zzau((String)object, zzas2, (String)object2, zzaa2.zza());
        return zzau2;
    }

    final zzfo zzj(zzap zzap2) {
        zzfn zzfn2 = zzfo.zze();
        zzfn2.zzl(zzap2.zze);
        Object object = zzap2.zzf;
        zzar zzar2 = new zzar(object);
        while (zzar2.hasNext()) {
            object = zzar2.zza();
            zzfr zzfr2 = zzfs.zze();
            zzfr2.zzj((String)object);
            object = zzap2.zzf.zzf((String)object);
            Preconditions.checkNotNull((Object)object);
            this.zzt(zzfr2, object);
            zzfn2.zze(zzfr2);
        }
        return (zzfo)zzfn2.zzay();
    }

    static zzlf zzl(zzlf zzlf2, byte[] byArray) throws zzkj {
        zzjl zzjl2 = zzjl.zzb();
        if (zzjl2 != null) {
            return zzlf2.zzau(byArray, zzjl2);
        }
        return zzlf2.zzat(byArray);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    final String zzm(zzfw var1_1) {
        if (var1_1 == null) {
            return "";
        }
        var2_2 = new StringBuilder();
        var2_2.append("\nbatch {\n");
        var3_3 = var1_1.zzd().iterator();
        block0: while (true) {
            if (!var3_3.hasNext()) {
                var2_2.append("}\n");
                return var2_2.toString();
            }
            var4_4 = (zzfy)var3_3.next();
            if (var4_4 == null) continue;
            zzkt.zzF(var2_2, 1);
            var2_2.append("bundle {\n");
            if (var4_4.zzbf()) {
                zzkt.zzI(var2_2, 1, "protocol_version", var4_4.zzd());
            }
            zzkt.zzI(var2_2, 1, "platform", var4_4.zzJ());
            if (var4_4.zzbb()) {
                zzkt.zzI(var2_2, 1, "gmp_version", var4_4.zzn());
            }
            if (var4_4.zzbl()) {
                zzkt.zzI(var2_2, 1, "uploading_gmp_version", var4_4.zzs());
            }
            if (var4_4.zzaZ()) {
                zzkt.zzI(var2_2, 1, "dynamite_version", var4_4.zzk());
            }
            if (var4_4.zzaW()) {
                zzkt.zzI(var2_2, 1, "config_version", var4_4.zzi());
            }
            zzkt.zzI(var2_2, 1, "gmp_app_id", var4_4.zzG());
            zzkt.zzI(var2_2, 1, "admob_app_id", var4_4.zzx());
            zzkt.zzI(var2_2, 1, "app_id", var4_4.zzy());
            zzkt.zzI(var2_2, 1, "app_version", var4_4.zzB());
            if (var4_4.zzaU()) {
                zzkt.zzI(var2_2, 1, "app_version_major", var4_4.zza());
            }
            zzkt.zzI(var2_2, 1, "firebase_instance_id", var4_4.zzF());
            if (var4_4.zzaY()) {
                zzkt.zzI(var2_2, 1, "dev_cert_hash", var4_4.zzj());
            }
            zzkt.zzI(var2_2, 1, "app_store", var4_4.zzA());
            if (var4_4.zzbk()) {
                zzkt.zzI(var2_2, 1, "upload_timestamp_millis", var4_4.zzr());
            }
            if (var4_4.zzbi()) {
                zzkt.zzI(var2_2, 1, "start_timestamp_millis", var4_4.zzq());
            }
            if (var4_4.zzba()) {
                zzkt.zzI(var2_2, 1, "end_timestamp_millis", var4_4.zzm());
            }
            if (var4_4.zzbe()) {
                zzkt.zzI(var2_2, 1, "previous_bundle_start_timestamp_millis", var4_4.zzp());
            }
            if (var4_4.zzbd()) {
                zzkt.zzI(var2_2, 1, "previous_bundle_end_timestamp_millis", var4_4.zzo());
            }
            zzkt.zzI(var2_2, 1, "app_instance_id", var4_4.zzz());
            zzkt.zzI(var2_2, 1, "resettable_device_id", var4_4.zzK());
            zzkt.zzI(var2_2, 1, "ds_id", var4_4.zzE());
            if (var4_4.zzbc()) {
                zzkt.zzI(var2_2, 1, "limited_ad_tracking", var4_4.zzaR());
            }
            zzkt.zzI(var2_2, 1, "os_version", var4_4.zzI());
            zzkt.zzI(var2_2, 1, "device_model", var4_4.zzD());
            zzkt.zzI(var2_2, 1, "user_default_language", var4_4.zzL());
            if (var4_4.zzbj()) {
                zzkt.zzI(var2_2, 1, "time_zone_offset_minutes", var4_4.zzf());
            }
            if (var4_4.zzaV()) {
                zzkt.zzI(var2_2, 1, "bundle_sequential_index", var4_4.zzb());
            }
            if (var4_4.zzbh()) {
                zzkt.zzI(var2_2, 1, "service_upload", var4_4.zzaS());
            }
            zzkt.zzI(var2_2, 1, "health_monitor", var4_4.zzH());
            if (!this.zzs.zzf().zzs(null, zzdw.zzah) && var4_4.zzaT() && var4_4.zzh() != 0L) {
                zzkt.zzI(var2_2, 1, "android_id", var4_4.zzh());
            }
            if (var4_4.zzbg()) {
                zzkt.zzI(var2_2, 1, "retry_counter", var4_4.zze());
            }
            if (var4_4.zzaX()) {
                zzkt.zzI(var2_2, 1, "consent_signals", var4_4.zzC());
            }
            if ((var1_1 = var4_4.zzO()) == null) ** GOTO lbl73
            var5_5 /* !! */  = var1_1.iterator();
            while (true) {
                block37: {
                    if (var5_5 /* !! */ .hasNext()) break block37;
lbl73:
                    // 2 sources

                    if ((var1_1 = var4_4.zzM()) != null) {
                        var1_1 = var1_1.iterator();
                        while (var1_1.hasNext()) {
                            var5_5 /* !! */  = (zzfk)var1_1.next();
                            if (var5_5 /* !! */  == null) continue;
                            zzkt.zzF(var2_2, 2);
                            var2_2.append("audience_membership {\n");
                            if (var5_5 /* !! */ .zzk()) {
                                zzkt.zzI(var2_2, 2, "audience_id", var5_5 /* !! */ .zza());
                            }
                            if (var5_5 /* !! */ .zzm()) {
                                zzkt.zzI(var2_2, 2, "new_audience", var5_5 /* !! */ .zzj());
                            }
                            zzkt.zzH(var2_2, 2, "current_data", var5_5 /* !! */ .zzd());
                            if (var5_5 /* !! */ .zzn()) {
                                zzkt.zzH(var2_2, 2, "previous_data", var5_5 /* !! */ .zze());
                            }
                            zzkt.zzF(var2_2, 2);
                            var2_2.append("}\n");
                        }
                    }
                    if ((var1_1 = var4_4.zzN()) != null) {
                        var1_1 = var1_1.iterator();
                        while (var1_1.hasNext()) {
                            var4_4 = (zzfo)var1_1.next();
                            if (var4_4 == null) continue;
                            zzkt.zzF(var2_2, 2);
                            var2_2.append("event {\n");
                            zzkt.zzI(var2_2, 2, "name", this.zzs.zzj().zzd(var4_4.zzh()));
                            if (var4_4.zzu()) {
                                zzkt.zzI(var2_2, 2, "timestamp_millis", var4_4.zzd());
                            }
                            if (var4_4.zzt()) {
                                zzkt.zzI(var2_2, 2, "previous_timestamp_millis", var4_4.zzc());
                            }
                            if (var4_4.zzs()) {
                                zzkt.zzI(var2_2, 2, "count", var4_4.zza());
                            }
                            if (var4_4.zzb() != 0) {
                                this.zzD(var2_2, 2, var4_4.zzi());
                            }
                            zzkt.zzF(var2_2, 2);
                            var2_2.append("}\n");
                        }
                    }
                    zzkt.zzF(var2_2, 1);
                    var2_2.append("}\n");
                    continue block0;
                }
                var6_6 = (zzgh)var5_5 /* !! */ .next();
                if (var6_6 == null) continue;
                zzkt.zzF(var2_2, 2);
                var2_2.append("user_property {\n");
                var1_1 = var6_6.zzs() != false ? Long.valueOf(var6_6.zzc()) : null;
                zzkt.zzI(var2_2, 2, "set_timestamp_millis", var1_1);
                zzkt.zzI(var2_2, 2, "name", this.zzs.zzj().zzf(var6_6.zzf()));
                zzkt.zzI(var2_2, 2, "string_value", var6_6.zzg());
                var1_1 = var6_6.zzr() != false ? Long.valueOf(var6_6.zzb()) : null;
                zzkt.zzI(var2_2, 2, "int_value", var1_1);
                var1_1 = var6_6.zzq() != false ? Double.valueOf(var6_6.zza()) : null;
                zzkt.zzI(var2_2, 2, "double_value", var1_1);
                zzkt.zzF(var2_2, 2);
                var2_2.append("}\n");
            }
            break;
        }
    }

    final String zzo(zzej object) {
        if (object == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        if (((zzej)((Object)object)).zzp()) {
            zzkt.zzI(stringBuilder, 0, "filter_id", ((zzej)((Object)object)).zzb());
        }
        zzkt.zzI(stringBuilder, 0, "event_name", this.zzs.zzj().zzd(((zzej)((Object)object)).zzg()));
        String string = zzkt.zzG(((zzej)((Object)object)).zzk(), ((zzej)((Object)object)).zzm(), ((zzej)((Object)object)).zzn());
        if (!string.isEmpty()) {
            zzkt.zzI(stringBuilder, 0, "filter_type", string);
        }
        if (((zzej)((Object)object)).zzo()) {
            zzkt.zzJ(stringBuilder, 1, "event_count_filter", ((zzej)((Object)object)).zzf());
        }
        if (((zzej)((Object)object)).zza() > 0) {
            stringBuilder.append("  filters {\n");
            object = ((zzej)((Object)object)).zzh().iterator();
            while (object.hasNext()) {
                this.zzE(stringBuilder, 2, (zzel)((Object)object.next()));
            }
        }
        zzkt.zzF(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    final String zzp(zzes zzes2) {
        if (zzes2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        if (zzes2.zzj()) {
            zzkt.zzI(stringBuilder, 0, "filter_id", zzes2.zza());
        }
        zzkt.zzI(stringBuilder, 0, "property_name", this.zzs.zzj().zzf(zzes2.zze()));
        String string = zzkt.zzG(zzes2.zzg(), zzes2.zzh(), zzes2.zzi());
        if (!string.isEmpty()) {
            zzkt.zzI(stringBuilder, 0, "filter_type", string);
        }
        this.zzE(stringBuilder, 1, zzes2.zzb());
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final List zzq(List object, List object2) {
        ArrayList<Long> arrayList = new ArrayList<Long>((Collection<Long>)object);
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (Integer)object.next();
            if ((Integer)object2 < 0) {
                this.zzs.zzay().zzk().zzb("Ignoring negative bit index to be cleared", object2);
                continue;
            }
            int n = (Integer)object2 / 64;
            if (n >= arrayList.size()) {
                this.zzs.zzay().zzk().zzc("Ignoring bit index greater than bitSet size", object2, (Object)arrayList.size());
                continue;
            }
            arrayList.set(n, (Long)arrayList.get(n) & (1L << (Integer)object2 % 64 ^ 0xFFFFFFFFFFFFFFFFL));
        }
        int n = arrayList.size();
        int n2 = arrayList.size() + -1;
        while (n2 >= 0 && (Long)arrayList.get(n2) == 0L) {
            int n3 = n2 + -1;
            n = n2;
            n2 = n3;
        }
        return arrayList.subList(0, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    static List zzr(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        int n2 = 0;
        block0: while (n2 < n) {
            long l = 0L;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 >= 64 || (n4 = n2 * 64 + n3) >= bitSet.length()) {
                    arrayList.add(l);
                    ++n2;
                    continue block0;
                }
                long l2 = bitSet.get(n4) ? (l |= 1L << n3) : l;
                ++n3;
                l = l2;
            }
            break;
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    final Map zzs(Bundle bundle, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = bundle.get(string);
            zzoz.zzc();
            if (this.zzs.zzf().zzs(null, zzdw.zzam) ? object instanceof Parcelable[] || object instanceof ArrayList || object instanceof Bundle : object instanceof Bundle[] || object instanceof ArrayList || object instanceof Bundle) {
                if (!bl) continue;
                ArrayList<Map> arrayList = new ArrayList<Map>();
                if (object instanceof Parcelable[]) {
                    for (Parcelable parcelable : (Parcelable[])object) {
                        if (!(parcelable instanceof Bundle)) continue;
                        arrayList.add(this.zzs((Bundle)parcelable, false));
                    }
                } else if (object instanceof ArrayList) {
                    ArrayList arrayList2 = (ArrayList)object;
                    int n = arrayList2.size();
                    for (int i = 0; i < n; ++i) {
                        Object e = arrayList2.get(i);
                        if (!(e instanceof Bundle)) continue;
                        arrayList.add(this.zzs((Bundle)e, false));
                    }
                } else if (object instanceof Bundle) {
                    arrayList.add(this.zzs((Bundle)object, false));
                }
                hashMap.put(string, arrayList);
                continue;
            }
            if (object == null) continue;
            hashMap.put(string, object);
        }
        return hashMap;
    }

    zzkt(zzkr zzkr2) {
        super(zzkr2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzD(StringBuilder stringBuilder, int n, List iterator) {
        if (iterator == null) {
            return;
        }
        int n2 = n + 1;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            zzfs zzfs2 = (zzfs)((Object)iterator.next());
            if (zzfs2 == null) continue;
            zzkt.zzF(stringBuilder, n2);
            stringBuilder.append("param {\n");
            Object object = zzfs2.zzx() ? this.zzs.zzj().zze(zzfs2.zzg()) : null;
            zzkt.zzI(stringBuilder, n2, "name", object);
            object = zzfs2.zzy() ? zzfs2.zzh() : null;
            zzkt.zzI(stringBuilder, n2, "string_value", object);
            object = zzfs2.zzw() ? Long.valueOf(zzfs2.zzd()) : null;
            zzkt.zzI(stringBuilder, n2, "int_value", object);
            object = zzfs2.zzu() ? Double.valueOf(zzfs2.zza()) : null;
            zzkt.zzI(stringBuilder, n2, "double_value", object);
            if (zzfs2.zzc() > 0) {
                this.zzD(stringBuilder, n2, zzfs2.zzi());
            }
            zzkt.zzF(stringBuilder, n2);
            stringBuilder.append("}\n");
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzE(StringBuilder stringBuilder, int n, zzel zzel2) {
        if (zzel2 == null) {
            return;
        }
        zzkt.zzF(stringBuilder, n);
        stringBuilder.append("filter {\n");
        if (zzel2.zzh()) {
            zzkt.zzI(stringBuilder, n, "complement", zzel2.zzg());
        }
        if (zzel2.zzj()) {
            zzkt.zzI(stringBuilder, n, "param_name", ((zzgm)object).zzs.zzj().zze(zzel2.zze()));
        }
        if (zzel2.zzk()) {
            int n2 = n + 1;
            zzex zzex2 = zzel2.zzd();
            if (zzex2 != null) {
                zzkt.zzF(stringBuilder, n2);
                stringBuilder.append("string_filter {\n");
                if (zzex2.zzi()) {
                    switch (zzex2.zzj()) {
                        default: {
                            Object object = "IN_LIST";
                            break;
                        }
                        case 1: {
                            Object object = "UNKNOWN_MATCH_TYPE";
                            break;
                        }
                        case 6: {
                            Object object = "EXACT";
                            break;
                        }
                        case 5: {
                            Object object = "PARTIAL";
                            break;
                        }
                        case 4: {
                            Object object = "ENDS_WITH";
                            break;
                        }
                        case 3: {
                            Object object = "BEGINS_WITH";
                            break;
                        }
                        case 2: {
                            Object object = "REGEXP";
                        }
                    }
                    zzkt.zzI(stringBuilder, n2, "match_type", object);
                }
                if (zzex2.zzh()) {
                    zzkt.zzI(stringBuilder, n2, "expression", zzex2.zzd());
                }
                if (zzex2.zzg()) {
                    zzkt.zzI(stringBuilder, n2, "case_sensitive", zzex2.zzf());
                }
                if (zzex2.zza() > 0) {
                    zzkt.zzF(stringBuilder, n2 + 1);
                    stringBuilder.append("expression_list {\n");
                    for (Object e : zzex2.zze()) {
                        String string = (String)e;
                        zzkt.zzF(stringBuilder, n2 + 2);
                        stringBuilder.append(string);
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append("}\n");
                }
                zzkt.zzF(stringBuilder, n2);
                stringBuilder.append("}\n");
            }
        }
        if (zzel2.zzi()) {
            zzkt.zzJ(stringBuilder, n + 1, "number_filter", zzel2.zzc());
        }
        zzkt.zzF(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    /*
     * Unable to fully structure code
     */
    final void zzt(zzfr var1_2, Object var2_3) {
        block9: {
            Preconditions.checkNotNull((Object)var2_3);
            var1_2.zzg();
            var1_2.zze();
            var1_2.zzd();
            var1_2.zzf();
            if (var2_3 instanceof String) {
                var1_2.zzk((String)var2_3);
                return;
            }
            if (var2_3 instanceof Long) {
                var1_2.zzi((Long)var2_3);
                return;
            }
            if (var2_3 instanceof Double) {
                var1_2.zzh((Double)var2_3);
                return;
            }
            if (!(var2_3 instanceof Bundle[])) break block9;
            var2_3 = var2_3;
            var3_4 = new ArrayList<zzfs>();
            block0: for (Bundle var5_6 : var2_3) {
                if (var5_6 == null) lbl-1000:
                // 3 sources

                {
                    continue block0;
                }
                var6_7 = zzfs.zze();
                block2: for (Object var8_9 : var5_6.keySet()) {
                    block10: {
                        var9_10 = zzfs.zze();
                        var9_10.zzj((String)var8_9);
                        var8_9 = var5_6.get((String)var8_9);
                        if (var8_9 instanceof Long) {
                            var9_10.zzi((Long)var8_9);
lbl39:
                            // 3 sources

                            while (true) {
                                var6_7.zzc(var9_10);
                                continue block2;
                                break;
                            }
                        }
                        if (!(var8_9 instanceof String)) break block10;
                        var9_10.zzk((String)var8_9);
                        ** GOTO lbl39
                    }
                    if (!(var8_9 instanceof Double)) continue;
                    var9_10.zzh((Double)var8_9);
                    ** continue;
                }
                if (var6_7.zza() <= 0) ** GOTO lbl-1000
                var3_4.add((zzfs)var6_7.zzay());
                ** continue;
            }
            var1_2.zzb(var3_4);
            return;
        }
        this.zzs.zzay().zzd().zzb("Ignoring invalid (type) event param value", (Object)var2_3);
    }

    final void zzu(zzgg zzgg2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zzgg2.zzc();
        zzgg2.zzb();
        zzgg2.zza();
        if (object instanceof String) {
            zzgg2.zzh((String)object);
            return;
        }
        if (object instanceof Long) {
            zzgg2.zze((Long)object);
            return;
        }
        if (object instanceof Double) {
            zzgg2.zzd((Double)object);
            return;
        }
        this.zzs.zzay().zzd().zzb("Ignoring invalid (type) user attribute value", object);
    }

    static boolean zzv(List list, int n) {
        return n < list.size() * 64 && ((Long)list.get(n / 64) & 1L << n % 64) != 0L;
    }

    final boolean zzw(long l, long l2) {
        return l == 0L || l2 <= 0L || Math.abs(this.zzs.zzav().currentTimeMillis() - l) > l2;
    }

    static boolean zzx(String string) {
        return string != null && string.matches("([+-])?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    @Override
    protected final boolean zzb() {
        return false;
    }

    final byte[] zzy(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzs.zzay().zzd().zzb("Failed to gzip content", (Object)iOException);
            throw iOException;
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    static final void zzz(zzfn zzfn2, String string, Object object) {
        int n;
        Object object2;
        block4: {
            object2 = zzfn2.zzp();
            for (n = 0; n < object2.size(); ++n) {
                if (!string.equals(((zzfs)((Object)object2.get(n))).zzg())) {
                    continue;
                }
                break block4;
            }
            n = -1;
        }
        object2 = zzfs.zze();
        ((zzfr)((Object)object2)).zzj(string);
        if (object instanceof Long) {
            ((zzfr)((Object)object2)).zzi((Long)object);
        }
        if (n >= 0) {
            zzfn2.zzj(n, (zzfr)((Object)object2));
            return;
        }
        zzfn2.zze((zzfr)((Object)object2));
    }

    private static final void zzF(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    @WorkerThread
    static final boolean zzA(zzau zzau2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzau2);
        Preconditions.checkNotNull((Object)zzp2);
        return !TextUtils.isEmpty((CharSequence)zzp2.zzb) || !TextUtils.isEmpty((CharSequence)zzp2.zzq);
    }

    static final zzfs zzB(zzfo object, String string) {
        for (zzfs zzfs2 : ((zzfo)((Object)object)).zzi()) {
            if (!zzfs2.zzg().equals(string)) continue;
            return zzfs2;
        }
        return null;
    }

    private static final String zzG(boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("Dynamic ");
        }
        if (bl2) {
            stringBuilder.append("Sequence ");
        }
        if (bl3) {
            stringBuilder.append("Session-Scoped ");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final void zzH(StringBuilder stringBuilder, int n, String iterator, zzgd object) {
        void var5_27;
        Object object2;
        Iterator iterator2;
        Object object3;
        if (object3 == null) {
            return;
        }
        zzkt.zzF(stringBuilder, 3);
        stringBuilder.append((String)((Object)iterator2));
        stringBuilder.append(" {\n");
        if (((zzgd)((Object)object3)).zzb() != 0) {
            zzkt.zzF(stringBuilder, 4);
            stringBuilder.append("results: ");
            iterator2 = ((zzgd)((Object)object3)).zzk().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_3;
                object2 = (Long)iterator2.next();
                var5_27 = var1_3 + true;
                if (var1_3 != false) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object2);
                var1_3 = var5_27;
            }
            stringBuilder.append('\n');
        }
        if (((zzgd)((Object)object3)).zzd() != 0) {
            zzkt.zzF(stringBuilder, 4);
            stringBuilder.append("status: ");
            iterator2 = ((zzgd)((Object)object3)).zzn().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_5;
                object2 = (Long)iterator2.next();
                var5_27 = var1_5 + true;
                if (var1_5 != false) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object2);
                var1_5 = var5_27;
            }
            stringBuilder.append('\n');
        }
        if (((zzgd)((Object)object3)).zza() != 0) {
            zzkt.zzF(stringBuilder, 4);
            stringBuilder.append("dynamic_filter_timestamps: {");
            iterator2 = ((zzgd)((Object)object3)).zzj().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_11;
                void var1_9;
                void var1_7;
                object2 = (zzfm)((Object)iterator2.next());
                var5_27 = var1_7 + true;
                if (var1_7 != false) {
                    stringBuilder.append(", ");
                }
                if (((zzfm)((Object)object2)).zzh()) {
                    Integer n2 = ((zzfm)((Object)object2)).zza();
                } else {
                    Object var1_14 = null;
                }
                stringBuilder.append(var1_9);
                stringBuilder.append(":");
                if (((zzfm)((Object)object2)).zzg()) {
                    Long l = ((zzfm)((Object)object2)).zzb();
                } else {
                    Object var1_13 = null;
                }
                stringBuilder.append(var1_11);
                void var1_12 = var5_27;
            }
            stringBuilder.append("}\n");
        }
        if (((zzgd)((Object)object3)).zzc() != 0) {
            zzkt.zzF(stringBuilder, 4);
            stringBuilder.append("sequence_filter_timestamps: {");
            iterator2 = ((zzgd)((Object)object3)).zzm().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                void var1_18;
                void var1_16;
                object3 = (zzgf)((Object)iterator2.next());
                void var4_26 = var1_16 + true;
                if (var1_16 != false) {
                    stringBuilder.append(", ");
                }
                if (((zzgf)((Object)object3)).zzi()) {
                    Integer n3 = ((zzgf)((Object)object3)).zzb();
                } else {
                    Object var1_22 = null;
                }
                stringBuilder.append(var1_18);
                stringBuilder.append(": [");
                object3 = ((zzgf)((Object)object3)).zzf().iterator();
                boolean bl2 = false;
                while (object3.hasNext()) {
                    void var1_20;
                    long l = (Long)object3.next();
                    var5_27 = var1_20 + true;
                    if (var1_20 != false) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(l);
                    var1_20 = var5_27;
                }
                stringBuilder.append("]");
                void var1_21 = var4_26;
            }
            stringBuilder.append("}\n");
        }
        zzkt.zzF(stringBuilder, 3);
        stringBuilder.append("}\n");
    }

    private static final void zzI(StringBuilder stringBuilder, int n, String string, Object object) {
        if (object == null) {
            return;
        }
        zzkt.zzF(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    static final Object zzC(zzfo object, String arrayList) {
        if ((object = zzkt.zzB((zzfo)((Object)object), (String)((Object)arrayList))) != null) {
            if (((zzfs)((Object)object)).zzy()) {
                return ((zzfs)((Object)object)).zzh();
            }
            if (((zzfs)((Object)object)).zzw()) {
                return ((zzfs)((Object)object)).zzd();
            }
            if (((zzfs)((Object)object)).zzu()) {
                return ((zzfs)((Object)object)).zza();
            }
            if (((zzfs)((Object)object)).zzc() > 0) {
                object = ((zzfs)((Object)object)).zzi();
                arrayList = new ArrayList<Bundle>();
                object = object.iterator();
                while (object.hasNext()) {
                    Object object2 = (zzfs)((Object)object.next());
                    if (object2 == null) continue;
                    Bundle bundle = new Bundle();
                    for (zzfs zzfs2 : object2.zzi()) {
                        if (zzfs2.zzy()) {
                            bundle.putString(zzfs2.zzg(), zzfs2.zzh());
                            continue;
                        }
                        if (zzfs2.zzw()) {
                            bundle.putLong(zzfs2.zzg(), zzfs2.zzd());
                            continue;
                        }
                        if (!zzfs2.zzu()) continue;
                        bundle.putDouble(zzfs2.zzg(), zzfs2.zza());
                    }
                    if (bundle.isEmpty()) continue;
                    arrayList.add(bundle);
                }
                return arrayList.toArray(new Bundle[arrayList.size()]);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void zzJ(StringBuilder stringBuilder, int n, String string, zzeq zzeq2) {
        if (zzeq2 == null) {
            return;
        }
        zzkt.zzF(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzeq2.zzg()) {
            switch (zzeq2.zzm()) {
                default: {
                    string = "BETWEEN";
                    break;
                }
                case 1: {
                    string = "UNKNOWN_COMPARISON_TYPE";
                    break;
                }
                case 4: {
                    string = "EQUAL";
                    break;
                }
                case 3: {
                    string = "GREATER_THAN";
                    break;
                }
                case 2: {
                    string = "LESS_THAN";
                }
            }
            zzkt.zzI(stringBuilder, n, "comparison_type", string);
        }
        if (zzeq2.zzi()) {
            zzkt.zzI(stringBuilder, n, "match_as_float", zzeq2.zzf());
        }
        if (zzeq2.zzh()) {
            zzkt.zzI(stringBuilder, n, "comparison_value", zzeq2.zzc());
        }
        if (zzeq2.zzk()) {
            zzkt.zzI(stringBuilder, n, "min_comparison_value", zzeq2.zze());
        }
        if (zzeq2.zzj()) {
            zzkt.zzI(stringBuilder, n, "max_comparison_value", zzeq2.zzd());
        }
        zzkt.zzF(stringBuilder, n);
        stringBuilder.append("}\n");
    }
}

