/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.measurement.zzbs;
import com.google.android.gms.internal.measurement.zzbt;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzeb;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzkk;
import com.google.android.gms.measurement.internal.zzkn;
import com.google.android.gms.measurement.internal.zzkz;
import com.google.android.gms.measurement.internal.zzlh;

public final class zzkl
extends zzkn {
    private final AlarmManager zza;
    private zzap zzb;
    private Integer zzc;

    private final int zzf() {
        if (this.zzc == null) {
            this.zzc = "measurement".concat(String.valueOf(this.zzs.zzau().getPackageName())).hashCode();
        }
        return this.zzc;
    }

    private final PendingIntent zzh() {
        zzkl zzkl2 = zzkl2.zzs.zzau();
        Intent intent = new Intent();
        return PendingIntent.getBroadcast((Context)zzkl2, (int)0, (Intent)intent.setClassName((Context)zzkl2, "com.google.android.gms.measurement.AppMeasurementReceiver").setAction("com.google.android.gms.measurement.UPLOAD"), (int)zzbs.zza);
    }

    private final zzap zzi() {
        if (this.zzb == null) {
            zzkk zzkk2 = new zzkk(this, (zzgt)this.zzf.zzq());
            this.zzb = zzkk2;
        }
        return this.zzb;
    }

    protected zzkl(zzkz zzkz2) {
        super(zzkz2);
        this.zza = (AlarmManager)this.zzs.zzau().getSystemService("alarm");
    }

    public final void zza() {
        this.zzW();
        this.zzs.zzay().zzj().zza("Unscheduling upload");
        AlarmManager alarmManager = this.zza;
        if (alarmManager != null) {
            alarmManager.cancel(this.zzh());
        }
        this.zzi().zzb();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzj();
            return;
        }
    }

    @TargetApi(value=24)
    private final void zzj() {
        JobScheduler jobScheduler = (JobScheduler)this.zzs.zzau().getSystemService("jobscheduler");
        if (jobScheduler != null) {
            jobScheduler.cancel(this.zzf());
            return;
        }
    }

    public final void zzd(long l) {
        this.zzW();
        this.zzs.zzaw();
        Context context = this.zzs.zzau();
        if (!zzlh.zzaj((Context)context)) {
            this.zzs.zzay().zzc().zza("Receiver not registered/enabled");
        }
        if (!zzlh.zzak((Context)context, (boolean)false)) {
            this.zzs.zzay().zzc().zza("Service not registered/enabled");
        }
        this.zza();
        this.zzs.zzay().zzj().zzb("Scheduling upload, millis", (Object)l);
        long l2 = this.zzs.zzav().elapsedRealtime() + l;
        this.zzs.zzf();
        if (l < Math.max(0L, (Long)zzeb.zzw.zza(null)) && !this.zzi().zze()) {
            this.zzi().zzd(l);
        }
        this.zzs.zzaw();
        if (Build.VERSION.SDK_INT >= 24) {
            context = this.zzs.zzau();
            ComponentName componentName = new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementJobService");
            int n = this.zzf();
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            JobInfo.Builder builder = new JobInfo.Builder(n, componentName);
            zzbt.zza(context, builder.setMinimumLatency(l).setOverrideDeadline(l + l).setExtras(persistableBundle).build(), "com.google.android.gms", "UploadAlarm");
            return;
        }
        context = this.zza;
        if (context != null) {
            this.zzs.zzf();
            context.setInexactRepeating(2, l2, Math.max((Long)zzeb.zzr.zza(null), l), this.zzh());
            return;
        }
    }

    @Override
    protected final boolean zzb() {
        AlarmManager alarmManager = this.zza;
        if (alarmManager != null) {
            alarmManager.cancel(this.zzh());
        }
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzj();
        }
        return false;
    }
}

