/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.internal.measurement.zzb;
import com.google.android.gms.internal.measurement.zzc;
import com.google.android.gms.internal.measurement.zzql;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzbg;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzhi;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzhk;
import com.google.android.gms.measurement.internal.zzhl;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzhn;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzhp;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzhr;
import com.google.android.gms.measurement.internal.zzhs;
import com.google.android.gms.measurement.internal.zzht;
import com.google.android.gms.measurement.internal.zzhu;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzhw;
import com.google.android.gms.measurement.internal.zzhx;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzhz;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zzmi;
import com.google.android.gms.measurement.internal.zzml;
import com.google.android.gms.measurement.internal.zzmq;
import com.google.android.gms.measurement.internal.zzmz;
import com.google.android.gms.measurement.internal.zzna;
import com.google.android.gms.measurement.internal.zznb;
import com.google.android.gms.measurement.internal.zzne;
import com.google.android.gms.measurement.internal.zzo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzhg
extends zzfk {
    private final zzmq zza;
    private Boolean zzb;
    private @Nullable String zzc;

    @BinderThread
    public final zzam zza(zzo zzo2) {
        this.zzb(zzo2, false);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        if (zzql.zzb()) {
            Future future = this.zza.zzl().zzb((Callable)new zzhv(this, zzo2));
            try {
                return (zzam)future.get(10000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                this.zza.zzj().zzg().zza("Failed to get consent. appId", zzfs.zza((String)zzo2.zza), (Object)exception);
                return new zzam(null);
            }
        }
        return new zzam(null);
    }

    @VisibleForTesting
    final zzbg zzb(zzbg zzbg2, zzo zzo2) {
        String string;
        zzbg zzbg3 = zzbg2;
        if (!"_cmp".equals(zzbg3.zza) || zzbg3.zzb == null || zzbg3.zzb.zza() == 0 ? false : "referrer broadcast".equals(string = zzbg3.zzb.zzd("_cis")) || "referrer API".equals(string)) {
            this.zza.zzj().zzn().zza("Event has been filtered ", (Object)zzbg2.toString());
            return new zzbg("_cmpx", zzbg2.zzb, zzbg2.zzc, zzbg2.zzd);
        }
        return zzbg2;
    }

    static /* bridge */ /* synthetic */ zzmq zza(zzhg zzhg2) {
        return zzhg2.zza;
    }

    @BinderThread
    public final @Nullable String zzb(zzo zzo2) {
        this.zzb(zzo2, false);
        return this.zza.zzb(zzo2);
    }

    @BinderThread
    public final List<zzmi> zza(zzo zzo2, Bundle bundle) {
        this.zzb(zzo2, false);
        Preconditions.checkNotNull((Object)zzo2.zza);
        Future future = this.zza.zzl().zza((Callable)new zzhy(this, zzo2, bundle));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get trigger URIs. appId", zzfs.zza((String)zzo2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final @Nullable List<zzmz> zza(zzo zzo2, boolean bl) {
        this.zzb(zzo2, false);
        String string = zzo2.zza;
        Preconditions.checkNotNull((Object)string);
        Future future = this.zza.zzl().zza((Callable)new zzib(this, string));
        try {
            List list = (List)future.get();
            ArrayList<zzmz> arrayList = new ArrayList<zzmz>(list.size());
            for (zznb zznb2 : list) {
                if (!bl && zzne.zzg((String)zznb2.zzc)) continue;
                arrayList.add(new zzmz(zznb2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get user properties. appId", zzfs.zza((String)zzo2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final List<zzad> zza(@Nullable String string, @Nullable String string2, zzo zzo2) {
        this.zzb(zzo2, false);
        String string3 = zzo2.zza;
        Preconditions.checkNotNull((Object)string3);
        Future future = this.zza.zzl().zza((Callable)new zzhr(this, string3, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzad> zza(String string, @Nullable String string2, @Nullable String string3) {
        this.zza(string, true);
        Future future = this.zza.zzl().zza((Callable)new zzhq(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzmz> zza(@Nullable String string, @Nullable String string2, boolean bl, zzo zzo2) {
        this.zzb(zzo2, false);
        String string3 = zzo2.zza;
        Preconditions.checkNotNull((Object)string3);
        Future future = this.zza.zzl().zza((Callable)new zzhp(this, string3, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzmz> arrayList = new ArrayList<zzmz>(list.size());
            for (zznb zznb2 : list) {
                if (!bl && zzne.zzg((String)zznb2.zzc)) continue;
                arrayList.add(new zzmz(zznb2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to query user properties. appId", zzfs.zza((String)zzo2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzmz> zza(String string, @Nullable String string2, @Nullable String string3, boolean bl) {
        this.zza(string, true);
        Future future = this.zza.zzl().zza((Callable)new zzho(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzmz> arrayList = new ArrayList<zzmz>(list.size());
            for (zznb zznb2 : list) {
                if (!bl && zzne.zzg((String)zznb2.zzc)) continue;
                arrayList.add(new zzmz(zznb2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get user properties as. appId", zzfs.zza((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    public zzhg(zzmq zzmq2) {
        this(zzmq2, null);
    }

    private zzhg(zzmq zzmq2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzmq2);
        this.zza = zzmq2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzc(zzo zzo2) {
        this.zzb(zzo2, false);
        this.zza(new zzhl(this, zzo2));
    }

    @BinderThread
    private final void zzb(zzo zzo2, boolean bl) {
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        this.zza(zzo2.zza, false);
        this.zza.zzq().zza(zzo2.zzb, zzo2.zzp);
    }

    @BinderThread
    private final void zza(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zza.zzj().zzg().zza("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzhg zzhg2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzhg2 = this;
                    if (!bl2) break block9;
                    if (zzhg2.zzb == null) {
                        zzhg2.zzb = "com.google.android.gms".equals(zzhg2.zzc) || UidVerifier.isGooglePlayServicesUid((Context)zzhg2.zza.zza(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzhg2.zza.zza()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzhg2.zzb.booleanValue()) break block10;
                }
                if (zzhg2.zzc == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzhg2.zza.zza(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzhg2.zzc = string2;
                }
                if (!string2.equals(zzhg2.zzc)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zza.zzj().zzg().zza("Measurement Service called with invalid calling package. appId", zzfs.zza((String)string));
            throw securityException;
        }
    }

    final void zzc(zzbg zzbg2, zzo zzo2) {
        if (!this.zza.zzi().zzl(zzo2.zza)) {
            this.zzd(zzbg2, zzo2);
            return;
        }
        this.zza.zzj().zzp().zza("EES config found for", (Object)zzo2.zza);
        String string = zzo2.zza;
        zzml zzml2 = this.zza.zzi();
        zzb zzb2 = TextUtils.isEmpty((CharSequence)string) ? null : (zzb)((zzgp)zzml2).zza.get((Object)string);
        if (zzb2 == null) {
            this.zza.zzj().zzp().zza("EES not loaded for", (Object)zzo2.zza);
            this.zzd(zzbg2, zzo2);
            return;
        }
        boolean bl = false;
        try {
            string = zzbg2;
            zzml2 = this.zza.zzp();
            Bundle bundle = ((zzbg)string).zzb.zzb();
            Map<String, Object> map = ((zzna)zzml2).zza(bundle, true);
            String string2 = zzii.zza((String)((zzbg)string).zza);
            if (string2 == null) {
                string2 = ((zzbg)string).zza;
            }
            bl = zzb2.zza(new com.google.android.gms.internal.measurement.zzad(string2, ((zzbg)string).zzd, map));
        }
        catch (zzc zzc2) {
            this.zza.zzj().zzg().zza("EES error. appId, eventName", (Object)zzo2.zzb, (Object)zzbg2.zza);
        }
        if (!bl) {
            this.zza.zzj().zzp().zza("EES was not applied to event", (Object)zzbg2.zza);
            this.zzd(zzbg2, zzo2);
            return;
        }
        if (zzb2.zzd()) {
            this.zza.zzj().zzp().zza("EES edited event", (Object)zzbg2.zza);
            this.zzd(this.zza.zzp().zza(zzb2.zza().zzb()), zzo2);
        } else {
            this.zzd(zzbg2, zzo2);
        }
        if (zzb2.zzc()) {
            for (com.google.android.gms.internal.measurement.zzad zzad2 : zzb2.zza().zzc()) {
                this.zza.zzj().zzp().zza("EES logging created event", (Object)zzad2.zzb());
                this.zzd(this.zza.zzp().zza(zzad2), zzo2);
            }
        }
    }

    final /* synthetic */ void zza(String string, Bundle bundle) {
        this.zza.zzf().zza(string, bundle);
    }

    @BinderThread
    public final void zza(zzbg zzbg2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzbg2);
        this.zzb(zzo2, false);
        this.zza(new zzhu(this, zzbg2, zzo2));
    }

    @BinderThread
    public final void zza(zzbg zzbg2, String string, @Nullable String string2) {
        Preconditions.checkNotNull((Object)zzbg2);
        Preconditions.checkNotEmpty((String)string);
        this.zza(string, true);
        this.zza(new zzhx(this, zzbg2, string));
    }

    private final void zzd(zzbg zzbg2, zzo zzo2) {
        this.zza.zzr();
        this.zza.zza(zzbg2, zzo2);
    }

    @BinderThread
    public final void zzd(zzo zzo2) {
        Preconditions.checkNotEmpty((String)zzo2.zza);
        this.zza(zzo2.zza, false);
        this.zza(new zzht(this, zzo2));
    }

    @VisibleForTesting
    private final void zza(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzl().zzg()) {
            runnable.run();
            return;
        }
        this.zza.zzl().zzb(runnable);
    }

    @BinderThread
    public final void zza(zzad zzad2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzad2);
        Preconditions.checkNotNull((Object)zzad2.zzc);
        this.zzb(zzo2, false);
        zzad zzad3 = new zzad(zzad2);
        new zzad(zzad2).zza = zzo2.zza;
        this.zza(new zzhn(this, zzad3, zzo2));
    }

    @BinderThread
    public final void zza(zzad zzad2) {
        Preconditions.checkNotNull((Object)zzad2);
        Preconditions.checkNotNull((Object)zzad2.zzc);
        Preconditions.checkNotEmpty((String)zzad2.zza);
        this.zza(zzad2.zza, true);
        zzad zzad3 = new zzad(zzad2);
        this.zza(new zzhm(this, zzad3));
    }

    @BinderThread
    public final void zze(zzo zzo2) {
        Preconditions.checkNotEmpty((String)zzo2.zza);
        Preconditions.checkNotNull((Object)zzo2.zzt);
        zzhs zzhs2 = new zzhs(this, zzo2);
        zzhg zzhg2 = this;
        Preconditions.checkNotNull((Object)zzhs2);
        if (zzhg2.zza.zzl().zzg()) {
            zzhs2.run();
            return;
        }
        zzhg2.zza.zzl().zzc((Runnable)zzhs2);
    }

    @BinderThread
    public final void zza(long l, @Nullable String string, @Nullable String string2, String string3) {
        this.zza(new zzhk(this, string2, string3, string, l));
    }

    @BinderThread
    public final void zza(Bundle bundle, zzo zzo2) {
        this.zzb(zzo2, false);
        String string = zzo2.zza;
        Preconditions.checkNotNull((Object)string);
        Bundle bundle2 = bundle;
        String string2 = string;
        zzhg zzhg2 = this;
        this.zza(new zzhj(zzhg2, string2, bundle2));
    }

    @BinderThread
    public final void zzf(zzo zzo2) {
        this.zzb(zzo2, false);
        this.zza(new zzhi(this, zzo2));
    }

    @BinderThread
    public final void zza(zzmz zzmz2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzmz2);
        this.zzb(zzo2, false);
        this.zza(new zzhz(this, zzmz2, zzo2));
    }

    @BinderThread
    public final byte @Nullable [] zza(zzbg zzbg2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzbg2);
        this.zza(string, true);
        this.zza.zzj().zzc().zza("Log and bundle. event", (Object)this.zza.zzg().zza(zzbg2.zza));
        long l = this.zza.zzb().nanoTime() / 1000000L;
        Future future = this.zza.zzl().zzb((Callable)new zzhw(this, zzbg2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zza.zzj().zzg().zza("Log and bundle returned null. appId", zzfs.zza((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zza.zzb().nanoTime() / 1000000L;
            this.zza.zzj().zzc().zza("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzg().zza(zzbg2.zza), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to log and bundle. appId, event, error", zzfs.zza((String)string), (Object)this.zza.zzg().zza(zzbg2.zza), (Object)exception);
            return null;
        }
    }
}

