/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.internal.measurement.zzad;
import com.google.android.gms.internal.measurement.zzev;
import com.google.android.gms.internal.measurement.zzfh;
import com.google.android.gms.internal.measurement.zzlj;
import com.google.android.gms.internal.measurement.zzlw;
import com.google.android.gms.internal.measurement.zzme;
import com.google.android.gms.internal.measurement.zzni;
import com.google.android.gms.internal.measurement.zzql;
import com.google.android.gms.internal.measurement.zzsg;
import com.google.android.gms.internal.measurement.zzss;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzaz;
import com.google.android.gms.measurement.internal.zzbb;
import com.google.android.gms.measurement.internal.zzbg;
import com.google.android.gms.measurement.internal.zzbi;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzie;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zzmi;
import com.google.android.gms.measurement.internal.zzml;
import com.google.android.gms.measurement.internal.zzmm;
import com.google.android.gms.measurement.internal.zzmq;
import com.google.android.gms.measurement.internal.zzne;
import com.google.android.gms.measurement.internal.zzo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzna
extends zzml {
    static int zza(zzfh.zzj.zza zza2, String string) {
        if (zza2 == null) {
            return -1;
        }
        for (int i = 0; i < zza2.zzb(); ++i) {
            if (!string.equals(zza2.zzj(i).zzg())) continue;
            return i;
        }
        return -1;
    }

    final long zza(@Nullable String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 0L;
        }
        return this.zza(string.getBytes(Charset.forName("UTF-8")));
    }

    @WorkerThread
    final long zza(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        this.zzq().zzt();
        MessageDigest messageDigest = zzne.zzu();
        if (messageDigest == null) {
            this.zzj().zzg().zza("Failed to get MD5");
            return 0L;
        }
        return zzne.zza((byte[])messageDigest.digest(byArray));
    }

    private final Bundle zza(Map<String, Object> map, boolean bl) {
        Bundle bundle = new Bundle();
        for (String string : map.keySet()) {
            Object object = map.get(string);
            if (object == null) {
                bundle.putString(string, null);
                continue;
            }
            if (object instanceof Long) {
                bundle.putLong(string, ((Long)object).longValue());
                continue;
            }
            if (object instanceof Double) {
                bundle.putDouble(string, ((Double)object).doubleValue());
                continue;
            }
            if (object instanceof ArrayList) {
                if (!bl) continue;
                ArrayList arrayList = (ArrayList)object;
                zzna zzna2 = this;
                ArrayList<Bundle> arrayList2 = new ArrayList<Bundle>();
                ArrayList arrayList3 = arrayList;
                int n = arrayList3.size();
                for (int i = 0; i < n; ++i) {
                    Object e = arrayList3.get(i);
                    Map map2 = (Map)e;
                    Bundle bundle2 = zzna2.zza(map2, false);
                    arrayList2.add(bundle2);
                }
                bundle.putParcelableArray(string, arrayList2.toArray(new Parcelable[0]));
                continue;
            }
            bundle.putString(string, object.toString());
        }
        return bundle;
    }

    final <T extends Parcelable> @Nullable T zza(byte[] byArray, Parcelable.Creator<T> creator) {
        if (byArray == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            Parcelable parcelable = (Parcelable)creator.createFromParcel(parcel);
            return (T)parcelable;
        }
        catch (SafeParcelReader.ParseException parseException) {
            this.zzj().zzg().zza("Failed to load parcelable from buffer");
            return null;
        }
        finally {
            parcel.recycle();
        }
    }

    final zzbg zza(zzad zzad2) {
        Object object;
        Bundle bundle = this.zza(zzad2.zzc(), true);
        String string = "app";
        if (bundle.containsKey("_o") && (object = bundle.get("_o")) != null) {
            string = object.toString();
        }
        if ((object = zzii.zzb((String)zzad2.zzb())) == null) {
            object = zzad2.zzb();
        }
        return new zzbg((String)object, new zzbb(bundle), string, zzad2.zza());
    }

    @TargetApi(value=30)
    final @Nullable zzmi zza(String string, zzfh.zzj zzj2, zzfh.zze.zza zza2, @Nullable String string2) {
        String string3;
        if (!zzsg.zzb() || !this.zze().zze(string, zzbi.zzcf)) {
            return null;
        }
        long l = this.zzb().currentTimeMillis();
        Object object = this.zze().zzd(string, zzbi.zzbb).split(",");
        Object object2 = new HashSet<String>(((String[])object).length);
        Bundle bundle = object;
        int n = ((String[])object).length;
        for (int i = 0; i < n; ++i) {
            String string4 = string3 = bundle[i];
            string4.getClass();
            if (((HashSet)object2).add(string4)) continue;
            throw new IllegalArgumentException("duplicate element: " + string3);
        }
        Set<String> set = Collections.unmodifiableSet(object2);
        object2 = string;
        object = ((zzmm)this).zzo();
        bundle = ((zzmm)((Object)object)).zzm().zzf((String)object2);
        Object object3 = new Uri.Builder();
        object3.scheme(object.zze().zzd((String)object2, zzbi.zzav));
        if (!TextUtils.isEmpty((CharSequence)bundle)) {
            string3 = object.zze().zzd((String)object2, zzbi.zzaw);
            Object object4 = bundle;
            object3.authority((String)object4 + "." + string3);
        } else {
            object3.authority(object.zze().zzd((String)object2, zzbi.zzaw));
        }
        object3.path(object.zze().zzd((String)object2, zzbi.zzax));
        Uri.Builder builder = object3;
        zzna.zza(builder, "gmp_app_id", zzj2.zzah(), set);
        zzna.zza(builder, "gmp_version", "81010", set);
        String string5 = zzj2.zzy();
        if (this.zze().zze(string, zzbi.zzci) && ((zzmm)this).zzm().zzp(string)) {
            string5 = "";
        }
        zzna.zza(builder, "app_instance_id", string5, set);
        zzna.zza(builder, "rdid", zzj2.zzal(), set);
        zzna.zza(builder, "bundle_id", zzj2.zzx(), set);
        String string6 = zza2.zze();
        String string7 = zzii.zza((String)string6);
        if (!TextUtils.isEmpty((CharSequence)string7)) {
            string6 = string7;
        }
        zzna.zza(builder, "app_event_name", string6, set);
        zzna.zza(builder, "app_version", String.valueOf(zzj2.zzb()), set);
        String string8 = zzj2.zzaj();
        if (this.zze().zze(string, zzbi.zzci) && ((zzmm)this).zzm().zzt(string)) {
            if (this.zze().zze(string, zzbi.zzbv)) {
                int n2;
                if (!TextUtils.isEmpty((CharSequence)string8) && (n2 = string8.indexOf(".")) != -1) {
                    string8 = string8.substring(0, n2);
                }
            } else {
                string8 = "";
            }
        }
        zzna.zza(builder, "os_version", string8, set);
        zzna.zza(builder, "timestamp", String.valueOf(zza2.zzc()), set);
        if (zzj2.zzat()) {
            zzna.zza(builder, "lat", "1", set);
        }
        zzna.zza(builder, "privacy_sandbox_version", String.valueOf(zzj2.zza()), set);
        zzna.zza(builder, "trigger_uri_source", "1", set);
        zzna.zza(builder, "trigger_uri_timestamp", String.valueOf(l), set);
        if (string2 != null) {
            zzna.zza(builder, "request_uuid", string2, set);
        }
        object = zza2.zzf();
        bundle = new Bundle();
        object3 = object.iterator();
        while (object3.hasNext()) {
            zzfh.zzg zzg2 = (zzfh.zzg)((Object)object3.next());
            string3 = zzg2.zzg();
            if (zzg2.zzj()) {
                bundle.putString(string3, String.valueOf(zzg2.zza()));
                continue;
            }
            if (zzg2.zzk()) {
                bundle.putString(string3, String.valueOf(zzg2.zzb()));
                continue;
            }
            if (zzg2.zzn()) {
                bundle.putString(string3, zzg2.zzh());
                continue;
            }
            if (!zzg2.zzl()) continue;
            bundle.putString(string3, String.valueOf(zzg2.zzd()));
        }
        Bundle bundle2 = bundle;
        String[] stringArray = this.zze().zzd(string, zzbi.zzba).split("\\|");
        zzna.zza(builder, stringArray, bundle2, set);
        object = zzj2.zzaq();
        bundle = new Bundle();
        object3 = object.iterator();
        while (object3.hasNext()) {
            zzfh.zzn zzn2 = (zzfh.zzn)((Object)object3.next());
            string3 = zzn2.zzg();
            if (zzn2.zzi()) {
                bundle.putString(string3, String.valueOf(zzn2.zza()));
                continue;
            }
            if (zzn2.zzj()) {
                bundle.putString(string3, String.valueOf(zzn2.zzb()));
                continue;
            }
            if (zzn2.zzm()) {
                bundle.putString(string3, zzn2.zzh());
                continue;
            }
            if (!zzn2.zzk()) continue;
            bundle.putString(string3, String.valueOf(zzn2.zzc()));
        }
        Bundle bundle3 = bundle;
        String[] stringArray2 = this.zze().zzd(string, zzbi.zzaz).split("\\|");
        zzna.zza(builder, stringArray2, bundle3, set);
        if (zzql.zzb() && this.zze().zza(zzbi.zzcm)) {
            zzna.zza(builder, "dma", zzj2.zzas() ? "1" : "0", set);
            if (!TextUtils.isEmpty((CharSequence)zzj2.zzad())) {
                zzna.zza(builder, "dma_cps", zzj2.zzad(), set);
            }
        }
        return new zzmi(builder.build().toString(), l, 1);
    }

    final zzfh.zze zza(zzaz zzaz2) {
        zzfh.zze.zza zza2 = zzfh.zze.zze().zza(zzaz2.zzd);
        for (String string : zzaz2.zze) {
            zzfh.zzg.zza zza3 = zzfh.zzg.zze().zza(string);
            Object object = zzaz2.zze.zzc(string);
            Preconditions.checkNotNull((Object)object);
            this.zza(zza3, object);
            zza2.zza(zza3);
        }
        return (zzfh.zze)((zzlw)zza2.zzab());
    }

    static @Nullable zzfh.zzg zza(zzfh.zze zze2, String string) {
        for (zzfh.zzg zzg2 : zze2.zzh()) {
            if (!zzg2.zzg().equals(string)) continue;
            return zzg2;
        }
        return null;
    }

    static <BuilderT extends zzni> BuilderT zza(BuilderT BuilderT, byte[] byArray) throws zzme {
        zzlj zzlj2 = zzlj.zza();
        if (zzlj2 != null) {
            return (BuilderT)BuilderT.zza(byArray, zzlj2);
        }
        return (BuilderT)BuilderT.zza(byArray);
    }

    static @Nullable Object zzb(zzfh.zze zze2, String string) {
        zzfh.zzg zzg2 = zzna.zza(zze2, string);
        if (zzg2 != null) {
            if (zzg2.zzn()) {
                return zzg2.zzh();
            }
            if (zzg2.zzl()) {
                return zzg2.zzd();
            }
            if (zzg2.zzj()) {
                return zzg2.zza();
            }
            if (zzg2.zzc() > 0) {
                List<zzfh.zzg> list = zzg2.zzi();
                ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
                for (zzfh.zzg zzg3 : list) {
                    if (zzg3 == null) continue;
                    Bundle bundle = new Bundle();
                    for (zzfh.zzg zzg4 : zzg3.zzi()) {
                        if (zzg4.zzn()) {
                            bundle.putString(zzg4.zzg(), zzg4.zzh());
                            continue;
                        }
                        if (zzg4.zzl()) {
                            bundle.putLong(zzg4.zzg(), zzg4.zzd());
                            continue;
                        }
                        if (!zzg4.zzj()) continue;
                        bundle.putDouble(zzg4.zzg(), zzg4.zza());
                    }
                    if (bundle.isEmpty()) continue;
                    arrayList.add(bundle);
                }
                return arrayList.toArray(new Bundle[arrayList.size()]);
            }
        }
        return null;
    }

    final String zza(zzfh.zzi zzi2) {
        if (zzi2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nbatch {\n");
        Iterator<zzfh.zzj> iterator = zzi2.zzd().iterator();
        while (iterator.hasNext()) {
            Object object;
            Iterator<zzfh.zzn> iterator2;
            StringBuilder stringBuilder2;
            int n;
            Object object2;
            zzfh.zzj zzj2;
            zzfh.zzj zzj3 = zzj2 = iterator.next();
            StringBuilder stringBuilder3 = stringBuilder;
            zzna zzna2 = this;
            if (zzj3 == null) continue;
            zzna.zza(stringBuilder3, 1);
            stringBuilder3.append("bundle {\n");
            if (zzj3.zzbk()) {
                zzna.zza(stringBuilder3, 1, "protocol_version", zzj3.zze());
            }
            if (zzss.zzb() && zzna2.zze().zze(zzj3.zzx(), zzbi.zzbt) && zzj3.zzbn()) {
                zzna.zza(stringBuilder3, 1, "session_stitching_token", zzj3.zzam());
            }
            zzna.zza(stringBuilder3, 1, "platform", zzj3.zzak());
            if (zzj3.zzbf()) {
                zzna.zza(stringBuilder3, 1, "gmp_version", zzj3.zzm());
            }
            if (zzj3.zzbs()) {
                zzna.zza(stringBuilder3, 1, "uploading_gmp_version", zzj3.zzs());
            }
            if (zzj3.zzbd()) {
                zzna.zza(stringBuilder3, 1, "dynamite_version", zzj3.zzk());
            }
            if (zzj3.zzay()) {
                zzna.zza(stringBuilder3, 1, "config_version", zzj3.zzi());
            }
            zzna.zza(stringBuilder3, 1, "gmp_app_id", zzj3.zzah());
            zzna.zza(stringBuilder3, 1, "admob_app_id", zzj3.zzw());
            zzna.zza(stringBuilder3, 1, "app_id", zzj3.zzx());
            zzna.zza(stringBuilder3, 1, "app_version", zzj3.zzaa());
            if (zzj3.zzav()) {
                zzna.zza(stringBuilder3, 1, "app_version_major", zzj3.zzb());
            }
            zzna.zza(stringBuilder3, 1, "firebase_instance_id", zzj3.zzag());
            if (zzj3.zzbc()) {
                zzna.zza(stringBuilder3, 1, "dev_cert_hash", zzj3.zzj());
            }
            zzna.zza(stringBuilder3, 1, "app_store", zzj3.zzz());
            if (zzj3.zzbr()) {
                zzna.zza(stringBuilder3, 1, "upload_timestamp_millis", zzj3.zzr());
            }
            if (zzj3.zzbo()) {
                zzna.zza(stringBuilder3, 1, "start_timestamp_millis", zzj3.zzp());
            }
            if (zzj3.zzbe()) {
                zzna.zza(stringBuilder3, 1, "end_timestamp_millis", zzj3.zzl());
            }
            if (zzj3.zzbj()) {
                zzna.zza(stringBuilder3, 1, "previous_bundle_start_timestamp_millis", zzj3.zzo());
            }
            if (zzj3.zzbi()) {
                zzna.zza(stringBuilder3, 1, "previous_bundle_end_timestamp_millis", zzj3.zzn());
            }
            zzna.zza(stringBuilder3, 1, "app_instance_id", zzj3.zzy());
            zzna.zza(stringBuilder3, 1, "resettable_device_id", zzj3.zzal());
            zzna.zza(stringBuilder3, 1, "ds_id", zzj3.zzaf());
            if (zzj3.zzbh()) {
                zzna.zza(stringBuilder3, 1, "limited_ad_tracking", zzj3.zzat());
            }
            zzna.zza(stringBuilder3, 1, "os_version", zzj3.zzaj());
            zzna.zza(stringBuilder3, 1, "device_model", zzj3.zzae());
            zzna.zza(stringBuilder3, 1, "user_default_language", zzj3.zzan());
            if (zzj3.zzbq()) {
                zzna.zza(stringBuilder3, 1, "time_zone_offset_minutes", zzj3.zzg());
            }
            if (zzj3.zzax()) {
                zzna.zza(stringBuilder3, 1, "bundle_sequential_index", zzj3.zzc());
            }
            if (zzj3.zzbm()) {
                zzna.zza(stringBuilder3, 1, "service_upload", zzj3.zzau());
            }
            zzna.zza(stringBuilder3, 1, "health_monitor", zzj3.zzai());
            if (zzj3.zzbl()) {
                zzna.zza(stringBuilder3, 1, "retry_counter", zzj3.zzf());
            }
            if (zzj3.zzba()) {
                zzna.zza(stringBuilder3, 1, "consent_signals", zzj3.zzac());
            }
            if (zzj3.zzbg()) {
                zzna.zza(stringBuilder3, 1, "is_dma_region", zzj3.zzas());
            }
            if (zzj3.zzbb()) {
                zzna.zza(stringBuilder3, 1, "core_platform_services", zzj3.zzad());
            }
            if (zzj3.zzaz()) {
                zzna.zza(stringBuilder3, 1, "consent_diagnostics", zzj3.zzab());
            }
            if (zzj3.zzbp()) {
                zzna.zza(stringBuilder3, 1, "target_os_version", zzj3.zzq());
            }
            if (zzsg.zzb() && zzna2.zze().zze(zzj3.zzx(), zzbi.zzcf)) {
                zzna.zza(stringBuilder3, 1, "ad_services_version", zzj3.zza());
                if (zzj3.zzaw()) {
                    object2 = zzj3.zzt();
                    n = 1;
                    stringBuilder2 = stringBuilder3;
                    if (object2 != null) {
                        ++n;
                        zzna.zza(stringBuilder2, 2);
                        stringBuilder2.append("attribution_eligibility_status {\n");
                        zzna.zza(stringBuilder2, 2, "eligible", ((zzfh.zzb)((Object)object2)).zzf());
                        zzna.zza(stringBuilder2, 2, "no_access_adservices_attribution_permission", ((zzfh.zzb)((Object)object2)).zzh());
                        zzna.zza(stringBuilder2, 2, "pre_r", ((zzfh.zzb)((Object)object2)).zzi());
                        zzna.zza(stringBuilder2, 2, "r_extensions_too_old", ((zzfh.zzb)((Object)object2)).zzj());
                        zzna.zza(stringBuilder2, 2, "adservices_extension_too_old", ((zzfh.zzb)((Object)object2)).zze());
                        zzna.zza(stringBuilder2, 2, "ad_storage_not_allowed", ((zzfh.zzb)((Object)object2)).zzd());
                        zzna.zza(stringBuilder2, 2, "measurement_manager_disabled", ((zzfh.zzb)((Object)object2)).zzg());
                        zzna.zza(stringBuilder2, 2);
                        stringBuilder2.append("}\n");
                    }
                }
            }
            object2 = zzj3.zzaq();
            n = 1;
            stringBuilder2 = stringBuilder3;
            zzna zzna3 = zzna2;
            if (object2 != null) {
                ++n;
                iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    object = iterator2.next();
                    if (object == null) continue;
                    zzna.zza(stringBuilder2, 2);
                    stringBuilder2.append("user_property {\n");
                    zzna.zza(stringBuilder2, 2, "set_timestamp_millis", object.zzl() ? Long.valueOf(object.zzd()) : null);
                    zzna.zza(stringBuilder2, 2, "name", zzna3.zzi().zzc(object.zzg()));
                    zzna.zza(stringBuilder2, 2, "string_value", object.zzh());
                    zzna.zza(stringBuilder2, 2, "int_value", object.zzk() ? Long.valueOf(object.zzc()) : null);
                    zzna.zza(stringBuilder2, 2, "double_value", object.zzi() ? Double.valueOf(object.zza()) : null);
                    zzna.zza(stringBuilder2, 2);
                    stringBuilder2.append("}\n");
                }
            }
            List<zzfh.zzc> list = zzj3.zzao();
            zzj3.zzx();
            object2 = list;
            n = 1;
            stringBuilder2 = stringBuilder3;
            if (object2 != null) {
                ++n;
                object = object2.iterator();
                while (object.hasNext()) {
                    zzfh.zzc zzc2 = (zzfh.zzc)((Object)object.next());
                    if (zzc2 == null) continue;
                    zzna.zza(stringBuilder2, 2);
                    stringBuilder2.append("audience_membership {\n");
                    if (zzc2.zzg()) {
                        zzna.zza(stringBuilder2, 2, "audience_id", zzc2.zza());
                    }
                    if (zzc2.zzh()) {
                        zzna.zza(stringBuilder2, 2, "new_audience", zzc2.zzf());
                    }
                    zzna.zza(stringBuilder2, 2, "current_data", zzc2.zzd());
                    if (zzc2.zzi()) {
                        zzna.zza(stringBuilder2, 2, "previous_data", zzc2.zze());
                    }
                    zzna.zza(stringBuilder2, 2);
                    stringBuilder2.append("}\n");
                }
            }
            object2 = zzj3.zzap();
            n = 1;
            stringBuilder2 = stringBuilder3;
            zzna3 = zzna2;
            if (object2 != null) {
                ++n;
                iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    object = (zzfh.zze)((Object)iterator2.next());
                    if (object == null) continue;
                    zzna.zza(stringBuilder2, 2);
                    stringBuilder2.append("event {\n");
                    zzna.zza(stringBuilder2, 2, "name", zzna3.zzi().zza(((zzfh.zze)((Object)object)).zzg()));
                    if (((zzfh.zze)((Object)object)).zzk()) {
                        zzna.zza(stringBuilder2, 2, "timestamp_millis", ((zzfh.zze)((Object)object)).zzd());
                    }
                    if (((zzfh.zze)((Object)object)).zzj()) {
                        zzna.zza(stringBuilder2, 2, "previous_timestamp_millis", ((zzfh.zze)((Object)object)).zzc());
                    }
                    if (((zzfh.zze)((Object)object)).zzi()) {
                        zzna.zza(stringBuilder2, 2, "count", ((zzfh.zze)((Object)object)).zza());
                    }
                    if (((zzfh.zze)((Object)object)).zzb() != 0) {
                        zzna3.zza(stringBuilder2, 2, ((zzfh.zze)((Object)object)).zzh());
                    }
                    zzna.zza(stringBuilder2, 2);
                    stringBuilder2.append("}\n");
                }
            }
            zzna.zza(stringBuilder3, 1);
            stringBuilder3.append("}\n");
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final String zza(zzev.zzb zzb2) {
        if (zzb2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        if (zzb2.zzl()) {
            zzna.zza(stringBuilder, 0, "filter_id", zzb2.zzb());
        }
        zzna.zza(stringBuilder, 0, "event_name", this.zzi().zza(zzb2.zzf()));
        String string = zzna.zza(zzb2.zzh(), zzb2.zzi(), zzb2.zzj());
        if (!string.isEmpty()) {
            zzna.zza(stringBuilder, 0, "filter_type", string);
        }
        if (zzb2.zzk()) {
            zzna.zza(stringBuilder, 1, "event_count_filter", zzb2.zze());
        }
        if (zzb2.zza() > 0) {
            stringBuilder.append("  filters {\n");
            for (zzev.zzc zzc2 : zzb2.zzg()) {
                this.zza(stringBuilder, 2, zzc2);
            }
        }
        zzna.zza(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    private static String zza(boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("Dynamic ");
        }
        if (bl2) {
            stringBuilder.append("Sequence ");
        }
        if (bl3) {
            stringBuilder.append("Session-Scoped ");
        }
        return stringBuilder.toString();
    }

    final String zza(zzev.zze zze2) {
        if (zze2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        if (zze2.zzi()) {
            zzna.zza(stringBuilder, 0, "filter_id", zze2.zza());
        }
        zzna.zza(stringBuilder, 0, "property_name", this.zzi().zzc(zze2.zze()));
        String string = zzna.zza(zze2.zzf(), zze2.zzg(), zze2.zzh());
        if (!string.isEmpty()) {
            zzna.zza(stringBuilder, 0, "filter_type", string);
        }
        this.zza(stringBuilder, 1, zze2.zzb());
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final List<Long> zza(List<Long> list, List<Integer> list2) {
        ArrayList<Long> arrayList = new ArrayList<Long>(list);
        for (Integer n : list2) {
            if (n < 0) {
                this.zzj().zzu().zza("Ignoring negative bit index to be cleared", (Object)n);
                continue;
            }
            int n2 = n / 64;
            if (n2 >= arrayList.size()) {
                this.zzj().zzu().zza("Ignoring bit index greater than bitSet size", (Object)n, (Object)arrayList.size());
                continue;
            }
            arrayList.set(n2, arrayList.get(n2) & (1L << n % 64 ^ 0xFFFFFFFFFFFFFFFFL));
        }
        int n = arrayList.size();
        int n3 = arrayList.size() - 1;
        while (n3 >= 0 && arrayList.get(n3) == 0L) {
            n = n3--;
        }
        return arrayList.subList(0, n);
    }

    final @Nullable List<Integer> zzu() {
        Map map = zzbi.zza((Context)this.zzf.zza());
        if (map == null || map.isEmpty()) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = (Integer)zzbi.zzap.zza(null);
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getKey()).startsWith("measurement.id.")) continue;
            try {
                int n2 = Integer.parseInt((String)entry.getValue());
                if (n2 == 0) continue;
                arrayList.add(n2);
                if (arrayList.size() < n) continue;
                this.zzj().zzu().zza("Too many experiment IDs. Number of IDs", (Object)arrayList.size());
                break;
            }
            catch (NumberFormatException numberFormatException) {
                this.zzj().zzu().zza("Experiment ID NumberFormatException", (Object)numberFormatException);
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    static List<Long> zza(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        for (int i = 0; i < n; ++i) {
            long l = 0L;
            for (int j = 0; j < 64 && (i << 6) + j < bitSet.length(); ++j) {
                if (!bitSet.get((i << 6) + j)) continue;
                l |= 1L << j;
            }
            arrayList.add(l);
        }
        return arrayList;
    }

    final Map<String, Object> zza(Bundle bundle, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string : bundle.keySet()) {
            Object object;
            Object object2 = object = bundle.get(string);
            if (object instanceof Parcelable[] || object2 instanceof ArrayList || object2 instanceof Bundle) {
                if (!bl) continue;
                Object object3 = object;
                object2 = this;
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                if (object3 instanceof Parcelable[]) {
                    for (Parcelable parcelable : (Parcelable[])object3) {
                        if (!(parcelable instanceof Bundle)) continue;
                        arrayList.add(((zzna)((Object)object2)).zza((Bundle)parcelable, false));
                    }
                } else if (object3 instanceof ArrayList) {
                    ArrayList arrayList2 = (ArrayList)object3;
                    int n = arrayList2.size();
                    for (int i = 0; i < n; ++i) {
                        Object e = arrayList2.get(i);
                        Object e2 = e;
                        if (!(e instanceof Bundle)) continue;
                        arrayList.add(((zzna)((Object)object2)).zza((Bundle)e2, false));
                    }
                } else if (object3 instanceof Bundle) {
                    arrayList.add(((zzna)((Object)object2)).zza((Bundle)object3, false));
                }
                hashMap.put(string, arrayList);
                continue;
            }
            if (object == null) continue;
            hashMap.put(string, object);
        }
        return hashMap;
    }

    zzna(zzmq zzmq2) {
        super(zzmq2);
    }

    static void zza(zzfh.zze.zza zza2, String string, Object object) {
        List<zzfh.zzg> list = zza2.zzf();
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(list.get(i).zzg())) continue;
            n = i;
            break;
        }
        zzfh.zzg.zza zza3 = zzfh.zzg.zze().zza(string);
        if (object instanceof Long) {
            zza3.zza((Long)object);
        } else if (object instanceof String) {
            zza3.zzb((String)object);
        } else if (object instanceof Double) {
            zza3.zza((Double)object);
        }
        if (n >= 0) {
            zza2.zza(n, zza3);
            return;
        }
        zza2.zza(zza3);
    }

    private static void zza(Uri.Builder builder, String[] stringArray, Bundle bundle, Set<String> set) {
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(",");
            String string = stringArray2[0];
            String string2 = stringArray2[stringArray2.length - 1];
            String string3 = bundle.getString(string);
            if (string3 == null) continue;
            zzna.zza(builder, string2, string3, set);
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzfh.zzl zzl2) {
        int n2;
        if (zzl2 == null) {
            return;
        }
        ++n;
        zzna.zza(stringBuilder, 3);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzl2.zzb() != 0) {
            zzna.zza(stringBuilder, 4);
            stringBuilder.append("results: ");
            n2 = 0;
            for (Long object : zzl2.zzi()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object);
            }
            stringBuilder.append('\n');
        }
        if (zzl2.zzd() != 0) {
            zzna.zza(stringBuilder, 4);
            stringBuilder.append("status: ");
            n2 = 0;
            for (Long l : zzl2.zzk()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        if (zzl2.zza() != 0) {
            zzna.zza(stringBuilder, 4);
            stringBuilder.append("dynamic_filter_timestamps: {");
            n2 = 0;
            for (zzfh.zzd zzd2 : zzl2.zzh()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(zzd2.zzf() ? Integer.valueOf(zzd2.zza()) : null).append(":").append(zzd2.zze() ? Long.valueOf(zzd2.zzb()) : null);
            }
            stringBuilder.append("}\n");
        }
        if (zzl2.zzc() != 0) {
            zzna.zza(stringBuilder, 4);
            stringBuilder.append("sequence_filter_timestamps: {");
            n2 = 0;
            for (zzfh.zzm zzm2 : zzl2.zzj()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(zzm2.zzf() ? Integer.valueOf(zzm2.zzb()) : null).append(": [");
                int n3 = 0;
                for (long l : zzm2.zze()) {
                    if (n3++ != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(l);
                }
                stringBuilder.append("]");
            }
            stringBuilder.append("}\n");
        }
        zzna.zza(stringBuilder, 3);
        stringBuilder.append("}\n");
    }

    private final void zza(StringBuilder stringBuilder, int n, List<zzfh.zzg> list) {
        if (list == null) {
            return;
        }
        ++n;
        for (zzfh.zzg zzg2 : list) {
            if (zzg2 == null) continue;
            zzna.zza(stringBuilder, n);
            stringBuilder.append("param {\n");
            zzna.zza(stringBuilder, n, "name", zzg2.zzm() ? this.zzi().zzb(zzg2.zzg()) : null);
            zzna.zza(stringBuilder, n, "string_value", zzg2.zzn() ? zzg2.zzh() : null);
            zzna.zza(stringBuilder, n, "int_value", zzg2.zzl() ? Long.valueOf(zzg2.zzd()) : null);
            zzna.zza(stringBuilder, n, "double_value", zzg2.zzj() ? Double.valueOf(zzg2.zza()) : null);
            if (zzg2.zzc() > 0) {
                this.zza(stringBuilder, n, zzg2.zzi());
            }
            zzna.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private final void zza(StringBuilder stringBuilder, int n, zzev.zzc zzc2) {
        if (zzc2 == null) {
            return;
        }
        zzna.zza(stringBuilder, n);
        stringBuilder.append("filter {\n");
        if (zzc2.zzg()) {
            zzna.zza(stringBuilder, n, "complement", zzc2.zzf());
        }
        if (zzc2.zzi()) {
            zzna.zza(stringBuilder, n, "param_name", this.zzi().zzb(zzc2.zze()));
        }
        if (zzc2.zzj()) {
            zzev.zzf zzf2 = zzc2.zzd();
            String string = "string_filter";
            int n2 = n + 1;
            StringBuilder stringBuilder2 = stringBuilder;
            if (zzf2 != null) {
                zzna.zza(stringBuilder2, n2);
                stringBuilder2.append(string);
                stringBuilder2.append(" {\n");
                if (zzf2.zzj()) {
                    zzna.zza(stringBuilder2, n2, "match_type", zzf2.zzb().name());
                }
                if (zzf2.zzi()) {
                    zzna.zza(stringBuilder2, n2, "expression", zzf2.zze());
                }
                if (zzf2.zzh()) {
                    zzna.zza(stringBuilder2, n2, "case_sensitive", zzf2.zzg());
                }
                if (zzf2.zza() > 0) {
                    zzna.zza(stringBuilder2, n2 + 1);
                    stringBuilder2.append("expression_list {\n");
                    for (String string2 : zzf2.zzf()) {
                        zzna.zza(stringBuilder2, n2 + 2);
                        stringBuilder2.append(string2);
                        stringBuilder2.append("\n");
                    }
                    stringBuilder2.append("}\n");
                }
                zzna.zza(stringBuilder2, n2);
                stringBuilder2.append("}\n");
            }
        }
        if (zzc2.zzh()) {
            zzna.zza(stringBuilder, n + 1, "number_filter", zzc2.zzc());
        }
        zzna.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzev.zzd zzd2) {
        if (zzd2 == null) {
            return;
        }
        zzna.zza(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzd2.zzh()) {
            zzna.zza(stringBuilder, n, "comparison_type", zzd2.zza().name());
        }
        if (zzd2.zzj()) {
            zzna.zza(stringBuilder, n, "match_as_float", zzd2.zzg());
        }
        if (zzd2.zzi()) {
            zzna.zza(stringBuilder, n, "comparison_value", zzd2.zzd());
        }
        if (zzd2.zzl()) {
            zzna.zza(stringBuilder, n, "min_comparison_value", zzd2.zzf());
        }
        if (zzd2.zzk()) {
            zzna.zza(stringBuilder, n, "max_comparison_value", zzd2.zze());
        }
        zzna.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(Uri.Builder builder, String string, String string2, Set<String> set) {
        if (set.contains(string) || TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        builder.appendQueryParameter(string, string2);
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, @Nullable Object object) {
        if (object == null) {
            return;
        }
        zzna.zza(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    final void zza(zzfh.zzj.zza zza2) {
        this.zzj().zzp().zza("Checking account type status for ad personalization signals");
        if (this.zzc(zza2.zzr())) {
            this.zzj().zzc().zza("Turning off ad personalization due to account type");
            zzfh.zzn zzn2 = (zzfh.zzn)((zzlw)zzfh.zzn.zze().zza("_npa").zzb(this.zzf().zzc()).zza(1L).zzab());
            boolean bl = false;
            for (int i = 0; i < zza2.zzb(); ++i) {
                if (!"_npa".equals(zza2.zzj(i).zzg())) continue;
                zza2.zza(i, zzn2);
                bl = true;
                break;
            }
            if (!bl) {
                zza2.zza(zzn2);
            }
            if (zzql.zzb() && this.zze().zza(zzbi.zzcm)) {
                zzak zzak2 = zzak.zza(zza2.zzs());
                zzak2.zza(zzie.zza.zzd, zzaj.zzg);
                zza2.zzf(zzak2.toString());
            }
        }
    }

    final void zza(zzfh.zzg.zza zza2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zza2.zze().zzc().zzb().zzd();
        if (object instanceof String) {
            zza2.zzb((String)object);
            return;
        }
        if (object instanceof Long) {
            zza2.zza((Long)object);
            return;
        }
        if (object instanceof Double) {
            zza2.zza((Double)object);
            return;
        }
        if (object instanceof Bundle[]) {
            Bundle[] bundleArray = (Bundle[])object;
            ArrayList<zzfh.zzg> arrayList = new ArrayList<zzfh.zzg>();
            Bundle[] bundleArray2 = bundleArray;
            int n = bundleArray.length;
            for (int i = 0; i < n; ++i) {
                Bundle bundle = bundleArray2[i];
                if (bundle == null) continue;
                zzfh.zzg.zza zza3 = zzfh.zzg.zze();
                for (String string : bundle.keySet()) {
                    zzfh.zzg.zza zza4 = zzfh.zzg.zze().zza(string);
                    Object object2 = bundle.get(string);
                    if (object2 instanceof Long) {
                        zza4.zza((Long)object2);
                    } else if (object2 instanceof String) {
                        zza4.zzb((String)object2);
                    } else {
                        if (!(object2 instanceof Double)) continue;
                        zza4.zza((Double)object2);
                    }
                    zza3.zza(zza4);
                }
                if (zza3.zza() <= 0) continue;
                arrayList.add((zzfh.zzg)((zzlw)zza3.zzab()));
            }
            zza2.zza(arrayList);
            return;
        }
        this.zzj().zzg().zza("Ignoring invalid (type) event param value", object);
    }

    final void zza(zzfh.zzn.zza zza2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zza2.zzc().zzb().zza();
        if (object instanceof String) {
            zza2.zzb((String)object);
            return;
        }
        if (object instanceof Long) {
            zza2.zza((Long)object);
            return;
        }
        if (object instanceof Double) {
            zza2.zza((Double)object);
            return;
        }
        this.zzj().zzg().zza("Ignoring invalid (type) user attribute value", object);
    }

    @WorkerThread
    static boolean zza(zzbg zzbg2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzbg2);
        Preconditions.checkNotNull((Object)zzo2);
        return !TextUtils.isEmpty((CharSequence)zzo2.zzb) || !TextUtils.isEmpty((CharSequence)zzo2.zzp);
    }

    static boolean zza(List<Long> list, int n) {
        return n < list.size() << 6 && (list.get(n / 64) & 1L << n % 64) != 0L;
    }

    final boolean zza(long l, long l2) {
        return l == 0L || l2 <= 0L || Math.abs(this.zzb().currentTimeMillis() - l) > l2;
    }

    static boolean zzb(String string) {
        return string != null && string.matches("([+-])?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    @Override
    protected final boolean zzc() {
        return false;
    }

    final boolean zzc(String string) {
        Preconditions.checkNotNull((Object)string);
        zzh zzh2 = ((zzmm)this).zzh().zzd(string);
        if (zzh2 == null) {
            return false;
        }
        return this.zzf().zzn() && zzh2.zzaj() && ((zzmm)this).zzm().zzk(string);
    }

    final byte[] zzb(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to gzip content", (Object)iOException);
            throw iOException;
        }
    }

    final byte[] zzc(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to ungzip content", (Object)iOException);
            throw iOException;
        }
    }
}

