/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzaf;
import com.google.android.gms.internal.measurement.zzag;
import com.google.android.gms.internal.measurement.zzai;
import com.google.android.gms.internal.measurement.zzao;
import com.google.android.gms.internal.measurement.zzap;
import com.google.android.gms.internal.measurement.zzaq;
import com.google.android.gms.internal.measurement.zzas;
import com.google.android.gms.internal.measurement.zzax;
import com.google.android.gms.internal.measurement.zzbv;
import com.google.android.gms.internal.measurement.zzh;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzg {
    public static double zza(double d) {
        if (Double.isNaN(d)) {
            return 0.0;
        }
        if (Double.isInfinite(d) || d == 0.0 || d == -0.0) {
            return d;
        }
        return (double)(d > 0.0 ? 1 : -1) * Math.floor(Math.abs(d));
    }

    public static int zzb(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d) || d == 0.0) {
            return 0;
        }
        return (int)((double)(d > 0.0 ? 1 : -1) * Math.floor(Math.abs(d)) % 4.294967296E9);
    }

    public static int zza(zzh zzh2) {
        int n = zzg.zzb(zzh2.zza("runtime.counter").zze() + 1.0);
        if (n > 1000000) {
            throw new IllegalStateException("Instructions allowed exceeded");
        }
        zzh2.zzc("runtime.counter", new zzai(Double.valueOf(n)));
        return n;
    }

    public static long zzc(double d) {
        return (long)zzg.zzb(d) & 0xFFFFFFFFL;
    }

    public static zzbv zza(@Nullable String string) {
        zzbv zzbv2 = null;
        if (string != null && !string.isEmpty()) {
            zzbv2 = zzbv.zza(Integer.parseInt(string));
        }
        if (zzbv2 == null) {
            throw new IllegalArgumentException(String.format("Unsupported commandId %s", string));
        }
        return zzbv2;
    }

    public static @Nullable Object zza(zzaq zzaq2) {
        if (zzaq.zzd.equals(zzaq2)) {
            return null;
        }
        if (zzaq.zzc.equals(zzaq2)) {
            return "";
        }
        if (zzaq2 instanceof zzap) {
            return zzg.zza((zzap)zzaq2);
        }
        if (zzaq2 instanceof zzaf) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator<zzaq> iterator = ((zzaf)zzaq2).iterator();
            while (iterator.hasNext()) {
                Object object = zzg.zza(iterator.next());
                if (object == null) continue;
                arrayList.add(object);
            }
            return arrayList;
        }
        if (!zzaq2.zze().isNaN()) {
            return zzaq2.zze();
        }
        return zzaq2.zzf();
    }

    public static Map<String, Object> zza(zzap zzap2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string : zzap2.zza()) {
            Object object = zzg.zza(zzap2.zza(string));
            if (object == null) continue;
            hashMap.put(string, object);
        }
        return hashMap;
    }

    public static void zza(zzbv zzbv2, int n, List<zzaq> list) {
        zzg.zza(zzbv2.name(), n, list);
    }

    public static void zza(String string, int n, List<zzaq> list) {
        if (list.size() != n) {
            throw new IllegalArgumentException(String.format("%s operation requires %s parameters found %s", string, n, list.size()));
        }
    }

    public static void zzb(zzbv zzbv2, int n, List<zzaq> list) {
        zzg.zzb(zzbv2.name(), n, list);
    }

    public static void zzb(String string, int n, List<zzaq> list) {
        if (list.size() < n) {
            throw new IllegalArgumentException(String.format("%s operation requires at least %s parameters found %s", string, n, list.size()));
        }
    }

    public static void zzc(String string, int n, List<zzaq> list) {
        if (list.size() > n) {
            throw new IllegalArgumentException(String.format("%s operation requires at most %s parameters found %s", string, n, list.size()));
        }
    }

    public static boolean zzb(zzaq zzaq2) {
        if (zzaq2 == null) {
            return false;
        }
        Double d = zzaq2.zze();
        return !d.isNaN() && d >= 0.0 && d.equals(Math.floor(d));
    }

    public static boolean zza(zzaq zzaq2, zzaq zzaq3) {
        if (!zzaq2.getClass().equals(zzaq3.getClass())) {
            return false;
        }
        if (zzaq2 instanceof zzax || zzaq2 instanceof zzao) {
            return true;
        }
        if (zzaq2 instanceof zzai) {
            if (Double.isNaN(zzaq2.zze()) || Double.isNaN(zzaq3.zze())) {
                return false;
            }
            return zzaq2.zze().equals(zzaq3.zze());
        }
        if (zzaq2 instanceof zzas) {
            return zzaq2.zzf().equals(zzaq3.zzf());
        }
        if (zzaq2 instanceof zzag) {
            return zzaq2.zzd().equals(zzaq3.zzd());
        }
        return zzaq2 == zzaq3;
    }
}

