/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import androidx.collection.LruCache;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzb;
import com.google.android.gms.internal.measurement.zzc;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzfc;
import com.google.android.gms.internal.measurement.zzfp;
import com.google.android.gms.internal.measurement.zzjf;
import com.google.android.gms.internal.measurement.zzjq;
import com.google.android.gms.internal.measurement.zzv;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzig;
import com.google.android.gms.measurement.internal.zzml;
import com.google.android.gms.measurement.internal.zzmo;
import com.google.android.gms.measurement.internal.zzmp;
import com.google.android.gms.measurement.internal.zzmz;
import com.google.android.gms.measurement.internal.zzng;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzgn
extends zzmo
implements zzai {
    private final Map<String, @Nullable Map<String, String>> zzc = new ArrayMap();
    @VisibleForTesting
    private final Map<String, @Nullable Set<String>> zzd = new ArrayMap();
    @VisibleForTesting
    private final Map<String, @Nullable Map<String, Boolean>> zze = new ArrayMap();
    @VisibleForTesting
    private final Map<String, @Nullable Map<String, Boolean>> zzg = new ArrayMap();
    private final Map<String, @Nullable zzfc.zzd> zzh = new ArrayMap();
    private final Map<String, @Nullable Map<String, Integer>> zzi;
    @VisibleForTesting
    final LruCache<String, zzb> zza;
    final zzv zzb;
    private final Map<String, @Nullable String> zzj = new ArrayMap();
    private final Map<String, @Nullable String> zzk = new ArrayMap();
    private final Map<String, @Nullable String> zzl = new ArrayMap();

    @WorkerThread
    final int zzb(String string, String string2) {
        this.zzt();
        this.zzv(string);
        Map<String, Integer> map = this.zzi.get(string);
        if (map != null) {
            Integer n = map.get(string2);
            if (n == null) {
                return 1;
            }
            return n;
        }
        return 1;
    }

    @WorkerThread
    final long zza(String string) {
        String string2 = this.zza(string, "measurement.account.time_zone_offset_minutes");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.zzj().zzu().zza("Unable to parse timezone offset. appId", zzfp.zza((String)string), (Object)numberFormatException);
            }
        }
        return 0L;
    }

    static /* synthetic */ zzb zza(zzgn zzgn2, String string) {
        String string2 = string;
        zzgn zzgn3 = zzgn2;
        zzgn3.zzak();
        Preconditions.checkNotEmpty((String)string2);
        if (!zzgn3.zzl(string2)) {
            return null;
        }
        if (zzgn3.zzh.containsKey(string2) && zzgn3.zzh.get(string2) != null) {
            zzgn3.zza(string2, zzgn3.zzh.get(string2));
        } else {
            zzgn3.zzv(string2);
        }
        return (zzb)zzgn3.zza.snapshot().get(string2);
    }

    @WorkerThread
    final // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable zzif.zza zza(String string, zzif.zza zza2) {
        this.zzt();
        this.zzv(string);
        zzfc.zza zza3 = this.zzb(string);
        if (zza3 == null) {
            return null;
        }
        for (zzfc.zza.zzc zzc2 : zza3.zze()) {
            zzif.zza zza4 = zzgn.zza(zzc2.zzc());
            if (zza2 != zza4) continue;
            return zzgn.zza(zzc2.zzb());
        }
        return null;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable zzif.zza zza(zzfc.zza.zze zze2) {
        switch (zze2) {
            case zzb: {
                return zzif.zza.zza;
            }
            case zzc: {
                return zzif.zza.zzb;
            }
            case zzd: {
                return zzif.zza.zzc;
            }
            case zze: {
                return zzif.zza.zzd;
            }
        }
        return null;
    }

    @WorkerThread
    final @Nullable zzfc.zza zzb(String string) {
        this.zzt();
        this.zzv(string);
        zzfc.zzd zzd2 = this.zzc(string);
        if (zzd2 == null || !zzd2.zzp()) {
            return null;
        }
        return zzd2.zzd();
    }

    @WorkerThread
    protected final @Nullable zzfc.zzd zzc(String string) {
        this.zzak();
        this.zzt();
        Preconditions.checkNotEmpty((String)string);
        this.zzv(string);
        return this.zzh.get(string);
    }

    @WorkerThread
    private final zzfc.zzd zza(String string, byte @Nullable [] byArray) {
        zzfc.zzd zzd2;
        if (byArray == null) {
            return zzfc.zzd.zzg();
        }
        try {
            zzd2 = (zzfc.zzd)((zzjf)zzmz.zza(zzfc.zzd.zze(), byArray).zzah());
            this.zzj().zzp().zza("Parsed config. version, gmp_app_id", (Object)(zzd2.zzs() ? Long.valueOf(zzd2.zzc()) : null), (Object)(zzd2.zzq() ? zzd2.zzi() : null));
        }
        catch (zzjq zzjq2) {
            this.zzj().zzu().zza("Unable to merge remote config. appId", zzfp.zza((String)string), (Object)zzjq2);
            return zzfc.zzd.zzg();
        }
        catch (RuntimeException runtimeException) {
            this.zzj().zzu().zza("Unable to merge remote config. appId", zzfp.zza((String)string), (Object)runtimeException);
            return zzfc.zzd.zzg();
        }
        return zzd2;
    }

    @WorkerThread
    public final @Nullable String zza(String string, String string2) {
        this.zzt();
        this.zzv(string);
        Map<String, String> map = this.zzc.get(string);
        if (map != null) {
            return map.get(string2);
        }
        return null;
    }

    @WorkerThread
    protected final @Nullable String zzd(String string) {
        this.zzt();
        return this.zzl.get(string);
    }

    @WorkerThread
    protected final @Nullable String zze(String string) {
        this.zzt();
        return this.zzk.get(string);
    }

    @WorkerThread
    final @Nullable String zzf(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzj.get(string);
    }

    static /* bridge */ /* synthetic */ Map zza(zzgn zzgn2) {
        return zzgn2.zzc;
    }

    private static Map<String, String> zza(zzfc.zzd zzd2) {
        ArrayMap arrayMap = new ArrayMap();
        if (zzd2 != null) {
            for (zzfc.zzg zzg2 : zzd2.zzn()) {
                arrayMap.put(zzg2.zzb(), zzg2.zzc());
            }
        }
        return arrayMap;
    }

    @WorkerThread
    final @Nullable Set<String> zzg(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzd.get(string);
    }

    @WorkerThread
    final SortedSet<String> zzh(String string) {
        this.zzt();
        this.zzv(string);
        TreeSet<String> treeSet = new TreeSet<String>();
        zzfc.zza zza2 = this.zzb(string);
        if (zza2 == null) {
            return treeSet;
        }
        for (zzfc.zza.zzf zzf2 : zza2.zzc()) {
            treeSet.add(zzf2.zzb());
        }
        return treeSet;
    }

    zzgn(zzmp zzmp2) {
        super(zzmp2);
        this.zzi = new ArrayMap();
        this.zza = new zzgt(this, 20);
        this.zzb = new zzgs(this);
    }

    @WorkerThread
    protected final void zzi(String string) {
        this.zzt();
        this.zzk.put(string, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void zza(String string, zzfc.zzd.zza zza2) {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayMap arrayMap = new ArrayMap();
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        if (zza2 != null) {
            for (zzfc.zzb zzkt2 : zza2.zze()) {
                hashSet.add(zzkt2.zzb());
            }
            for (int i = 0; i < zza2.zza(); ++i) {
                void var8_13;
                zzfc.zzc.zza zza3 = (zzfc.zzc.zza)zza2.zza(i).zzby();
                if (zza3.zzb().isEmpty()) {
                    this.zzj().zzu().zza("EventConfig contained null event name");
                    continue;
                }
                String string2 = zza3.zzb();
                String string3 = zzig.zzb((String)zza3.zzb());
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    zzfc.zzc.zza zza4 = zza3.zza(string3);
                    zza2.zza(i, zza4);
                }
                if (var8_13.zze() && var8_13.zzc()) {
                    arrayMap.put(string2, true);
                }
                if (var8_13.zzf() && var8_13.zzd()) {
                    arrayMap2.put(var8_13.zzb(), true);
                }
                if (!var8_13.zzg()) continue;
                if (var8_13.zza() < 2 || var8_13.zza() > 65535) {
                    this.zzj().zzu().zza("Invalid sampling rate. Event name, sample rate", (Object)var8_13.zzb(), (Object)var8_13.zza());
                    continue;
                }
                arrayMap3.put(var8_13.zzb(), var8_13.zza());
            }
        }
        this.zzd.put(string, hashSet);
        this.zze.put(string, (Map<String, Boolean>)arrayMap);
        this.zzg.put(string, (Map<String, Boolean>)arrayMap2);
        this.zzi.put(string, (Map<String, Integer>)arrayMap3);
    }

    @WorkerThread
    private final void zzv(String string) {
        this.zzak();
        this.zzt();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzh.get(string) == null) {
            zzan zzan2 = ((zzml)this).zzh().zze(string);
            if (zzan2 == null) {
                this.zzc.put(string, null);
                this.zze.put(string, null);
                this.zzd.put(string, null);
                this.zzg.put(string, null);
                this.zzh.put(string, null);
                this.zzj.put(string, null);
                this.zzk.put(string, null);
                this.zzl.put(string, null);
                this.zzi.put(string, null);
                return;
            }
            byte[] byArray = zzan2.zza;
            zzfc.zzd.zza zza2 = (zzfc.zzd.zza)this.zza(string, byArray).zzby();
            this.zza(string, zza2);
            this.zzc.put(string, zzgn.zza((zzfc.zzd)((zzjf)zza2.zzah())));
            this.zzh.put(string, (zzfc.zzd)((zzjf)zza2.zzah()));
            this.zza(string, (zzfc.zzd)((zzjf)zza2.zzah()));
            this.zzj.put(string, zza2.zzc());
            this.zzk.put(string, zzan2.zzb);
            this.zzl.put(string, zzan2.zzc);
        }
    }

    @WorkerThread
    private final void zza(String string, zzfc.zzd zzd2) {
        if (zzd2.zza() == 0) {
            this.zza.remove((Object)string);
            return;
        }
        this.zzj().zzp().zza("EES programs found", (Object)zzd2.zza());
        zzfp.zzc zzc2 = zzd2.zzm().get(0);
        try {
            zzb zzb2 = new zzb();
            String string2 = string;
            zzgn zzgn2 = this;
            zzb2.zza("internal.remoteConfig", new zzgo(zzgn2, string2));
            string2 = string;
            zzgn2 = this;
            zzb2.zza("internal.appMetadata", new zzgr(zzgn2, string2));
            zzgn2 = this;
            zzb2.zza("internal.logger", new zzgq(zzgn2));
            zzb2.zza(zzc2);
            this.zza.put((Object)string, (Object)zzb2);
            this.zzj().zzp().zza("EES program loaded for appId, activities", (Object)string, (Object)zzc2.zza().zza());
            for (zzfp.zzb zzb3 : zzc2.zza().zzd()) {
                this.zzj().zzp().zza("EES program activity", (Object)zzb3.zzb());
            }
            return;
        }
        catch (zzc zzc3) {
            this.zzj().zzg().zza("Failed to load EES program. appId", (Object)string);
            return;
        }
    }

    @WorkerThread
    final void zzj(String string) {
        this.zzt();
        this.zzh.remove(string);
    }

    @WorkerThread
    final boolean zzk(String string) {
        this.zzt();
        zzfc.zzd zzd2 = this.zzc(string);
        if (zzd2 == null) {
            return false;
        }
        return zzd2.zzo();
    }

    public final boolean zzl(@Nullable String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        zzfc.zzd zzd2 = this.zzh.get(string);
        if (zzd2 == null) {
            return false;
        }
        return zzd2.zza() != 0;
    }

    final boolean zzm(String string) {
        return "1".equals(this.zza(string, "measurement.upload.blacklist_internal"));
    }

    @WorkerThread
    final boolean zzb(String string, zzif.zza zza2) {
        this.zzt();
        this.zzv(string);
        zzfc.zza zza3 = this.zzb(string);
        if (zza3 == null) {
            return false;
        }
        for (zzfc.zza.zzb zzb2 : zza3.zzd()) {
            if (zza2 != zzgn.zza(zzb2.zzc())) continue;
            return zzb2.zzb() == zzfc.zza.zzd.zzb;
        }
        return false;
    }

    @WorkerThread
    final boolean zzn(String string) {
        this.zzt();
        this.zzv(string);
        zzfc.zza zza2 = this.zzb(string);
        if (zza2 == null) {
            return true;
        }
        return !zza2.zzg() || zza2.zzf();
    }

    @WorkerThread
    final boolean zzc(String string, String string2) {
        this.zzt();
        this.zzv(string);
        if ("ecommerce_purchase".equals(string2)) {
            return true;
        }
        if ("purchase".equals(string2) || "refund".equals(string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzg.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final boolean zzd(String string, String string2) {
        this.zzt();
        this.zzv(string);
        if (this.zzm(string) && zzng.zzg((String)string2)) {
            return true;
        }
        if (this.zzo(string) && zzng.zzh((String)string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zze.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @Override
    protected final boolean zzc() {
        return false;
    }

    final boolean zzo(String string) {
        return "1".equals(this.zza(string, "measurement.upload.blacklist_public"));
    }

    @WorkerThread
    protected final boolean zza(String string, byte @Nullable [] byArray, @Nullable String string2, @Nullable String string3) {
        this.zzak();
        this.zzt();
        Preconditions.checkNotEmpty((String)string);
        zzfc.zzd.zza zza2 = (zzfc.zzd.zza)this.zza(string, byArray).zzby();
        if (zza2 == null) {
            return false;
        }
        this.zza(string, zza2);
        this.zza(string, (zzfc.zzd)((zzjf)zza2.zzah()));
        this.zzh.put(string, (zzfc.zzd)((zzjf)zza2.zzah()));
        this.zzj.put(string, zza2.zzc());
        this.zzk.put(string, string2);
        this.zzl.put(string, string3);
        this.zzc.put(string, zzgn.zza((zzfc.zzd)((zzjf)zza2.zzah())));
        ((zzml)this).zzh().zza(string, new ArrayList<zzew.zza>(zza2.zzd()));
        try {
            zza2.zzb();
            byArray = ((zzfc.zzd)((zzjf)zza2.zzah())).zzbv();
        }
        catch (RuntimeException runtimeException) {
            this.zzj().zzu().zza("Unable to serialize reduced-size config. Storing full config instead. appId", zzfp.zza((String)string), (Object)runtimeException);
        }
        String string4 = string3;
        String string5 = string2;
        byte[] byArray2 = byArray;
        String string6 = string;
        zzal zzal2 = ((zzml)this).zzh();
        Preconditions.checkNotEmpty((String)string6);
        zzal2.zzt();
        zzal2.zzak();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", byArray2);
        contentValues.put("config_last_modified_time", string5);
        contentValues.put("e_tag", string4);
        try {
            if ((long)zzal2.e_().update("apps", contentValues, "app_id = ?", new String[]{string6}) == 0L) {
                zzal2.zzj().zzg().zza("Failed to update remote config (got 0). appId", zzfp.zza((String)string6));
            }
        }
        catch (SQLiteException sQLiteException) {
            zzal2.zzj().zzg().zza("Error storing remote config. appId", zzfp.zza((String)string6), (Object)sQLiteException);
        }
        this.zzh.put(string, (zzfc.zzd)((zzjf)zza2.zzah()));
        return true;
    }

    @WorkerThread
    final boolean zzp(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzd.get(string) != null && this.zzd.get(string).contains("app_instance_id");
    }

    @WorkerThread
    final boolean zzq(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzd.get(string) != null && (this.zzd.get(string).contains("device_model") || this.zzd.get(string).contains("device_info"));
    }

    @WorkerThread
    final boolean zzr(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzd.get(string) != null && this.zzd.get(string).contains("enhanced_user_id");
    }

    @WorkerThread
    final boolean zzs(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzd.get(string) != null && this.zzd.get(string).contains("google_signals");
    }

    @WorkerThread
    final boolean zzt(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzd.get(string) != null && (this.zzd.get(string).contains("os_version") || this.zzd.get(string).contains("device_info"));
    }

    @WorkerThread
    final boolean zzu(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzd.get(string) != null && this.zzd.get(string).contains("user_id");
    }
}

