/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.internal.measurement.zzad;
import com.google.android.gms.internal.measurement.zzff;
import com.google.android.gms.internal.measurement.zzfn;
import com.google.android.gms.internal.measurement.zzix;
import com.google.android.gms.internal.measurement.zzjk;
import com.google.android.gms.internal.measurement.zzjt;
import com.google.android.gms.internal.measurement.zzkt;
import com.google.android.gms.internal.measurement.zznn;
import com.google.android.gms.internal.measurement.zzpd;
import com.google.android.gms.internal.measurement.zzpi;
import com.google.android.gms.internal.measurement.zzpo;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzay;
import com.google.android.gms.measurement.internal.zzba;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zzir;
import com.google.android.gms.measurement.internal.zzmu;
import com.google.android.gms.measurement.internal.zzmy;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zznb;
import com.google.android.gms.measurement.internal.zznc;
import com.google.android.gms.measurement.internal.zznt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zznp
extends zznb {
    static int zza(zzfn.zzj.zza zza2, String string) {
        if (zza2 == null) {
            return -1;
        }
        for (int i = 0; i < zza2.zzd(); ++i) {
            if (!string.equals(zza2.zzk(i).zzg())) continue;
            return i;
        }
        return -1;
    }

    final long zza(@Nullable String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 0L;
        }
        return this.zza(string.getBytes(Charset.forName("UTF-8")));
    }

    @WorkerThread
    final long zza(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        this.zzq().zzt();
        MessageDigest messageDigest = zznt.zzu();
        if (messageDigest == null) {
            this.zzj().zzg().zza("Failed to get MD5");
            return 0L;
        }
        return zznt.zza((byte[])messageDigest.digest(byArray));
    }

    static Bundle zza(List<zzfn.zzg> list) {
        Bundle bundle = new Bundle();
        for (zzfn.zzg zzg2 : list) {
            String string = zzg2.zzg();
            if (zzg2.zzj()) {
                bundle.putDouble(string, zzg2.zza());
                continue;
            }
            if (zzg2.zzk()) {
                bundle.putFloat(string, zzg2.zzb());
                continue;
            }
            if (zzg2.zzn()) {
                bundle.putString(string, zzg2.zzh());
                continue;
            }
            if (!zzg2.zzl()) continue;
            bundle.putLong(string, zzg2.zzd());
        }
        return bundle;
    }

    private final Bundle zza(Map<String, Object> map, boolean bl) {
        Bundle bundle = new Bundle();
        for (String string : map.keySet()) {
            Object object = map.get(string);
            if (object == null) {
                bundle.putString(string, null);
                continue;
            }
            if (object instanceof Long) {
                bundle.putLong(string, ((Long)object).longValue());
                continue;
            }
            if (object instanceof Double) {
                bundle.putDouble(string, ((Double)object).doubleValue());
                continue;
            }
            if (object instanceof ArrayList) {
                if (!bl) continue;
                ArrayList arrayList = (ArrayList)object;
                zznp zznp2 = this;
                ArrayList<Bundle> arrayList2 = new ArrayList<Bundle>();
                ArrayList arrayList3 = arrayList;
                int n = arrayList3.size();
                for (int i = 0; i < n; ++i) {
                    Object e = arrayList3.get(i);
                    Map map2 = (Map)e;
                    Bundle bundle2 = zznp2.zza(map2, false);
                    arrayList2.add(bundle2);
                }
                bundle.putParcelableArray(string, arrayList2.toArray(new Parcelable[0]));
                continue;
            }
            bundle.putString(string, object.toString());
        }
        return bundle;
    }

    final <T extends Parcelable> @Nullable T zza(byte[] byArray, Parcelable.Creator<T> creator) {
        if (byArray == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            Parcelable parcelable = (Parcelable)creator.createFromParcel(parcel);
            return (T)parcelable;
        }
        catch (SafeParcelReader.ParseException parseException) {
            this.zzj().zzg().zza("Failed to load parcelable from buffer");
            return null;
        }
        finally {
            parcel.recycle();
        }
    }

    final zzbf zza(zzad zzad2) {
        Object object;
        Bundle bundle = this.zza(zzad2.zzc(), true);
        String string = "app";
        if (bundle.containsKey("_o") && (object = bundle.get("_o")) != null) {
            string = object.toString();
        }
        if ((object = zzir.zzb((String)zzad2.zzb())) == null) {
            object = zzad2.zzb();
        }
        return new zzbf((String)object, new zzba(bundle), string, zzad2.zza());
    }

    @TargetApi(value=30)
    final @Nullable zzmu zza(String string, zzfn.zzj.zza zza2, zzfn.zze.zza zza3, @Nullable String string2) {
        int n;
        String string3;
        if (!zzpd.zza() || !this.zze().zze(string, zzbh.zzcb)) {
            return null;
        }
        long l = this.zzb().currentTimeMillis();
        Object object = this.zze().zzd(string, zzbh.zzbe).split(",");
        Object object2 = new HashSet<String>(((String[])object).length);
        Bundle bundle = object;
        int n2 = ((String[])object).length;
        for (int i = 0; i < n2; ++i) {
            string3 = bundle[i];
            if (((HashSet)object2).add(Objects.requireNonNull(string3))) continue;
            throw new IllegalArgumentException("duplicate element: " + string3);
        }
        Set<String> set = Collections.unmodifiableSet(object2);
        object2 = string;
        object = ((zzmy)this).zzo();
        bundle = ((zzmy)((Object)object)).zzm().zzf((String)object2);
        Object object3 = new Uri.Builder();
        object3.scheme(object.zze().zzd((String)object2, zzbh.zzax));
        if (!TextUtils.isEmpty((CharSequence)bundle)) {
            string3 = object.zze().zzd((String)object2, zzbh.zzay);
            Object object4 = bundle;
            object3.authority((String)object4 + "." + string3);
        } else {
            object3.authority(object.zze().zzd((String)object2, zzbh.zzay));
        }
        object3.path(object.zze().zzd((String)object2, zzbh.zzaz));
        Uri.Builder builder = object3;
        zznp.zza(builder, "gmp_app_id", zza2.zzw(), set);
        zznp.zza(builder, "gmp_version", "95001", set);
        String string4 = zza2.zzt();
        if (this.zze().zze(string, zzbh.zzce) && ((zzmy)this).zzm().zzp(string)) {
            string4 = "";
        }
        zznp.zza(builder, "app_instance_id", string4, set);
        zznp.zza(builder, "rdid", zza2.zzy(), set);
        zznp.zza(builder, "bundle_id", zza2.zzs(), set);
        String string5 = zza3.zze();
        String string6 = zzir.zza((String)string5);
        if (!TextUtils.isEmpty((CharSequence)string6)) {
            string5 = string6;
        }
        zznp.zza(builder, "app_event_name", string5, set);
        zznp.zza(builder, "app_version", String.valueOf(zza2.zzb()), set);
        String string7 = zza2.zzx();
        if (this.zze().zze(string, zzbh.zzce) && ((zzmy)this).zzm().zzt(string) && !TextUtils.isEmpty((CharSequence)string7) && (n = string7.indexOf(".")) != -1) {
            string7 = string7.substring(0, n);
        }
        zznp.zza(builder, "os_version", string7, set);
        zznp.zza(builder, "timestamp", String.valueOf(zza3.zzc()), set);
        if (zza2.zzac()) {
            zznp.zza(builder, "lat", "1", set);
        }
        zznp.zza(builder, "privacy_sandbox_version", String.valueOf(zza2.zza()), set);
        zznp.zza(builder, "trigger_uri_source", "1", set);
        zznp.zza(builder, "trigger_uri_timestamp", String.valueOf(l), set);
        zznp.zza(builder, "request_uuid", string2, set);
        object = zza3.zzf();
        bundle = new Bundle();
        object3 = object.iterator();
        while (object3.hasNext()) {
            zzfn.zzg zzg2 = (zzfn.zzg)((Object)object3.next());
            string3 = zzg2.zzg();
            if (zzg2.zzj()) {
                bundle.putString(string3, String.valueOf(zzg2.zza()));
                continue;
            }
            if (zzg2.zzk()) {
                bundle.putString(string3, String.valueOf(zzg2.zzb()));
                continue;
            }
            if (zzg2.zzn()) {
                bundle.putString(string3, zzg2.zzh());
                continue;
            }
            if (!zzg2.zzl()) continue;
            bundle.putString(string3, String.valueOf(zzg2.zzd()));
        }
        Bundle bundle2 = bundle;
        String[] stringArray = this.zze().zzd(string, zzbh.zzbd).split("\\|");
        zznp.zza(builder, stringArray, bundle2, set);
        object = zza2.zzaa();
        bundle = new Bundle();
        object3 = object.iterator();
        while (object3.hasNext()) {
            zzfn.zzn zzn2 = (zzfn.zzn)((Object)object3.next());
            string3 = zzn2.zzg();
            if (zzn2.zzi()) {
                bundle.putString(string3, String.valueOf(zzn2.zza()));
                continue;
            }
            if (zzn2.zzj()) {
                bundle.putString(string3, String.valueOf(zzn2.zzb()));
                continue;
            }
            if (zzn2.zzm()) {
                bundle.putString(string3, zzn2.zzh());
                continue;
            }
            if (!zzn2.zzk()) continue;
            bundle.putString(string3, String.valueOf(zzn2.zzc()));
        }
        Bundle bundle3 = bundle;
        String[] stringArray2 = this.zze().zzd(string, zzbh.zzbc).split("\\|");
        zznp.zza(builder, stringArray2, bundle3, set);
        zznp.zza(builder, "dma", zza2.zzab() ? "1" : "0", set);
        if (!zza2.zzv().isEmpty()) {
            zznp.zza(builder, "dma_cps", zza2.zzv(), set);
        }
        return new zzmu(builder.build().toString(), l, 1);
    }

    final zzfn.zze zza(zzay zzay2) {
        zzfn.zze.zza zza2 = zzfn.zze.zze().zza(zzay2.zzd);
        for (String string : zzay2.zze) {
            zzfn.zzg.zza zza3 = zzfn.zzg.zze().zza(string);
            Object object = zzay2.zze.zzc(string);
            Preconditions.checkNotNull((Object)object);
            this.zza(zza3, object);
            zza2.zza(zza3);
        }
        return (zzfn.zze)((zzjk)zza2.zzag());
    }

    static @Nullable zzfn.zzg zza(zzfn.zze zze2, String string) {
        for (zzfn.zzg zzg2 : zze2.zzh()) {
            if (!zzg2.zzg().equals(string)) continue;
            return zzg2;
        }
        return null;
    }

    static <BuilderT extends zzkt> BuilderT zza(BuilderT BuilderT, byte[] byArray) throws zzjt {
        zzix zzix2 = zzix.zza();
        if (zzix2 != null) {
            return (BuilderT)BuilderT.zza(byArray, zzix2);
        }
        return (BuilderT)BuilderT.zza(byArray);
    }

    static @Nullable Object zzb(zzfn.zze zze2, String string) {
        zzfn.zzg zzg2 = zznp.zza(zze2, string);
        if (zzg2 != null) {
            if (zzg2.zzn()) {
                return zzg2.zzh();
            }
            if (zzg2.zzl()) {
                return zzg2.zzd();
            }
            if (zzg2.zzj()) {
                return zzg2.zza();
            }
            if (zzg2.zzc() > 0) {
                List<zzfn.zzg> list = zzg2.zzi();
                ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
                for (zzfn.zzg zzg3 : list) {
                    if (zzg3 == null) continue;
                    Bundle bundle = new Bundle();
                    for (zzfn.zzg zzg4 : zzg3.zzi()) {
                        if (zzg4.zzn()) {
                            bundle.putString(zzg4.zzg(), zzg4.zzh());
                            continue;
                        }
                        if (zzg4.zzl()) {
                            bundle.putLong(zzg4.zzg(), zzg4.zzd());
                            continue;
                        }
                        if (!zzg4.zzj()) continue;
                        bundle.putDouble(zzg4.zzg(), zzg4.zza());
                    }
                    if (bundle.isEmpty()) continue;
                    arrayList.add(bundle);
                }
                return arrayList.toArray(new Bundle[arrayList.size()]);
            }
        }
        return null;
    }

    final String zza(zzfn.zzi zzi2) {
        if (zzi2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nbatch {\n");
        if (zzpo.zza() && this.zze().zza(zzbh.zzbu) && zzi2.zza() > 0) {
            this.zzq();
            if (zznt.zzf((String)zzi2.zza(0).zzy()) && zzi2.zzf()) {
                zznp.zza(stringBuilder, 0, "UploadSubdomain", zzi2.zzd());
            }
        }
        Iterator<zzfn.zzj> iterator = zzi2.zze().iterator();
        while (iterator.hasNext()) {
            Object object;
            Iterator<zzfn.zzn> iterator2;
            StringBuilder stringBuilder2;
            int n;
            Object object2;
            zzfn.zzj zzj2;
            zzfn.zzj zzj3 = zzj2 = iterator.next();
            StringBuilder stringBuilder3 = stringBuilder;
            zznp zznp2 = this;
            if (zzj3 == null) continue;
            zznp.zza(stringBuilder3, 1);
            stringBuilder3.append("bundle {\n");
            if (zzj3.zzbm()) {
                zznp.zza(stringBuilder3, 1, "protocol_version", zzj3.zzf());
            }
            if (zzpi.zza() && zznp2.zze().zze(zzj3.zzy(), zzbh.zzbt) && zzj3.zzbp()) {
                zznp.zza(stringBuilder3, 1, "session_stitching_token", zzj3.zzan());
            }
            zznp.zza(stringBuilder3, 1, "platform", zzj3.zzal());
            if (zzj3.zzbh()) {
                zznp.zza(stringBuilder3, 1, "gmp_version", zzj3.zzn());
            }
            if (zzj3.zzbu()) {
                zznp.zza(stringBuilder3, 1, "uploading_gmp_version", zzj3.zzt());
            }
            if (zzj3.zzbf()) {
                zznp.zza(stringBuilder3, 1, "dynamite_version", zzj3.zzl());
            }
            if (zzj3.zzaz()) {
                zznp.zza(stringBuilder3, 1, "config_version", zzj3.zzj());
            }
            zznp.zza(stringBuilder3, 1, "gmp_app_id", zzj3.h_());
            zznp.zza(stringBuilder3, 1, "admob_app_id", zzj3.zzx());
            zznp.zza(stringBuilder3, 1, "app_id", zzj3.zzy());
            zznp.zza(stringBuilder3, 1, "app_version", zzj3.zzab());
            if (zzj3.zzaw()) {
                zznp.zza(stringBuilder3, 1, "app_version_major", zzj3.zzb());
            }
            zznp.zza(stringBuilder3, 1, "firebase_instance_id", zzj3.zzah());
            if (zzj3.zzbe()) {
                zznp.zza(stringBuilder3, 1, "dev_cert_hash", zzj3.zzk());
            }
            zznp.zza(stringBuilder3, 1, "app_store", zzj3.zzaa());
            if (zzj3.zzbt()) {
                zznp.zza(stringBuilder3, 1, "upload_timestamp_millis", zzj3.zzs());
            }
            if (zzj3.zzbq()) {
                zznp.zza(stringBuilder3, 1, "start_timestamp_millis", zzj3.zzq());
            }
            if (zzj3.zzbg()) {
                zznp.zza(stringBuilder3, 1, "end_timestamp_millis", zzj3.zzm());
            }
            if (zzj3.zzbl()) {
                zznp.zza(stringBuilder3, 1, "previous_bundle_start_timestamp_millis", zzj3.zzp());
            }
            if (zzj3.zzbk()) {
                zznp.zza(stringBuilder3, 1, "previous_bundle_end_timestamp_millis", zzj3.zzo());
            }
            zznp.zza(stringBuilder3, 1, "app_instance_id", zzj3.zzz());
            zznp.zza(stringBuilder3, 1, "resettable_device_id", zzj3.zzam());
            zznp.zza(stringBuilder3, 1, "ds_id", zzj3.zzag());
            if (zzj3.zzbj()) {
                zznp.zza(stringBuilder3, 1, "limited_ad_tracking", zzj3.zzau());
            }
            zznp.zza(stringBuilder3, 1, "os_version", zzj3.zzak());
            zznp.zza(stringBuilder3, 1, "device_model", zzj3.zzaf());
            zznp.zza(stringBuilder3, 1, "user_default_language", zzj3.zzao());
            if (zzj3.zzbs()) {
                zznp.zza(stringBuilder3, 1, "time_zone_offset_minutes", zzj3.zzh());
            }
            if (zzj3.zzay()) {
                zznp.zza(stringBuilder3, 1, "bundle_sequential_index", zzj3.zzc());
            }
            if (zzpo.zza()) {
                zznp2.zzq();
                if (zznt.zzf((String)zzj3.zzy()) && zznp2.zze().zza(zzbh.zzbu) && zzj3.zzbd()) {
                    zznp.zza(stringBuilder3, 1, "delivery_index", zzj3.zzd());
                }
            }
            if (zzj3.zzbo()) {
                zznp.zza(stringBuilder3, 1, "service_upload", zzj3.zzav());
            }
            zznp.zza(stringBuilder3, 1, "health_monitor", zzj3.zzaj());
            if (zzj3.zzbn()) {
                zznp.zza(stringBuilder3, 1, "retry_counter", zzj3.zzg());
            }
            if (zzj3.zzbb()) {
                zznp.zza(stringBuilder3, 1, "consent_signals", zzj3.zzad());
            }
            if (zzj3.zzbi()) {
                zznp.zza(stringBuilder3, 1, "is_dma_region", zzj3.zzat());
            }
            if (zzj3.zzbc()) {
                zznp.zza(stringBuilder3, 1, "core_platform_services", zzj3.zzae());
            }
            if (zzj3.zzba()) {
                zznp.zza(stringBuilder3, 1, "consent_diagnostics", zzj3.zzac());
            }
            if (zzj3.zzbr()) {
                zznp.zza(stringBuilder3, 1, "target_os_version", zzj3.zzr());
            }
            if (zzpd.zza() && zznp2.zze().zze(zzj3.zzy(), zzbh.zzcb)) {
                zznp.zza(stringBuilder3, 1, "ad_services_version", zzj3.zza());
                if (zzj3.zzax()) {
                    object2 = zzj3.zzu();
                    n = 1;
                    stringBuilder2 = stringBuilder3;
                    if (object2 != null) {
                        ++n;
                        zznp.zza(stringBuilder2, 2);
                        stringBuilder2.append("attribution_eligibility_status {\n");
                        zznp.zza(stringBuilder2, 2, "eligible", ((zzfn.zzb)((Object)object2)).zzf());
                        zznp.zza(stringBuilder2, 2, "no_access_adservices_attribution_permission", ((zzfn.zzb)((Object)object2)).zzh());
                        zznp.zza(stringBuilder2, 2, "pre_r", ((zzfn.zzb)((Object)object2)).zzi());
                        zznp.zza(stringBuilder2, 2, "r_extensions_too_old", ((zzfn.zzb)((Object)object2)).zzj());
                        zznp.zza(stringBuilder2, 2, "adservices_extension_too_old", ((zzfn.zzb)((Object)object2)).zze());
                        zznp.zza(stringBuilder2, 2, "ad_storage_not_allowed", ((zzfn.zzb)((Object)object2)).zzd());
                        zznp.zza(stringBuilder2, 2, "measurement_manager_disabled", ((zzfn.zzb)((Object)object2)).zzg());
                        zznp.zza(stringBuilder2, 2);
                        stringBuilder2.append("}\n");
                    }
                }
            }
            object2 = zzj3.zzar();
            n = 1;
            stringBuilder2 = stringBuilder3;
            zznp zznp3 = zznp2;
            if (object2 != null) {
                ++n;
                iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    object = iterator2.next();
                    if (object == null) continue;
                    zznp.zza(stringBuilder2, 2);
                    stringBuilder2.append("user_property {\n");
                    zznp.zza(stringBuilder2, 2, "set_timestamp_millis", object.zzl() ? Long.valueOf(object.zzd()) : null);
                    zznp.zza(stringBuilder2, 2, "name", zznp3.zzi().zzc(object.zzg()));
                    zznp.zza(stringBuilder2, 2, "string_value", object.zzh());
                    zznp.zza(stringBuilder2, 2, "int_value", object.zzk() ? Long.valueOf(object.zzc()) : null);
                    zznp.zza(stringBuilder2, 2, "double_value", object.zzi() ? Double.valueOf(object.zza()) : null);
                    zznp.zza(stringBuilder2, 2);
                    stringBuilder2.append("}\n");
                }
            }
            List<zzfn.zzc> list = zzj3.zzap();
            zzj3.zzy();
            object2 = list;
            n = 1;
            stringBuilder2 = stringBuilder3;
            if (object2 != null) {
                ++n;
                object = object2.iterator();
                while (object.hasNext()) {
                    zzfn.zzc zzc2 = (zzfn.zzc)((Object)object.next());
                    if (zzc2 == null) continue;
                    zznp.zza(stringBuilder2, 2);
                    stringBuilder2.append("audience_membership {\n");
                    if (zzc2.zzg()) {
                        zznp.zza(stringBuilder2, 2, "audience_id", zzc2.zza());
                    }
                    if (zzc2.zzh()) {
                        zznp.zza(stringBuilder2, 2, "new_audience", zzc2.zzf());
                    }
                    zznp.zza(stringBuilder2, 2, "current_data", zzc2.zzd());
                    if (zzc2.zzi()) {
                        zznp.zza(stringBuilder2, 2, "previous_data", zzc2.zze());
                    }
                    zznp.zza(stringBuilder2, 2);
                    stringBuilder2.append("}\n");
                }
            }
            object2 = zzj3.zzaq();
            n = 1;
            stringBuilder2 = stringBuilder3;
            zznp3 = zznp2;
            if (object2 != null) {
                ++n;
                iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    object = (zzfn.zze)((Object)iterator2.next());
                    if (object == null) continue;
                    zznp.zza(stringBuilder2, 2);
                    stringBuilder2.append("event {\n");
                    zznp.zza(stringBuilder2, 2, "name", zznp3.zzi().zza(((zzfn.zze)((Object)object)).zzg()));
                    if (((zzfn.zze)((Object)object)).zzk()) {
                        zznp.zza(stringBuilder2, 2, "timestamp_millis", ((zzfn.zze)((Object)object)).zzd());
                    }
                    if (((zzfn.zze)((Object)object)).zzj()) {
                        zznp.zza(stringBuilder2, 2, "previous_timestamp_millis", ((zzfn.zze)((Object)object)).zzc());
                    }
                    if (((zzfn.zze)((Object)object)).zzi()) {
                        zznp.zza(stringBuilder2, 2, "count", ((zzfn.zze)((Object)object)).zza());
                    }
                    if (((zzfn.zze)((Object)object)).zzb() != 0) {
                        zznp3.zza(stringBuilder2, 2, ((zzfn.zze)((Object)object)).zzh());
                    }
                    zznp.zza(stringBuilder2, 2);
                    stringBuilder2.append("}\n");
                }
            }
            zznp.zza(stringBuilder3, 1);
            stringBuilder3.append("}\n");
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final String zza(zzff.zzb zzb2) {
        if (zzb2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        if (zzb2.zzl()) {
            zznp.zza(stringBuilder, 0, "filter_id", zzb2.zzb());
        }
        zznp.zza(stringBuilder, 0, "event_name", this.zzi().zza(zzb2.zzf()));
        String string = zznp.zza(zzb2.zzh(), zzb2.zzi(), zzb2.zzj());
        if (!string.isEmpty()) {
            zznp.zza(stringBuilder, 0, "filter_type", string);
        }
        if (zzb2.zzk()) {
            zznp.zza(stringBuilder, 1, "event_count_filter", zzb2.zze());
        }
        if (zzb2.zza() > 0) {
            stringBuilder.append("  filters {\n");
            for (zzff.zzc zzc2 : zzb2.zzg()) {
                this.zza(stringBuilder, 2, zzc2);
            }
        }
        zznp.zza(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    private static String zza(boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("Dynamic ");
        }
        if (bl2) {
            stringBuilder.append("Sequence ");
        }
        if (bl3) {
            stringBuilder.append("Session-Scoped ");
        }
        return stringBuilder.toString();
    }

    final String zza(zzff.zze zze2) {
        if (zze2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        if (zze2.zzi()) {
            zznp.zza(stringBuilder, 0, "filter_id", zze2.zza());
        }
        zznp.zza(stringBuilder, 0, "property_name", this.zzi().zzc(zze2.zze()));
        String string = zznp.zza(zze2.zzf(), zze2.zzg(), zze2.zzh());
        if (!string.isEmpty()) {
            zznp.zza(stringBuilder, 0, "filter_type", string);
        }
        this.zza(stringBuilder, 1, zze2.zzb());
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final List<Long> zza(List<Long> list, List<Integer> list2) {
        ArrayList<Long> arrayList = new ArrayList<Long>(list);
        for (Integer n : list2) {
            if (n < 0) {
                this.zzj().zzu().zza("Ignoring negative bit index to be cleared", (Object)n);
                continue;
            }
            int n2 = n / 64;
            if (n2 >= arrayList.size()) {
                this.zzj().zzu().zza("Ignoring bit index greater than bitSet size", (Object)n, (Object)arrayList.size());
                continue;
            }
            arrayList.set(n2, arrayList.get(n2) & (1L << n % 64 ^ 0xFFFFFFFFFFFFFFFFL));
        }
        int n = arrayList.size();
        int n3 = arrayList.size() - 1;
        while (n3 >= 0 && arrayList.get(n3) == 0L) {
            n = n3--;
        }
        return arrayList.subList(0, n);
    }

    final @Nullable List<Integer> zzu() {
        Map map = zzbh.zza((Context)this.zzf.zza());
        if (map == null || map.isEmpty()) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = (Integer)zzbh.zzap.zza(null);
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getKey()).startsWith("measurement.id.")) continue;
            try {
                int n2 = Integer.parseInt((String)entry.getValue());
                if (n2 == 0) continue;
                arrayList.add(n2);
                if (arrayList.size() < n) continue;
                this.zzj().zzu().zza("Too many experiment IDs. Number of IDs", (Object)arrayList.size());
                break;
            }
            catch (NumberFormatException numberFormatException) {
                this.zzj().zzu().zza("Experiment ID NumberFormatException", (Object)numberFormatException);
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    static List<Long> zza(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        for (int i = 0; i < n; ++i) {
            long l = 0L;
            for (int j = 0; j < 64 && (i << 6) + j < bitSet.length(); ++j) {
                if (!bitSet.get((i << 6) + j)) continue;
                l |= 1L << j;
            }
            arrayList.add(l);
        }
        return arrayList;
    }

    final Map<String, Object> zza(Bundle bundle, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string : bundle.keySet()) {
            Object object;
            Object object2 = object = bundle.get(string);
            if (object instanceof Parcelable[] || object2 instanceof ArrayList || object2 instanceof Bundle) {
                if (!bl) continue;
                Object object3 = object;
                object2 = this;
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                if (object3 instanceof Parcelable[]) {
                    for (Parcelable parcelable : (Parcelable[])object3) {
                        if (!(parcelable instanceof Bundle)) continue;
                        arrayList.add(((zznp)((Object)object2)).zza((Bundle)parcelable, false));
                    }
                } else if (object3 instanceof ArrayList) {
                    ArrayList arrayList2 = (ArrayList)object3;
                    int n = arrayList2.size();
                    for (int i = 0; i < n; ++i) {
                        Object e = arrayList2.get(i);
                        Object e2 = e;
                        if (!(e instanceof Bundle)) continue;
                        arrayList.add(((zznp)((Object)object2)).zza((Bundle)e2, false));
                    }
                } else if (object3 instanceof Bundle) {
                    arrayList.add(((zznp)((Object)object2)).zza((Bundle)object3, false));
                }
                hashMap.put(string, arrayList);
                continue;
            }
            if (object == null) continue;
            hashMap.put(string, object);
        }
        return hashMap;
    }

    zznp(zznc zznc2) {
        super(zznc2);
    }

    static void zza(zzfn.zze.zza zza2, String string, Object object) {
        List<zzfn.zzg> list = zza2.zzf();
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(list.get(i).zzg())) continue;
            n = i;
            break;
        }
        zzfn.zzg.zza zza3 = zzfn.zzg.zze().zza(string);
        if (object instanceof Long) {
            zza3.zza((Long)object);
        } else if (object instanceof String) {
            zza3.zzb((String)object);
        } else if (object instanceof Double) {
            zza3.zza((Double)object);
        }
        if (n >= 0) {
            zza2.zza(n, zza3);
            return;
        }
        zza2.zza(zza3);
    }

    private static void zza(Uri.Builder builder, String[] stringArray, Bundle bundle, Set<String> set) {
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(",");
            String string = stringArray2[0];
            String string2 = stringArray2[stringArray2.length - 1];
            String string3 = bundle.getString(string);
            if (string3 == null) continue;
            zznp.zza(builder, string2, string3, set);
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzfn.zzl zzl2) {
        int n2;
        if (zzl2 == null) {
            return;
        }
        ++n;
        zznp.zza(stringBuilder, 3);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzl2.zzb() != 0) {
            zznp.zza(stringBuilder, 4);
            stringBuilder.append("results: ");
            n2 = 0;
            for (Long object : zzl2.zzi()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object);
            }
            stringBuilder.append('\n');
        }
        if (zzl2.zzd() != 0) {
            zznp.zza(stringBuilder, 4);
            stringBuilder.append("status: ");
            n2 = 0;
            for (Long l : zzl2.zzk()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        if (zzl2.zza() != 0) {
            zznp.zza(stringBuilder, 4);
            stringBuilder.append("dynamic_filter_timestamps: {");
            n2 = 0;
            for (zzfn.zzd zzd2 : zzl2.zzh()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(zzd2.zzf() ? Integer.valueOf(zzd2.zza()) : null).append(":").append(zzd2.zze() ? Long.valueOf(zzd2.zzb()) : null);
            }
            stringBuilder.append("}\n");
        }
        if (zzl2.zzc() != 0) {
            zznp.zza(stringBuilder, 4);
            stringBuilder.append("sequence_filter_timestamps: {");
            n2 = 0;
            for (zzfn.zzm zzm2 : zzl2.zzj()) {
                if (n2++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(zzm2.zzf() ? Integer.valueOf(zzm2.zzb()) : null).append(": [");
                int n3 = 0;
                for (long l : zzm2.zze()) {
                    if (n3++ != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(l);
                }
                stringBuilder.append("]");
            }
            stringBuilder.append("}\n");
        }
        zznp.zza(stringBuilder, 3);
        stringBuilder.append("}\n");
    }

    private final void zza(StringBuilder stringBuilder, int n, List<zzfn.zzg> list) {
        if (list == null) {
            return;
        }
        ++n;
        for (zzfn.zzg zzg2 : list) {
            if (zzg2 == null) continue;
            zznp.zza(stringBuilder, n);
            stringBuilder.append("param {\n");
            zznp.zza(stringBuilder, n, "name", zzg2.zzm() ? this.zzi().zzb(zzg2.zzg()) : null);
            zznp.zza(stringBuilder, n, "string_value", zzg2.zzn() ? zzg2.zzh() : null);
            zznp.zza(stringBuilder, n, "int_value", zzg2.zzl() ? Long.valueOf(zzg2.zzd()) : null);
            zznp.zza(stringBuilder, n, "double_value", zzg2.zzj() ? Double.valueOf(zzg2.zza()) : null);
            if (zzg2.zzc() > 0) {
                this.zza(stringBuilder, n, zzg2.zzi());
            }
            zznp.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private final void zza(StringBuilder stringBuilder, int n, zzff.zzc zzc2) {
        if (zzc2 == null) {
            return;
        }
        zznp.zza(stringBuilder, n);
        stringBuilder.append("filter {\n");
        if (zzc2.zzg()) {
            zznp.zza(stringBuilder, n, "complement", zzc2.zzf());
        }
        if (zzc2.zzi()) {
            zznp.zza(stringBuilder, n, "param_name", this.zzi().zzb(zzc2.zze()));
        }
        if (zzc2.zzj()) {
            zzff.zzf zzf2 = zzc2.zzd();
            String string = "string_filter";
            int n2 = n + 1;
            StringBuilder stringBuilder2 = stringBuilder;
            if (zzf2 != null) {
                zznp.zza(stringBuilder2, n2);
                stringBuilder2.append(string);
                stringBuilder2.append(" {\n");
                if (zzf2.zzj()) {
                    zznp.zza(stringBuilder2, n2, "match_type", zzf2.zzb().name());
                }
                if (zzf2.zzi()) {
                    zznp.zza(stringBuilder2, n2, "expression", zzf2.zze());
                }
                if (zzf2.zzh()) {
                    zznp.zza(stringBuilder2, n2, "case_sensitive", zzf2.zzg());
                }
                if (zzf2.zza() > 0) {
                    zznp.zza(stringBuilder2, n2 + 1);
                    stringBuilder2.append("expression_list {\n");
                    for (String string2 : zzf2.zzf()) {
                        zznp.zza(stringBuilder2, n2 + 2);
                        stringBuilder2.append(string2);
                        stringBuilder2.append("\n");
                    }
                    stringBuilder2.append("}\n");
                }
                zznp.zza(stringBuilder2, n2);
                stringBuilder2.append("}\n");
            }
        }
        if (zzc2.zzh()) {
            zznp.zza(stringBuilder, n + 1, "number_filter", zzc2.zzc());
        }
        zznp.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzff.zzd zzd2) {
        if (zzd2 == null) {
            return;
        }
        zznp.zza(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzd2.zzh()) {
            zznp.zza(stringBuilder, n, "comparison_type", zzd2.zza().name());
        }
        if (zzd2.zzj()) {
            zznp.zza(stringBuilder, n, "match_as_float", zzd2.zzg());
        }
        if (zzd2.zzi()) {
            zznp.zza(stringBuilder, n, "comparison_value", zzd2.zzd());
        }
        if (zzd2.zzl()) {
            zznp.zza(stringBuilder, n, "min_comparison_value", zzd2.zzf());
        }
        if (zzd2.zzk()) {
            zznp.zza(stringBuilder, n, "max_comparison_value", zzd2.zze());
        }
        zznp.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(Uri.Builder builder, String string, @Nullable String string2, Set<String> set) {
        if (set.contains(string) || TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        builder.appendQueryParameter(string, string2);
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, @Nullable Object object) {
        if (object == null) {
            return;
        }
        zznp.zza(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    final void zza(zzfn.zzj.zza zza2) {
        this.zzj().zzp().zza("Checking account type status for ad personalization signals");
        if (this.zzc(zza2.zzs())) {
            this.zzj().zzc().zza("Turning off ad personalization due to account type");
            zzfn.zzn zzn2 = (zzfn.zzn)((zzjk)zzfn.zzn.zze().zza("_npa").zzb(this.zzf().zzc()).zza(1L).zzag());
            boolean bl = false;
            for (int i = 0; i < zza2.zzd(); ++i) {
                if (!"_npa".equals(zza2.zzk(i).zzg())) continue;
                zza2.zza(i, zzn2);
                bl = true;
                break;
            }
            if (!bl) {
                zza2.zza(zzn2);
            }
            zzaj zzaj2 = zzaj.zza(zza2.zzu());
            zzaj2.zza(zzin.zza.zzd, zzai.zzg);
            zza2.zzf(zzaj2.toString());
        }
    }

    final void zza(zzfn.zzg.zza zza2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zza2.zze().zzc().zzb().zzd();
        if (object instanceof String) {
            zza2.zzb((String)object);
            return;
        }
        if (object instanceof Long) {
            zza2.zza((Long)object);
            return;
        }
        if (object instanceof Double) {
            zza2.zza((Double)object);
            return;
        }
        if (object instanceof Bundle[]) {
            Bundle[] bundleArray = (Bundle[])object;
            ArrayList<zzfn.zzg> arrayList = new ArrayList<zzfn.zzg>();
            Bundle[] bundleArray2 = bundleArray;
            int n = bundleArray.length;
            for (int i = 0; i < n; ++i) {
                Bundle bundle = bundleArray2[i];
                if (bundle == null) continue;
                zzfn.zzg.zza zza3 = zzfn.zzg.zze();
                for (String string : bundle.keySet()) {
                    zzfn.zzg.zza zza4 = zzfn.zzg.zze().zza(string);
                    Object object2 = bundle.get(string);
                    if (object2 instanceof Long) {
                        zza4.zza((Long)object2);
                    } else if (object2 instanceof String) {
                        zza4.zzb((String)object2);
                    } else {
                        if (!(object2 instanceof Double)) continue;
                        zza4.zza((Double)object2);
                    }
                    zza3.zza(zza4);
                }
                if (zza3.zza() <= 0) continue;
                arrayList.add((zzfn.zzg)((zzjk)zza3.zzag()));
            }
            zza2.zza(arrayList);
            return;
        }
        this.zzj().zzg().zza("Ignoring invalid (type) event param value", object);
    }

    final void zza(zzfn.zzn.zza zza2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zza2.zzc().zzb().zza();
        if (object instanceof String) {
            zza2.zzb((String)object);
            return;
        }
        if (object instanceof Long) {
            zza2.zza((Long)object);
            return;
        }
        if (object instanceof Double) {
            zza2.zza((Double)object);
            return;
        }
        this.zzj().zzg().zza("Ignoring invalid (type) user attribute value", object);
    }

    @WorkerThread
    static boolean zza(zzbf zzbf2, zzn zzn2) {
        Preconditions.checkNotNull((Object)zzbf2);
        Preconditions.checkNotNull((Object)zzn2);
        return !TextUtils.isEmpty((CharSequence)zzn2.zzb) || !TextUtils.isEmpty((CharSequence)zzn2.zzp);
    }

    static boolean zza(List<Long> list, int n) {
        return n < list.size() << 6 && (list.get(n / 64) & 1L << n % 64) != 0L;
    }

    final boolean zza(long l, long l2) {
        return l == 0L || l2 <= 0L || Math.abs(this.zzb().currentTimeMillis() - l) > l2;
    }

    static boolean zzb(String string) {
        return string != null && string.matches("([+-])?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    @Override
    protected final boolean zzc() {
        return false;
    }

    final boolean zzc(String string) {
        if (zznn.zza() && this.zze().zza(zzbh.zzct)) {
            return false;
        }
        Preconditions.checkNotNull((Object)string);
        zzf zzf2 = ((zzmy)this).zzh().zze(string);
        if (zzf2 == null) {
            return false;
        }
        return this.zzf().zzn() && zzf2.zzaq() && ((zzmy)this).zzm().zzk(string);
    }

    final byte[] zzb(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to gzip content", (Object)iOException);
            throw iOException;
        }
    }

    final byte[] zzc(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to ungzip content", (Object)iOException);
            throw iOException;
        }
    }
}

