/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzfn;
import com.google.android.gms.internal.measurement.zzgn;
import com.google.android.gms.internal.measurement.zzlc;
import com.google.android.gms.internal.measurement.zzmn;
import com.google.android.gms.internal.measurement.zzox;
import com.google.android.gms.internal.measurement.zzpd;
import com.google.android.gms.internal.measurement.zzpo;
import com.google.android.gms.internal.measurement.zzpv;
import com.google.android.gms.internal.measurement.zzqn;
import com.google.android.gms.internal.measurement.zzrl;
import com.google.android.gms.internal.measurement.zzrw;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzav;
import com.google.android.gms.measurement.internal.zzaz;
import com.google.android.gms.measurement.internal.zzba;
import com.google.android.gms.measurement.internal.zzbd;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzbj;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzjc;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zznk;
import com.google.android.gms.measurement.internal.zznl;
import com.google.android.gms.measurement.internal.zznr;
import com.google.android.gms.measurement.internal.zznt;
import com.google.android.gms.measurement.internal.zznv;
import com.google.android.gms.measurement.internal.zzog;
import com.google.android.gms.measurement.internal.zzoj;
import com.google.android.gms.measurement.internal.zzok;
import com.google.android.gms.measurement.internal.zzol;
import com.google.android.gms.measurement.internal.zzom;
import com.google.android.gms.measurement.internal.zzop;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class zzam
extends zznr {
    private static final String[] zza = new String[]{"last_bundled_timestamp", "ALTER TABLE events ADD COLUMN last_bundled_timestamp INTEGER;", "last_bundled_day", "ALTER TABLE events ADD COLUMN last_bundled_day INTEGER;", "last_sampled_complex_event_id", "ALTER TABLE events ADD COLUMN last_sampled_complex_event_id INTEGER;", "last_sampling_rate", "ALTER TABLE events ADD COLUMN last_sampling_rate INTEGER;", "last_exempt_from_sampling", "ALTER TABLE events ADD COLUMN last_exempt_from_sampling INTEGER;", "current_session_count", "ALTER TABLE events ADD COLUMN current_session_count INTEGER;"};
    private static final String[] zzb = new String[]{"origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;"};
    private static final String[] zzc = new String[]{"app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;", "app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;", "gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;", "dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;", "measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;", "last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;", "day", "ALTER TABLE apps ADD COLUMN day INTEGER;", "daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;", "daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;", "daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;", "remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;", "config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;", "failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;", "app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;", "firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;", "daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;", "daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;", "health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;", "android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;", "adid_reporting_enabled", "ALTER TABLE apps ADD COLUMN adid_reporting_enabled INTEGER;", "ssaid_reporting_enabled", "ALTER TABLE apps ADD COLUMN ssaid_reporting_enabled INTEGER;", "admob_app_id", "ALTER TABLE apps ADD COLUMN admob_app_id TEXT;", "linked_admob_app_id", "ALTER TABLE apps ADD COLUMN linked_admob_app_id TEXT;", "dynamite_version", "ALTER TABLE apps ADD COLUMN dynamite_version INTEGER;", "safelisted_events", "ALTER TABLE apps ADD COLUMN safelisted_events TEXT;", "ga_app_id", "ALTER TABLE apps ADD COLUMN ga_app_id TEXT;", "config_last_modified_time", "ALTER TABLE apps ADD COLUMN config_last_modified_time TEXT;", "e_tag", "ALTER TABLE apps ADD COLUMN e_tag TEXT;", "session_stitching_token", "ALTER TABLE apps ADD COLUMN session_stitching_token TEXT;", "sgtm_upload_enabled", "ALTER TABLE apps ADD COLUMN sgtm_upload_enabled INTEGER;", "target_os_version", "ALTER TABLE apps ADD COLUMN target_os_version INTEGER;", "session_stitching_token_hash", "ALTER TABLE apps ADD COLUMN session_stitching_token_hash INTEGER;", "ad_services_version", "ALTER TABLE apps ADD COLUMN ad_services_version INTEGER;", "unmatched_first_open_without_ad_id", "ALTER TABLE apps ADD COLUMN unmatched_first_open_without_ad_id INTEGER;", "npa_metadata_value", "ALTER TABLE apps ADD COLUMN npa_metadata_value INTEGER;", "attribution_eligibility_status", "ALTER TABLE apps ADD COLUMN attribution_eligibility_status INTEGER;", "sgtm_preview_key", "ALTER TABLE apps ADD COLUMN sgtm_preview_key TEXT;", "dma_consent_state", "ALTER TABLE apps ADD COLUMN dma_consent_state INTEGER;", "daily_realtime_dcu_count", "ALTER TABLE apps ADD COLUMN daily_realtime_dcu_count INTEGER;", "bundle_delivery_index", "ALTER TABLE apps ADD COLUMN bundle_delivery_index INTEGER;", "serialized_npa_metadata", "ALTER TABLE apps ADD COLUMN serialized_npa_metadata TEXT;", "unmatched_pfo", "ALTER TABLE apps ADD COLUMN unmatched_pfo INTEGER;", "unmatched_uwa", "ALTER TABLE apps ADD COLUMN unmatched_uwa INTEGER;", "ad_campaign_info", "ALTER TABLE apps ADD COLUMN ad_campaign_info BLOB;"};
    private static final String[] zzd = new String[]{"realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;"};
    private static final String[] zze = new String[]{"has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;", "retry_count", "ALTER TABLE queue ADD COLUMN retry_count INTEGER;"};
    private static final String[] zzf = new String[]{"session_scoped", "ALTER TABLE event_filters ADD COLUMN session_scoped BOOLEAN;"};
    private static final String[] zzh = new String[]{"session_scoped", "ALTER TABLE property_filters ADD COLUMN session_scoped BOOLEAN;"};
    private static final String[] zzi = new String[]{"previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;"};
    private static final String[] zzj = new String[]{"consent_source", "ALTER TABLE consent_settings ADD COLUMN consent_source INTEGER;", "dma_consent_settings", "ALTER TABLE consent_settings ADD COLUMN dma_consent_settings TEXT;", "storage_consent_at_bundling", "ALTER TABLE consent_settings ADD COLUMN storage_consent_at_bundling TEXT;"};
    private static final String[] zzk = new String[]{"idempotent", "CREATE INDEX IF NOT EXISTS trigger_uris_index ON trigger_uris (app_id);"};
    private final zzav zzl;
    private final zznl zzm = new zznl(this.zzb());

    @WorkerThread
    public final int zza(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzt();
        this.zzal();
        try {
            return this.e_().delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error deleting conditional property", zzgi.zza((String)string), (Object)this.zzi().zzc(string2), (Object)sQLiteException);
            return 0;
        }
    }

    public final long zza(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzt();
        this.zzal();
        try {
            SQLiteDatabase sQLiteDatabase = this.e_();
            int n = this.zze().zzb(string, zzbj.zzp);
            n = Math.min(1000000, n);
            String string2 = String.valueOf(Math.max(0, n));
            return sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error deleting over the limit events. appId", zzgi.zza((String)string), (Object)sQLiteException);
            return 0L;
        }
    }

    public final long b_() {
        try (Cursor cursor = null;){
            cursor = this.e_().rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    public final long zza(zzgn.zzk zzk2) throws IOException {
        this.zzt();
        this.zzal();
        Preconditions.checkNotNull((Object)((Object)zzk2));
        Preconditions.checkNotEmpty((String)zzk2.zzz());
        byte[] byArray = zzk2.zzca();
        long l = this.g_().zza(byArray);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzk2.zzz());
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("metadata", byArray);
        try {
            this.e_().insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing raw event metadata. appId", zzgi.zza((String)zzk2.zzz()), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l;
    }

    @WorkerThread
    @VisibleForTesting
    protected final long zzb(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzt();
        this.zzal();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.e_();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues;
            String string3 = string2;
            l = this.zza("select " + string3 + " from app2 where app_id=?", new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                if (sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5) == -1L) {
                    this.zzj().zzg().zza("Failed to insert column (got -1). appId", zzgi.zza((String)string), (Object)string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            if ((long)sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string}) == 0L) {
                this.zzj().zzg().zza("Failed to update column (got 0). appId", zzgi.zza((String)string), (Object)string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error inserting column. appId", zzgi.zza((String)string), (Object)string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public final long zzb(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzt();
        this.zzal();
        return this.zza("select first_open_count from app2 where app_id=?", new String[]{string}, -1L);
    }

    @WorkerThread
    public final long c_() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    public final long d_() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public final long zzc(String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    @WorkerThread
    private final long zzb(String string, String @Nullable [] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.e_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzj().zzg().zza("Database error", (Object)string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private final long zza(String string, String @Nullable [] stringArray, long l) {
        long l2;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.e_();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    long l3 = cursor.getLong(0);
                    return l3;
                }
                l2 = l;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return l2;
    }

    @VisibleForTesting
    @WorkerThread
    final SQLiteDatabase e_() {
        this.zzt();
        try {
            return this.zzl.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzu().zza("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    public final @Nullable Bundle zzd(String string) {
        this.zzt();
        this.zzal();
        try (Cursor cursor = null;){
            zzgn.zzf zzf2;
            cursor = this.e_().rawQuery("select parameters from default_event_params where app_id=?", new String[]{string});
            if (!cursor.moveToFirst()) {
                this.zzj().zzp().zza("Default event parameters not found");
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            try {
                zzf2 = (zzgn.zzf)((zzlc)zzol.zza(zzgn.zzf.zze(), byArray).zzai());
            }
            catch (IOException iOException) {
                this.zzj().zzg().zza("Failed to retrieve default event parameters. appId", zzgi.zza((String)string), (Object)iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return null;
            }
            this.g_();
            Bundle bundle = zzol.zza(zzf2.zzh());
            return bundle;
        }
        return null;
    }

    public final @Nullable Pair<zzgn.zzf, Long> zza(String string, Long l) {
        this.zzt();
        this.zzal();
        try (Cursor cursor = null;){
            zzgn.zzf zzf2;
            cursor = this.e_().rawQuery("select main_event, children_to_process from main_event_params where app_id=? and event_id=?", new String[]{string, String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzj().zzp().zza("Main event not found");
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            Long l2 = cursor.getLong(1);
            try {
                zzf2 = (zzgn.zzf)((zzlc)zzol.zza(zzgn.zzf.zze(), byArray).zzai());
            }
            catch (IOException iOException) {
                this.zzj().zzg().zza("Failed to merge main event. appId, eventId", zzgi.zza((String)string), (Object)l, (Object)iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return null;
            }
            Pair pair = Pair.create((Object)((Object)zzf2), (Object)l2);
            return pair;
        }
        return null;
    }

    @WorkerThread
    public final @Nullable zzh zze(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzt();
        this.zzal();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.e_().query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id", "adid_reporting_enabled", "admob_app_id", "dynamite_version", "safelisted_events", "ga_app_id", "session_stitching_token", "sgtm_upload_enabled", "target_os_version", "session_stitching_token_hash", "ad_services_version", "unmatched_first_open_without_ad_id", "npa_metadata_value", "attribution_eligibility_status", "sgtm_preview_key", "dma_consent_state", "daily_realtime_dcu_count", "bundle_delivery_index", "serialized_npa_metadata", "unmatched_pfo", "unmatched_uwa", "ad_campaign_info"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzh zzh2 = new zzh(this.zzg.zzk(), string);
            if (!zzpd.zza() || !this.zze().zza(zzbj.zzdc) || this.zzg.zzb(string).zza(zzjc.zza.zzb)) {
                zzh2.zzb(cursor.getString(0));
            }
            zzh2.zzf(cursor.getString(1));
            if (!zzpd.zza() || !this.zze().zza(zzbj.zzdc) || this.zzg.zzb(string).zza(zzjc.zza.zza)) {
                zzh2.zzh(cursor.getString(2));
            }
            zzh2.zzq(cursor.getLong(3));
            zzh2.zzr(cursor.getLong(4));
            zzh2.zzp(cursor.getLong(5));
            zzh2.zzd(cursor.getString(6));
            zzh2.zzc(cursor.getString(7));
            zzh2.zzn(cursor.getLong(8));
            zzh2.zzk(cursor.getLong(9));
            zzh2.zzb(cursor.isNull(10) || cursor.getInt(10) != 0);
            zzh2.zzj(cursor.getLong(11));
            zzh2.zzh(cursor.getLong(12));
            zzh2.zzg(cursor.getLong(13));
            zzh2.zze(cursor.getLong(14));
            zzh2.zzd(cursor.getLong(15));
            zzh2.zzm(cursor.getLong(16));
            zzh2.zzb(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzh2.zze(cursor.getString(18));
            zzh2.zzf(cursor.getLong(19));
            zzh2.zzi(cursor.getLong(20));
            zzh2.zzg(cursor.getString(21));
            zzh2.zza(cursor.isNull(23) || cursor.getInt(23) != 0);
            zzh2.zza(cursor.getString(24));
            zzh2.zzl(cursor.isNull(25) ? 0L : cursor.getLong(25));
            if (!cursor.isNull(26)) {
                zzh2.zza(Arrays.asList(cursor.getString(26).split(",", -1)));
            }
            if (!zzpd.zza() || !this.zze().zza(zzbj.zzdc) || this.zzg.zzb(string).zza(zzjc.zza.zzb)) {
                zzh2.zzj(cursor.getString(28));
            }
            if (zzrw.zza() && this.zze().zza(zzbj.zzbw)) {
                this.zzq();
                if (zzop.zzf((String)string)) {
                    zzh2.zzc(!cursor.isNull(29) && cursor.getInt(29) != 0);
                    zzh2.zzo(cursor.getLong(39));
                    if (this.zze().zza(zzbj.zzbx)) {
                        zzh2.zzk(cursor.getString(36));
                    }
                }
            }
            zzh2.zzt(cursor.getLong(30));
            zzh2.zzs(cursor.getLong(31));
            if (zzrl.zza() && this.zze().zze(string, zzbj.zzcg)) {
                zzh2.zza(cursor.getInt(32));
                zzh2.zzc(cursor.getLong(35));
            }
            if (zzpo.zza() && this.zze().zze(string, zzbj.zzcr)) {
                zzh2.zzd(!cursor.isNull(33) && cursor.getInt(33) != 0);
            }
            zzh2.zza(cursor.isNull(34) ? null : Boolean.valueOf(cursor.getInt(34) != 0));
            zzh2.zzc(cursor.getInt(37));
            zzh2.zzb(cursor.getInt(38));
            if (zzox.zza() && this.zze().zze(string, zzbj.zzcw)) {
                object = cursor.getString(40);
                zzh2.zzi((String)(object == null ? "" : object));
            }
            if (this.zze().zza(zzbj.zzcz)) {
                if (!cursor.isNull(41)) {
                    zzh2.zza((Long)cursor.getLong(41));
                }
                if (!cursor.isNull(42)) {
                    zzh2.zzb((Long)cursor.getLong(42));
                }
            }
            if (zzqn.zza() && this.zze().zze(string, zzbj.zzct)) {
                zzh2.zza(cursor.getBlob(43));
            }
            zzh2.zzao();
            if (cursor.moveToNext()) {
                this.zzj().zzg().zza("Got multiple records for app, expected one. appId", zzgi.zza((String)string));
            }
            object = zzh2;
            return object;
        }
    }

    @WorkerThread
    public final @Nullable zzaf zzc(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzt();
        this.zzal();
        try (Cursor cursor = null;){
            cursor = this.e_().query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            if (string3 == null) {
                string3 = "";
            }
            Object object = this.zza(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzbh zzbh2 = (zzbh)this.g_().zza(cursor.getBlob(5), zzbh.CREATOR);
            long l2 = cursor.getLong(6);
            zzbh zzbh3 = (zzbh)this.g_().zza(cursor.getBlob(7), zzbh.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzbh zzbh4 = (zzbh)this.g_().zza(cursor.getBlob(10), zzbh.CREATOR);
            zzok zzok2 = new zzok(string2, l3, object, string3);
            zzaf zzaf2 = new zzaf(string, string3, zzok2, l2, bl, string4, zzbh2, l, zzbh3, l4, zzbh4);
            if (cursor.moveToNext()) {
                this.zzj().zzg().zza("Got multiple records for conditional property, expected one", zzgi.zza((String)string), (Object)this.zzi().zzc(string2));
            }
            zzaf zzaf3 = zzaf2;
            return zzaf3;
        }
    }

    @WorkerThread
    public final @Nullable zzao zzf(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzt();
        this.zzal();
        try (Cursor cursor = null;){
            cursor = this.e_().query("apps", new String[]{"remote_config", "config_last_modified_time", "e_tag"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            String string2 = cursor.getString(1);
            String string3 = cursor.getString(2);
            if (cursor.moveToNext()) {
                this.zzj().zzg().zza("Got multiple records for app config, expected one. appId", zzgi.zza((String)string));
            }
            if (byArray == null) {
                return null;
            }
            zzao zzao2 = new zzao(byArray, string2, string3);
            return zzao2;
        }
    }

    @WorkerThread
    public final zzar zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        return this.zza(l, string, 1L, false, false, bl3, false, bl5, bl6);
    }

    @WorkerThread
    public final zzar zza(long l, String string, long l2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        Preconditions.checkNotEmpty((String)string);
        this.zzt();
        this.zzal();
        String[] stringArray = new String[]{string};
        zzar zzar2 = new zzar();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.e_();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count", "daily_realtime_dcu_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzj().zzu().zza("Not updating daily counts, app is not known. appId", zzgi.zza((String)string));
                zzar zzar3 = zzar2;
                return zzar3;
            }
            if (cursor.getLong(0) == l) {
                zzar2.zzb = cursor.getLong(1);
                zzar2.zza = cursor.getLong(2);
                zzar2.zzc = cursor.getLong(3);
                zzar2.zzd = cursor.getLong(4);
                zzar2.zze = cursor.getLong(5);
                zzar2.zzf = cursor.getLong(6);
            }
            if (bl) {
                zzar2.zzb += l2;
            }
            if (bl2) {
                zzar2.zza += l2;
            }
            if (bl3) {
                zzar2.zzc += l2;
            }
            if (bl4) {
                zzar2.zzd += l2;
            }
            if (bl5) {
                zzar2.zze += l2;
            }
            if (bl6) {
                zzar2.zzf += l2;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zzar2.zza));
            contentValues.put("daily_events_count", Long.valueOf(zzar2.zzb));
            contentValues.put("daily_conversions_count", Long.valueOf(zzar2.zzc));
            contentValues.put("daily_error_events_count", Long.valueOf(zzar2.zzd));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zzar2.zze));
            contentValues.put("daily_realtime_dcu_count", Long.valueOf(zzar2.zzf));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zzar zzar4 = zzar2;
            return zzar4;
        }
    }

    public final zzaz zzg(String string) {
        Preconditions.checkNotNull((Object)string);
        this.zzt();
        this.zzal();
        return zzaz.zza((String)this.zza("select dma_consent_settings from consent_settings where app_id=? limit 1;", new String[]{string}, ""));
    }

    @WorkerThread
    public final @Nullable zzbd zzd(String string, String string2) {
        return this.zzc("events", string, string2);
    }

    @WorkerThread
    private final @Nullable zzbd zzc(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string2);
        Preconditions.checkNotEmpty((String)string3);
        this.zzt();
        this.zzal();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("lifetime_count", "current_bundle_count", "last_fire_timestamp", "last_bundled_timestamp", "last_bundled_day", "last_sampled_complex_event_id", "last_sampling_rate", "last_exempt_from_sampling", "current_session_count"));
        try (Cursor cursor = null;){
            cursor = this.e_().query(string, arrayList.toArray(new String[0]), "app_id=? and name=?", new String[]{string2, string3}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            long l4 = cursor.isNull(3) ? 0L : cursor.getLong(3);
            Long l5 = cursor.isNull(4) ? null : Long.valueOf(cursor.getLong(4));
            Long l6 = cursor.isNull(5) ? null : Long.valueOf(cursor.getLong(5));
            Long l7 = cursor.isNull(6) ? null : Long.valueOf(cursor.getLong(6));
            Boolean bl = null;
            if (!cursor.isNull(7)) {
                bl = cursor.getLong(7) == 1L;
            }
            long l8 = cursor.isNull(8) ? 0L : cursor.getLong(8);
            zzbd zzbd2 = new zzbd(string2, string3, l, l2, l8, l3, l4, l5, l6, l7, bl);
            if (cursor.moveToNext()) {
                this.zzj().zzg().zza("Got multiple records for event aggregates, expected one. appId", zzgi.zza((String)string2));
            }
            zzbd zzbd3 = zzbd2;
            return zzbd3;
        }
    }

    static /* synthetic */ zzjc zza(Cursor cursor) {
        String string = cursor.getString(0);
        int n = cursor.getInt(1);
        return zzjc.zza((String)string, (int)n);
    }

    public final zzjc zzh(String string) {
        Preconditions.checkNotNull((Object)string);
        this.zzt();
        this.zzal();
        return zzjc.zzb((String)this.zza("select storage_consent_at_bundling from consent_settings where app_id=? limit 1;", new String[]{string}, ""));
    }

    public final zzjc zzi(String string) {
        Preconditions.checkNotNull((Object)string);
        this.zzt();
        this.zzal();
        zzjc zzjc2 = (zzjc)this.zza("select consent_state, consent_source from consent_settings where app_id=? limit 1;", new String[]{string}, new zzap());
        if (zzjc2 == null) {
            return zzjc.zza;
        }
        return zzjc2;
    }

    static /* bridge */ /* synthetic */ zznl zza(zzam zzam2) {
        return zzam2.zzm;
    }

    @WorkerThread
    public final @Nullable zzog zzj(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzt();
        this.zzal();
        if (zzrw.zza() && !this.zze().zza(zzbj.zzbz)) {
            return null;
        }
        try (Cursor cursor = null;){
            cursor = this.e_().query("upload_queue", new String[]{"rowId", "app_id", "measurement_batch", "upload_uri", "upload_headers", "upload_type", "retry_count"}, this.zzao(), new String[]{string}, null, null, "creation_timestamp ASC", "1");
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string2 = cursor.getString(3);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                this.zzj().zzc().zza("Upload uri is null or empty. Destination is unknown. Dropping batch. ");
                return null;
            }
            try {
                Object object;
                HashMap<String, String> hashMap;
                zzgn.zzj.zza zza2 = zzol.zza(zzgn.zzj.zzb(), cursor.getBlob(2));
                zznt zznt2 = zznt.values()[cursor.getInt(5)];
                if ((zznt2 == zznt.zzc || zznt2 == zznt.zza) && cursor.getInt(6) > 0) {
                    hashMap = new ArrayList();
                    object = zza2.zzd().iterator();
                    while (object.hasNext()) {
                        zzgn.zzk.zza zza3 = (zzgn.zzk.zza)((zzgn.zzk)((Object)object.next())).zzcd();
                        zza3.zzi(cursor.getInt(6));
                        hashMap.add((zzgn.zzk)((zzlc)zza3.zzai()));
                    }
                    zza2.zzb();
                    zza2.zza((Iterable<? extends zzgn.zzk>)((Object)hashMap));
                }
                hashMap = new HashMap();
                object = cursor.getString(4);
                if (object != null) {
                    for (String string3 : ((String)object).split("\r\n")) {
                        if (string3.isEmpty()) break;
                        String[] stringArray = string3.split("=", 2);
                        if (stringArray.length != 2) {
                            this.zzj().zzg().zza("Invalid upload header: ", (Object)string3);
                            break;
                        }
                        String string4 = stringArray[0];
                        String string5 = stringArray[1];
                        hashMap.put(string4, string5);
                    }
                }
                zzog zzog2 = new zzoj().zza(cursor.getLong(0)).zza((zzgn.zzj)((zzlc)zza2.zzai())).zza(string2).zza(hashMap).zza(zznt2).zza();
                return zzog2;
            }
            catch (IOException iOException) {
                block19: {
                    try {
                        this.zzj().zzg().zza("Failed to queued MeasurementBatch from upload_queue. appId", (Object)string, (Object)iOException);
                        if (cursor == null) break block19;
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zzj().zzg().zza("Error to querying MeasurementBatch from upload_queue. appId", (Object)string, (Object)sQLiteException);
                        return null;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    cursor.close();
                }
                return null;
            }
        }
    }

    @WorkerThread
    public final @Nullable zzom zze(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzt();
        this.zzal();
        try (Cursor cursor = null;){
            cursor = this.e_().query("user_attributes", new String[]{"set_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zza(cursor, 1);
            if (object == null) {
                return null;
            }
            String string3 = cursor.getString(2);
            zzom zzom2 = new zzom(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzj().zzg().zza("Got multiple records for user property, expected one. appId", zzgi.zza((String)string));
            }
            zzom zzom3 = zzom2;
            return zzom3;
        }
    }

    @VisibleForTesting
    @WorkerThread
    private final @Nullable Object zza(Cursor cursor, int n) {
        int n2 = cursor.getType(n);
        switch (n2) {
            case 0: {
                this.zzj().zzg().zza("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzj().zzg().zza("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzj().zzg().zza("Loaded invalid unknown value type, ignoring it", (Object)n2);
        return null;
    }

    @WorkerThread
    private final <T> @Nullable T zza(String string, String[] stringArray, zzas<T> zzas2) {
        try (Cursor cursor = null;){
            cursor = this.e_().rawQuery(string, stringArray);
            if (!cursor.moveToFirst()) {
                this.zzj().zzp().zza("No data found");
                return null;
            }
            T t = zzas2.zza(cursor);
            return t;
        }
        return null;
    }

    private final String zzao() {
        String string;
        long l = this.zzb().currentTimeMillis();
        long l2 = zzah.zzm();
        int n = zznt.zzb.zza();
        String string2 = "(upload_type = " + n + " AND (ABS(creation_timestamp - " + l + ") <= CAST(" + l2 + " AS INTEGER)))";
        l2 = zzah.zzo();
        n = zznt.zzb.zza();
        String string3 = string = "(upload_type != " + n + " AND (ABS(creation_timestamp - " + l + ") <= CAST(" + l2 + " AS INTEGER)))";
        String string4 = string2;
        return "app_id=? AND (" + string4 + " OR" + string3 + ")";
    }

    public final @Nullable String zza(long l) {
        this.zzt();
        this.zzal();
        try (Cursor cursor = null;){
            cursor = this.e_().rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzj().zzp().zza("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final @Nullable String f_() {
        SQLiteDatabase sQLiteDatabase = this.e_();
        Cursor cursor = null;
        try {
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Database error getting next bundle app id", (Object)sQLiteException);
            return null;
        }
        if (cursor == null) return null;
        cursor.close();
        return null;
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    @WorkerThread
    private final String zza(String string, String[] stringArray, String string2) {
        String string3;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.e_();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    String string4 = cursor.getString(0);
                    return string4;
                }
                string3 = string2;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return string3;
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    public final List<Pair<zzgn.zzk, Long>> zza(String var1_1, int var2_2, int var3_3) {
        this.zzt();
        this.zzal();
        Preconditions.checkArgument((boolean)(var2_2 > 0));
        Preconditions.checkArgument((boolean)(var3_3 > 0));
        Preconditions.checkNotEmpty((String)var1_1);
        var4_4 = null;
        try {
            var4_4 = this.e_().query("queue", new String[]{"rowid", "data", "retry_count"}, "app_id=?", new String[]{var1_1}, null, null, "rowid", String.valueOf(var2_2));
            if (!var4_4.moveToFirst()) {
                var6_5 = Collections.emptyList();
                return var6_5;
            }
            var6_6 = new ArrayList<Pair<zzgn.zzk, Long>>();
            var7_8 = 0;
            do {
                block18: {
                    var8_9 = var4_4.getLong(0);
                    try {
                        var11_12 = var4_4.getBlob(1);
                        var10_11 = this.g_().zzc((byte[])var11_12);
                    }
                    catch (IOException var11_13) {
                        this.zzj().zzg().zza("Failed to unzip queued bundle. appId", zzgi.zza((String)var1_1), (Object)var11_13);
                        continue;
                    }
                    if (!var6_6.isEmpty() && var7_8 + var10_11.length > var3_3) break;
                    try {
                        var11_12 = (Object)zzol.zza(zzgn.zzk.zzw(), var10_11);
                    }
                    catch (IOException var12_14) {
                        this.zzj().zzg().zza("Failed to merge queued bundle. appId", zzgi.zza((String)var1_1), (Object)var12_14);
                        continue;
                    }
                    if (var6_6.isEmpty()) break block18;
                    var15_16 = (zzgn.zzk)((zzlc)var11_12.zzai());
                    var14_15 = (zzgn.zzk)((Pair)var6_6.get((int)0)).first;
                    if (!var14_15.zzae().equals(var15_16.zzae()) || !var14_15.zzad().equals(var15_16.zzad()) || var14_15.zzau() != var15_16.zzau() || !var14_15.zzaf().equals(var15_16.zzaf())) ** GOTO lbl-1000
                    var16_17 = -1L;
                    for (zzgn.zzo var19_20 : var14_15.zzas()) {
                        if (!"_npa".equals(var19_20.zzg())) continue;
                        var16_17 = var19_20.zzc();
                        break;
                    }
                    var18_18 = -1L;
                    for (zzgn.zzo var21_22 : var15_16.zzas()) {
                        if (!"_npa".equals(var21_22.zzg())) continue;
                        var18_18 = var21_22.zzc();
                        break;
                    }
                    if (var16_17 == var18_18) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                    if (!v0) break;
                }
                if (!var4_4.isNull(2)) {
                    var11_12.zzi(var4_4.getInt(2));
                }
                var7_8 += var10_11.length;
                var6_6.add((Pair<zzgn.zzk, Long>)Pair.create((Object)((zzgn.zzk)((zzlc)var11_12.zzai())), (Object)var8_9));
            } while (var4_4.moveToNext() && var7_8 <= var3_3);
            var8_10 = var6_6;
            return var8_10;
        }
        catch (SQLiteException var5_23) {
            this.zzj().zzg().zza("Error querying bundles. appId", zzgi.zza((String)var1_1), (Object)var5_23);
            var6_7 = Collections.emptyList();
            return var6_7;
        }
        finally {
            if (var4_4 != null) {
                var4_4.close();
            }
        }
    }

    @WorkerThread
    public final List<zzaf> zza(String string, @Nullable String string2, @Nullable String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzt();
        this.zzal();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            String string4 = string3;
            arrayList.add(string4 + "*");
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zza(stringBuilder.toString(), stringArray);
    }

    public final List<zzaf> zza(String string, String[] stringArray) {
        this.zzt();
        this.zzal();
        ArrayList<zzaf> arrayList = new ArrayList<zzaf>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.e_().query("conditional_properties", new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, string, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzaf> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzj().zzg().zza("Read more than the max allowed conditional properties, ignoring extra", (Object)1000);
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zza(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzbh zzbh2 = (zzbh)this.g_().zza(cursor.getBlob(7), zzbh.CREATOR);
                long l2 = cursor.getLong(8);
                zzbh zzbh3 = (zzbh)this.g_().zza(cursor.getBlob(9), zzbh.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzbh zzbh4 = (zzbh)this.g_().zza(cursor.getBlob(12), zzbh.CREATOR);
                zzok zzok2 = new zzok(string3, l3, object2, string2);
                zzaf zzaf2 = new zzaf((String)object, string2, zzok2, l2, bl, string4, zzbh2, l, zzbh3, l4, zzbh4);
                arrayList.add(zzaf2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    public final List<zznk> zzk(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzt();
        this.zzal();
        ArrayList<zznk> arrayList = new ArrayList<zznk>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.e_().query("trigger_uris", new String[]{"trigger_uri", "timestamp_millis", "source"}, "app_id=?", new String[]{string}, null, null, "rowid", null);
            if (!cursor.moveToFirst()) {
                ArrayList<zznk> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if ((object = cursor.getString(0)) == null) {
                    object = "";
                }
                long l = cursor.getLong(1);
                int n = cursor.getInt(2);
                zznk zznk2 = new zznk((String)object, l, n);
                arrayList.add(zznk2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzom> zzl(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzt();
        this.zzal();
        ArrayList<zzom> arrayList = new ArrayList<zzom>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.e_().query("user_attributes", new String[]{"name", "origin", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", "1000");
            if (!cursor.moveToFirst()) {
                ArrayList<zzom> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zza(cursor, 3);
                if (object2 == null) {
                    this.zzj().zzg().zza("Read invalid user property value, ignoring it. appId", zzgi.zza((String)string));
                    continue;
                }
                zzom zzom2 = new zzom(string, string2, (String)object, l, object2);
                arrayList.add(zzom2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzom> zzb(String string, @Nullable String string2, @Nullable String string3) {
        Object object;
        Preconditions.checkNotEmpty((String)string);
        this.zzt();
        this.zzal();
        ArrayList<zzom> arrayList = new ArrayList<zzom>();
        try (Cursor cursor = null;){
            Object object2;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            object = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                ((StringBuilder)object).append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                String string4 = string3;
                arrayList2.add(string4 + "*");
                ((StringBuilder)object).append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            cursor = this.e_().query("user_attributes", new String[]{"name", "set_timestamp", "value", "origin"}, ((StringBuilder)object).toString(), stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzom> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzj().zzg().zza("Read more than the max allowed user properties, ignoring excess", (Object)1000);
                    break;
                }
                object2 = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object3 = this.zza(cursor, 2);
                string2 = cursor.getString(3);
                if (object3 == null) {
                    this.zzj().zzg().zza("(2)Read invalid user property value, ignoring it", zzgi.zza((String)string), (Object)string2, (Object)string3);
                    continue;
                }
                zzom zzom2 = new zzom(string, string2, (String)object2, l, object3);
                arrayList.add(zzom2);
            } while (cursor.moveToNext());
            object2 = arrayList;
            return object2;
        }
    }

    final Map<Integer, zzgn.zzm> zzm(String string) {
        this.zzal();
        this.zzt();
        Preconditions.checkNotEmpty((String)string);
        SQLiteDatabase sQLiteDatabase = this.e_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, zzgn.zzm> map = Collections.emptyMap();
                return map;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                zzgn.zzm zzm2;
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                try {
                    zzm2 = (zzgn.zzm)((zzlc)zzol.zza(zzgn.zzm.zze(), byArray).zzai());
                }
                catch (IOException iOException) {
                    this.zzj().zzg().zza("Failed to merge filter results. appId, audienceId, error", zzgi.zza((String)string), (Object)n, (Object)iOException);
                    continue;
                }
                arrayMap.put(n, zzm2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    final Map<Integer, List<zzfn.zzb>> zzn(String string) {
        Preconditions.checkNotEmpty((String)string);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.e_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzfn.zzb>> map = Collections.emptyMap();
                return map;
            }
            do {
                zzfn.zzb zzb2;
                byte[] byArray = cursor.getBlob(1);
                try {
                    zzb2 = (zzfn.zzb)((zzlc)zzol.zza(zzfn.zzb.zzc(), byArray).zzai());
                }
                catch (IOException iOException) {
                    this.zzj().zzg().zza("Failed to merge filter. appId", zzgi.zza((String)string), (Object)iOException);
                    continue;
                }
                if (!zzb2.zzk()) continue;
                int n = cursor.getInt(0);
                ArrayList<zzfn.zzb> arrayList = (ArrayList<zzfn.zzb>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzfn.zzb>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzb2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzfn.zzb>> zzf(String string, String string2) {
        this.zzal();
        this.zzt();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.e_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzfn.zzb>> map = Collections.emptyMap();
                return map;
            }
            do {
                zzfn.zzb zzb2;
                byte[] byArray = cursor.getBlob(1);
                try {
                    zzb2 = (zzfn.zzb)((zzlc)zzol.zza(zzfn.zzb.zzc(), byArray).zzai());
                }
                catch (IOException iOException) {
                    this.zzj().zzg().zza("Failed to merge filter. appId", zzgi.zza((String)string), (Object)iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzfn.zzb> arrayList = (ArrayList<zzfn.zzb>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzfn.zzb>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzb2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzfn.zze>> zzg(String string, String string2) {
        this.zzal();
        this.zzt();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.e_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzfn.zze>> map = Collections.emptyMap();
                return map;
            }
            do {
                zzfn.zze zze2;
                byte[] byArray = cursor.getBlob(1);
                try {
                    zze2 = (zzfn.zze)((zzlc)zzol.zza(zzfn.zze.zzc(), byArray).zzai());
                }
                catch (IOException iOException) {
                    this.zzj().zzg().zza("Failed to merge filter", zzgi.zza((String)string), (Object)iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzfn.zze> arrayList = (ArrayList<zzfn.zze>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzfn.zze>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zze2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<Integer>> zzo(String string) {
        this.zzal();
        this.zzt();
        Preconditions.checkNotEmpty((String)string);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.e_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery("select audience_id, filter_id from event_filters where app_id = ? and session_scoped = 1 UNION select audience_id, filter_id from property_filters where app_id = ? and session_scoped = 1;", new String[]{string, string});
            if (!cursor.moveToFirst()) {
                Map<Integer, List<Integer>> map = Collections.emptyMap();
                return map;
            }
            do {
                int n;
                ArrayList<Integer> arrayList;
                if ((arrayList = (ArrayList<Integer>)arrayMap.get(n = cursor.getInt(0))) == null) {
                    arrayList = new ArrayList<Integer>();
                    arrayMap.put(n, arrayList);
                }
                int n2 = cursor.getInt(1);
                arrayList.add(n2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    zzam(zznv zznv2) {
        super(zznv2);
        String string = "google_app_measurement.db";
        this.zzl = new zzav(this, this.zza(), string);
    }

    @WorkerThread
    public final void zzp() {
        this.zzal();
        this.e_().beginTransaction();
    }

    public final void zzp(String string) {
        this.zzt();
        this.zzal();
        try {
            this.e_().execSQL("delete from default_event_params where app_id=?", (Object[])new String[]{string});
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error clearing default event params", (Object)sQLiteException);
            return;
        }
    }

    private final void zzi(String string, String string2) {
        Preconditions.checkNotEmpty((String)string2);
        this.zzt();
        this.zzal();
        try {
            this.e_().delete(string, "app_id=?", new String[]{string2});
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error deleting snapshot. appId", zzgi.zza((String)string2), (Object)sQLiteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void zzq(String string) {
        String string2 = string;
        this.zzi("events_snapshot", string2);
        List<String> list = Collections.singletonList("name");
        Cursor cursor = null;
        try {
            cursor = this.e_().query("events", list.toArray(new String[0]), "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return;
            }
            do {
                zzbd zzbd2;
                String string3;
                if ((string3 = cursor.getString(0)) == null || (zzbd2 = this.zzd(string, string3)) == null) continue;
                string2 = zzbd2;
                this.zza("events_snapshot", (zzbd)string2);
            } while (cursor.moveToNext());
            if (cursor == null) return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error creating snapshot. appId", zzgi.zza((String)string), (Object)sQLiteException);
            return;
        }
        finally {
            if (cursor == null) return;
            cursor.close();
        }
        cursor.close();
        return;
    }

    @WorkerThread
    public final void zzu() {
        this.zzal();
        this.e_().endTransaction();
    }

    @VisibleForTesting
    @WorkerThread
    final void zza(List<Long> list) {
        this.zzt();
        this.zzal();
        Preconditions.checkNotNull(list);
        Preconditions.checkNotZero((int)list.size());
        if (!this.zzaa()) {
            return;
        }
        String string = TextUtils.join((CharSequence)",", list);
        String string2 = "(" + string + ")";
        if (this.zzb("SELECT COUNT(1) FROM queue WHERE rowid IN " + (string = string2) + " AND retry_count =  2147483647 LIMIT 1", (String[])null) > 0L) {
            this.zzj().zzu().zza("The number of upload retries exceeds the limit. Will remain unchanged.");
        }
        try {
            string = string2;
            this.e_().execSQL("UPDATE queue SET retry_count = IFNULL(retry_count, 0) + 1 WHERE rowid IN " + string + " AND (retry_count IS NULL OR retry_count < 2147483647)");
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error incrementing retry count. error", (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    final void zza(Long l) {
        this.zzt();
        this.zzal();
        Preconditions.checkNotNull((Object)l);
        if (zzrw.zza() && !this.zze().zza(zzbj.zzbz)) {
            return;
        }
        if (!this.zzaa()) {
            return;
        }
        Long l2 = l;
        if (this.zzb("SELECT COUNT(1) FROM upload_queue WHERE rowid = " + l2 + " AND retry_count =  2147483647 LIMIT 1", (String[])null) > 0L) {
            this.zzj().zzu().zza("The number of upload retries exceeds the limit. Will remain unchanged.");
        }
        try {
            l2 = l;
            this.e_().execSQL("UPDATE upload_queue SET retry_count = retry_count + 1 WHERE rowid = " + l2 + " AND retry_count < 2147483647");
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error incrementing retry count. error", (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    final void zzv() {
        this.zzt();
        this.zzal();
        if (!this.zzaa()) {
            return;
        }
        long l = this.zzn().zza.zza();
        long l2 = this.zzb().elapsedRealtime();
        if (Math.abs(l2 - l) > zzah.zzp()) {
            this.zzn().zza.zza(l2);
            zzam zzam2 = this;
            zzam2.zzt();
            zzam2.zzal();
            if (zzam2.zzaa()) {
                SQLiteDatabase sQLiteDatabase = zzam2.e_();
                String[] stringArray = new String[]{String.valueOf(zzam2.zzb().currentTimeMillis()), String.valueOf(zzah.zzo())};
                int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
                if (n > 0) {
                    zzam2.zzj().zzp().zza("Deleted stale rows. rowsDeleted", (Object)n);
                }
            }
        }
    }

    @WorkerThread
    public final void zzh(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzt();
        this.zzal();
        try {
            this.e_().delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error deleting user property. appId", zzgi.zza((String)string), (Object)this.zzi().zzc(string2), (Object)sQLiteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzr(String string) {
        Cursor cursor;
        boolean bl;
        boolean bl2;
        String string2;
        zzbd zzbd2;
        zzbd zzbd3;
        block22: {
            block23: {
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("name", "lifetime_count"));
                zzbd3 = this.zzd(string, "_f");
                zzbd2 = this.zzd(string, "_v");
                string2 = string;
                this.zzi("events", string2);
                bl2 = false;
                bl = false;
                cursor = null;
                try {
                    cursor = this.e_().query("events_snapshot", arrayList.toArray(new String[0]), "app_id=?", new String[]{string}, null, null, null);
                    if (!cursor.moveToFirst()) {
                        if (cursor == null) break block22;
                        break block23;
                    }
                    do {
                        String string3;
                        zzbd zzbd4;
                        String string4;
                        block25: {
                            block24: {
                                string4 = cursor.getString(0);
                                if (!this.zze().zza(zzbj.zzde)) break block24;
                                if (cursor.getLong(1) >= 1L) {
                                    if ("_f".equals(string4)) {
                                        bl2 = true;
                                        break block25;
                                    } else if ("_v".equals(string4)) {
                                        bl = true;
                                    }
                                }
                                break block25;
                            }
                            if ("_f".equals(string4)) {
                                bl2 = true;
                            } else if ("_v".equals(string4)) {
                                bl = true;
                            }
                        }
                        if (string4 == null || (zzbd4 = this.zzc("events_snapshot", string2 = string, string3 = string4)) == null) continue;
                        string2 = zzbd4;
                        this.zza("events", (zzbd)string2);
                    } while (cursor.moveToNext());
                    return;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzj().zzg().zza("Error querying snapshot. appId", zzgi.zza((String)string), (Object)sQLiteException);
                    return;
                }
            }
            cursor.close();
        }
        if (zzbd3 != null) {
            string2 = zzbd3;
            this.zza("events", (zzbd)string2);
        } else if (zzbd2 != null) {
            string2 = zzbd2;
            this.zza("events", (zzbd)string2);
        }
        string2 = string;
        this.zzi("events_snapshot", string2);
        return;
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (!bl2 && zzbd3 != null) {
                string2 = zzbd3;
                this.zza("events", (zzbd)string2);
            } else if (!bl && zzbd2 != null) {
                string2 = zzbd2;
                this.zza("events", (zzbd)string2);
            }
            string2 = string;
            this.zzi("events_snapshot", string2);
        }
    }

    @WorkerThread
    private static void zza(ContentValues contentValues, String string, Object object) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
            return;
        }
        if (object instanceof Long) {
            contentValues.put(string, (Long)object);
            return;
        }
        if (object instanceof Double) {
            contentValues.put(string, (Double)object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @WorkerThread
    final void zza(String string, List<zzfn.zza> list) {
        Preconditions.checkNotNull(list);
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            zzmn zzmn2;
            int n;
            zzfn.zza.zza zza2 = (zzfn.zza.zza)list.get(i).zzcd();
            if (zza2.zza() != 0) {
                for (n = 0; n < zza2.zza(); ++n) {
                    zzmn2 = (zzfn.zzb.zza)zza2.zza(n).zzcd();
                    object = (zzfn.zzb.zza)((zzlc.zzb)zzmn2.clone());
                    boolean bl = false;
                    String string2 = zzjf.zzb((String)zzmn2.zzb());
                    if (string2 != null) {
                        ((zzfn.zzb.zza)((Object)object)).zza(string2);
                        bl = true;
                    }
                    for (int j = 0; j < zzmn2.zza(); ++j) {
                        zzfn.zzc zzc2 = zzmn2.zza(j);
                        String string3 = zzje.zza((String)zzc2.zze());
                        if (string3 == null) continue;
                        zzfn.zzc zzc3 = (zzfn.zzc)((zzlc)((zzfn.zzc.zza)zzc2.zzcd()).zza(string3).zzai());
                        ((zzfn.zzb.zza)((Object)object)).zza(j, zzc3);
                        bl = true;
                    }
                    if (!bl) continue;
                    zza2 = zza2.zza(n, (zzfn.zzb.zza)((Object)object));
                    list.set(i, (zzfn.zza)((zzlc)zza2.zzai()));
                }
            }
            if (zza2.zzb() == 0) continue;
            for (n = 0; n < zza2.zzb(); ++n) {
                zzmn2 = zza2.zzb(n);
                object = zzjh.zza((String)zzmn2.zze());
                if (object == null) continue;
                zza2 = zza2.zza(n, ((zzfn.zze.zza)zzmn2.zzcd()).zza((String)object));
                list.set(i, (zzfn.zza)((zzlc)zza2.zzai()));
            }
        }
        List<zzfn.zza> list2 = list;
        String string4 = string;
        zzam zzam2 = this;
        zzam2.zzal();
        zzam2.zzt();
        Preconditions.checkNotEmpty((String)string4);
        Preconditions.checkNotNull(list2);
        SQLiteDatabase sQLiteDatabase = zzam2.e_();
        sQLiteDatabase.beginTransaction();
        try {
            String string5 = string4;
            zzam zzam3 = zzam2;
            zzam3.zzal();
            zzam3.zzt();
            Preconditions.checkNotEmpty((String)string5);
            Object object = zzam3.e_();
            object.delete("property_filters", "app_id=?", new String[]{string5});
            object.delete("event_filters", "app_id=?", new String[]{string5});
            Object object2 = list2.iterator();
            block7: while (object2.hasNext()) {
                Object object3;
                object = object3 = object2.next();
                string5 = string4;
                zzam3 = zzam2;
                zzam3.zzal();
                zzam3.zzt();
                Preconditions.checkNotEmpty((String)string5);
                Preconditions.checkNotNull((Object)object);
                if (!((zzfn.zza)((Object)object)).zzg()) {
                    zzam3.zzj().zzu().zza("Audience with no ID. appId", zzgi.zza((String)string5));
                    continue;
                }
                int n = ((zzfn.zza)((Object)object)).zza();
                Iterator<zzlc> iterator = ((zzfn.zza)((Object)object)).zze().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().zzl()) continue;
                    zzam3.zzj().zzu().zza("Event filter with no ID. Audience definition ignored. appId, audienceId", zzgi.zza((String)string5), (Object)n);
                    continue block7;
                }
                iterator = ((zzfn.zza)((Object)object)).zzf().iterator();
                while (iterator.hasNext()) {
                    if (((zzfn.zze)iterator.next()).zzi()) continue;
                    zzam3.zzj().zzu().zza("Property filter with no ID. Audience definition ignored. appId, audienceId", zzgi.zza((String)string5), (Object)n);
                    continue block7;
                }
                boolean bl = true;
                for (zzfn.zzb zzb2 : ((zzfn.zza)((Object)object)).zze()) {
                    if (zzam3.zza(string5, n, zzb2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    for (zzfn.zze zze2 : ((zzfn.zza)((Object)object)).zzf()) {
                        if (zzam3.zza(string5, n, zze2)) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                int n2 = n;
                String string2 = string5;
                zzam zzam4 = zzam3;
                zzam4.zzal();
                zzam4.zzt();
                Preconditions.checkNotEmpty((String)string2);
                SQLiteDatabase sQLiteDatabase2 = zzam4.e_();
                sQLiteDatabase2.delete("property_filters", "app_id=? and audience_id=?", new String[]{string2, String.valueOf(n2)});
                sQLiteDatabase2.delete("event_filters", "app_id=? and audience_id=?", new String[]{string2, String.valueOf(n2)});
            }
            object2 = new ArrayList();
            for (zzfn.zza zza2 : list2) {
                object2.add(zza2.zzg() ? Integer.valueOf(zza2.zza()) : null);
            }
            zzam2.zzb(string4, (List<Integer>)object2);
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    public final void zzw() {
        this.zzal();
        this.e_().setTransactionSuccessful();
    }

    @WorkerThread
    public final void zza(zzh zzh2, boolean bl, boolean bl2) {
        List<String> list;
        ContentValues contentValues;
        String string;
        block26: {
            block25: {
                block24: {
                    block22: {
                        block23: {
                            Preconditions.checkNotNull((Object)zzh2);
                            this.zzt();
                            this.zzal();
                            string = zzh2.zzac();
                            Preconditions.checkNotNull((Object)string);
                            contentValues = new ContentValues();
                            contentValues.put("app_id", string);
                            if (!zzpd.zza() || !this.zze().zza(zzbj.zzdc)) break block22;
                            if (!bl) break block23;
                            contentValues.put("app_instance_id", null);
                            break block24;
                        }
                        if (!this.zzg.zzb(string).zza(zzjc.zza.zzb)) break block24;
                    }
                    contentValues.put("app_instance_id", zzh2.zzad());
                }
                contentValues.put("gmp_app_id", zzh2.zzah());
                if (!zzpd.zza() || !this.zze().zza(zzbj.zzdc) || this.zzg.zzb(string).zza(zzjc.zza.zza)) {
                    contentValues.put("resettable_device_id_hash", zzh2.zzaj());
                }
                contentValues.put("last_bundle_index", Long.valueOf(zzh2.zzt()));
                contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzh2.zzu()));
                contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzh2.zzs()));
                contentValues.put("app_version", zzh2.zzaf());
                contentValues.put("app_store", zzh2.zzae());
                contentValues.put("gmp_version", Long.valueOf(zzh2.zzq()));
                contentValues.put("dev_cert_hash", Long.valueOf(zzh2.zzn()));
                contentValues.put("measurement_enabled", Boolean.valueOf(zzh2.zzar()));
                contentValues.put("day", Long.valueOf(zzh2.zzm()));
                contentValues.put("daily_public_events_count", Long.valueOf(zzh2.zzk()));
                contentValues.put("daily_events_count", Long.valueOf(zzh2.zzj()));
                contentValues.put("daily_conversions_count", Long.valueOf(zzh2.zzh()));
                contentValues.put("config_fetched_time", Long.valueOf(zzh2.zzg()));
                contentValues.put("failed_config_fetch_time", Long.valueOf(zzh2.zzp()));
                contentValues.put("app_version_int", Long.valueOf(zzh2.zze()));
                contentValues.put("firebase_instance_id", zzh2.zzag());
                contentValues.put("daily_error_events_count", Long.valueOf(zzh2.zzi()));
                contentValues.put("daily_realtime_events_count", Long.valueOf(zzh2.zzl()));
                contentValues.put("health_monitor_sample", zzh2.zzai());
                contentValues.put("android_id", Long.valueOf(zzh2.zzd()));
                contentValues.put("adid_reporting_enabled", Boolean.valueOf(zzh2.zzaq()));
                contentValues.put("admob_app_id", zzh2.zzaa());
                contentValues.put("dynamite_version", Long.valueOf(zzh2.zzo()));
                if (!zzpd.zza() || !this.zze().zza(zzbj.zzdc)) break block25;
                if (!this.zzg.zzb(string).zza(zzjc.zza.zzb)) break block26;
            }
            contentValues.put("session_stitching_token", zzh2.zzal());
        }
        contentValues.put("sgtm_upload_enabled", Boolean.valueOf(zzh2.zzat()));
        contentValues.put("target_os_version", Long.valueOf(zzh2.zzw()));
        contentValues.put("session_stitching_token_hash", Long.valueOf(zzh2.zzv()));
        if (zzrl.zza() && this.zze().zze(string, zzbj.zzcg)) {
            contentValues.put("ad_services_version", Integer.valueOf(zzh2.zza()));
            contentValues.put("attribution_eligibility_status", Long.valueOf(zzh2.zzf()));
        }
        if (zzpo.zza() && this.zze().zze(string, zzbj.zzcr)) {
            contentValues.put("unmatched_first_open_without_ad_id", Boolean.valueOf(zzh2.zzau()));
        }
        contentValues.put("npa_metadata_value", zzh2.zzx());
        if (zzrw.zza() && this.zze().zze(string, zzbj.zzbw)) {
            this.zzq();
            if (zzop.zzf((String)string)) {
                contentValues.put("bundle_delivery_index", Long.valueOf(zzh2.zzr()));
            }
        }
        if (zzrw.zza() && this.zze().zze(string, zzbj.zzbx)) {
            contentValues.put("sgtm_preview_key", zzh2.zzam());
        }
        contentValues.put("dma_consent_state", Integer.valueOf(zzh2.zzc()));
        contentValues.put("daily_realtime_dcu_count", Integer.valueOf(zzh2.zzb()));
        if (zzox.zza() && this.zze().zze(string, zzbj.zzcw)) {
            contentValues.put("serialized_npa_metadata", zzh2.zzak());
        }
        if ((list = zzh2.zzan()) != null) {
            if (list.isEmpty()) {
                this.zzj().zzu().zza("Safelisted events should not be an empty list. appId", (Object)string);
            } else {
                contentValues.put("safelisted_events", TextUtils.join((CharSequence)",", list));
            }
        }
        if (zzpv.zza() && this.zze().zza(zzbj.zzbt) && !contentValues.containsKey("safelisted_events")) {
            contentValues.put("safelisted_events", null);
        }
        if (this.zze().zza(zzbj.zzcz)) {
            contentValues.put("unmatched_pfo", zzh2.zzy());
            contentValues.put("unmatched_uwa", zzh2.zzz());
        }
        if (zzqn.zza() && this.zze().zze(string, zzbj.zzct)) {
            contentValues.put("ad_campaign_info", zzh2.zzav());
        }
        try {
            SQLiteDatabase sQLiteDatabase = this.e_();
            if ((long)sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{string}) == 0L && sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert/update app (got -1). appId", zzgi.zza((String)string));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing app. appId", zzgi.zza((String)string), (Object)sQLiteException);
            return;
        }
    }

    public final void zza(String string, zzaz zzaz2) {
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkNotNull((Object)zzaz2);
        this.zzt();
        this.zzal();
        if (this.zze().zza(zzbj.zzcq) && this.zzi(string) == zzjc.zza) {
            this.zzb(string, zzjc.zza);
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("dma_consent_settings", zzaz2.zzf());
        this.zza("consent_settings", "app_id", contentValues);
    }

    @WorkerThread
    public final void zza(zzbd zzbd2) {
        this.zza("events", zzbd2);
    }

    @WorkerThread
    private final void zza(String string, zzbd zzbd2) {
        Preconditions.checkNotNull((Object)zzbd2);
        this.zzt();
        this.zzal();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzbd2.zza);
        contentValues.put("name", zzbd2.zzb);
        contentValues.put("lifetime_count", Long.valueOf(zzbd2.zzc));
        contentValues.put("current_bundle_count", Long.valueOf(zzbd2.zzd));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzbd2.zzf));
        contentValues.put("last_bundled_timestamp", Long.valueOf(zzbd2.zzg));
        contentValues.put("last_bundled_day", zzbd2.zzh);
        contentValues.put("last_sampled_complex_event_id", zzbd2.zzi);
        contentValues.put("last_sampling_rate", zzbd2.zzj);
        contentValues.put("current_session_count", Long.valueOf(zzbd2.zze));
        Long l = null;
        if (zzbd2.zzk != null && zzbd2.zzk.booleanValue()) {
            l = 1L;
        }
        contentValues.put("last_exempt_from_sampling", l);
        try {
            if (this.e_().insertWithOnConflict(string, null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert/update event aggregates (got -1). appId", zzgi.zza((String)zzbd2.zza));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing event aggregates. appId", zzgi.zza((String)zzbd2.zza), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    private final void zza(String string, String string2, ContentValues contentValues) {
        try {
            SQLiteDatabase sQLiteDatabase = this.e_();
            String string3 = contentValues.getAsString(string2);
            if (string3 == null) {
                this.zzj().zzh().zza("Value of the primary key is not set.", zzgi.zza((String)string2));
                return;
            }
            String string4 = string2;
            if ((long)sQLiteDatabase.update(string, contentValues, string4 + " = ?", new String[]{string3}) == 0L && sQLiteDatabase.insertWithOnConflict(string, null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert/update table (got -1). key", zzgi.zza((String)string), zzgi.zza((String)string2));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing into table. key", zzgi.zza((String)string), zzgi.zza((String)string2), (Object)sQLiteException);
            return;
        }
    }

    public final void zza(String string, zzjc zzjc2) {
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkNotNull((Object)zzjc2);
        this.zzt();
        this.zzal();
        this.zzb(string, this.zzi(string));
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("storage_consent_at_bundling", zzjc2.zzh());
        this.zza("consent_settings", "app_id", contentValues);
    }

    public final void zzb(String string, zzjc zzjc2) {
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkNotNull((Object)zzjc2);
        this.zzt();
        this.zzal();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("consent_state", zzjc2.zzh());
        contentValues.put("consent_source", Integer.valueOf(zzjc2.zza()));
        this.zza("consent_settings", "app_id", contentValues);
    }

    private final boolean zzb(String string, List<@Nullable Integer> list) {
        String string2;
        long l;
        Preconditions.checkNotEmpty((String)string);
        this.zzal();
        this.zzt();
        SQLiteDatabase sQLiteDatabase = this.e_();
        try {
            l = this.zzb("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Database error querying filters. appId", zzgi.zza((String)string), (Object)sQLiteException);
            return false;
        }
        int n = this.zze().zzb(string, zzbj.zzah);
        n = Math.min(2000, n);
        int n2 = Math.max(0, n);
        if (l <= (long)n2) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            Integer n3 = list.get(i);
            if (n3 == null) {
                return false;
            }
            arrayList.add(Integer.toString(n3));
        }
        String string3 = TextUtils.join((CharSequence)",", arrayList);
        string3 = string2 = "(" + string3 + ")";
        return sQLiteDatabase.delete("audience_filter_values", "audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in " + string3 + " order by rowid desc limit -1 offset ?)", new String[]{string, Integer.toString(n2)}) > 0;
    }

    public final boolean zzx() {
        return this.zzb("select count(1) > 0 from raw_events", (String[])null) != 0L;
    }

    public final boolean zzy() {
        return this.zzb("select count(1) > 0 from queue where has_realtime = 1", (String[])null) != 0L;
    }

    public final boolean zzz() {
        return this.zzb("select count(1) > 0 from raw_events where realtime = 1", (String[])null) != 0L;
    }

    @WorkerThread
    public final boolean zzs(String string) {
        if (zzrw.zza() && !this.zze().zza(zzbj.zzbz)) {
            return false;
        }
        String string2 = this.zzao();
        return this.zzb("SELECT COUNT(1) > 0 FROM upload_queue WHERE " + string2, new String[]{string}) != 0L;
    }

    @WorkerThread
    public final boolean zza(zzgn.zzk zzk2, boolean bl) {
        this.zzt();
        this.zzal();
        Preconditions.checkNotNull((Object)((Object)zzk2));
        Preconditions.checkNotEmpty((String)zzk2.zzz());
        Preconditions.checkState((boolean)zzk2.zzbj());
        this.zzv();
        long l = this.zzb().currentTimeMillis();
        if (zzk2.zzm() < l - zzah.zzo() || zzk2.zzm() > l + zzah.zzo()) {
            this.zzj().zzu().zza("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzgi.zza((String)zzk2.zzz()), (Object)l, (Object)zzk2.zzm());
        }
        byte[] byArray = zzk2.zzca();
        try {
            byArray = this.g_().zzb(byArray);
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Data loss. Failed to serialize bundle. appId", zzgi.zza((String)zzk2.zzz()), (Object)iOException);
            return false;
        }
        this.zzj().zzp().zza("Saving bundle, size", (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzk2.zzz());
        contentValues.put("bundle_end_timestamp", Long.valueOf(zzk2.zzm()));
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        if (zzk2.zzbq()) {
            contentValues.put("retry_count", Integer.valueOf(zzk2.zzg()));
        }
        try {
            if (this.e_().insert("queue", null, contentValues) == -1L) {
                this.zzj().zzg().zza("Failed to insert bundle (got -1). appId", zzgi.zza((String)zzk2.zzz()));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing bundle. appId", zzgi.zza((String)zzk2.zzz()), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzfn.zzb zzb2) {
        this.zzal();
        this.zzt();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zzb2));
        if (zzb2.zzf().isEmpty()) {
            this.zzj().zzu().zza("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzgi.zza((String)string), (Object)n, (Object)String.valueOf(zzb2.zzl() ? Integer.valueOf(zzb2.zzb()) : null));
            return false;
        }
        byte[] byArray = zzb2.zzca();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzb2.zzl() ? Integer.valueOf(zzb2.zzb()) : null);
        contentValues.put("event_name", zzb2.zzf());
        contentValues.put("session_scoped", zzb2.zzm() ? Boolean.valueOf(zzb2.zzj()) : null);
        contentValues.put("data", byArray);
        try {
            if (this.e_().insertWithOnConflict("event_filters", null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert event filter (got -1). appId", zzgi.zza((String)string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing event filter. appId", zzgi.zza((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzfn.zze zze2) {
        this.zzal();
        this.zzt();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zze2));
        if (zze2.zze().isEmpty()) {
            this.zzj().zzu().zza("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzgi.zza((String)string), (Object)n, (Object)String.valueOf(zze2.zzi() ? Integer.valueOf(zze2.zza()) : null));
            return false;
        }
        byte[] byArray = zze2.zzca();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zze2.zzi() ? Integer.valueOf(zze2.zza()) : null);
        contentValues.put("property_name", zze2.zze());
        contentValues.put("session_scoped", zze2.zzj() ? Boolean.valueOf(zze2.zzh()) : null);
        contentValues.put("data", byArray);
        try {
            if (this.e_().insertWithOnConflict("property_filters", null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert property filter (got -1). appId", zzgi.zza((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing property filter. appId", zzgi.zza((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    public final boolean zza(zzba zzba2, long l, boolean bl) {
        this.zzt();
        this.zzal();
        Preconditions.checkNotNull((Object)zzba2);
        Preconditions.checkNotEmpty((String)zzba2.zza);
        byte[] byArray = this.g_().zza(zzba2).zzca();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzba2.zza);
        contentValues.put("name", zzba2.zzb);
        contentValues.put("timestamp", Long.valueOf(zzba2.zzd));
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("data", byArray);
        contentValues.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.e_().insert("raw_events", null, contentValues) == -1L) {
                this.zzj().zzg().zza("Failed to insert raw event (got -1). appId", zzgi.zza((String)zzba2.zza));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing raw event. appId", zzgi.zza((String)zzba2.zza), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final boolean zza(String string, zznk zznk2) {
        this.zzt();
        this.zzal();
        Preconditions.checkNotNull((Object)zznk2);
        Preconditions.checkNotEmpty((String)string);
        long l = this.zzb().currentTimeMillis();
        if (zznk2.zzb < l - zzah.zzo() || zznk2.zzb > l + zzah.zzo()) {
            this.zzj().zzu().zza("Storing trigger URI outside of the max retention time span. appId, now, timestamp", zzgi.zza((String)string), (Object)l, (Object)zznk2.zzb);
        }
        this.zzj().zzp().zza("Saving trigger URI");
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("trigger_uri", zznk2.zza);
        contentValues.put("source", Integer.valueOf(zznk2.zzc));
        contentValues.put("timestamp_millis", Long.valueOf(zznk2.zzb));
        try {
            if (this.e_().insert("trigger_uris", null, contentValues) == -1L) {
                this.zzj().zzg().zza("Failed to insert trigger URI (got -1). appId", zzgi.zza((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing trigger URI. appId", zzgi.zza((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final boolean zza(String string, @NonNull zzgn.zzj zzj2, @NonNull String string2, @NonNull Map<String, String> map, zznt zznt2) {
        this.zzt();
        this.zzal();
        Preconditions.checkNotNull((Object)((Object)zzj2));
        Preconditions.checkNotEmpty((String)string);
        if (zzrw.zza() && !this.zze().zza(zzbj.zzbz)) {
            return false;
        }
        Object object = this;
        object.zzt();
        object.zzal();
        if (object.zzaa()) {
            long l = object.zzn().zzb.zza();
            long l2 = object.zzb().elapsedRealtime();
            if (Math.abs(l2 - l) > zzah.zzp()) {
                object.zzn().zzb.zza(l2);
                zzam zzam2 = object;
                zzam2.zzt();
                zzam2.zzal();
                if (zzam2.zzaa()) {
                    SQLiteDatabase sQLiteDatabase = zzam2.e_();
                    long l3 = zzam2.zzb().currentTimeMillis();
                    long l4 = zzah.zzm();
                    int n = zznt.zzb.zza();
                    new StringBuilder("(upload_type = ").append(n).append(" AND (ABS(creation_timestamp - ").append(l3).append(") > CAST(").append(l4).append(" AS INTEGER)))");
                    l4 = zzah.zzo();
                    n = zznt.zzb.zza();
                    new StringBuilder("(upload_type != ").append(n).append(" AND (ABS(creation_timestamp - ").append(l3).append(") > CAST(").append(l4).append(" AS INTEGER)))");
                    String[] stringArray = new String[]{};
                    int n2 = sQLiteDatabase.delete("upload_queue", "ABS(creation_timestamp - ?) > CAST(? as integer)", stringArray);
                    if (n2 > 0) {
                        zzam2.zzj().zzp().zza("Deleted stale MeasurementBatch rows from upload_queue. rowsDeleted", (Object)n2);
                    }
                }
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, String> contentValues2 : map.entrySet()) {
            String string3 = contentValues2.getValue();
            String string4 = contentValues2.getKey();
            arrayList.add(string4 + "=" + string3);
        }
        Object object2 = zzj2.zzca();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("measurement_batch", (byte[])object2);
        contentValues.put("upload_uri", string2);
        ArrayList<String> arrayList2 = arrayList;
        object = "\r\n";
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList3 = arrayList2;
        int n = arrayList3.size();
        int n2 = 0;
        if (n > 0) {
            ++n2;
            stringBuilder.append((CharSequence)arrayList3.get(0));
            while (n2 < n) {
                stringBuilder.append((CharSequence)object);
                Object e = arrayList3.get(n2);
                ++n2;
                stringBuilder.append((CharSequence)e);
            }
        }
        contentValues.put("upload_headers", stringBuilder.toString());
        contentValues.put("upload_type", Integer.valueOf(zznt2.zza()));
        contentValues.put("creation_timestamp", Long.valueOf(this.zzb().currentTimeMillis()));
        contentValues.put("retry_count", Integer.valueOf(0));
        try {
            if (this.e_().insert("upload_queue", null, contentValues) == -1L) {
                this.zzj().zzg().zza("Failed to insert MeasurementBatch (got -1) to upload_queue. appId", (Object)string);
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing MeasurementBatch to upload_queue. appId", (Object)string, (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @VisibleForTesting
    protected final boolean zzaa() {
        return this.zza().getDatabasePath("google_app_measurement.db").exists();
    }

    @Override
    protected final boolean zzc() {
        return false;
    }

    public final boolean zza(String string, Long l, long l2, zzgn.zzf zzf2) {
        this.zzt();
        this.zzal();
        Preconditions.checkNotNull((Object)((Object)zzf2));
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)l);
        byte[] byArray = zzf2.zzca();
        this.zzj().zzp().zza("Saving complex main event, appId, data size", (Object)this.zzi().zza(string), (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("event_id", l);
        contentValues.put("children_to_process", Long.valueOf(l2));
        contentValues.put("main_event", byArray);
        try {
            if (this.e_().insertWithOnConflict("main_event_params", null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert complex main event (got -1). appId", zzgi.zza((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing complex main event. appId", zzgi.zza((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final boolean zza(zzaf zzaf2) {
        Preconditions.checkNotNull((Object)zzaf2);
        this.zzt();
        this.zzal();
        String string = zzaf2.zza;
        Preconditions.checkNotNull((Object)string);
        if (this.zze(string, zzaf2.zzc.zza) == null && this.zzb("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{string}) >= 1000L) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("origin", zzaf2.zzb);
        contentValues.put("name", zzaf2.zzc.zza);
        zzam.zza(contentValues, "value", Preconditions.checkNotNull((Object)zzaf2.zzc.zza()));
        contentValues.put("active", Boolean.valueOf(zzaf2.zze));
        contentValues.put("trigger_event_name", zzaf2.zzf);
        contentValues.put("trigger_timeout", Long.valueOf(zzaf2.zzh));
        this.zzq();
        contentValues.put("timed_out_event", zzop.zza((Parcelable)zzaf2.zzg));
        contentValues.put("creation_timestamp", Long.valueOf(zzaf2.zzd));
        this.zzq();
        contentValues.put("triggered_event", zzop.zza((Parcelable)zzaf2.zzi));
        contentValues.put("triggered_timestamp", Long.valueOf(zzaf2.zzc.zzb));
        contentValues.put("time_to_live", Long.valueOf(zzaf2.zzj));
        this.zzq();
        contentValues.put("expired_event", zzop.zza((Parcelable)zzaf2.zzk));
        try {
            if (this.e_().insertWithOnConflict("conditional_properties", null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert/update conditional user property (got -1)", zzgi.zza((String)string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing conditional user property", zzgi.zza((String)string), (Object)sQLiteException);
        }
        return true;
    }

    final boolean zza(String string, Bundle bundle) {
        this.zzt();
        this.zzal();
        zzba zzba2 = new zzba(this.zzu, "", string, "dep", 0L, 0L, bundle);
        byte[] byArray = this.g_().zza(zzba2).zzca();
        this.zzj().zzp().zza("Saving default event parameters, appId, data size", (Object)this.zzi().zza(string), (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("parameters", byArray);
        try {
            if (this.e_().insertWithOnConflict("default_event_params", null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert default event parameters (got -1). appId", zzgi.zza((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing default event parameters. appId", zzgi.zza((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    public final boolean zza(long l, zzba zzba2, long l2, boolean bl) {
        this.zzt();
        this.zzal();
        Preconditions.checkNotNull((Object)zzba2);
        Preconditions.checkNotEmpty((String)zzba2.zza);
        byte[] byArray = this.g_().zza(zzba2).zzca();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzba2.zza);
        contentValues.put("name", zzba2.zzb);
        contentValues.put("timestamp", Long.valueOf(zzba2.zzd));
        contentValues.put("metadata_fingerprint", Long.valueOf(l2));
        contentValues.put("data", byArray);
        contentValues.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            long l3 = this.e_().update("raw_events", contentValues, "rowid = ?", new String[]{String.valueOf(l)});
            if (l3 != 1L) {
                this.zzj().zzg().zza("Failed to update raw event. appId, updatedRows", zzgi.zza((String)zzba2.zza), (Object)l3);
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error updating raw event. appId", zzgi.zza((String)zzba2.zza), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final boolean zza(zzom zzom2) {
        Preconditions.checkNotNull((Object)zzom2);
        this.zzt();
        this.zzal();
        if (this.zze(zzom2.zza, zzom2.zzc) == null && (zzop.zzh((String)zzom2.zzc) ? this.zzb("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzom2.zza}) >= (long)this.zze().zza(zzom2.zza, zzbj.zzai, 25, 100) : !"_npa".equals(zzom2.zzc) && this.zzb("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzom2.zza, zzom2.zzb}) >= 25L)) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzom2.zza);
        contentValues.put("origin", zzom2.zzb);
        contentValues.put("name", zzom2.zzc);
        contentValues.put("set_timestamp", Long.valueOf(zzom2.zzd));
        zzam.zza(contentValues, "value", zzom2.zze);
        try {
            if (this.e_().insertWithOnConflict("user_attributes", null, contentValues, 5) == -1L) {
                this.zzj().zzg().zza("Failed to insert/update user property (got -1). appId", zzgi.zza((String)zzom2.zza));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzj().zzg().zza("Error storing user property. appId", zzgi.zza((String)zzom2.zza), (Object)sQLiteException);
        }
        return true;
    }

    static /* bridge */ /* synthetic */ String[] zzab() {
        return zzi;
    }

    static /* bridge */ /* synthetic */ String[] zzac() {
        return zzc;
    }

    static /* bridge */ /* synthetic */ String[] zzad() {
        return zzj;
    }

    static /* bridge */ /* synthetic */ String[] zzae() {
        return zza;
    }

    static /* bridge */ /* synthetic */ String[] zzaf() {
        return zzf;
    }

    static /* bridge */ /* synthetic */ String[] zzag() {
        return zzh;
    }

    static /* bridge */ /* synthetic */ String[] zzah() {
        return zze;
    }

    static /* bridge */ /* synthetic */ String[] zzai() {
        return zzd;
    }

    static /* bridge */ /* synthetic */ String[] zzaj() {
        return zzk;
    }

    static /* bridge */ /* synthetic */ String[] zzak() {
        return zzb;
    }
}

