/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.stats.zzb;
import com.google.android.gms.measurement.AppMeasurementService;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzy;
import java.util.ArrayList;
import java.util.List;

public class zzab
extends zzy {
    private final zza zzaOl;
    private zzm zzaOm;
    private Boolean zzaOn;
    private final zze zzaOo;
    private final zzac zzaOp;
    private final List<Runnable> zzaOq = new ArrayList<Runnable>();
    private final zze zzaOr;

    protected zzab(zzv zzv2) {
        super(zzv2);
        this.zzaOp = new zzac(zzv2.zzit());
        this.zzaOl = new zza();
        this.zzaOo = new zze(zzv2){

            @Override
            public void run() {
                zzab.this.zziS();
            }
        };
        this.zzaOr = new zze(zzv2){

            @Override
            public void run() {
                zzab.this.zzyd().zzzL().zzec("Tasks have been queued for a long time");
            }
        };
    }

    @Override
    protected void zzhR() {
    }

    public boolean isConnected() {
        this.zzis();
        this.zziE();
        return this.zzaOm != null;
    }

    protected void zzAr() {
        this.zzis();
        this.zziE();
        this.zzj(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzab.this.zzaOm;
                if (zzm2 == null) {
                    zzab.this.zzyd().zzzK().zzec("Discarding data. Failed to send app launch");
                    return;
                }
                try {
                    zzm2.zza(zzab.this.zzzo().zzzG());
                    zzab.this.zziR();
                }
                catch (RemoteException remoteException) {
                    zzab.this.zzyd().zzzK().zzj("Failed to send app launch to AppMeasurementService", (Object)remoteException);
                }
            }
        });
    }

    private void zziR() {
        this.zzis();
        this.zzaOp.start();
        this.zzaOo.zzt(this.zzzt().zzjV());
    }

    private void zzjg() {
        this.zzis();
        this.zziE();
        if (this.isConnected()) {
            return;
        }
        if (this.zzaOn == null) {
            this.zzaOn = this.zzzs().zzzW();
            if (this.zzaOn == null) {
                this.zzyd().zzzQ().zzec("State of service unknown");
                this.zzaOn = this.zzAt();
                this.zzzs().zzan(this.zzaOn);
            }
        }
        if (this.zzaOn.booleanValue()) {
            this.zzyd().zzzQ().zzec("Using measurement service");
            this.zzaOl.zzAw();
        } else {
            if (this.zzAs()) {
                this.zzyd().zzzQ().zzec("Using local app measurement service");
                Intent intent = new Intent("com.google.android.gms.measurement.START");
                intent.setComponent(new ComponentName(this.getContext(), AppMeasurementService.class));
                this.zzaOl.zzu(intent);
                return;
            }
            if (this.zzzt().zzjB()) {
                this.zzyd().zzzQ().zzec("Using direct local measurement implementation");
                this.zza(new zzw(this.zzaKG, true));
            } else {
                this.zzyd().zzzK().zzec("Not in main process. Unable to use local measurement implementation. Please register the AppMeasurementService service in the app manifest");
            }
        }
    }

    private boolean zzAs() {
        Intent intent;
        PackageManager packageManager = this.getContext().getPackageManager();
        List list = packageManager.queryIntentServices(intent = new Intent(this.getContext(), AppMeasurementService.class), 65536);
        return list != null && list.size() > 0;
    }

    private boolean zzAt() {
        this.zzis();
        this.zziE();
        if (this.zzzt().zzjA()) {
            return true;
        }
        Intent intent = new Intent("com.google.android.gms.measurement.START");
        intent.setComponent(new ComponentName("com.google.android.gms", "com.google.android.gms.measurement.service.MeasurementBrokerService"));
        zzb zzb2 = zzb.zzqh();
        this.zzyd().zzzQ().zzec("Checking service availability");
        if (zzb2.zza(this.getContext(), intent, new ServiceConnection(){

            public void onServiceConnected(ComponentName name, IBinder binder) {
            }

            public void onServiceDisconnected(ComponentName name) {
            }
        }, 0)) {
            this.zzyd().zzzQ().zzec("Service available");
            return true;
        }
        return false;
    }

    private void zza(zzm zzm2) {
        this.zzis();
        zzx.zzw((Object)zzm2);
        this.zzaOm = zzm2;
        this.zziR();
        this.zzAv();
    }

    public void disconnect() {
        this.zzis();
        this.zziE();
        try {
            zzb zzb2 = zzb.zzqh();
            zzb2.zza(this.getContext(), (ServiceConnection)this.zzaOl);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.zzaOm != null) {
            this.zzaOm = null;
        }
    }

    private void onServiceDisconnected(ComponentName name) {
        this.zzis();
        if (this.zzaOm != null) {
            this.zzaOm = null;
            this.zzyd().zzzQ().zzj("Disconnected from device MeasurementService", name);
            this.zzAu();
        }
    }

    private void zziS() {
        this.zzis();
        if (!this.isConnected()) {
            return;
        }
        this.zzyd().zzzQ().zzec("Inactivity, disconnecting from AppMeasurementService");
        this.disconnect();
    }

    private void zzAu() {
        this.zzis();
        this.zzjg();
    }

    private void zzj(Runnable runnable) throws IllegalStateException {
        this.zzis();
        if (this.isConnected()) {
            runnable.run();
        } else {
            if ((long)this.zzaOq.size() >= this.zzzt().zzze()) {
                this.zzyd().zzzK().zzec("Discarding data. Max runnable queue size reached");
                return;
            }
            this.zzaOq.add(runnable);
            this.zzaOr.zzt(60000L);
            this.zzjg();
        }
    }

    private void zzAv() {
        this.zzis();
        this.zzyd().zzzQ().zzj("Flushing task queue", this.zzaOq.size());
        for (Runnable runnable : this.zzaOq) {
            this.zzzr().zzh(runnable);
        }
        this.zzaOq.clear();
        this.zzaOr.cancel();
    }

    protected class zza
    implements ServiceConnection,
    GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private volatile boolean zzaOt;
        private volatile zzo zzaOu;

        protected zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzu(Intent intent) {
            zzab.this.zzis();
            Context context = zzab.this.getContext();
            zzb zzb2 = zzb.zzqh();
            zza zza2 = this;
            synchronized (zza2) {
                if (this.zzaOt) {
                    zzab.this.zzyd().zzzQ().zzec("Connection attempt already in progress");
                    return;
                }
                this.zzaOt = true;
                zzb2.zza(context, intent, (ServiceConnection)zzab.this.zzaOl, 129);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder binder) {
            zzx.zzci((String)"MeasurementServiceConnection.onServiceConnected");
            zza zza2 = this;
            synchronized (zza2) {
                Object object;
                this.zzaOt = false;
                if (binder == null) {
                    zzab.this.zzyd().zzzK().zzec("Service connected with null binder");
                    return;
                }
                zzm zzm2 = null;
                try {
                    object = binder.getInterfaceDescriptor();
                    if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(object)) {
                        zzm2 = zzm.zza.zzcZ(binder);
                        zzab.this.zzyd().zzzQ().zzec("Bound to IMeasurementService interface");
                    } else {
                        zzab.this.zzyd().zzzK().zzj("Got binder with a wrong descriptor", object);
                    }
                }
                catch (RemoteException remoteException) {
                    zzab.this.zzyd().zzzK().zzec("Service connect failed to get IMeasurementService");
                }
                if (zzm2 == null) {
                    try {
                        zzb.zzqh().zza(zzab.this.getContext(), (ServiceConnection)zzab.this.zzaOl);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else {
                    object = zzm2;
                    zzab.this.zzzr().zzh(new Runnable((zzm)object){
                        final /* synthetic */ zzm zzaOv;
                        {
                            this.zzaOv = zzm2;
                        }

                        @Override
                        public void run() {
                            if (!zzab.this.isConnected()) {
                                zzab.this.zzyd().zzzP().zzec("Connected to service");
                                zzab.this.zza(this.zzaOv);
                            }
                        }
                    });
                }
            }
        }

        public void onServiceDisconnected(final ComponentName name) {
            zzx.zzci((String)"MeasurementServiceConnection.onServiceDisconnected");
            zzab.this.zzzr().zzh(new Runnable(){

                @Override
                public void run() {
                    zzab.this.onServiceDisconnected(name);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzAw() {
            zzab.this.zzis();
            Context context = zzab.this.getContext();
            zza zza2 = this;
            synchronized (zza2) {
                if (this.zzaOt) {
                    zzab.this.zzyd().zzzQ().zzec("Connection attempt already in progress");
                    return;
                }
                if (this.zzaOu != null) {
                    zzab.this.zzyd().zzzQ().zzec("Already awaiting connection attempt");
                    return;
                }
                this.zzaOu = new zzo(context, Looper.getMainLooper(), zzf.zzak((Context)context), this, this);
                zzab.this.zzyd().zzzQ().zzec("Connecting to remote service");
                this.zzaOt = true;
                this.zzaOu.zzoZ();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConnected(Bundle connectionHint) {
            zzx.zzci((String)"MeasurementServiceConnection.onConnected");
            zza zza2 = this;
            synchronized (zza2) {
                this.zzaOt = false;
                try {
                    final zzm zzm2 = (zzm)this.zzaOu.zzpc();
                    this.zzaOu = null;
                    zzab.this.zzzr().zzh(new Runnable(){

                        @Override
                        public void run() {
                            if (!zzab.this.isConnected()) {
                                zzab.this.zzyd().zzzP().zzec("Connected to remote service");
                                zzab.this.zza(zzm2);
                            }
                        }
                    });
                }
                catch (DeadObjectException | IllegalStateException throwable) {
                    this.zzaOu = null;
                }
            }
        }

        public void onConnectionSuspended(int cause) {
            zzx.zzci((String)"MeasurementServiceConnection.onConnectionSuspended");
            zzab.this.zzzr().zzh(new Runnable(){

                @Override
                public void run() {
                    zzab.this.onServiceDisconnected(new ComponentName(zzab.this.getContext(), AppMeasurementService.class));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConnectionFailed(ConnectionResult result) {
            zzx.zzci((String)"MeasurementServiceConnection.onConnectionFailed");
            zza zza2 = this;
            synchronized (zza2) {
                this.zzaOu = null;
            }
        }
    }
}

