/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.util.Pair;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzrw;
import com.google.android.gms.internal.zzrx;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class zzd
extends zzy {
    private final zza zzaLU;
    private final zzac zzaLV = new zzac(this.zzit());

    zzd(zzv zzv2) {
        super(zzv2);
        String string = this.zziZ();
        this.zzaLU = new zza(this.getContext(), string);
    }

    @Override
    protected void zzhR() {
    }

    public void beginTransaction() {
        this.zziE();
        this.getWritableDatabase().beginTransaction();
    }

    public void setTransactionSuccessful() {
        this.zziE();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    public void endTransaction() {
        this.zziE();
        this.getWritableDatabase().endTransaction();
    }

    private long zza(String string, String[] stringArray, long l) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l2 = cursor.getLong(0);
                return l2;
            }
            long l3 = l;
            return l3;
        }
    }

    SQLiteDatabase getWritableDatabase() {
        this.zzis();
        try {
            return this.zzaLU.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzyd().zzzL().zzj("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    private String zziZ() {
        if (!this.zzzt().zzjA()) {
            return this.zzzt().zzka();
        }
        if (this.zzzt().zzjB()) {
            return this.zzzt().zzka();
        }
        this.zzyd().zzzM().zzec("Using secondary database");
        return this.zzzt().zzkb();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzh zzH(String string, String string2) {
        zzx.zzcr((String)string);
        zzx.zzcr((String)string2);
        this.zzis();
        this.zziE();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                zzh zzh2 = null;
                return zzh2;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            zzh zzh3 = new zzh(string, string2, l, l2, l3);
            if (cursor.moveToNext()) {
                this.zzyd().zzzK().zzec("Got multiple records for event aggregates, expected one");
            }
            zzh zzh4 = zzh3;
            return zzh4;
        }
    }

    public void zza(zzh zzh2) {
        zzx.zzw((Object)zzh2);
        this.zzis();
        this.zziE();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzh2.zzaLl);
        contentValues.put("name", zzh2.mName);
        contentValues.put("lifetime_count", Long.valueOf(zzh2.zzaMe));
        contentValues.put("current_bundle_count", Long.valueOf(zzh2.zzaMf));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzh2.zzaMg));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.insertWithOnConflict("events", null, contentValues, 5);
            if (l == -1L) {
                this.zzyd().zzzK().zzec("Failed to insert/update event aggregates (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzyd().zzzK().zzj("Error storing event aggregates", (Object)sQLiteException);
        }
    }

    public void zzI(String string, String string2) {
        zzx.zzcr((String)string);
        zzx.zzcr((String)string2);
        this.zzis();
        this.zziE();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            int n = sQLiteDatabase.delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzyd().zzzQ().zzj("Deleted user attribute rows:", n);
        }
        catch (SQLiteException sQLiteException) {
            this.zzyd().zzzK().zzd("Error deleting user attribute", string, string2, (Object)sQLiteException);
        }
    }

    public void zza(zzae zzae2) {
        zzx.zzw((Object)zzae2);
        this.zzis();
        this.zziE();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzae2.zzaLl);
        contentValues.put("name", zzae2.mName);
        contentValues.put("set_timestamp", Long.valueOf(zzae2.zzaOy));
        this.zza(contentValues, "value", zzae2.zzJy);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.insertWithOnConflict("user_attributes", null, contentValues, 5);
            if (l == -1L) {
                this.zzyd().zzzK().zzec("Failed to insert/update user attribute (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzyd().zzzK().zzj("Error storing user attribute", (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<zzae> zzdZ(String string) {
        zzx.zzcr((String)string);
        this.zzis();
        this.zziE();
        ArrayList<zzae> arrayList = new ArrayList<zzae>();
        try (Cursor cursor = null;){
            Object object;
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("user_attributes", new String[]{"name", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(this.zzzt().zzyW() + 1));
            if (!cursor.moveToFirst()) {
                ArrayList<zzae> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zzb(cursor, 2);
                if (object2 == null) {
                    this.zzyd().zzzK().zzec("Read invalid user attribute value, ignoring it");
                    continue;
                }
                zzae zzae2 = new zzae(string, (String)object, l, object2);
                arrayList.add(zzae2);
            } while (cursor.moveToNext());
            if (arrayList.size() > this.zzzt().zzyW()) {
                this.zzyd().zzzK().zzec("Loaded too many user attributes");
                arrayList.remove(this.zzzt().zzyW());
            }
            object = arrayList;
            return object;
        }
    }

    public void zza(com.google.android.gms.measurement.internal.zza zza2) {
        zzx.zzw((Object)zza2);
        this.zzis();
        this.zziE();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zza2.zzaLl);
        contentValues.put("app_instance_id", zza2.zzaLK);
        contentValues.put("gmp_app_id", zza2.zzaLL);
        contentValues.put("resettable_device_id_hash", zza2.zzaLM);
        contentValues.put("last_bundle_index", Long.valueOf(zza2.zzaLN));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zza2.zzaLO));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5);
            if (l == -1L) {
                this.zzyd().zzzK().zzec("Failed to insert/update app (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzyd().zzzK().zzj("Error storing app", (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.google.android.gms.measurement.internal.zza zzea(String string) {
        zzx.zzcr((String)string);
        this.zzis();
        this.zziE();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_end_timestamp"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                com.google.android.gms.measurement.internal.zza zza2 = null;
                return zza2;
            }
            String string2 = cursor.getString(0);
            String string3 = cursor.getString(1);
            String string4 = cursor.getString(2);
            long l = cursor.getLong(3);
            long l2 = cursor.getLong(4);
            com.google.android.gms.measurement.internal.zza zza3 = new com.google.android.gms.measurement.internal.zza(string, string2, string3, string4, l, l2);
            if (cursor.moveToNext()) {
                this.zzyd().zzzK().zzec("Got multiple records for app, expected one");
            }
            com.google.android.gms.measurement.internal.zza zza4 = zza3;
            return zza4;
        }
    }

    public void zza(zzpk.zzd zzd2) {
        byte[] byArray;
        Object object;
        this.zzis();
        this.zziE();
        zzx.zzw((Object)((Object)zzd2));
        zzx.zzcr((String)zzd2.zzaOX);
        zzx.zzw((Object)zzd2.zzaOP);
        this.zzzv();
        long l = this.zzit().currentTimeMillis();
        if (zzd2.zzaOP < l - this.zzzt().zzzc() || zzd2.zzaOP > l + this.zzzt().zzzc()) {
            this.zzyd().zzzL().zze("Storing bundle outside of the max uploading time span. now, timestamp", l, zzd2.zzaOP);
        }
        try {
            int n = zzd2.zzFR();
            object = new byte[n];
            zzrx zzrx2 = zzrx.zzC((byte[])object);
            zzd2.zza(zzrx2);
            zzrx2.zzFE();
            byArray = this.zzzq().zzg((byte[])object);
        }
        catch (IOException iOException) {
            this.zzyd().zzzK().zzj("Data loss. Failed to serialize bundle", iOException);
            return;
        }
        this.zzyd().zzzQ().zzj("Saving bundle, size", byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzd2.zzaOX);
        contentValues.put("bundle_end_timestamp", zzd2.zzaOP);
        contentValues.put("data", byArray);
        try {
            object = this.getWritableDatabase();
            long l2 = object.insert("queue", null, contentValues);
            if (l2 == -1L) {
                this.zzyd().zzzK().zzec("Failed to insert bundle (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzyd().zzzK().zzj("Error storing bundle", (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zzzu() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("queue", new String[]{"app_id"}, null, null, null, null, "rowid", "1");
            if (cursor.moveToFirst()) {
                String string = cursor.getString(0);
                return string;
            }
            String string = null;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pair<zzpk.zzd, Long>> zzn(String string, int n, int n2) {
        this.zzis();
        this.zziE();
        zzx.zzaa((n > 0 ? 1 : 0) != 0);
        zzx.zzaa((n2 > 0 ? 1 : 0) != 0);
        zzx.zzcr((String)string);
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("queue", new String[]{"rowid", "data"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzpk.zzd, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzpk.zzd, Long>> arrayList = new ArrayList<Pair<zzpk.zzd, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzzq().zzp((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzyd().zzzK().zze("Failed to unzip queued bundle", string, iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                object = zzrw.zzB((byte[])byArray);
                zzpk.zzd zzd2 = new zzpk.zzd();
                try {
                    zzd2.zzx((zzrw)object);
                }
                catch (IOException iOException) {
                    this.zzyd().zzzK().zze("Failed to merge queued bundle", string, iOException);
                    continue;
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzpk.zzd, Long>)Pair.create((Object)((Object)zzd2), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzpk.zzd, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    public void zzN(long l) {
        this.zzis();
        this.zziE();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String[] stringArray = new String[]{String.valueOf(l)};
        int n = sQLiteDatabase.delete("queue", "rowid=?", stringArray);
        if (n != 1) {
            this.zzyd().zzzK().zzec("Deleted fewer rows from queue than expected");
        }
    }

    private void zzzv() {
        this.zzis();
        this.zziE();
        long l = this.zzzs().zzaNl.get();
        long l2 = this.zzit().elapsedRealtime();
        if (Math.abs(l2 - l) > this.zzzt().zzzd()) {
            this.zzzs().zzaNl.set(l2);
            this.zzzw();
        }
    }

    void zzzw() {
        this.zzis();
        this.zziE();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String[] stringArray = new String[]{String.valueOf(this.zzit().currentTimeMillis()), String.valueOf(this.zzzt().zzzc())};
        int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
        if (n > 0) {
            this.zzyd().zzzQ().zzj("Deleted stale rows. rowsDeleted", n);
        }
    }

    void zza(ContentValues contentValues, String string, Object object) {
        zzx.zzcr((String)string);
        zzx.zzw((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
        } else if (object instanceof Long) {
            contentValues.put(string, (Long)object);
        } else if (object instanceof Float) {
            contentValues.put(string, (Float)object);
        } else {
            throw new IllegalArgumentException("Invalid value type");
        }
    }

    static int zza(Cursor cursor, int n) {
        int n2;
        if (Build.VERSION.SDK_INT >= 11) {
            return cursor.getType(n);
        }
        SQLiteCursor sQLiteCursor = (SQLiteCursor)cursor;
        CursorWindow cursorWindow = sQLiteCursor.getWindow();
        if (cursorWindow.isNull(n2 = cursor.getPosition(), n)) {
            return 0;
        }
        if (cursorWindow.isLong(n2, n)) {
            return 1;
        }
        if (cursorWindow.isFloat(n2, n)) {
            return 2;
        }
        if (cursorWindow.isString(n2, n)) {
            return 3;
        }
        if (cursorWindow.isBlob(n2, n)) {
            return 4;
        }
        return -1;
    }

    Object zzb(Cursor cursor, int n) {
        int n2 = zzd.zza(cursor, n);
        switch (n2) {
            case 0: {
                this.zzyd().zzzK().zzec("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return Float.valueOf(cursor.getFloat(n));
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzyd().zzzK().zzec("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzyd().zzzK().zzj("Loaded invalid unknown value type, ignoring it", n2);
        return null;
    }

    public long zzzx() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    private class zza
    extends SQLiteOpenHelper {
        zza(Context context, String string) {
            super(context, string, null, 1);
        }

        public SQLiteDatabase getWritableDatabase() {
            if (!zzd.this.zzaLV.zzv(zzd.this.zzzt().zzyX())) {
                throw new SQLiteException("Database open failed");
            }
            try {
                SQLiteDatabase sQLiteDatabase = super.getWritableDatabase();
                return sQLiteDatabase;
            }
            catch (SQLiteException sQLiteException) {
                zzd.this.zzaLV.start();
                zzd.this.zzyd().zzzK().zzec("Opening the database failed, dropping and recreating it");
                String string = zzd.this.zziZ();
                zzd.this.getContext().getDatabasePath(string).delete();
                try {
                    SQLiteDatabase sQLiteDatabase = super.getWritableDatabase();
                    zzd.this.zzaLV.clear();
                    return sQLiteDatabase;
                }
                catch (SQLiteException sQLiteException2) {
                    zzd.this.zzyd().zzzK().zzj("Failed to open freshly created database", (Object)sQLiteException2);
                    throw sQLiteException2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(SQLiteDatabase sQLiteDatabase, String string) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string) {
            HashSet<String> hashSet = new HashSet<String>();
            String string2 = "SELECT * FROM " + string + " LIMIT 0";
            try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
                String[] stringArray = cursor.getColumnNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.add(stringArray[i]);
                }
            }
            return hashSet;
        }

        private void zza(SQLiteDatabase sQLiteDatabase, String string, String string2) throws SQLiteException {
            Set<String> set = this.zzb(sQLiteDatabase, string);
            for (String string3 : string2.split(",")) {
                if (set.remove(string3)) continue;
                throw new SQLiteException("Database " + string + " is missing required column: " + string3);
            }
            if (!set.isEmpty()) {
                throw new SQLiteException("Database " + string + " table has extra columns");
            }
        }

        private void zza(SQLiteDatabase sQLiteDatabase, String string, String string2, String string3) throws SQLiteException {
            if (!this.zza(sQLiteDatabase, string)) {
                sQLiteDatabase.execSQL(string2);
            }
            try {
                this.zza(sQLiteDatabase, string, string3);
            }
            catch (SQLiteException sQLiteException) {
                zzd.this.zzyd().zzzK().zzj("Failed to verify columns on table that was just created", string);
                throw sQLiteException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase database) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = database.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            this.zza(database, "events", "CREATE TABLE IF NOT EXISTS events ( app_id TEXT NOT NULL, name TEXT NOT NULL, lifetime_count INTEGER NOT NULL, current_bundle_count INTEGER NOT NULL, last_fire_timestamp INTEGER NOT NULL, PRIMARY KEY (app_id, name)) ;", "app_id,name,lifetime_count,current_bundle_count,last_fire_timestamp");
            this.zza(database, "user_attributes", "CREATE TABLE IF NOT EXISTS user_attributes ( app_id TEXT NOT NULL, name TEXT NOT NULL, set_timestamp INTEGER NOT NULL, value BLOB NOT NULL, PRIMARY KEY (app_id, name)) ;", "app_id,name,set_timestamp,value");
            this.zza(database, "apps", "CREATE TABLE IF NOT EXISTS apps ( app_id TEXT NOT NULL, app_instance_id TEXT, gmp_app_id TEXT, resettable_device_id_hash TEXT, last_bundle_index INTEGER NOT NULL, last_bundle_end_timestamp INTEGER NOT NULL, PRIMARY KEY (app_id)) ;", "app_id,app_instance_id,gmp_app_id,resettable_device_id_hash,last_bundle_index,last_bundle_end_timestamp");
            this.zza(database, "queue", "CREATE TABLE IF NOT EXISTS queue ( app_id TEXT NOT NULL, bundle_end_timestamp INTEGER NOT NULL, data BLOB NOT NULL);", "app_id,bundle_end_timestamp,data");
        }

        public void onCreate(SQLiteDatabase database) {
            if (Build.VERSION.SDK_INT >= 9) {
                File file = new File(database.getPath());
                file.setReadable(false, false);
                file.setWritable(false, false);
                file.setReadable(true, true);
                file.setWritable(true, true);
            }
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        }
    }
}

