/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzy;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.UUID;

class zzs
extends zzy {
    static final Pair<String, Long> zzaNg = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzPC;
    public final zzb zzaNh = new zzb("health_monitor", this.zzzt().zzkg());
    public final zza zzaNi = new zza("last_upload", 0L);
    public final zza zzaNj = new zza("last_upload_attempt", 0L);
    public final zza zzaNk = new zza("backoff", 0L);
    public final zza zzaNl = new zza("last_delete_stale", 0L);
    private String zzaNm;
    private boolean zzaNn;
    private long zzaNo;

    Pair<String, Boolean> zzzS() {
        this.zzis();
        long l = this.zzit().elapsedRealtime();
        if (this.zzaNm != null && l < this.zzaNo) {
            return new Pair((Object)this.zzaNm, (Object)this.zzaNn);
        }
        this.zzaNo = l + this.zzzt().zzza();
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            this.zzaNm = info.getId();
            this.zzaNn = info.isLimitAdTrackingEnabled();
        }
        catch (Throwable throwable) {
            this.zzyd().zzzP().zzj("Unable to get advertising id", throwable);
            this.zzaNm = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzaNm, (Object)this.zzaNn);
    }

    String zzzT() {
        String string = (String)this.zzzS().first;
        MessageDigest messageDigest = zzs.zzbs("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string.getBytes())));
    }

    static MessageDigest zzbs(String string) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(string);
                if (messageDigest == null) continue;
                return messageDigest;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return null;
    }

    String zzzU() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    zzs(zzv zzv2) {
        super(zzv2);
    }

    @Override
    protected void zzhR() {
        this.zzPC = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
    }

    private SharedPreferences zzzV() {
        this.zzis();
        this.zziE();
        return this.zzPC;
    }

    Boolean zzzW() {
        this.zzis();
        if (!this.zzzV().contains("use_service")) {
            return null;
        }
        return this.zzzV().getBoolean("use_service", false);
    }

    void zzan(boolean bl) {
        this.zzis();
        this.zzyd().zzzQ().zzj("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzzV().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    public final class zza {
        private final String zzue;
        private final long zzaNp;
        private boolean zzaNq;
        private long zzavc;

        public zza(String string, long l) {
            zzx.zzcr((String)string);
            this.zzue = string;
            this.zzaNp = l;
        }

        private void zzzX() {
            if (this.zzaNq) {
                return;
            }
            this.zzaNq = true;
            this.zzavc = zzs.this.zzPC.getLong(this.zzue, this.zzaNp);
        }

        public long get() {
            this.zzzX();
            return this.zzavc;
        }

        public void set(long value) {
            SharedPreferences.Editor editor = zzs.this.zzPC.edit();
            editor.putLong(this.zzue, value);
            editor.apply();
            this.zzavc = value;
        }
    }

    public final class zzb {
        final String zzaNs;
        private final String zzaNt;
        private final String zzaNu;
        private final long zzPG;

        private zzb(String string, long l) {
            zzx.zzcr((String)string);
            zzx.zzaa((l > 0L ? 1 : 0) != 0);
            this.zzaNs = string + ":start";
            this.zzaNt = string + ":count";
            this.zzaNu = string + ":value";
            this.zzPG = l;
        }

        private void zzkU() {
            zzs.this.zzis();
            long l = zzs.this.zzit().currentTimeMillis();
            SharedPreferences.Editor editor = zzs.this.zzPC.edit();
            editor.remove(this.zzaNt);
            editor.remove(this.zzaNu);
            editor.putLong(this.zzaNs, l);
            editor.apply();
        }

        private long zzkV() {
            zzs.this.zzis();
            long l = this.zzkX();
            if (l == 0L) {
                this.zzkU();
                return 0L;
            }
            return Math.abs(l - zzs.this.zzit().currentTimeMillis());
        }

        public void zzbn(String string) {
            long l;
            zzs.this.zzis();
            long l2 = this.zzkX();
            if (l2 == 0L) {
                this.zzkU();
            }
            if (string == null) {
                string = "";
            }
            if ((l = zzs.this.zzPC.getLong(this.zzaNt, 0L)) <= 0L) {
                SharedPreferences.Editor editor = zzs.this.zzPC.edit();
                editor.putString(this.zzaNu, string);
                editor.putLong(this.zzaNt, 1L);
                editor.apply();
                return;
            }
            UUID uUID = UUID.randomUUID();
            long l3 = uUID.getLeastSignificantBits() & Long.MAX_VALUE;
            boolean bl = l3 < Long.MAX_VALUE / (l + 1L);
            SharedPreferences.Editor editor = zzs.this.zzPC.edit();
            if (bl) {
                editor.putString(this.zzaNu, string);
            }
            editor.putLong(this.zzaNt, l + 1L);
            editor.apply();
        }

        public Pair<String, Long> zzkW() {
            zzs.this.zzis();
            long l = this.zzkV();
            if (l < this.zzPG) {
                return null;
            }
            if (l > this.zzPG * 2L) {
                this.zzkU();
                return null;
            }
            String string = zzs.this.zzzV().getString(this.zzaNu, null);
            long l2 = zzs.this.zzzV().getLong(this.zzaNt, 0L);
            this.zzkU();
            if (string == null || l2 <= 0L) {
                return zzaNg;
            }
            return new Pair((Object)string, (Object)l2);
        }

        private long zzkX() {
            return zzs.this.zzzV().getLong(this.zzaNs, 0L);
        }
    }
}

