/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.barcode.internal;

import android.content.Context;
import android.media.Image;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.mlkit_vision_barcode.zzcd;
import com.google.android.gms.internal.mlkit_vision_barcode.zznd;
import com.google.android.gms.internal.mlkit_vision_barcode.zzrl;
import com.google.android.gms.internal.mlkit_vision_barcode.zzsm;
import com.google.android.gms.internal.mlkit_vision_barcode.zzso;
import com.google.android.gms.internal.mlkit_vision_barcode.zzsw;
import com.google.android.gms.internal.mlkit_vision_barcode.zzsy;
import com.google.android.gms.internal.mlkit_vision_barcode.zztf;
import com.google.mlkit.common.MlKitException;
import com.google.mlkit.common.sdkinternal.OptionalModuleUtils;
import com.google.mlkit.vision.barcode.BarcodeScannerOptions;
import com.google.mlkit.vision.barcode.common.Barcode;
import com.google.mlkit.vision.barcode.common.internal.BarcodeSource;
import com.google.mlkit.vision.barcode.internal.zzb;
import com.google.mlkit.vision.barcode.internal.zzj;
import com.google.mlkit.vision.barcode.internal.zzk;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.common.internal.CommonConvertUtils;
import com.google.mlkit.vision.common.internal.ImageUtils;
import java.util.ArrayList;
import java.util.List;

final class zzl
implements zzj {
    private static final zzcd zza = zzcd.zzh("com.google.android.gms.vision.barcode", "com.google.android.gms.tflite_dynamite");
    private boolean zzb;
    private boolean zzc;
    private boolean zzd;
    private final Context zze;
    private final BarcodeScannerOptions zzf;
    private final zzrl zzg;
    @Nullable
    private zzsw zzh;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final List zza(InputImage inputImage) throws MlKitException {
        if (this.zzh == null) {
            this.zzc();
        }
        ArrayList<Barcode> arrayList = (zzsw)Preconditions.checkNotNull((Object)this.zzh);
        if (!this.zzb) {
            try {
                ((zzsw)((Object)arrayList)).zze();
                this.zzb = true;
            }
            catch (RemoteException remoteException) {
                throw new MlKitException("Failed to init barcode scanner.", 13, (Throwable)remoteException);
            }
        }
        int n = inputImage.getWidth();
        if (inputImage.getFormat() == 35) {
            n = ((Image.Plane[])Preconditions.checkNotNull((Object)inputImage.getPlanes()))[0].getRowStride();
        }
        AbstractSafeParcelable abstractSafeParcelable = new zztf(inputImage.getFormat(), n, inputImage.getHeight(), CommonConvertUtils.convertToMVRotation((int)inputImage.getRotationDegrees()), SystemClock.elapsedRealtime());
        Object object = ImageUtils.getInstance().getImageDataWrapper(inputImage);
        try {
            object = ((zzsw)((Object)arrayList)).zzd((IObjectWrapper)object, (zztf)abstractSafeParcelable);
            arrayList = new ArrayList<Barcode>();
            object = object.iterator();
        }
        catch (RemoteException remoteException) {
            throw new MlKitException("Failed to run barcode scanner.", 13, (Throwable)remoteException);
        }
        while (object.hasNext()) {
            abstractSafeParcelable = (zzsm)((Object)object.next());
            arrayList.add(new Barcode((BarcodeSource)new zzk((zzsm)abstractSafeParcelable), inputImage.getCoordinatesMatrix()));
        }
        return arrayList;
    }

    zzl(Context context, BarcodeScannerOptions barcodeScannerOptions, zzrl zzrl2) {
        this.zze = context;
        this.zzf = barcodeScannerOptions;
        this.zzg = zzrl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final void zzb() {
        zzsw zzsw2 = this.zzh;
        if (zzsw2 == null) {
            return;
        }
        try {
            zzsw2.zzf();
        }
        catch (RemoteException remoteException) {
            Log.e((String)"DecoupledBarcodeScanner", (String)"Failed to release barcode scanner.", (Throwable)remoteException);
        }
        this.zzh = null;
        this.zzb = false;
    }

    static boolean zzd(Context context) {
        return DynamiteModule.getLocalVersion((Context)context, (String)"com.google.mlkit.dynamite.barcode") > 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final boolean zzc() throws MlKitException {
        if (this.zzh != null) {
            return this.zzc;
        }
        if (zzl.zzd(this.zze)) {
            this.zzc = true;
            try {
                this.zzh = this.zze(DynamiteModule.PREFER_LOCAL, "com.google.mlkit.dynamite.barcode", "com.google.mlkit.vision.barcode.bundled.internal.ThickBarcodeScannerCreator");
            }
            catch (DynamiteModule.LoadingException loadingException) {
                throw new MlKitException("Failed to load the bundled barcode module.", 13, (Throwable)loadingException);
            }
            catch (RemoteException remoteException) {
                throw new MlKitException("Failed to create thick barcode scanner.", 13, (Throwable)remoteException);
            }
        }
        this.zzc = false;
        if (!OptionalModuleUtils.areAllRequiredModulesAvailable((Context)this.zze, (List)zza)) {
            if (!this.zzd) {
                OptionalModuleUtils.requestDownload((Context)this.zze, (List)zzcd.zzh("barcode", "tflite_dynamite"));
                this.zzd = true;
            }
            com.google.mlkit.vision.barcode.internal.zzb.zze(this.zzg, zznd.zzB);
            throw new MlKitException("Waiting for the barcode module to be downloaded. Please wait.", 14);
        }
        try {
            this.zzh = this.zze(DynamiteModule.PREFER_REMOTE, "com.google.android.gms.vision.barcode", "com.google.android.gms.vision.barcode.mlkit.BarcodeScannerCreator");
        }
        catch (RemoteException | DynamiteModule.LoadingException throwable) {
            com.google.mlkit.vision.barcode.internal.zzb.zze(this.zzg, zznd.zzC);
            throw new MlKitException("Failed to create thin barcode scanner.", 13, throwable);
        }
        com.google.mlkit.vision.barcode.internal.zzb.zze(this.zzg, zznd.zza);
        return this.zzc;
    }

    @VisibleForTesting
    final zzsw zze(DynamiteModule.VersionPolicy versionPolicy, String string, String string2) throws DynamiteModule.LoadingException, RemoteException {
        return zzsy.zza(DynamiteModule.load((Context)this.zze, (DynamiteModule.VersionPolicy)versionPolicy, (String)string).instantiate(string2)).zzd(ObjectWrapper.wrap((Object)this.zze), new zzso(this.zzf.zza(), this.zzf.zzc()));
    }
}

