/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.barcode.internal;

import android.content.Context;
import android.media.Image;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.mlkit_vision_barcode.zzcs;
import com.google.android.gms.internal.mlkit_vision_barcode.zzrb;
import com.google.android.gms.internal.mlkit_vision_barcode.zzwp;
import com.google.android.gms.internal.mlkit_vision_barcode.zzyb;
import com.google.android.gms.internal.mlkit_vision_barcode.zzyd;
import com.google.android.gms.internal.mlkit_vision_barcode.zzyl;
import com.google.android.gms.internal.mlkit_vision_barcode.zzyn;
import com.google.android.gms.internal.mlkit_vision_barcode.zzyu;
import com.google.mlkit.common.MlKitException;
import com.google.mlkit.common.sdkinternal.OptionalModuleUtils;
import com.google.mlkit.vision.barcode.BarcodeScannerOptions;
import com.google.mlkit.vision.barcode.common.Barcode;
import com.google.mlkit.vision.barcode.common.internal.BarcodeSource;
import com.google.mlkit.vision.barcode.internal.zzb;
import com.google.mlkit.vision.barcode.internal.zzm;
import com.google.mlkit.vision.barcode.internal.zzn;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.common.internal.CommonConvertUtils;
import com.google.mlkit.vision.common.internal.ImageUtils;
import java.util.ArrayList;
import java.util.List;

final class zzo
implements zzm {
    private static final zzcs zza = zzcs.zzh("com.google.android.gms.vision.barcode", "com.google.android.gms.tflite_dynamite");
    private boolean zzb;
    private boolean zzc;
    private boolean zzd;
    private final Context zze;
    private final BarcodeScannerOptions zzf;
    private final zzwp zzg;
    @Nullable
    private zzyl zzh;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final List zza(InputImage inputImage) throws MlKitException {
        if (this.zzh == null) {
            this.zzc();
        }
        ArrayList<Barcode> arrayList = (zzyl)Preconditions.checkNotNull((Object)this.zzh);
        if (!this.zzb) {
            try {
                ((zzyl)((Object)arrayList)).zze();
                this.zzb = true;
            }
            catch (RemoteException remoteException) {
                throw new MlKitException("Failed to init barcode scanner.", 13, (Throwable)remoteException);
            }
        }
        int n = inputImage.getWidth();
        if (inputImage.getFormat() == 35) {
            n = ((Image.Plane[])Preconditions.checkNotNull((Object)inputImage.getPlanes()))[0].getRowStride();
        }
        AbstractSafeParcelable abstractSafeParcelable = new zzyu(inputImage.getFormat(), n, inputImage.getHeight(), CommonConvertUtils.convertToMVRotation((int)inputImage.getRotationDegrees()), SystemClock.elapsedRealtime());
        Object object = ImageUtils.getInstance().getImageDataWrapper(inputImage);
        try {
            object = ((zzyl)((Object)arrayList)).zzd((IObjectWrapper)object, (zzyu)abstractSafeParcelable);
            arrayList = new ArrayList<Barcode>();
            object = object.iterator();
        }
        catch (RemoteException remoteException) {
            throw new MlKitException("Failed to run barcode scanner.", 13, (Throwable)remoteException);
        }
        while (object.hasNext()) {
            abstractSafeParcelable = (zzyb)((Object)object.next());
            arrayList.add(new Barcode((BarcodeSource)new zzn((zzyb)abstractSafeParcelable), inputImage.getCoordinatesMatrix()));
        }
        return arrayList;
    }

    zzo(Context context, BarcodeScannerOptions barcodeScannerOptions, zzwp zzwp2) {
        this.zze = context;
        this.zzf = barcodeScannerOptions;
        this.zzg = zzwp2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final void zzb() {
        zzyl zzyl2 = this.zzh;
        if (zzyl2 == null) {
            return;
        }
        try {
            zzyl2.zzf();
        }
        catch (RemoteException remoteException) {
            Log.e((String)"DecoupledBarcodeScanner", (String)"Failed to release barcode scanner.", (Throwable)remoteException);
        }
        this.zzh = null;
        this.zzb = false;
    }

    static boolean zzd(Context context) {
        return DynamiteModule.getLocalVersion((Context)context, (String)"com.google.mlkit.dynamite.barcode") > 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final boolean zzc() throws MlKitException {
        if (this.zzh != null) {
            return this.zzc;
        }
        if (zzo.zzd(this.zze)) {
            this.zzc = true;
            try {
                this.zzh = this.zze(DynamiteModule.PREFER_LOCAL, "com.google.mlkit.dynamite.barcode", "com.google.mlkit.vision.barcode.bundled.internal.ThickBarcodeScannerCreator");
            }
            catch (DynamiteModule.LoadingException loadingException) {
                throw new MlKitException("Failed to load the bundled barcode module.", 13, (Throwable)loadingException);
            }
            catch (RemoteException remoteException) {
                throw new MlKitException("Failed to create thick barcode scanner.", 13, (Throwable)remoteException);
            }
        }
        this.zzc = false;
        if (!OptionalModuleUtils.areAllRequiredModulesAvailable((Context)this.zze, (List)zza)) {
            if (!this.zzd) {
                OptionalModuleUtils.requestDownload((Context)this.zze, (List)zzcs.zzh("barcode", "tflite_dynamite"));
                this.zzd = true;
            }
            com.google.mlkit.vision.barcode.internal.zzb.zze(this.zzg, zzrb.zzB);
            throw new MlKitException("Waiting for the barcode module to be downloaded. Please wait.", 14);
        }
        try {
            this.zzh = this.zze(DynamiteModule.PREFER_REMOTE, "com.google.android.gms.vision.barcode", "com.google.android.gms.vision.barcode.mlkit.BarcodeScannerCreator");
        }
        catch (RemoteException | DynamiteModule.LoadingException throwable) {
            com.google.mlkit.vision.barcode.internal.zzb.zze(this.zzg, zzrb.zzC);
            throw new MlKitException("Failed to create thin barcode scanner.", 13, throwable);
        }
        com.google.mlkit.vision.barcode.internal.zzb.zze(this.zzg, zzrb.zza);
        return this.zzc;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    final zzyl zze(DynamiteModule.VersionPolicy object, String string, String object2) throws DynamiteModule.LoadingException, RemoteException {
        object = zzyn.zza(DynamiteModule.load((Context)this.zze, (DynamiteModule.VersionPolicy)object, (String)string).instantiate(object2));
        BarcodeScannerOptions barcodeScannerOptions = this.zzf;
        string = ObjectWrapper.wrap((Object)this.zze);
        int n = barcodeScannerOptions.zza();
        boolean bl = !barcodeScannerOptions.zzd() ? this.zzf.zzb() != null : true;
        zzyd zzyd2 = new zzyd(n, bl);
        return object.zzd((IObjectWrapper)string, zzyd2);
    }
}

