/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.face;

import android.graphics.PointF;
import android.graphics.Rect;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.mlkit_vision_face.zza;
import com.google.android.gms.internal.mlkit_vision_face.zzc;
import com.google.android.gms.vision.face.Landmark;
import com.google.mlkit.vision.face.FaceContour;
import com.google.mlkit.vision.face.FaceLandmark;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Face {
    private final Rect zza;
    private int zzb;
    private float zzc;
    private float zzd;
    private float zze;
    private final float zzf;
    private final float zzg;
    private final float zzh;
    private final SparseArray<FaceLandmark> zzi = new SparseArray();
    private final SparseArray<FaceContour> zzj = new SparseArray();

    @NonNull
    public Rect getBoundingBox() {
        return this.zza;
    }

    @Nullable
    public Integer getTrackingId() {
        if (this.zzb == -1) {
            return null;
        }
        return this.zzb;
    }

    private static boolean zzb(@FaceLandmark.LandmarkType int n) {
        return n == 0 || n == 1 || n == 7 || n == 3 || n == 9 || n == 4 || n == 10 || n == 5 || n == 11 || n == 6;
    }

    public Face(@NonNull com.google.android.gms.vision.face.Face face) {
        PointF pointF = face.getPosition();
        this.zza = new Rect((int)pointF.x, (int)pointF.y, (int)(pointF.x + face.getWidth()), (int)(pointF.y + face.getHeight()));
        this.zzb = face.getId();
        for (Landmark landmark : face.getLandmarks()) {
            if (!Face.zzb(landmark.getType()) || landmark.getPosition() == null) continue;
            this.zzi.put(landmark.getType(), (Object)new FaceLandmark(landmark.getType(), new PointF(landmark.getPosition().x, landmark.getPosition().y)));
        }
        for (Landmark landmark : face.getContours()) {
            int n;
            switch (landmark.getType()) {
                case 1: {
                    n = 1;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 3;
                    break;
                }
                case 4: {
                    n = 4;
                    break;
                }
                case 5: {
                    n = 5;
                    break;
                }
                case 6: {
                    n = 6;
                    break;
                }
                case 7: {
                    n = 7;
                    break;
                }
                case 8: {
                    n = 8;
                    break;
                }
                case 9: {
                    n = 9;
                    break;
                }
                case 10: {
                    n = 10;
                    break;
                }
                case 11: {
                    n = 11;
                    break;
                }
                case 12: {
                    n = 12;
                    break;
                }
                case 13: {
                    n = 13;
                    break;
                }
                case 14: {
                    n = 14;
                    break;
                }
                case 15: {
                    n = 15;
                    break;
                }
                default: {
                    n = -1;
                }
            }
            int n2 = n;
            int n3 = n;
            if (!(n <= 15 && n3 > 0)) continue;
            PointF[] pointFArray = landmark.getPositions();
            ArrayList<PointF> arrayList = new ArrayList<PointF>();
            if (pointFArray == null) continue;
            PointF[] pointFArray2 = pointFArray;
            int n4 = pointFArray.length;
            for (int i = 0; i < n4; ++i) {
                PointF pointF2 = pointFArray2[i];
                arrayList.add(new PointF(pointF2.x, pointF2.y));
            }
            this.zzj.put(n2, (Object)new FaceContour(n2, arrayList));
        }
        this.zzf = face.getEulerX();
        this.zzg = face.getEulerY();
        this.zzh = face.getEulerZ();
        this.zze = face.getIsSmilingProbability();
        this.zzd = face.getIsLeftEyeOpenProbability();
        this.zzc = face.getIsRightEyeOpenProbability();
    }

    public float getHeadEulerAngleX() {
        return this.zzf;
    }

    public float getHeadEulerAngleY() {
        return this.zzg;
    }

    public float getHeadEulerAngleZ() {
        return this.zzh;
    }

    @Nullable
    public FaceLandmark getLandmark(@FaceLandmark.LandmarkType int n) {
        return (FaceLandmark)this.zzi.get(n);
    }

    @NonNull
    public List<FaceLandmark> getAllLandmarks() {
        ArrayList<FaceLandmark> arrayList = new ArrayList<FaceLandmark>();
        int n = this.zzi.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add((FaceLandmark)this.zzi.valueAt(i));
        }
        return arrayList;
    }

    @Nullable
    public FaceContour getContour(@FaceContour.ContourType int n) {
        return (FaceContour)this.zzj.get(n);
    }

    @NonNull
    public List<FaceContour> getAllContours() {
        ArrayList<FaceContour> arrayList = new ArrayList<FaceContour>();
        int n = this.zzj.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add((FaceContour)this.zzj.valueAt(i));
        }
        return arrayList;
    }

    public final SparseArray<FaceContour> zza() {
        return this.zzj;
    }

    public final void zza(SparseArray<FaceContour> sparseArray) {
        this.zzj.clear();
        for (int i = 0; i < sparseArray.size(); ++i) {
            this.zzj.put(sparseArray.keyAt(i), (Object)((FaceContour)sparseArray.valueAt(i)));
        }
    }

    public final void zza(int n) {
        this.zzb = -1;
    }

    @Nullable
    public Float getSmilingProbability() {
        if (this.zze == -1.0f) {
            return null;
        }
        return Float.valueOf(this.zze);
    }

    @Nullable
    public Float getLeftEyeOpenProbability() {
        if (this.zzd == -1.0f) {
            return null;
        }
        return Float.valueOf(this.zzd);
    }

    @Nullable
    public Float getRightEyeOpenProbability() {
        if (this.zzc == -1.0f) {
            return null;
        }
        return Float.valueOf(this.zzc);
    }

    public String toString() {
        int n;
        zzc zzc2 = com.google.android.gms.internal.mlkit_vision_face.zza.zza("Face").zza("boundingBox", this.zza).zza("trackingId", this.zzb).zza("rightEyeOpenProbability", this.zzc).zza("leftEyeOpenProbability", this.zzd).zza("smileProbability", this.zze).zza("eulerX", this.zzf).zza("eulerY", this.zzg).zza("eulerZ", this.zzh);
        zzc zzc3 = com.google.android.gms.internal.mlkit_vision_face.zza.zza("Landmarks");
        for (int i = 0; i <= 11; ++i) {
            if (!Face.zzb(i)) continue;
            n = i;
            zzc3.zza(new StringBuilder(20).append("landmark_").append(n).toString(), this.getLandmark(i));
        }
        zzc2.zza("landmarks", zzc3.toString());
        zzc zzc4 = com.google.android.gms.internal.mlkit_vision_face.zza.zza("Contours");
        for (n = 1; n <= 15; ++n) {
            int n2 = n;
            zzc4.zza(new StringBuilder(19).append("Contour_").append(n2).toString(), this.getContour(n));
        }
        zzc2.zza("contours", zzc4.toString());
        return zzc2.toString();
    }
}

