/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.text.internal;

import android.content.Context;
import android.os.SystemClock;
import android.util.SparseArray;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.mlkit_vision_text.zzbh;
import com.google.android.gms.internal.mlkit_vision_text.zzbr;
import com.google.android.gms.internal.mlkit_vision_text.zzbs;
import com.google.android.gms.internal.mlkit_vision_text.zzeg;
import com.google.android.gms.internal.mlkit_vision_text.zzek;
import com.google.android.gms.internal.mlkit_vision_text.zzfy;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.text.TextBlock;
import com.google.android.gms.vision.text.TextRecognizer;
import com.google.mlkit.common.MlKitException;
import com.google.mlkit.common.sdkinternal.MLTask;
import com.google.mlkit.common.sdkinternal.MLTaskInput;
import com.google.mlkit.common.sdkinternal.MlKitContext;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.common.internal.CommonConvertUtils;
import com.google.mlkit.vision.common.internal.ImageConvertUtils;
import com.google.mlkit.vision.common.internal.ImageUtils;
import com.google.mlkit.vision.text.Text;
import com.google.mlkit.vision.text.internal.zza;
import com.google.mlkit.vision.text.internal.zzc;

public class zzb
extends MLTask<Text, InputImage> {
    @VisibleForTesting
    private static boolean zza = true;
    private static final ImageUtils zzb = ImageUtils.getInstance();
    @GuardedBy(value="this")
    private TextRecognizer zzc;
    private final Context zzd;
    private final zzeg zze;

    public zzb(@NonNull MlKitContext mlKitContext) {
        Preconditions.checkNotNull((Object)mlKitContext, (Object)"MlKitContext can not be null");
        this.zzd = mlKitContext.getApplicationContext();
        this.zze = (zzeg)mlKitContext.get(zzeg.class);
    }

    @WorkerThread
    public synchronized void load() {
        if (this.zzc == null) {
            this.zzc = new TextRecognizer.Builder(this.zzd).build();
        }
    }

    @WorkerThread
    public synchronized void release() {
        if (this.zzc != null) {
            this.zzc.release();
            this.zzc = null;
        }
        zza = true;
    }

    @WorkerThread
    private final synchronized Text zza(@NonNull InputImage inputImage) throws MlKitException {
        long l = SystemClock.elapsedRealtime();
        if (this.zzc == null) {
            this.zza(zzbr.zzc, l, inputImage);
            throw new MlKitException("Model source is unavailable. Please load the model resource first.", 13);
        }
        if (!this.zzc.isOperational()) {
            this.zza(zzbr.zzb, l, inputImage);
            throw new MlKitException("Waiting for the text recognition model to be downloaded. Please wait.", 14);
        }
        InputImage inputImage2 = inputImage;
        Frame frame = inputImage2.getFormat() == -1 ? new Frame.Builder().setBitmap(inputImage2.getBitmapInternal()).setRotation(CommonConvertUtils.convertToMVRotation((int)inputImage2.getRotationDegrees())).build() : new Frame.Builder().setBitmap(ImageConvertUtils.getInstance().convertToUpRightBitmap(inputImage2)).setRotation(0).build();
        SparseArray sparseArray = this.zzc.detect(frame);
        this.zza(zzbr.zza, l, inputImage);
        zza = false;
        return new Text((SparseArray<TextBlock>)sparseArray);
    }

    @WorkerThread
    private final void zza(zzbr zzbr2, long l, InputImage inputImage) {
        long l2 = SystemClock.elapsedRealtime() - l;
        zza zza2 = new zza(l2, zzbr2, inputImage);
        this.zze.zza(zza2, zzbs.zza);
        zzbh.zzi.zzb zzb2 = (zzbh.zzi.zzb)((zzfy)zzbh.zzi.zzb.zza().zza(zzbr2).zza(zza).zza(zzek.zza(zzb.getMobileVisionImageFormat(inputImage), zzb.getMobileVisionImageSize(inputImage))).zzh());
        zzeg.zza zza3 = com.google.mlkit.vision.text.internal.zzc.zza;
        this.zze.zza(zzb2, l2, zzbs.zzc, zza3);
    }

    @WorkerThread
    public /* synthetic */ Object run(@NonNull MLTaskInput mLTaskInput) throws MlKitException {
        return this.zza((InputImage)mLTaskInput);
    }

    static final /* synthetic */ zzbh.zzad.zza zza(zzbh.zzi.zzb zzb2, int n, zzbh.zzab zzab2) {
        return zzbh.zzad.zzb().zza(zzbh.zzi.zza().zza(n).zza(zzb2).zza(zzab2));
    }

    static final /* synthetic */ zzbh.zzad.zza zza(long l, zzbr zzbr2, InputImage inputImage) {
        zzbh.zzbd zzbd2 = (zzbh.zzbd)((zzfy)zzbh.zzbd.zza().zza(zzbh.zzaf.zza().zza(l).zza(zzbr2).zza(zza).zzb(true).zzc(true)).zza(zzek.zza(zzb.getMobileVisionImageFormat(inputImage), zzb.getMobileVisionImageSize(inputImage))).zzh());
        return zzbh.zzad.zzb().zza(zzbd2);
    }
}

