/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import com.google.android.gms.R;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.places.AutocompleteFilter;
import com.google.android.gms.location.places.Place;
import com.google.android.gms.location.places.ui.PlaceAutocomplete;
import com.google.android.gms.location.places.ui.PlaceSelectionListener;
import com.google.android.gms.maps.model.LatLngBounds;

public class SupportPlaceAutocompleteFragment
extends Fragment {
    private View zzbnp;
    private View zzbnq;
    private EditText zzbnr;
    private boolean zzbns;
    @Nullable
    private LatLngBounds zzbnt;
    @Nullable
    private AutocompleteFilter zzbnu;
    @Nullable
    private PlaceSelectionListener zzbnv;

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.place_autocomplete_fragment, viewGroup, false);
        this.zzbnp = view.findViewById(R.id.place_autocomplete_search_button);
        this.zzbnq = view.findViewById(R.id.place_autocomplete_clear_button);
        this.zzbnr = (EditText)view.findViewById(R.id.place_autocomplete_search_input);
        View.OnClickListener onClickListener = new View.OnClickListener(){

            public void onClick(View view) {
                if (!SupportPlaceAutocompleteFragment.this.zzbns) {
                    SupportPlaceAutocompleteFragment.this.zzJj();
                }
            }
        };
        this.zzbnp.setOnClickListener(onClickListener);
        this.zzbnr.setOnClickListener(onClickListener);
        this.zzbnq.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SupportPlaceAutocompleteFragment.this.setText("");
            }
        });
        this.zzJi();
        return view;
    }

    public void onDestroyView() {
        this.zzbnp = null;
        this.zzbnq = null;
        this.zzbnr = null;
        super.onDestroyView();
    }

    public void setBoundsBias(@Nullable LatLngBounds latLngBounds) {
        this.zzbnt = latLngBounds;
    }

    public void setFilter(@Nullable AutocompleteFilter autocompleteFilter) {
        this.zzbnu = autocompleteFilter;
    }

    public void setText(CharSequence charSequence) {
        this.zzbnr.setText(charSequence);
        this.zzJi();
    }

    public void setHint(CharSequence charSequence) {
        this.zzbnr.setHint(charSequence);
        this.zzbnp.setContentDescription(charSequence);
    }

    public void setOnPlaceSelectedListener(PlaceSelectionListener placeSelectionListener) {
        this.zzbnv = placeSelectionListener;
    }

    private void zzJi() {
        boolean bl = !this.zzbnr.getText().toString().isEmpty();
        this.zzbnq.setVisibility(bl ? 0 : 8);
    }

    private void zzJj() {
        GoogleApiAvailability googleApiAvailability;
        int n = -1;
        try {
            googleApiAvailability = new PlaceAutocomplete.IntentBuilder(2).setBoundsBias(this.zzbnt).setFilter(this.zzbnu).zzeZ(this.zzbnr.getText().toString()).zzlc(1).build((Activity)this.getActivity());
            this.zzbns = true;
            this.startActivityForResult((Intent)googleApiAvailability, 30421);
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            n = googlePlayServicesRepairableException.getConnectionStatusCode();
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesRepairableException);
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            n = googlePlayServicesNotAvailableException.errorCode;
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesNotAvailableException);
        }
        if (n != -1) {
            googleApiAvailability = GoogleApiAvailability.getInstance();
            googleApiAvailability.showErrorDialogFragment((Activity)this.getActivity(), n, 30422);
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        this.zzbns = false;
        if (n == 30421) {
            if (n2 == -1) {
                Place place = PlaceAutocomplete.getPlace((Context)this.getActivity(), intent);
                if (this.zzbnv != null) {
                    this.zzbnv.onPlaceSelected(place);
                }
                this.setText(place.getName().toString());
            } else if (n2 == 2) {
                Status status = PlaceAutocomplete.getStatus((Context)this.getActivity(), intent);
                if (this.zzbnv != null) {
                    this.zzbnv.onError(status);
                }
            }
        }
        super.onActivityResult(n, n2, intent);
    }
}

