/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.places;

import com.google.android.gms.internal.places.zzbd;
import com.google.android.gms.internal.places.zzbh;
import com.google.android.gms.internal.places.zzcw;
import com.google.android.gms.internal.places.zzq;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzao
extends zzq<Double>
implements zzbh<Double>,
zzcw,
RandomAccess {
    private static final zzao zzex = new zzao(new double[0], 0);
    private double[] zzey;
    private int size;

    zzao() {
        this(new double[10], 0);
    }

    private zzao(double[] dArray, int n) {
        this.zzey = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzac();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzey, n2, this.zzey, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzao)) {
            return super.equals(object);
        }
        zzao zzao2 = (zzao)object;
        if (this.size != zzao2.size) {
            return false;
        }
        double[] dArray = zzao2.zzey;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzey[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzey[i]);
            n = n * 31 + zzbd.zzl(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzd(double d) {
        this.zzd(this.size, d);
    }

    private final void zzd(int n, double d) {
        this.zzac();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
        if (this.size < this.zzey.length) {
            System.arraycopy(this.zzey, n, this.zzey, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzey, 0, dArray, 0, n);
            System.arraycopy(this.zzey, n, dArray, n + 1, this.size - n);
            this.zzey = dArray;
        }
        this.zzey[n] = d;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzac();
        zzbd.checkNotNull(collection);
        if (!(collection instanceof zzao)) {
            return super.addAll(collection);
        }
        zzao zzao2 = (zzao)collection;
        if (zzao2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzao2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzao2.size;
        if (n > this.zzey.length) {
            this.zzey = Arrays.copyOf(this.zzey, n);
        }
        System.arraycopy(zzao2.zzey, 0, this.zzey, this.size, zzao2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzac();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzey[i])) continue;
            System.arraycopy(this.zzey, i + 1, this.zzey, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
    }

    private final String zzg(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzao zzao2 = this;
        zzao2.zzac();
        zzao2.zzf(n);
        double d3 = zzao2.zzey[n];
        zzao2.zzey[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzao zzao2 = this;
        zzao2.zzac();
        zzao2.zzf(n);
        double d = zzao2.zzey[n];
        if (n < zzao2.size - 1) {
            System.arraycopy(zzao2.zzey, n + 1, zzao2.zzey, n, zzao2.size - n - 1);
        }
        --zzao2.size;
        ++zzao2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        this.zzd(n, d);
    }

    @Override
    public final /* synthetic */ zzbh zzh(int n) {
        int n2 = n;
        zzao zzao2 = this;
        if (n2 < zzao2.size) {
            throw new IllegalArgumentException();
        }
        return new zzao(Arrays.copyOf(zzao2.zzey, n2), zzao2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzao zzao2 = this;
        zzao2.zzf(n);
        return zzao2.zzey[n];
    }

    static {
        zzex.zzab();
    }
}

