/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places.ui;

import android.annotation.TargetApi;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.places.AutocompleteFilter;
import com.google.android.gms.location.places.Place;
import com.google.android.gms.location.places.R;
import com.google.android.gms.location.places.ui.PlaceAutocomplete;
import com.google.android.gms.location.places.ui.PlaceSelectionListener;
import com.google.android.gms.location.places.ui.zzc;
import com.google.android.gms.location.places.ui.zzd;
import com.google.android.gms.location.places.ui.zze;
import com.google.android.gms.maps.model.LatLngBounds;

@Deprecated
@TargetApi(value=12)
public class PlaceAutocompleteFragment
extends Fragment {
    private View zzde;
    private View zzdf;
    private EditText zzdg;
    private boolean zzdh;
    @Nullable
    private LatLngBounds zzdi;
    @Nullable
    private AutocompleteFilter zzdj;
    @Nullable
    private PlaceSelectionListener zzdk;

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.place_autocomplete_fragment, viewGroup, false);
        this.zzde = view.findViewById(R.id.place_autocomplete_search_button);
        this.zzdf = view.findViewById(R.id.place_autocomplete_clear_button);
        this.zzdg = (EditText)view.findViewById(R.id.place_autocomplete_search_input);
        zze zze2 = new zze(this);
        this.zzde.setOnClickListener((View.OnClickListener)zze2);
        this.zzdg.setOnClickListener((View.OnClickListener)zze2);
        this.zzdf.setOnClickListener((View.OnClickListener)new zzd(this));
        this.zzm();
        return view;
    }

    public void onDestroyView() {
        this.zzde = null;
        this.zzdf = null;
        this.zzdg = null;
        super.onDestroyView();
    }

    public void setBoundsBias(@Nullable LatLngBounds latLngBounds) {
        this.zzdi = latLngBounds;
    }

    public void setFilter(@Nullable AutocompleteFilter autocompleteFilter) {
        this.zzdj = autocompleteFilter;
    }

    public void setText(CharSequence charSequence) {
        this.zzdg.setText(charSequence);
        this.zzm();
    }

    public void setHint(CharSequence charSequence) {
        this.zzdg.setHint(charSequence);
        this.zzde.setContentDescription(charSequence);
    }

    public void setOnPlaceSelectedListener(PlaceSelectionListener placeSelectionListener) {
        this.zzdk = placeSelectionListener;
    }

    private final void zzm() {
        boolean bl = !this.zzdg.getText().toString().isEmpty();
        this.zzdf.setVisibility(bl ? 0 : 8);
    }

    private final void zzn() {
        int n = -1;
        try {
            Intent intent = ((zzc)new PlaceAutocomplete.IntentBuilder(2).setBoundsBias(this.zzdi).setFilter(this.zzdj).zzg(this.zzdg.getText().toString()).zzd(1)).build(this.getActivity());
            this.zzdh = true;
            this.startActivityForResult(intent, 30421);
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            GooglePlayServicesRepairableException googlePlayServicesRepairableException2 = googlePlayServicesRepairableException;
            n = googlePlayServicesRepairableException.getConnectionStatusCode();
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesRepairableException2);
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException2 = googlePlayServicesNotAvailableException;
            n = googlePlayServicesNotAvailableException.errorCode;
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesNotAvailableException2);
        }
        if (n != -1) {
            GoogleApiAvailability.getInstance().showErrorDialogFragment(this.getActivity(), n, 30422);
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        this.zzdh = false;
        if (n == 30421) {
            if (n2 == -1) {
                Place place = PlaceAutocomplete.getPlace((Context)this.getActivity(), intent);
                if (this.zzdk != null) {
                    this.zzdk.onPlaceSelected(place);
                }
                this.setText(place.getName().toString());
            } else if (n2 == 2) {
                Status status = PlaceAutocomplete.getStatus((Context)this.getActivity(), intent);
                if (this.zzdk != null) {
                    this.zzdk.onError(status);
                }
            }
        }
        super.onActivityResult(n, n2, intent);
    }

    static /* synthetic */ boolean zzb(PlaceAutocompleteFragment placeAutocompleteFragment) {
        return placeAutocompleteFragment.zzdh;
    }

    static /* synthetic */ void zzc(PlaceAutocompleteFragment placeAutocompleteFragment) {
        placeAutocompleteFragment.zzn();
    }
}

