/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.content.Context;
import android.os.Looper;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.util.zzv;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zztf;
import com.google.android.gms.internal.zztg;
import com.google.android.gms.internal.zzth;
import com.google.android.gms.internal.zzti;
import com.google.android.gms.plus.Account;
import com.google.android.gms.plus.People;
import com.google.android.gms.plus.internal.PlusCommonExtras;
import com.google.android.gms.plus.internal.PlusSession;
import com.google.android.gms.plus.internal.zze;
import com.google.android.gms.plus.zzb;
import java.util.HashSet;
import java.util.Set;

public final class Plus {
    public static final Api.zzf<zze> zzaaz = new Api.zzf();
    static final Api.zza<zze, PlusOptions> zzaaA = new Api.zza<zze, PlusOptions>(){

        public zze zza(Context context, Looper looper, zzg zzg2, PlusOptions plusOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            if (plusOptions == null) {
                plusOptions = new PlusOptions();
            }
            return new zze(context, looper, zzg2, new PlusSession(zzg2.zztk().name, zzv.zzc((Set)zzg2.zztw()), plusOptions.zzbln.toArray(new String[0]), new String[0], context.getPackageName(), context.getPackageName(), null, new PlusCommonExtras()), connectionCallbacks, onConnectionFailedListener);
        }

        public int getPriority() {
            return 2;
        }
    };
    public static final Api<PlusOptions> API = new Api("Plus.API", zzaaA, zzaaz);
    public static final Scope SCOPE_PLUS_LOGIN = new Scope("https://www.googleapis.com/auth/plus.login");
    public static final Scope SCOPE_PLUS_PROFILE = new Scope("https://www.googleapis.com/auth/plus.me");
    public static final People PeopleApi = new zzti();
    @Deprecated
    public static final Account AccountApi = new zztf();
    public static final zzb zzblk = new zzth();
    public static final com.google.android.gms.plus.zza zzbll = new zztg();

    private Plus() {
    }

    public static zze zzf(GoogleApiClient googleApiClient, boolean bl) {
        zzaa.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzaa.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        zzaa.zza((boolean)googleApiClient.zza(API), (Object)"GoogleApiClient is not configured to use the Plus.API Api. Pass this into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Plus.API and is not connected to Plus. Use GoogleApiClient.hasConnectedApi(Plus.API) to guard this call.");
        }
        return bl2 ? (zze)googleApiClient.zza(zzaaz) : null;
    }

    public static abstract class zza<R extends Result>
    extends zznt.zza<R, zze> {
        public zza(GoogleApiClient googleApiClient) {
            super(zzaaz, googleApiClient);
        }
    }

    public static final class PlusOptions
    implements Api.ApiOptions.Optional {
        final String zzblm;
        final Set<String> zzbln;

        private PlusOptions() {
            this.zzblm = null;
            this.zzbln = new HashSet<String>();
        }

        private PlusOptions(Builder builder) {
            this.zzblm = builder.zzblm;
            this.zzbln = builder.zzbln;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            String zzblm;
            final Set<String> zzbln = new HashSet<String>();

            public Builder setServerClientId(String string) {
                this.zzblm = string;
                return this;
            }

            public Builder addActivityTypes(String ... stringArray) {
                zzaa.zzb((Object)stringArray, (Object)"activityTypes may not be null.");
                for (int i = 0; i < stringArray.length; ++i) {
                    this.zzbln.add(stringArray[i]);
                }
                return this;
            }

            public PlusOptions build() {
                return new PlusOptions(this);
            }
        }
    }
}

