/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.content.Context;
import android.os.Looper;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.util.zzv;
import com.google.android.gms.internal.zzpr;
import com.google.android.gms.internal.zzvh;
import com.google.android.gms.internal.zzvi;
import com.google.android.gms.internal.zzvj;
import com.google.android.gms.internal.zzvk;
import com.google.android.gms.plus.Account;
import com.google.android.gms.plus.People;
import com.google.android.gms.plus.internal.PlusCommonExtras;
import com.google.android.gms.plus.internal.PlusSession;
import com.google.android.gms.plus.internal.zze;
import com.google.android.gms.plus.zzb;
import java.util.HashSet;
import java.util.Set;

public final class Plus {
    public static final Api.zzf<zze> bN = new Api.zzf();
    static final Api.zza<zze, PlusOptions> bO = new Api.zza<zze, PlusOptions>(){

        public zze zza(Context context, Looper looper, zzg zzg2, PlusOptions plusOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            if (plusOptions == null) {
                plusOptions = new PlusOptions();
            }
            return new zze(context, looper, zzg2, new PlusSession(zzg2.zzaru().name, zzv.zzd((Set)zzg2.zzasg()), plusOptions.ass.toArray(new String[0]), new String[0], context.getPackageName(), context.getPackageName(), null, new PlusCommonExtras()), connectionCallbacks, onConnectionFailedListener);
        }

        public int getPriority() {
            return 2;
        }
    };
    public static final Api<PlusOptions> API = new Api("Plus.API", bO, bN);
    public static final Scope SCOPE_PLUS_LOGIN = new Scope("https://www.googleapis.com/auth/plus.login");
    public static final Scope SCOPE_PLUS_PROFILE = new Scope("https://www.googleapis.com/auth/plus.me");
    public static final People PeopleApi = new zzvk();
    @Deprecated
    public static final Account AccountApi = new zzvh();
    public static final zzb asp = new zzvj();
    public static final com.google.android.gms.plus.zza asq = new zzvi();

    private Plus() {
    }

    public static zze zzf(GoogleApiClient googleApiClient, boolean bl) {
        zzab.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzab.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        zzab.zza((boolean)googleApiClient.zza(API), (Object)"GoogleApiClient is not configured to use the Plus.API Api. Pass this into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Plus.API and is not connected to Plus. Use GoogleApiClient.hasConnectedApi(Plus.API) to guard this call.");
        }
        return bl2 ? (zze)googleApiClient.zza(bN) : null;
    }

    public static abstract class zza<R extends Result>
    extends zzpr.zza<R, zze> {
        public zza(GoogleApiClient googleApiClient) {
            super(bN, googleApiClient);
        }
    }

    public static final class PlusOptions
    implements Api.ApiOptions.Optional {
        final String asr;
        final Set<String> ass;

        private PlusOptions() {
            this.asr = null;
            this.ass = new HashSet<String>();
        }

        private PlusOptions(Builder builder) {
            this.asr = builder.asr;
            this.ass = builder.ass;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            String asr;
            final Set<String> ass = new HashSet<String>();

            public Builder setServerClientId(String string) {
                this.asr = string;
                return this;
            }

            public Builder addActivityTypes(String ... stringArray) {
                zzab.zzb((Object)stringArray, (Object)"activityTypes may not be null.");
                for (int i = 0; i < stringArray.length; ++i) {
                    this.ass.add(stringArray[i]);
                }
                return this;
            }

            public PlusOptions build() {
                return new PlusOptions(this);
            }
        }
    }
}

