/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.recaptcha;

import android.app.Activity;
import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.recaptcha.zzak;
import com.google.android.gms.internal.recaptcha.zzal;
import com.google.android.gms.internal.recaptcha.zzam;
import com.google.android.gms.internal.recaptcha.zzan;
import com.google.android.gms.internal.recaptcha.zzao;
import com.google.android.gms.internal.recaptcha.zzap;
import com.google.android.gms.internal.recaptcha.zzbj;
import com.google.android.gms.internal.recaptcha.zzbp;
import com.google.android.gms.internal.recaptcha.zzbr;
import com.google.android.gms.internal.recaptcha.zzcp;
import com.google.android.gms.internal.recaptcha.zzcs;
import com.google.android.gms.internal.recaptcha.zzct;
import com.google.android.gms.internal.recaptcha.zzcy;
import com.google.android.gms.internal.recaptcha.zzdb;
import com.google.android.gms.internal.recaptcha.zzdf;
import com.google.android.gms.recaptcha.RecaptchaAction;
import com.google.android.gms.recaptcha.RecaptchaClient;
import com.google.android.gms.recaptcha.RecaptchaHandle;
import com.google.android.gms.recaptcha.RecaptchaResultData;
import com.google.android.gms.recaptcha.VerificationHandle;
import com.google.android.gms.recaptcha.VerificationResult;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;

public final class zzaq
implements RecaptchaClient {
    private static final zzcs zza = zzct.zza();
    private final Context zzb;
    private final zzbr zzc;
    private final zzbp zzd;
    private final zzbj zze;
    private final zzcy zzf;
    private final zzdf zzg;
    private final zzcp zzh;

    public static zzaq zza(Activity activity) {
        zzbr zzbr2 = new zzbr((Context)activity);
        zzbp zzbp2 = new zzbp((Context)activity);
        zzbj zzbj2 = new zzbj();
        zzcy zzcy2 = new zzcy(zza);
        zzdf zzdf2 = new zzdf((Context)activity, zza);
        zzaq zzaq2 = new zzaq((Context)activity, zzbr2, zzbp2, zzbj2, zzcy2, zzdf2, zzcp.zzb());
        return zzaq2;
    }

    public static zzaq zzb(Context context) {
        zzbr zzbr2 = new zzbr(context);
        zzbp zzbp2 = new zzbp(context);
        zzbj zzbj2 = new zzbj();
        zzcy zzcy2 = new zzcy(zza);
        zzdf zzdf2 = new zzdf(context, zza);
        zzaq zzaq2 = new zzaq(context, zzbr2, zzbp2, zzbj2, zzcy2, zzdf2, zzcp.zzb());
        return zzaq2;
    }

    @Override
    public final Task<VerificationHandle> challengeAccount(RecaptchaHandle recaptchaHandle, String string) {
        if (recaptchaHandle == null || string == null) {
            Object object = new NullPointerException("Cannot call challengeAccount with a null RecaptchaHandle or a null challenge request token.");
            throw object;
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzao zzao2 = new zzao((zzaq)object, taskCompletionSource);
        ((zzaq)object).zzf.zze(zzao2, recaptchaHandle, string);
        return taskCompletionSource.getTask();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final Task<Boolean> close(RecaptchaHandle recaptchaHandle) {
        Object object;
        if (recaptchaHandle == null) {
            object = new NullPointerException("Cannot call close with a null RecaptchaHandle.");
            throw object;
        }
        recaptchaHandle = new TaskCompletionSource();
        zzan zzan2 = new zzan((zzaq)object, (TaskCompletionSource)recaptchaHandle);
        try {
            object = new Status(0);
            zzan2.zzb((Status)object, false);
        }
        catch (RemoteException remoteException) {
            zzak.zza("RecaptchaOPClose", remoteException);
            return recaptchaHandle.getTask();
        }
        return recaptchaHandle.getTask();
    }

    @Override
    public final Task<RecaptchaResultData> execute(RecaptchaHandle recaptchaHandle, RecaptchaAction recaptchaAction) {
        if (recaptchaHandle == null || recaptchaAction == null) {
            Object object = new NullPointerException("Cannot call execute with a null RecaptchaHandle or a null RecaptchaAction. Make sure to call init first.");
            throw object;
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzam zzam2 = new zzam((zzaq)object, taskCompletionSource);
        Object object = ((zzaq)object).zzb;
        Object object2 = recaptchaHandle.getSiteKey();
        object = zzdb.zza(object, (String)object2);
        object2 = ((zzaq)object).zzd;
        RecaptchaAction recaptchaAction2 = new RecaptchaAction(recaptchaAction, (String)object);
        ((zzbp)object2).zze(zzam2, recaptchaHandle, recaptchaAction2, ((zzaq)object).zzh);
        return taskCompletionSource.getTask();
    }

    @Override
    public final Task<RecaptchaHandle> init(String string) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        if (string == null) {
            Object object = new NullPointerException("Cannot call init with a null site key.");
            throw object;
        }
        zzal zzal2 = new zzal((zzaq)object, taskCompletionSource);
        ((zzaq)object).zzc.zzb(zzal2, string, ((zzaq)object).zzb.getPackageName(), ((zzaq)object).zzh);
        return taskCompletionSource.getTask();
    }

    @Override
    public final Task<VerificationResult> verifyAccount(String string, VerificationHandle verificationHandle) {
        if (string == null || verificationHandle == null) {
            Object object = new NullPointerException("Cannot call verifyAccount with a null pin or a null VerificationHandle.");
            throw object;
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzap zzap2 = new zzap((zzaq)object, taskCompletionSource);
        ((zzaq)object).zzg.zze(zzap2, string, verificationHandle);
        return taskCompletionSource.getTask();
    }

    @VisibleForTesting
    zzaq(Context context, zzbr zzbr2, zzbp zzbp2, zzbj zzbj2, zzcy zzcy2, zzdf zzdf2, zzcp zzcp2) {
        this.zzb = context;
        this.zzc = zzbr2;
        this.zzd = zzbp2;
        this.zze = zzbj2;
        this.zzf = zzcy2;
        this.zzg = zzdf2;
        this.zzh = zzcp2;
    }
}

