/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.recaptcha;

import com.google.android.gms.internal.recaptcha.zzom;
import com.google.android.gms.internal.recaptcha.zzon;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

abstract class zzoo<T>
extends AtomicReference<Runnable>
implements Runnable {
    private static final Runnable zza;
    private static final Runnable zzb;

    abstract T zza() throws Exception;

    abstract String zzb();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final String toString() {
        CharSequence charSequence;
        Object object = (Runnable)((AtomicReference)((Object)string)).get();
        if (object == zza) {
            object = "running=[DONE]";
        } else if (object instanceof zzom) {
            object = "running=[INTERRUPTED]";
        } else if (object instanceof Thread) {
            object = ((Thread)object).getName();
            String string = String.valueOf(object);
            int n = string.length();
            charSequence = new StringBuilder(n + 21);
            ((StringBuilder)charSequence).append("running=[RUNNING ON ");
            ((StringBuilder)charSequence).append((String)object);
            ((StringBuilder)charSequence).append("]");
            object = ((StringBuilder)charSequence).toString();
        } else {
            object = "running=[NOT STARTED YET]";
        }
        String string = ((zzoo)((Object)string)).zzb();
        String string2 = String.valueOf(object);
        int n = string2.length();
        charSequence = String.valueOf(string);
        int n2 = ((String)charSequence).length();
        StringBuilder stringBuilder = new StringBuilder(n + 2 + n2);
        stringBuilder.append((String)object);
        stringBuilder.append(", ");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    static {
        zzon zzon2 = new zzon(null);
        zza = zzon2;
        zzon2 = new zzon(null);
        zzb = zzon2;
    }

    zzoo() {
    }

    abstract void zzd(Throwable var1);

    abstract void zze(T var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void zzh() {
        Runnable runnable = (Runnable)this.get();
        if (!(runnable instanceof Thread)) return;
        Runnable runnable2 = new zzom(this, null);
        zzom.zza((zzom)runnable2, Thread.currentThread());
        if (!this.compareAndSet(runnable, runnable2)) return;
        try {
            runnable2 = (Thread)runnable;
            ((Thread)runnable2).interrupt();
        }
        catch (Throwable throwable) {
            if (this.getAndSet(zza) != zzb) {
                throw throwable;
            }
            LockSupport.unpark((Thread)runnable);
            throw throwable;
        }
        if (this.getAndSet(zza) != zzb) return;
        LockSupport.unpark((Thread)runnable2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        T t;
        Thread thread = Thread.currentThread();
        if (!this.compareAndSet(null, thread)) {
            return;
        }
        boolean bl = this.zzg() ^ true;
        if (bl) {
            t = this.zza();
        } else {
            t = null;
        }
        if (!this.compareAndSet(thread, zza)) {
            this.zzc(thread);
        }
        if (bl) {
            this.zze(t);
            return;
        }
        return;
        catch (Throwable throwable) {
            if (!this.compareAndSet(thread, zza)) {
                this.zzc(thread);
            }
            this.zzd(throwable);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzc(Thread thread) {
        Runnable runnable = (Runnable)this.get();
        boolean bl = false;
        int n = 0;
        zzom zzom2 = null;
        while (true) {
            if (!(runnable instanceof zzom)) {
                if (runnable != zzb) {
                    if (bl) {
                        thread.interrupt();
                        return;
                    }
                    return;
                }
            } else {
                zzom2 = (zzom)runnable;
            }
            if (++n > 1000) {
                if (runnable == zzb || this.compareAndSet(runnable, zzb)) {
                    bl = !Thread.interrupted() ? bl : true;
                    LockSupport.park(zzom2);
                }
            } else {
                Thread.yield();
            }
            runnable = (Runnable)this.get();
        }
    }

    abstract boolean zzg();
}

