/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.internal.zzcos;
import com.google.android.gms.internal.zzcot;
import com.google.android.gms.internal.zzcow;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class zzcov {
    private static final String TAG = zzcov.class.getSimpleName();
    private static final char[] zzjmb = "0123456789ABCDEF".toCharArray();
    private static final Pattern zzjmc = Pattern.compile("/\\.\\.");
    private static final Pattern zzjmd = Pattern.compile("0[1-7][0-7]*");
    private static final Pattern zzjme = Pattern.compile("0x[0-9a-f]*", 2);
    private static final Pattern zzjmf = Pattern.compile("^((?:0x[0-9a-f]+|[0-9\\\\.])+)$", 2);
    private final String zzad;
    private final String zzjmg;
    private final String zzjmh;
    private final int zzjmi;
    private final String mPath;
    private final String zzarx;

    public zzcov(String string) {
        String string2;
        String string3;
        String string4;
        if (!(!TextUtils.isEmpty((CharSequence)string))) {
            this.zzad = null;
            this.zzjmg = null;
            this.zzjmh = null;
            this.zzjmi = -1;
            this.mPath = null;
            this.zzarx = null;
            return;
        }
        int n = (string = string.replaceAll("^\\s+", "").replaceAll("\\s+$", "").replaceAll("[\\t\\n\\r]", "")).indexOf(35);
        zza zza2 = new zza(string = n != -1 ? string.substring(0, n) : string, null);
        if (!zza2.zzbbr()) {
            this.zzad = null;
            this.zzjmg = null;
            this.zzjmh = null;
            this.zzjmi = -1;
            this.mPath = null;
            this.zzarx = null;
            return;
        }
        this.zzjmg = zza2.getScheme();
        this.zzjmi = zza2.getPort();
        if (this.zzjmg != null) {
            string4 = this.zzjmg;
            string = string.replaceAll(new StringBuilder(2 + String.valueOf(string4).length()).append("^").append(string4).append(":").toString(), "");
        }
        string = zzcov.zzky(string.replaceAll("^/+", ""));
        string4 = null;
        int n2 = string.indexOf(63);
        if (n2 != -1) {
            int n3 = n2 + 1;
            string4 = n3 < string.length() ? string.substring(n3) : "";
            string = string.substring(0, n2);
        }
        String string5 = string;
        zzcov zzcov2 = this;
        if (TextUtils.isEmpty((CharSequence)string5)) {
            string3 = null;
        } else {
            String string6;
            String string7 = string5;
            int n4 = string7.indexOf(47);
            string7 = n4 != -1 ? string7.substring(0, n4) : string7;
            int n5 = string7.indexOf(64);
            String string8 = string7 = n5 != -1 ? string7.substring(n5 + 1) : string7;
            if (zzcov2.zzjmi != -1) {
                int n6 = zzcov2.zzjmi;
                string7 = string7.replaceAll(new StringBuilder(13).append(":").append(n6).append("$").toString(), "");
            }
            if ((string6 = zzcov.zzku(string7 = string7.replaceAll("^\\.*", "").replaceAll("\\.*$", "").replaceAll("\\.+", "."))) != null) {
                string7 = string6;
            }
            string3 = string2 = string7.toLowerCase(Locale.getDefault());
        }
        if (TextUtils.isEmpty(string3)) {
            this.zzad = null;
            this.zzjmh = null;
            this.mPath = null;
            this.zzarx = null;
            return;
        }
        String string9 = this.zzkw(string);
        this.zzjmh = zzcov.zzkx(string2);
        this.mPath = zzcov.zzkx(string9);
        this.zzarx = !TextUtils.isEmpty((CharSequence)string4) ? zzcov.zzkx(string4) : string4;
        this.zzad = string;
    }

    private static String zzku(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String string2 = string.replaceAll("^\\[", "").replaceAll("\\]$", "");
        if (zzcot.zzko(string2)) {
            String string3;
            String string4;
            InetAddress inetAddress = zzcot.zzkt(string2);
            if (inetAddress instanceof Inet4Address) {
                string4 = inetAddress.getHostAddress();
            } else {
                int n;
                int n2;
                int n3;
                byte[] byArray = inetAddress.getAddress();
                int[] nArray = new int[8];
                for (int i = 0; i < 8; ++i) {
                    n3 = byArray[2 * i + 1];
                    n2 = byArray[2 * i];
                    nArray[i] = 0 | (n2 & 0xFF) << 8 | n3 & 0xFF;
                }
                int[] nArray2 = nArray;
                int n4 = -1;
                n2 = -1;
                n3 = -1;
                for (n = 0; n < 9; ++n) {
                    if (n < 8 && nArray2[n] == 0) {
                        if (n3 >= 0) continue;
                        n3 = n;
                        continue;
                    }
                    if (n3 < 0) continue;
                    int n5 = n - n3;
                    if (n5 > n2) {
                        n4 = n3;
                        n2 = n5;
                    }
                    n3 = -1;
                }
                if (n2 >= 2) {
                    Arrays.fill(nArray2, n4, n4 + n2, -1);
                }
                nArray2 = nArray;
                StringBuilder stringBuilder = new StringBuilder(39);
                n2 = 0;
                for (n3 = 0; n3 < 8; ++n3) {
                    n = nArray2[n3] >= 0 ? 1 : 0;
                    if (n != 0) {
                        if (n2 != 0) {
                            stringBuilder.append(':');
                        }
                        stringBuilder.append(Integer.toHexString(nArray2[n3]));
                    } else if (n3 == 0 || n2 != 0) {
                        stringBuilder.append("::");
                    }
                    n2 = n;
                }
                string4 = string3 = stringBuilder.toString();
            }
            if (string4.contains(":")) {
                return String.format("[%s]", string3);
            }
            return string3;
        }
        if (TextUtils.isDigitsOnly((CharSequence)string)) {
            String string5 = zzcov.zzkv(string);
            if (!TextUtils.isEmpty((CharSequence)string5)) {
                return string5;
            }
        } else if (zzjmf.matcher(string2).find()) {
            int n;
            Matcher matcher = zzjmd.matcher(string2);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                n = Integer.parseInt(matcher.group(), 8);
                matcher.appendReplacement(stringBuffer, new StringBuilder(11).append(n).toString());
            }
            matcher.appendTail(stringBuffer);
            matcher = zzjme.matcher(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            while (matcher.find()) {
                n = Integer.parseInt(matcher.group().substring(2), 16);
                matcher.appendReplacement(stringBuffer, new StringBuilder(11).append(n).toString());
            }
            matcher.appendTail(stringBuffer);
            String string6 = stringBuffer.toString();
            if (string6.contains(":")) {
                return String.format("[%s]", string6);
            }
            return string6;
        }
        return null;
    }

    private static String zzkv(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            byte[] byArray;
            BigInteger bigInteger = new BigInteger(string);
            byte[] byArray2 = bigInteger.toByteArray();
            if (byArray2.length < 4) {
                return null;
            }
            byte[] byArray3 = Arrays.copyOfRange(byArray2, byArray2.length - 4, byArray2.length);
            byte[] byArray4 = new byte[]{0, byArray3[0], byArray3[1], byArray3[2], byArray3[3]};
            BigInteger bigInteger2 = new BigInteger(byArray4);
            if (bigInteger.equals(bigInteger2)) {
                return Inet4Address.getByAddress(byArray3).getHostAddress();
            }
            if (byArray2.length >= 16) {
                byArray = Arrays.copyOfRange(byArray2, byArray2.length - 16, byArray2.length);
            } else {
                int n;
                byte[] byArray5 = new byte[16];
                int n2 = 0;
                int n3 = 16 - byArray2.length;
                for (n = 1; n <= n3; ++n) {
                    byArray5[n2++] = 0;
                }
                for (n = 0; n < byArray2.length; ++n) {
                    byArray5[n2++] = byArray2[n];
                }
                byArray = byArray5;
            }
            return String.format("[%s]", Inet6Address.getByAddress(byArray).getHostAddress());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    private final String zzkw(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.indexOf(47);
        String string2 = (n != -1 ? string.substring(n) : "/").replaceAll("/\\./", "/").replaceAll("/\\.$", "/");
        if (zzjmc.matcher(string2).find()) {
            try {
                string2 = new URI(this.zzjmg, "host", string2, null).normalize().getRawPath();
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return string2.replaceAll("/+", "/");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final List<zzcos> zzbbo() {
        List<String> list;
        zzcov zzcov2 = this;
        if (TextUtils.isEmpty((CharSequence)zzcov2.zzad)) return null;
        String string = zzcov.zzku(zzcov2.zzjmh);
        if (string != null) {
            list = new ArrayList<String>();
            list.add(string);
        } else {
            list = zzcov2.zzbbp();
        }
        if (list == null) return null;
        if (list.isEmpty()) {
            return null;
        }
        List<String> list2 = zzcov2.zzbbq();
        if (list2 == null) return null;
        if (list2.isEmpty()) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string2 : list) {
            for (String string3 : list2) {
                String string4 = String.valueOf(string2);
                String string5 = String.valueOf(string3);
                linkedList.add(string5.length() != 0 ? string4.concat(string5) : new String(string4));
            }
        }
        if (linkedList.isEmpty()) return null;
        LinkedList<String> linkedList2 = linkedList;
        LinkedList<String> linkedList3 = linkedList2;
        if (linkedList2 == null) return null;
        if (linkedList3.isEmpty()) {
            return null;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        if (messageDigest == null) {
            return null;
        }
        ArrayList<zzcos> arrayList = new ArrayList<zzcos>(linkedList3.size());
        for (String string6 : linkedList3) {
            if (TextUtils.isEmpty((CharSequence)string6)) continue;
            try {
                byte[] byArray = messageDigest.digest(string6.getBytes("UTF-8"));
                arrayList.add(new zzcos(byArray));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            messageDigest.reset();
        }
        if (arrayList.isEmpty()) return null;
        return arrayList;
    }

    private final List<String> zzbbp() {
        if (TextUtils.isEmpty((CharSequence)this.zzjmh)) {
            return null;
        }
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        char[] cArray = this.zzjmh.toCharArray();
        for (int i = cArray.length - 2; i > 0 && arrayList.size() < 4; --i) {
            if (cArray[i] != '.') continue;
            if (bl) {
                arrayList.add(this.zzjmh.substring(i + 1));
                continue;
            }
            bl = true;
        }
        arrayList.add(this.zzjmh);
        return arrayList;
    }

    private final List<String> zzbbq() {
        if (TextUtils.isEmpty((CharSequence)this.mPath)) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        char[] cArray = this.mPath.toCharArray();
        for (int i = 0; i < cArray.length && arrayList.size() < 4; ++i) {
            if (cArray[i] != '/') continue;
            arrayList.add(this.mPath.substring(0, i + 1));
        }
        if (!arrayList.isEmpty() && !((String)arrayList.get(arrayList.size() - 1)).equals(this.mPath)) {
            arrayList.add(this.mPath);
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzarx)) {
            String string = this.mPath;
            String string2 = this.zzarx;
            arrayList.add(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?").append(string2).toString());
        }
        return arrayList;
    }

    private static String zzkx(String string) {
        byte[] byArray;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            char c = (char)(byArray[i] & 0xFF);
            if (c <= ' ' || c > '~' || c == '#' || c == '%') {
                stringBuilder.append("%");
                stringBuilder.append(zzjmb[c >>> 4]);
                stringBuilder.append(zzjmb[c & 0xF]);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static String zzky(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String string2 = string;
        String string3 = null;
        for (int i = 0; !string2.equals(string3) && i < 1024; ++i) {
            string3 = string2;
            string2 = zzcov.zzkz(string3);
        }
        return string2;
    }

    /*
     * Unable to fully structure code
     */
    private static String zzkz(String var0) {
        try {
            var1_1 = var0.replace("\\x", "%").getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException v0) {
            return null;
        }
        var2_2 = new ByteArrayOutputStream(var1_1.length);
        for (var3_3 = 0; var3_3 < var1_1.length; ++var3_3) {
            block8: {
                var4_4 = var1_1[var3_3];
                if ((char)(var4_4 & 255) >= '\u0080') break block8;
                var7_7 = var3_3;
                var6_6 = var1_1;
                if (var7_7 + 2 >= var6_6.length || (char)(var6_6[var7_7] & 255) != '%') ** GOTO lbl-1000
                var8_8 = (char)(var6_6[var7_7 + 1] & 255);
                var9_9 = (char)(var6_6[var7_7 + 2] & 255);
                if (zzcov.isHexDigit(var8_8) && zzcov.isHexDigit(var9_9)) {
                    v1 = (byte)((Integer.parseInt(new StringBuilder(1).append(var8_8).toString(), 16) << 4) + Integer.parseInt(new StringBuilder(1).append(var9_9).toString(), 16));
                } else lbl-1000:
                // 2 sources

                {
                    v1 = var5_5 = null;
                }
                if (v1 != null) {
                    var2_2.write(var5_5.byteValue());
                    var3_3 += 2;
                    continue;
                }
            }
            var2_2.write(var4_4);
        }
        try {
            return new String(var2_2.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException v2) {
            return null;
        }
    }

    static final class zza {
        private static final String[] zzjmj = new String[]{"http", "https", "ftp"};
        private final String zzdvc;
        private final Uri zzjmk;
        private final URI zzjml;
        private final String zzjmg;
        private final Boolean zzjmm;
        private final Integer zzjmn;

        private zza(String string) {
            int n;
            this.zzdvc = string;
            this.zzjmk = Uri.parse((String)this.zzdvc);
            try {
                new URI(this.zzdvc);
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            finally {
                this.zzjml = null;
            }
            this.zzjmg = this.getScheme();
            this.zzjmm = this.zzbbr();
            zza zza2 = this;
            this.zzjmn = zza2.zzjmn != null ? zza2.zzjmn : (zza2.zzjmk != null && (n = zza2.zzjmk.getPort()) != -1 ? n : -1);
        }

        private final String getScheme() {
            if (this.zzjmg != null) {
                return this.zzjmg;
            }
            String string = null;
            if (this.zzjmk != null) {
                string = this.zzjmk.getScheme();
            }
            TextUtils.isEmpty(string);
            if (TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)this.zzdvc)) {
                String string2;
                int n = this.zzdvc.indexOf(":");
                if (n != -1 && zza.zzla(string2 = this.zzdvc.substring(0, n).toLowerCase(Locale.US))) {
                    string = string2;
                }
                if (TextUtils.isEmpty((CharSequence)string)) {
                    this.zzdvc.startsWith("www.");
                    string = "http";
                }
            }
            if (string != null) {
                return string.toLowerCase(Locale.US);
            }
            return null;
        }

        private final int getPort() {
            return this.zzjmn;
        }

        private final boolean zzbbr() {
            if (this.zzjmm != null) {
                return this.zzjmm;
            }
            return zza.zzla(this.zzjmg);
        }

        private static boolean zzla(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return false;
            }
            for (int i = 0; i < zzjmj.length; ++i) {
                if (!zzjmj[i].equals(string)) continue;
                return true;
            }
            return false;
        }

        /* synthetic */ zza(String string, zzcow zzcow2) {
            this(string);
        }
    }
}

