/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.SparseArray;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.internal.zzcoe;
import com.google.android.gms.internal.zzcof;
import com.google.android.gms.internal.zzcok;
import com.google.android.gms.internal.zzcol;
import com.google.android.gms.internal.zzcom;
import com.google.android.gms.internal.zzcon;
import com.google.android.gms.internal.zzcoo;
import com.google.android.gms.internal.zzcop;
import com.google.android.gms.internal.zzcoq;
import com.google.android.gms.internal.zzcor;
import com.google.android.gms.internal.zzcos;
import com.google.android.gms.internal.zzcot;
import com.google.android.gms.internal.zzcou;
import com.google.android.gms.internal.zzcov;
import com.google.android.gms.internal.zzcoy;
import com.google.android.gms.internal.zzcpa;
import com.google.android.gms.internal.zzcpb;
import com.google.android.gms.safetynet.HarmfulAppsData;
import com.google.android.gms.safetynet.SafeBrowsingData;
import com.google.android.gms.safetynet.SafeBrowsingThreat;
import com.google.android.gms.safetynet.SafetyNet;
import com.google.android.gms.safetynet.SafetyNetApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class zzcoj
implements SafetyNetApi {
    private static final String TAG = zzcoj.class.getSimpleName();
    protected static SparseArray<zzcpa> zzjlr;
    protected static long zzjls;

    @Override
    public PendingResult<SafetyNetApi.AttestationResult> attest(GoogleApiClient googleApiClient, byte[] byArray) {
        return zzcoj.zza(googleApiClient, byArray, null);
    }

    public static PendingResult<SafetyNetApi.AttestationResult> zza(GoogleApiClient googleApiClient, byte[] byArray, String string) {
        return googleApiClient.zzd((zzm)new zzcok(googleApiClient, byArray, string));
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, List<Integer> list, String string) {
        String string2 = string;
        List<Integer> list2 = list;
        GoogleApiClient googleApiClient2 = googleApiClient;
        zzcoj zzcoj2 = this;
        if (list2 == null) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        return googleApiClient2.zzd((zzm)new zzcol(zzcoj2, googleApiClient2, list2, string2, null));
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, String string, int ... nArray) {
        return zzcoj.zza(googleApiClient, string, 1, null, nArray);
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, String string, String string2, int ... nArray) {
        return zzcoj.zza(googleApiClient, string, 1, string2, nArray);
    }

    public static PendingResult<SafetyNetApi.SafeBrowsingResult> zza(GoogleApiClient googleApiClient, String string, int n, String string2, int ... nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        return googleApiClient.zzd((zzm)new zzcom(googleApiClient, nArray, n, string, string2));
    }

    @Override
    public boolean lookupUriInLocalBlacklist(String string, int ... nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        if (zzjlr == null || zzjls == 0L || SystemClock.elapsedRealtime() - zzjls >= 1200000L) {
            return true;
        }
        if (zzjlr != null && zzjlr.size() != 0) {
            List<zzcoy> list = new zzcpb(string).zzbbq();
            if (list == null || list.isEmpty()) {
                return true;
            }
            for (zzcoy zzcoy2 : list) {
                int[] nArray2 = nArray;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int n2 = nArray2[i];
                    zzcpa zzcpa2 = (zzcpa)zzjlr.get(n2);
                    if (zzcpa2 != null) {
                        if (!zzcpa2.zzv(zzcoy2.zzeb(4).getBytes())) continue;
                        return true;
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isVerifyAppsEnabled(Context context) {
        GoogleApiClient googleApiClient = new GoogleApiClient.Builder(context).addApi(SafetyNet.API).build();
        try {
            if (googleApiClient.blockingConnect(3L, TimeUnit.SECONDS).isSuccess()) {
                SafetyNetApi.VerifyAppsUserResult verifyAppsUserResult = (SafetyNetApi.VerifyAppsUserResult)this.isVerifyAppsEnabled(googleApiClient).await(3L, TimeUnit.SECONDS);
                boolean bl = verifyAppsUserResult != null && verifyAppsUserResult.isVerifyAppsEnabled();
                return bl;
            }
            return false;
        }
        finally {
            if (googleApiClient != null) {
                googleApiClient.disconnect();
            }
        }
    }

    @Override
    public PendingResult<SafetyNetApi.VerifyAppsUserResult> isVerifyAppsEnabled(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zzm)new zzcon(this, googleApiClient));
    }

    @Override
    public PendingResult<SafetyNetApi.VerifyAppsUserResult> enableVerifyApps(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zzm)new zzcoo(this, googleApiClient));
    }

    @Override
    public PendingResult<SafetyNetApi.HarmfulAppsResult> listHarmfulApps(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zzm)new zzcop(this, googleApiClient));
    }

    @Override
    public PendingResult<SafetyNetApi.RecaptchaTokenResult> verifyWithRecaptcha(GoogleApiClient googleApiClient, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty site key in verifyWithRecaptcha");
        }
        return googleApiClient.zzd((zzm)new zzcoq(this, googleApiClient, string));
    }

    static final class zzh
    implements SafetyNetApi.RecaptchaTokenResult {
        private final Status mStatus;
        private final com.google.android.gms.safetynet.zzf zzjmi;

        public zzh(Status status, com.google.android.gms.safetynet.zzf zzf2) {
            this.mStatus = status;
            this.zzjmi = zzf2;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getTokenResult() {
            if (this.zzjmi == null) {
                return null;
            }
            return this.zzjmi.getTokenResult();
        }
    }

    static abstract class zze
    extends zzcoe<SafetyNetApi.RecaptchaTokenResult> {
        protected zzcof zzjmb = new zzcou(this);

        public zze(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zzh(status2, null);
        }
    }

    static abstract class zzd
    extends zzcoe<SafetyNetApi.HarmfulAppsResult> {
        protected final zzcof zzjmb = new zzcot(this);

        public zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zzg(status2, null);
        }
    }

    static final class zzg
    implements SafetyNetApi.HarmfulAppsResult {
        private final Status mStatus;
        private final com.google.android.gms.safetynet.zzd zzjmh;

        public zzg(Status status, com.google.android.gms.safetynet.zzd zzd2) {
            this.mStatus = status;
            this.zzjmh = zzd2;
        }

        @Override
        public final List<HarmfulAppsData> getHarmfulAppsList() {
            if (this.zzjmh == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(this.zzjmh.zzjlm);
        }

        @Override
        public final long getLastScanTimeMs() {
            if (this.zzjmh == null) {
                return 0L;
            }
            return this.zzjmh.zzjll;
        }

        public final Status getStatus() {
            return this.mStatus;
        }
    }

    static abstract class zzc
    extends zzcoe<SafetyNetApi.VerifyAppsUserResult> {
        protected zzcof zzjmb = new zzcos(this);

        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zzj(status2, false);
        }
    }

    static final class zzj
    implements SafetyNetApi.VerifyAppsUserResult {
        private Status mStatus;
        private boolean zzbam;

        public zzj() {
        }

        public zzj(Status status, boolean bl) {
            this.mStatus = status;
            this.zzbam = bl;
        }

        @Override
        public final boolean isVerifyAppsEnabled() {
            if (this.mStatus != null && this.mStatus.isSuccess()) {
                return this.zzbam;
            }
            return false;
        }

        public final Status getStatus() {
            return this.mStatus;
        }
    }

    static final class zzi
    implements SafetyNetApi.SafeBrowsingResult {
        private Status mStatus;
        private final SafeBrowsingData zzjmj;
        private String zzjln;

        public zzi(Status status, SafeBrowsingData safeBrowsingData) {
            this.mStatus = status;
            this.zzjmj = safeBrowsingData;
            this.zzjln = null;
            if (this.zzjmj != null) {
                this.zzjln = this.zzjmj.getMetadata();
                return;
            }
            if (this.mStatus.isSuccess()) {
                this.mStatus = new Status(8);
            }
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getMetadata() {
            return this.zzjln;
        }

        @Override
        public final List<SafeBrowsingThreat> getDetectedThreats() {
            JSONArray jSONArray;
            ArrayList<SafeBrowsingThreat> arrayList = new ArrayList<SafeBrowsingThreat>();
            if (this.zzjln == null) {
                return arrayList;
            }
            try {
                jSONArray = new JSONObject(this.zzjln).getJSONArray("matches");
            }
            catch (JSONException jSONException) {
                return arrayList;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    int n = Integer.parseInt(jSONArray.getJSONObject(i).getString("threat_type"));
                    SafeBrowsingThreat safeBrowsingThreat = new SafeBrowsingThreat(n);
                    arrayList.add(safeBrowsingThreat);
                    continue;
                }
                catch (JSONException jSONException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return arrayList;
        }
    }

    static abstract class zzf
    extends zzcoe<SafetyNetApi.SafeBrowsingResult> {
        protected zzcof zzjmb = new zzcov(this);

        public zzf(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zzi(status2, null);
        }
    }

    static final class zza
    implements SafetyNetApi.AttestationResult {
        private final Status mStatus;
        private final com.google.android.gms.safetynet.zza zzjma;

        public zza(Status status, com.google.android.gms.safetynet.zza zza2) {
            this.mStatus = status;
            this.zzjma = zza2;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getJwsResult() {
            if (this.zzjma == null) {
                return null;
            }
            return this.zzjma.getJwsResult();
        }
    }

    static abstract class zzb
    extends zzcoe<SafetyNetApi.AttestationResult> {
        protected zzcof zzjmb = new zzcor(this);

        public zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zza(status2, null);
        }
    }
}

