/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.internal.zzcus;
import com.google.android.gms.internal.zzcut;
import com.google.android.gms.internal.zzcuy;
import com.google.android.gms.internal.zzcuz;
import com.google.android.gms.internal.zzcva;
import com.google.android.gms.internal.zzcvb;
import com.google.android.gms.internal.zzcvc;
import com.google.android.gms.internal.zzcvd;
import com.google.android.gms.internal.zzcve;
import com.google.android.gms.internal.zzcvf;
import com.google.android.gms.internal.zzcvg;
import com.google.android.gms.internal.zzcvh;
import com.google.android.gms.internal.zzcvi;
import com.google.android.gms.internal.zzcvj;
import com.google.android.gms.safetynet.HarmfulAppsData;
import com.google.android.gms.safetynet.SafeBrowsingData;
import com.google.android.gms.safetynet.SafeBrowsingThreat;
import com.google.android.gms.safetynet.SafetyNet;
import com.google.android.gms.safetynet.SafetyNetApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class zzcux
implements SafetyNetApi {
    private static final String TAG = zzcux.class.getSimpleName();

    @Override
    public PendingResult<SafetyNetApi.AttestationResult> attest(GoogleApiClient googleApiClient, byte[] byArray) {
        return zzcux.zza(googleApiClient, byArray, null);
    }

    public static PendingResult<SafetyNetApi.AttestationResult> zza(GoogleApiClient googleApiClient, byte[] byArray, String string) {
        return googleApiClient.zzd((zzm)new zzcuy(googleApiClient, byArray, string));
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, List<Integer> list, String string) {
        String string2 = string;
        List<Integer> list2 = list;
        GoogleApiClient googleApiClient2 = googleApiClient;
        zzcux zzcux2 = this;
        if (list2 == null) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        return googleApiClient2.zzd((zzm)new zzcuz(zzcux2, googleApiClient2, list2, string2, null));
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, String string, int ... nArray) {
        return zzcux.zza(googleApiClient, string, 1, null, nArray);
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, String string, String string2, int ... nArray) {
        return zzcux.zza(googleApiClient, string, 1, string2, nArray);
    }

    public static PendingResult<SafetyNetApi.SafeBrowsingResult> zza(GoogleApiClient googleApiClient, String string, int n, String string2, int ... nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        return googleApiClient.zzd((zzm)new zzcva(googleApiClient, nArray, n, string, string2));
    }

    @Override
    public boolean isVerifyAppsEnabled(Context context) {
        GoogleApiClient googleApiClient = new GoogleApiClient.Builder(context).addApi(SafetyNet.API).build();
        try {
            if (googleApiClient.blockingConnect(3L, TimeUnit.SECONDS).isSuccess()) {
                SafetyNetApi.VerifyAppsUserResult verifyAppsUserResult = (SafetyNetApi.VerifyAppsUserResult)this.isVerifyAppsEnabled(googleApiClient).await(3L, TimeUnit.SECONDS);
                boolean bl = verifyAppsUserResult != null && verifyAppsUserResult.isVerifyAppsEnabled();
                return bl;
            }
            return false;
        }
        finally {
            if (googleApiClient != null) {
                googleApiClient.disconnect();
            }
        }
    }

    @Override
    public PendingResult<SafetyNetApi.VerifyAppsUserResult> isVerifyAppsEnabled(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zzm)new zzcvb(this, googleApiClient));
    }

    @Override
    public PendingResult<SafetyNetApi.VerifyAppsUserResult> enableVerifyApps(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zzm)new zzcvc(this, googleApiClient));
    }

    @Override
    public PendingResult<SafetyNetApi.HarmfulAppsResult> listHarmfulApps(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zzm)new zzcvd(this, googleApiClient));
    }

    @Override
    public PendingResult<SafetyNetApi.RecaptchaTokenResult> verifyWithRecaptcha(GoogleApiClient googleApiClient, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty site key in verifyWithRecaptcha");
        }
        return googleApiClient.zzd((zzm)new zzcve(this, googleApiClient, string));
    }

    static final class zzh
    implements SafetyNetApi.RecaptchaTokenResult {
        private final Status mStatus;
        private final com.google.android.gms.safetynet.zzf zzjyi;

        public zzh(Status status, com.google.android.gms.safetynet.zzf zzf2) {
            this.mStatus = status;
            this.zzjyi = zzf2;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getTokenResult() {
            if (this.zzjyi == null) {
                return null;
            }
            return this.zzjyi.getTokenResult();
        }
    }

    static abstract class zze
    extends zzcus<SafetyNetApi.RecaptchaTokenResult> {
        protected zzcut zzjyb = new zzcvi(this);

        public zze(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zzh(status2, null);
        }
    }

    static abstract class zzd
    extends zzcus<SafetyNetApi.HarmfulAppsResult> {
        protected final zzcut zzjyb = new zzcvh(this);

        public zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zzg(status2, null);
        }
    }

    static final class zzg
    implements SafetyNetApi.HarmfulAppsResult {
        private final Status mStatus;
        private final com.google.android.gms.safetynet.zzd zzjyh;

        public zzg(Status status, com.google.android.gms.safetynet.zzd zzd2) {
            this.mStatus = status;
            this.zzjyh = zzd2;
        }

        @Override
        public final List<HarmfulAppsData> getHarmfulAppsList() {
            if (this.zzjyh == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(this.zzjyh.zzjxn);
        }

        @Override
        public final long getLastScanTimeMs() {
            if (this.zzjyh == null) {
                return 0L;
            }
            return this.zzjyh.zzjxm;
        }

        public final Status getStatus() {
            return this.mStatus;
        }
    }

    static abstract class zzc
    extends zzcus<SafetyNetApi.VerifyAppsUserResult> {
        protected zzcut zzjyb = new zzcvg(this);

        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zzj(status2, false);
        }
    }

    static final class zzj
    implements SafetyNetApi.VerifyAppsUserResult {
        private Status mStatus;
        private boolean zzbap;

        public zzj() {
        }

        public zzj(Status status, boolean bl) {
            this.mStatus = status;
            this.zzbap = bl;
        }

        @Override
        public final boolean isVerifyAppsEnabled() {
            if (this.mStatus != null && this.mStatus.isSuccess()) {
                return this.zzbap;
            }
            return false;
        }

        public final Status getStatus() {
            return this.mStatus;
        }
    }

    public static final class zzi
    implements SafetyNetApi.SafeBrowsingResult {
        private Status mStatus;
        private final SafeBrowsingData zzjyj;
        private String zzjxo;

        public zzi(Status status, SafeBrowsingData safeBrowsingData) {
            this.mStatus = status;
            this.zzjyj = safeBrowsingData;
            this.zzjxo = null;
            if (this.zzjyj != null) {
                this.zzjxo = this.zzjyj.getMetadata();
                return;
            }
            if (this.mStatus.isSuccess()) {
                this.mStatus = new Status(8);
            }
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getMetadata() {
            return this.zzjxo;
        }

        @Override
        public final List<SafeBrowsingThreat> getDetectedThreats() {
            JSONArray jSONArray;
            ArrayList<SafeBrowsingThreat> arrayList = new ArrayList<SafeBrowsingThreat>();
            if (this.zzjxo == null) {
                return arrayList;
            }
            try {
                jSONArray = new JSONObject(this.zzjxo).getJSONArray("matches");
            }
            catch (JSONException jSONException) {
                return arrayList;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    int n = Integer.parseInt(jSONArray.getJSONObject(i).getString("threat_type"));
                    SafeBrowsingThreat safeBrowsingThreat = new SafeBrowsingThreat(n);
                    arrayList.add(safeBrowsingThreat);
                    continue;
                }
                catch (JSONException jSONException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return arrayList;
        }
    }

    static abstract class zzf
    extends zzcus<SafetyNetApi.SafeBrowsingResult> {
        protected zzcut zzjyb = new zzcvj(this);

        public zzf(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zzi(status2, null);
        }
    }

    static final class zza
    implements SafetyNetApi.AttestationResult {
        private final Status mStatus;
        private final com.google.android.gms.safetynet.zza zzjya;

        public zza(Status status, com.google.android.gms.safetynet.zza zza2) {
            this.mStatus = status;
            this.zzjya = zza2;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getJwsResult() {
            if (this.zzjya == null) {
                return null;
            }
            return this.zzjya.getJwsResult();
        }
    }

    static abstract class zzb
    extends zzcus<SafetyNetApi.AttestationResult> {
        protected zzcut zzjyb = new zzcvf(this);

        public zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zza(status2, null);
        }
    }
}

