/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.internal.zzcvu;
import com.google.android.gms.internal.zzcvv;
import com.google.android.gms.internal.zzcwa;
import com.google.android.gms.internal.zzcwb;
import com.google.android.gms.internal.zzcwc;
import com.google.android.gms.internal.zzcwd;
import com.google.android.gms.internal.zzcwe;
import com.google.android.gms.internal.zzcwf;
import com.google.android.gms.internal.zzcwg;
import com.google.android.gms.internal.zzcwh;
import com.google.android.gms.internal.zzcwi;
import com.google.android.gms.internal.zzcwj;
import com.google.android.gms.internal.zzcwk;
import com.google.android.gms.internal.zzcwl;
import com.google.android.gms.safetynet.HarmfulAppsData;
import com.google.android.gms.safetynet.SafeBrowsingData;
import com.google.android.gms.safetynet.SafeBrowsingThreat;
import com.google.android.gms.safetynet.SafetyNet;
import com.google.android.gms.safetynet.SafetyNetApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class zzcvz
implements SafetyNetApi {
    private static final String TAG = zzcvz.class.getSimpleName();

    @Override
    public PendingResult<SafetyNetApi.AttestationResult> attest(GoogleApiClient googleApiClient, byte[] byArray) {
        return zzcvz.zza(googleApiClient, byArray, null);
    }

    public static PendingResult<SafetyNetApi.AttestationResult> zza(GoogleApiClient googleApiClient, byte[] byArray, String string) {
        return googleApiClient.zzd((zzm)new zzcwa(googleApiClient, byArray, string));
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, List<Integer> list, String string) {
        String string2 = string;
        List<Integer> list2 = list;
        GoogleApiClient googleApiClient2 = googleApiClient;
        zzcvz zzcvz2 = this;
        if (list2 == null) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        return googleApiClient2.zzd((zzm)new zzcwb(zzcvz2, googleApiClient2, list2, string2, null));
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, String string, int ... nArray) {
        return zzcvz.zza(googleApiClient, string, 1, null, nArray);
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, String string, String string2, int ... nArray) {
        return zzcvz.zza(googleApiClient, string, 1, string2, nArray);
    }

    public static PendingResult<SafetyNetApi.SafeBrowsingResult> zza(GoogleApiClient googleApiClient, String string, int n, String string2, int ... nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        return googleApiClient.zzd((zzm)new zzcwc(googleApiClient, nArray, n, string, string2));
    }

    @Override
    public boolean isVerifyAppsEnabled(Context context) {
        GoogleApiClient googleApiClient = new GoogleApiClient.Builder(context).addApi(SafetyNet.API).build();
        try {
            if (googleApiClient.blockingConnect(3L, TimeUnit.SECONDS).isSuccess()) {
                SafetyNetApi.VerifyAppsUserResult verifyAppsUserResult = (SafetyNetApi.VerifyAppsUserResult)this.isVerifyAppsEnabled(googleApiClient).await(3L, TimeUnit.SECONDS);
                boolean bl = verifyAppsUserResult != null && verifyAppsUserResult.isVerifyAppsEnabled();
                return bl;
            }
            return false;
        }
        finally {
            if (googleApiClient != null) {
                googleApiClient.disconnect();
            }
        }
    }

    @Override
    public PendingResult<SafetyNetApi.VerifyAppsUserResult> isVerifyAppsEnabled(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zzm)new zzcwd(this, googleApiClient));
    }

    @Override
    public PendingResult<SafetyNetApi.VerifyAppsUserResult> enableVerifyApps(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zzm)new zzcwe(this, googleApiClient));
    }

    @Override
    public PendingResult<SafetyNetApi.HarmfulAppsResult> listHarmfulApps(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zzm)new zzcwf(this, googleApiClient));
    }

    @Override
    public PendingResult<SafetyNetApi.RecaptchaTokenResult> verifyWithRecaptcha(GoogleApiClient googleApiClient, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty site key in verifyWithRecaptcha");
        }
        return googleApiClient.zzd((zzm)new zzcwg(this, googleApiClient, string));
    }

    static final class zzh
    implements SafetyNetApi.RecaptchaTokenResult {
        private final Status mStatus;
        private final com.google.android.gms.safetynet.zzf zzkbb;

        public zzh(Status status, com.google.android.gms.safetynet.zzf zzf2) {
            this.mStatus = status;
            this.zzkbb = zzf2;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getTokenResult() {
            if (this.zzkbb == null) {
                return null;
            }
            return this.zzkbb.getTokenResult();
        }
    }

    static abstract class zze
    extends zzcvu<SafetyNetApi.RecaptchaTokenResult> {
        protected zzcvv zzkau = new zzcwk(this);

        public zze(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zzh(status2, null);
        }
    }

    static abstract class zzd
    extends zzcvu<SafetyNetApi.HarmfulAppsResult> {
        protected final zzcvv zzkau = new zzcwj(this);

        public zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zzg(status2, null);
        }
    }

    static final class zzg
    implements SafetyNetApi.HarmfulAppsResult {
        private final Status mStatus;
        private final com.google.android.gms.safetynet.zzd zzkba;

        public zzg(Status status, com.google.android.gms.safetynet.zzd zzd2) {
            this.mStatus = status;
            this.zzkba = zzd2;
        }

        @Override
        public final List<HarmfulAppsData> getHarmfulAppsList() {
            if (this.zzkba == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(this.zzkba.zzkaf);
        }

        @Override
        public final long getLastScanTimeMs() {
            if (this.zzkba == null) {
                return 0L;
            }
            return this.zzkba.zzkae;
        }

        public final Status getStatus() {
            return this.mStatus;
        }
    }

    static abstract class zzc
    extends zzcvu<SafetyNetApi.VerifyAppsUserResult> {
        protected zzcvv zzkau = new zzcwi(this);

        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zzj(status2, false);
        }
    }

    static final class zzj
    implements SafetyNetApi.VerifyAppsUserResult {
        private Status mStatus;
        private boolean zzbbh;

        public zzj() {
        }

        public zzj(Status status, boolean bl) {
            this.mStatus = status;
            this.zzbbh = bl;
        }

        @Override
        public final boolean isVerifyAppsEnabled() {
            if (this.mStatus != null && this.mStatus.isSuccess()) {
                return this.zzbbh;
            }
            return false;
        }

        public final Status getStatus() {
            return this.mStatus;
        }
    }

    public static final class zzi
    implements SafetyNetApi.SafeBrowsingResult {
        private Status mStatus;
        private final SafeBrowsingData zzkbc;
        private String zzkag;
        private long zzcyk;
        private byte[] zzkai;

        public zzi(Status status, SafeBrowsingData safeBrowsingData) {
            this.mStatus = status;
            this.zzkbc = safeBrowsingData;
            this.zzkag = null;
            if (this.zzkbc != null) {
                this.zzkag = this.zzkbc.getMetadata();
                this.zzcyk = this.zzkbc.getLastUpdateTimeMs();
                this.zzkai = this.zzkbc.getState();
                return;
            }
            if (this.mStatus.isSuccess()) {
                this.mStatus = new Status(8);
            }
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getMetadata() {
            return this.zzkag;
        }

        @Override
        public final long getLastUpdateTimeMs() {
            return this.zzcyk;
        }

        @Override
        public final byte[] getState() {
            return this.zzkai;
        }

        @Override
        public final List<SafeBrowsingThreat> getDetectedThreats() {
            JSONArray jSONArray;
            ArrayList<SafeBrowsingThreat> arrayList = new ArrayList<SafeBrowsingThreat>();
            if (this.zzkag == null) {
                return arrayList;
            }
            try {
                jSONArray = new JSONObject(this.zzkag).getJSONArray("matches");
            }
            catch (JSONException jSONException) {
                return arrayList;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    int n = Integer.parseInt(jSONArray.getJSONObject(i).getString("threat_type"));
                    SafeBrowsingThreat safeBrowsingThreat = new SafeBrowsingThreat(n);
                    arrayList.add(safeBrowsingThreat);
                    continue;
                }
                catch (JSONException jSONException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return arrayList;
        }
    }

    static abstract class zzf
    extends zzcvu<SafetyNetApi.SafeBrowsingResult> {
        protected zzcvv zzkau = new zzcwl(this);

        public zzf(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zzi(status2, null);
        }
    }

    static final class zza
    implements SafetyNetApi.AttestationResult {
        private final Status mStatus;
        private final com.google.android.gms.safetynet.zza zzkat;

        public zza(Status status, com.google.android.gms.safetynet.zza zza2) {
            this.mStatus = status;
            this.zzkat = zza2;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getJwsResult() {
            if (this.zzkat == null) {
                return null;
            }
            return this.zzkat.getJwsResult();
        }
    }

    static abstract class zzb
    extends zzcvu<SafetyNetApi.AttestationResult> {
        protected zzcvv zzkau = new zzcwh(this);

        public zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zza(status2, null);
        }
    }
}

