/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.SparseArray;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzwy;
import com.google.android.gms.internal.zzwz;
import com.google.android.gms.internal.zzxa;
import com.google.android.gms.internal.zzxd;
import com.google.android.gms.internal.zzxf;
import com.google.android.gms.internal.zzxh;
import com.google.android.gms.internal.zzxi;
import com.google.android.gms.internal.zzxj;
import com.google.android.gms.safetynet.AttestationData;
import com.google.android.gms.safetynet.HarmfulAppsData;
import com.google.android.gms.safetynet.RecaptchaResultData;
import com.google.android.gms.safetynet.SafeBrowsingData;
import com.google.android.gms.safetynet.SafeBrowsingThreat;
import com.google.android.gms.safetynet.SafetyNetApi;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class zzxc
implements SafetyNetApi {
    private static final String TAG = zzxc.class.getSimpleName();
    protected static SparseArray<zzxh> aCk;
    protected static long aCl;

    @Override
    public PendingResult<SafetyNetApi.AttestationResult> attest(GoogleApiClient googleApiClient, final byte[] byArray) {
        return googleApiClient.zza((zzqo.zza)new zzb(googleApiClient){

            protected void zza(zzxd zzxd2) throws RemoteException {
                zzxd2.zza(this.aCu, byArray);
            }
        });
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, List<Integer> list, String string) {
        return this.zza(googleApiClient, list, string, null);
    }

    public PendingResult<SafetyNetApi.SafeBrowsingResult> zza(GoogleApiClient googleApiClient, final List<Integer> list, final String string, final String string2) {
        if (list == null) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        return googleApiClient.zza((zzqo.zza)new zzf(googleApiClient){

            protected void zza(zzxd zzxd2) throws RemoteException {
                zzxd2.zza(this.aCu, list, 2, string, string2);
            }
        });
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, final String string, final int ... nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        return googleApiClient.zza((zzqo.zza)new zzf(googleApiClient){

            protected void zza(zzxd zzxd2) throws RemoteException {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int n : nArray) {
                    arrayList.add(n);
                }
                zzxd2.zza(this.aCu, arrayList, 1, string, null);
            }
        });
    }

    @Override
    public boolean lookupUriInLocalBlacklist(String string, int ... nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        if (aCk == null || aCl == 0L || SystemClock.elapsedRealtime() - aCl >= 1200000L) {
            return true;
        }
        if (aCk != null && aCk.size() != 0) {
            List<zzxf> list = new zzxi(string).zzccs();
            if (list == null || list.isEmpty()) {
                return true;
            }
            for (zzxf zzxf2 : list) {
                for (int n : nArray) {
                    zzxh zzxh2 = (zzxh)aCk.get(n);
                    if (zzxh2 != null) {
                        if (!zzxh2.zzah(zzxf2.zzzr(4).getBytes())) continue;
                        return true;
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isVerifyAppsEnabled(Context context) {
        return new zzxj(context).zzccx();
    }

    @Override
    public PendingResult<SafetyNetApi.zzc> enableVerifyApps(GoogleApiClient googleApiClient) {
        return googleApiClient.zza((zzqo.zza)new zzc(googleApiClient){

            protected void zza(zzxd zzxd2) throws RemoteException {
                zzxd2.zzb(this.aCu);
            }
        });
    }

    @Override
    public PendingResult<SafetyNetApi.zza> listHarmfulApps(GoogleApiClient googleApiClient) {
        return googleApiClient.zza((zzqo.zza)new zzd(googleApiClient){

            protected void zza(zzxd zzxd2) throws RemoteException {
                zzxd2.zzc(this.aCu);
            }
        });
    }

    @Override
    public PendingResult<SafetyNetApi.zzb> verifyWithRecaptcha(GoogleApiClient googleApiClient, final String string) {
        return googleApiClient.zza((zzqo.zza)new zze(googleApiClient){

            protected void zza(zzxd zzxd2) throws RemoteException {
                zzxd2.zza(this.aCu, string);
            }
        });
    }

    static class zzh
    implements SafetyNetApi.zzb {
        private final Status hv;
        private final RecaptchaResultData aCB;

        public zzh(Status status, RecaptchaResultData recaptchaResultData) {
            this.hv = status;
            this.aCB = recaptchaResultData;
        }

        public Status getStatus() {
            return this.hv;
        }
    }

    static abstract class zze
    extends zzwz<SafetyNetApi.zzb> {
        protected zzxa aCu = new zzwy(){

            @Override
            public void zza(Status status, RecaptchaResultData recaptchaResultData) {
                zze.this.zzc(new zzh(status, recaptchaResultData));
            }
        };

        public zze(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected SafetyNetApi.zzb zzef(Status status) {
            return new zzh(status, null);
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzef(status);
        }
    }

    static abstract class zzd
    extends zzwz<SafetyNetApi.zza> {
        protected final zzxa aCu = new zzwy(){

            @Override
            public void zza(Status status, List<HarmfulAppsData> list) {
                zzd.this.zzc(new zzg(status, list));
            }
        };

        public zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected SafetyNetApi.zza zzee(Status status) {
            return new zzg(status, new ArrayList<HarmfulAppsData>());
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzee(status);
        }
    }

    static class zzg
    implements SafetyNetApi.zza {
        private final Status hv;
        private final List<HarmfulAppsData> aCA;

        public zzg(Status status, List<HarmfulAppsData> list) {
            this.hv = status;
            this.aCA = list;
        }

        public Status getStatus() {
            return this.hv;
        }
    }

    static abstract class zzc
    extends zzwz<SafetyNetApi.zzc> {
        protected zzxa aCu = new zzwy(){

            @Override
            public void zzb(Status status, boolean bl) {
                zzc.this.zzc(new zzj(status, bl));
            }
        };

        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected SafetyNetApi.zzc zzed(Status status) {
            return new zzj(status, false);
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzed(status);
        }
    }

    static class zzj
    implements SafetyNetApi.zzc {
        private final Status hv;
        private final boolean zzcxo;

        public zzj(Status status, boolean bl) {
            this.hv = status;
            this.zzcxo = bl;
        }

        public Status getStatus() {
            return this.hv;
        }
    }

    static class zzi
    implements SafetyNetApi.SafeBrowsingResult {
        private Status hv;
        private final SafeBrowsingData aCC;
        private String aCg;

        public zzi(Status status, SafeBrowsingData safeBrowsingData) {
            this.hv = status;
            this.aCC = safeBrowsingData;
            this.aCg = null;
            if (this.aCC != null) {
                this.aCg = this.aCC.getMetadata();
            } else if (this.hv.isSuccess()) {
                this.hv = new Status(8);
            }
        }

        public Status getStatus() {
            return this.hv;
        }

        @Override
        public String getMetadata() {
            return this.aCg;
        }

        @Override
        public List<SafeBrowsingThreat> getDetectedThreats() {
            ArrayList<SafeBrowsingThreat> arrayList = new ArrayList<SafeBrowsingThreat>();
            if (this.aCg == null) {
                return arrayList;
            }
            JSONArray jSONArray = null;
            try {
                JSONObject jSONObject = new JSONObject(this.aCg);
                jSONArray = jSONObject.getJSONArray("matches");
            }
            catch (JSONException jSONException) {
                return arrayList;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    JSONObject jSONObject = jSONArray.getJSONObject(i);
                    int n = Integer.parseInt(jSONObject.getString("threat_type"));
                    SafeBrowsingThreat safeBrowsingThreat = new SafeBrowsingThreat(n);
                    arrayList.add(safeBrowsingThreat);
                    continue;
                }
                catch (JSONException jSONException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return arrayList;
        }
    }

    static abstract class zzf
    extends zzwz<SafetyNetApi.SafeBrowsingResult> {
        protected zzxa aCu = new zzwy(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void zza(Status status, SafeBrowsingData safeBrowsingData) {
                DataHolder dataHolder = safeBrowsingData.getBlacklistsDataHolder();
                if (dataHolder != null) {
                    try {
                        int n = dataHolder.getCount();
                        if (n != 0) {
                            if (aCk != null) {
                                aCk.clear();
                            }
                            aCk = new SparseArray();
                            for (int i = 0; i < n; ++i) {
                                zzxh zzxh2 = new zzxh(dataHolder, i);
                                aCk.put(zzxh2.getThreatType(), (Object)zzxh2);
                            }
                            aCl = SystemClock.elapsedRealtime();
                        }
                    }
                    finally {
                        if (!dataHolder.isClosed()) {
                            dataHolder.close();
                        }
                    }
                }
                zzf.this.zzc(new zzi(status, safeBrowsingData));
            }
        };

        public zzf(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected SafetyNetApi.SafeBrowsingResult zzeg(Status status) {
            return new zzi(status, null);
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzeg(status);
        }
    }

    static class zza
    implements SafetyNetApi.AttestationResult {
        private final Status hv;
        private final AttestationData aCt;

        public zza(Status status, AttestationData attestationData) {
            this.hv = status;
            this.aCt = attestationData;
        }

        public Status getStatus() {
            return this.hv;
        }

        @Override
        public String getJwsResult() {
            if (this.aCt == null) {
                return null;
            }
            return this.aCt.getJwsResult();
        }
    }

    static abstract class zzb
    extends zzwz<SafetyNetApi.AttestationResult> {
        protected zzxa aCu = new zzwy(){

            @Override
            public void zza(Status status, AttestationData attestationData) {
                zzb.this.zzc(new zza(status, attestationData));
            }
        };

        public zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected SafetyNetApi.AttestationResult zzec(Status status) {
            return new zza(status, null);
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzec(status);
        }
    }
}

