/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tasks;

import android.app.Activity;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzbfe;
import com.google.android.gms.internal.zzbff;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.RuntimeExecutionException;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.android.gms.tasks.zzc;
import com.google.android.gms.tasks.zze;
import com.google.android.gms.tasks.zzg;
import com.google.android.gms.tasks.zzi;
import com.google.android.gms.tasks.zzk;
import com.google.android.gms.tasks.zzl;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;

final class zzn<TResult>
extends Task<TResult> {
    private final Object mLock = new Object();
    private final zzl<TResult> zzbMi = new zzl();
    private boolean zzbMj;
    private TResult zzbMk;
    private Exception zzbMl;

    zzn() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isComplete() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzbMj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isSuccessful() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzbMj && this.zzbMl == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TResult getResult() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzDD();
            if (this.zzbMl != null) {
                throw new RuntimeExecutionException(this.zzbMl);
            }
            return this.zzbMk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <X extends Throwable> TResult getResult(@NonNull Class<X> clazz) throws X {
        Object object = this.mLock;
        synchronized (object) {
            this.zzDD();
            if (clazz.isInstance(this.zzbMl)) {
                throw (Throwable)clazz.cast(this.zzbMl);
            }
            if (this.zzbMl != null) {
                throw new RuntimeExecutionException(this.zzbMl);
            }
            return this.zzbMk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final Exception getException() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzbMl;
        }
    }

    @Override
    @NonNull
    public final Task<TResult> addOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        return this.addOnSuccessListener(TaskExecutors.MAIN_THREAD, onSuccessListener);
    }

    @Override
    @NonNull
    public final Task<TResult> addOnSuccessListener(@NonNull Executor executor, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        this.zzbMi.zza(new zzi<TResult>(executor, onSuccessListener));
        this.zzDF();
        return this;
    }

    @Override
    @NonNull
    public final Task<TResult> addOnSuccessListener(@NonNull Activity activity, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzi<? super TResult> zzi2 = new zzi<TResult>(TaskExecutors.MAIN_THREAD, onSuccessListener);
        this.zzbMi.zza(zzi2);
        zza.zzr(activity).zzb(zzi2);
        this.zzDF();
        return this;
    }

    @Override
    @NonNull
    public final Task<TResult> addOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        return this.addOnFailureListener(TaskExecutors.MAIN_THREAD, onFailureListener);
    }

    @Override
    @NonNull
    public final Task<TResult> addOnFailureListener(@NonNull Executor executor, @NonNull OnFailureListener onFailureListener) {
        this.zzbMi.zza(new zzg(executor, onFailureListener));
        this.zzDF();
        return this;
    }

    @Override
    @NonNull
    public final Task<TResult> addOnFailureListener(@NonNull Activity activity, @NonNull OnFailureListener onFailureListener) {
        zzg zzg2 = new zzg(TaskExecutors.MAIN_THREAD, onFailureListener);
        this.zzbMi.zza(zzg2);
        zza.zzr(activity).zzb(zzg2);
        this.zzDF();
        return this;
    }

    @Override
    @NonNull
    public final Task<TResult> addOnCompleteListener(@NonNull OnCompleteListener<TResult> onCompleteListener) {
        return this.addOnCompleteListener(TaskExecutors.MAIN_THREAD, onCompleteListener);
    }

    @Override
    @NonNull
    public final Task<TResult> addOnCompleteListener(@NonNull Executor executor, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        this.zzbMi.zza(new zze<TResult>(executor, onCompleteListener));
        this.zzDF();
        return this;
    }

    @Override
    @NonNull
    public final Task<TResult> addOnCompleteListener(@NonNull Activity activity, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        zze<TResult> zze2 = new zze<TResult>(TaskExecutors.MAIN_THREAD, onCompleteListener);
        this.zzbMi.zza(zze2);
        zza.zzr(activity).zzb(zze2);
        this.zzDF();
        return this;
    }

    @Override
    @NonNull
    public final <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Continuation<TResult, TContinuationResult> continuation) {
        return this.continueWith(TaskExecutors.MAIN_THREAD, continuation);
    }

    @Override
    @NonNull
    public final <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        zzn<TResult> zzn2 = new zzn<TResult>();
        this.zzbMi.zza(new com.google.android.gms.tasks.zza<TResult, TContinuationResult>(executor, continuation, zzn2));
        this.zzDF();
        return zzn2;
    }

    @Override
    @NonNull
    public final <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.continueWithTask(TaskExecutors.MAIN_THREAD, continuation);
    }

    @Override
    @NonNull
    public final <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        zzn<TResult> zzn2 = new zzn<TResult>();
        this.zzbMi.zza(new zzc<TResult, TContinuationResult>(executor, continuation, zzn2));
        this.zzDF();
        return zzn2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResult(TResult TResult) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzDE();
            this.zzbMj = true;
            this.zzbMk = TResult;
        }
        this.zzbMi.zza(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean trySetResult(TResult TResult) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbMj) {
                return false;
            }
            this.zzbMj = true;
            this.zzbMk = TResult;
        }
        this.zzbMi.zza(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setException(@NonNull Exception exception) {
        zzbr.zzb((Object)exception, (Object)"Exception must not be null");
        Object object = this.mLock;
        synchronized (object) {
            this.zzDE();
            this.zzbMj = true;
            this.zzbMl = exception;
        }
        this.zzbMi.zza(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean trySetException(@NonNull Exception exception) {
        zzbr.zzb((Object)exception, (Object)"Exception must not be null");
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbMj) {
                return false;
            }
            this.zzbMj = true;
            this.zzbMl = exception;
        }
        this.zzbMi.zza(this);
        return true;
    }

    private final void zzDD() {
        zzbr.zza((boolean)this.zzbMj, (Object)"Task is not yet complete");
    }

    private final void zzDE() {
        zzbr.zza((!this.zzbMj ? 1 : 0) != 0, (Object)"Task is already complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzDF() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzbMj) {
                return;
            }
        }
        this.zzbMi.zza(this);
    }

    static class zza
    extends zzbfe {
        private final List<WeakReference<zzk<?>>> mListeners = new ArrayList();

        public static zza zzr(Activity activity) {
            zzbff zzbff2 = zza.zzn((Activity)activity);
            zza zza2 = (zza)zzbff2.zza("TaskOnStopCallback", zza.class);
            if (zza2 == null) {
                zza2 = new zza(zzbff2);
            }
            return zza2;
        }

        private zza(zzbff zzbff2) {
            super(zzbff2);
            this.zzaEI.zza("TaskOnStopCallback", (zzbfe)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> void zzb(zzk<T> zzk2) {
            List<WeakReference<zzk<?>>> list = this.mListeners;
            synchronized (list) {
                this.mListeners.add(new WeakReference<zzk<T>>(zzk2));
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public final void onStop() {
            List<WeakReference<zzk<?>>> list = this.mListeners;
            synchronized (list) {
                Iterator<WeakReference<zzk<?>>> iterator = this.mListeners.iterator();
                while (iterator.hasNext()) {
                    zzk zzk2 = (zzk)iterator.next().get();
                    if (zzk2 == null) continue;
                    zzk2.cancel();
                }
                this.mListeners.clear();
                return;
            }
        }
    }
}

