/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tasks;

import android.app.Activity;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.LifecycleFragment;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.DuplicateTaskCompletionException;
import com.google.android.gms.tasks.OnCanceledListener;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.RuntimeExecutionException;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.android.gms.tasks.zzc;
import com.google.android.gms.tasks.zzd;
import com.google.android.gms.tasks.zzh;
import com.google.android.gms.tasks.zzi;
import com.google.android.gms.tasks.zzl;
import com.google.android.gms.tasks.zzm;
import com.google.android.gms.tasks.zzp;
import com.google.android.gms.tasks.zzq;
import com.google.android.gms.tasks.zzr;
import com.google.android.gms.tasks.zzv;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;

final class zzu<TResult>
extends Task<TResult> {
    private final Object zza = new Object();
    private final zzq<TResult> zzb = new zzq();
    @GuardedBy(value="mLock")
    private boolean zzc;
    private volatile boolean zzd;
    @GuardedBy(value="mLock")
    @Nullable
    private TResult zze;
    @GuardedBy(value="mLock")
    private Exception zzf;

    zzu() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isComplete() {
        Object object = this.zza;
        synchronized (object) {
            return this.zzc;
        }
    }

    @Override
    public final boolean isCanceled() {
        return this.zzd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isSuccessful() {
        Object object = this.zza;
        synchronized (object) {
            return this.zzc && !this.zzd && this.zzf == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TResult getResult() {
        Object object = this.zza;
        synchronized (object) {
            this.zzb();
            this.zzd();
            if (this.zzf != null) {
                throw new RuntimeExecutionException(this.zzf);
            }
            return this.zze;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <X extends Throwable> TResult getResult(@NonNull Class<X> clazz) throws X {
        Object object = this.zza;
        synchronized (object) {
            this.zzb();
            this.zzd();
            if (clazz.isInstance(this.zzf)) {
                throw (Throwable)clazz.cast(this.zzf);
            }
            if (this.zzf != null) {
                throw new RuntimeExecutionException(this.zzf);
            }
            return this.zze;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final Exception getException() {
        Object object = this.zza;
        synchronized (object) {
            return this.zzf;
        }
    }

    @Override
    @NonNull
    public final Task<TResult> addOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        return ((Task)this).addOnSuccessListener(TaskExecutors.MAIN_THREAD, onSuccessListener);
    }

    @Override
    @NonNull
    public final Task<TResult> addOnSuccessListener(@NonNull Executor executor, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        this.zzb.zza(new zzm<TResult>(zzv.zza(executor), onSuccessListener));
        this.zze();
        return this;
    }

    @Override
    @NonNull
    public final Task<TResult> addOnSuccessListener(@NonNull Activity activity, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzm<? super TResult> zzm2 = new zzm<TResult>(zzv.zza(TaskExecutors.MAIN_THREAD), onSuccessListener);
        this.zzb.zza(zzm2);
        com.google.android.gms.tasks.zzu$zza.zza(activity).zza(zzm2);
        this.zze();
        return this;
    }

    @Override
    @NonNull
    public final Task<TResult> addOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        return ((Task)this).addOnFailureListener(TaskExecutors.MAIN_THREAD, onFailureListener);
    }

    @Override
    @NonNull
    public final Task<TResult> addOnFailureListener(@NonNull Executor executor, @NonNull OnFailureListener onFailureListener) {
        this.zzb.zza(new zzl(zzv.zza(executor), onFailureListener));
        this.zze();
        return this;
    }

    @Override
    @NonNull
    public final Task<TResult> addOnFailureListener(@NonNull Activity activity, @NonNull OnFailureListener onFailureListener) {
        zzl zzl2 = new zzl(zzv.zza(TaskExecutors.MAIN_THREAD), onFailureListener);
        this.zzb.zza(zzl2);
        com.google.android.gms.tasks.zzu$zza.zza(activity).zza(zzl2);
        this.zze();
        return this;
    }

    @Override
    @NonNull
    public final Task<TResult> addOnCompleteListener(@NonNull OnCompleteListener<TResult> onCompleteListener) {
        return ((Task)this).addOnCompleteListener(TaskExecutors.MAIN_THREAD, onCompleteListener);
    }

    @Override
    @NonNull
    public final Task<TResult> addOnCompleteListener(@NonNull Executor executor, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        this.zzb.zza(new zzi<TResult>(zzv.zza(executor), onCompleteListener));
        this.zze();
        return this;
    }

    @Override
    @NonNull
    public final Task<TResult> addOnCompleteListener(@NonNull Activity activity, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzi<TResult> zzi2 = new zzi<TResult>(zzv.zza(TaskExecutors.MAIN_THREAD), onCompleteListener);
        this.zzb.zza(zzi2);
        com.google.android.gms.tasks.zzu$zza.zza(activity).zza(zzi2);
        this.zze();
        return this;
    }

    @Override
    @NonNull
    public final <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Continuation<TResult, TContinuationResult> continuation) {
        return ((Task)this).continueWith(TaskExecutors.MAIN_THREAD, continuation);
    }

    @Override
    @NonNull
    public final <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        zzu<TResult> zzu2 = new zzu<TResult>();
        this.zzb.zza(new zzc<TResult, TContinuationResult>(zzv.zza(executor), continuation, zzu2));
        this.zze();
        return zzu2;
    }

    @Override
    @NonNull
    public final <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return ((Task)this).continueWithTask(TaskExecutors.MAIN_THREAD, continuation);
    }

    @Override
    @NonNull
    public final Task<TResult> addOnCanceledListener(@NonNull OnCanceledListener onCanceledListener) {
        return ((Task)this).addOnCanceledListener(TaskExecutors.MAIN_THREAD, onCanceledListener);
    }

    @Override
    @NonNull
    public final Task<TResult> addOnCanceledListener(@NonNull Executor executor, @NonNull OnCanceledListener onCanceledListener) {
        this.zzb.zza(new zzh(zzv.zza(executor), onCanceledListener));
        this.zze();
        return this;
    }

    @Override
    @NonNull
    public final Task<TResult> addOnCanceledListener(@NonNull Activity activity, @NonNull OnCanceledListener onCanceledListener) {
        zzh zzh2 = new zzh(zzv.zza(TaskExecutors.MAIN_THREAD), onCanceledListener);
        this.zzb.zza(zzh2);
        com.google.android.gms.tasks.zzu$zza.zza(activity).zza(zzh2);
        this.zze();
        return this;
    }

    @Override
    @NonNull
    public final <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        zzu<TResult> zzu2 = new zzu<TResult>();
        this.zzb.zza(new zzd<TResult, TContinuationResult>(zzv.zza(executor), continuation, zzu2));
        this.zze();
        return zzu2;
    }

    @Override
    @NonNull
    public final <TContinuationResult> Task<TContinuationResult> onSuccessTask(Executor executor, SuccessContinuation<TResult, TContinuationResult> successContinuation) {
        zzu<TResult> zzu2 = new zzu<TResult>();
        this.zzb.zza(new zzp<TResult, TContinuationResult>(zzv.zza(executor), successContinuation, zzu2));
        this.zze();
        return zzu2;
    }

    @Override
    @NonNull
    public final <TContinuationResult> Task<TContinuationResult> onSuccessTask(@NonNull SuccessContinuation<TResult, TContinuationResult> successContinuation) {
        return ((Task)this).onSuccessTask(TaskExecutors.MAIN_THREAD, successContinuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(@Nullable TResult TResult) {
        Object object = this.zza;
        synchronized (object) {
            this.zzc();
            this.zzc = true;
            this.zze = TResult;
        }
        this.zzb.zza(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzb(@Nullable TResult TResult) {
        Object object = this.zza;
        synchronized (object) {
            if (this.zzc) {
                return false;
            }
            this.zzc = true;
            this.zze = TResult;
        }
        this.zzb.zza(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(@NonNull Exception exception) {
        Preconditions.checkNotNull((Object)exception, (Object)"Exception must not be null");
        Object object = this.zza;
        synchronized (object) {
            this.zzc();
            this.zzc = true;
            this.zzf = exception;
        }
        this.zzb.zza(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzb(@NonNull Exception exception) {
        Preconditions.checkNotNull((Object)exception, (Object)"Exception must not be null");
        Object object = this.zza;
        synchronized (object) {
            if (this.zzc) {
                return false;
            }
            this.zzc = true;
            this.zzf = exception;
        }
        this.zzb.zza(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zza() {
        Object object = this.zza;
        synchronized (object) {
            if (this.zzc) {
                return false;
            }
            this.zzc = true;
            this.zzd = true;
        }
        this.zzb.zza(this);
        return true;
    }

    @GuardedBy(value="mLock")
    private final void zzb() {
        Preconditions.checkState((boolean)this.zzc, (Object)"Task is not yet complete");
    }

    @GuardedBy(value="mLock")
    private final void zzc() {
        if (this.zzc) {
            throw DuplicateTaskCompletionException.of(this);
        }
    }

    @GuardedBy(value="mLock")
    private final void zzd() {
        if (this.zzd) {
            throw new CancellationException("Task is already canceled.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zze() {
        Object object = this.zza;
        synchronized (object) {
            if (!this.zzc) {
                return;
            }
        }
        this.zzb.zza(this);
    }

    private static class zza
    extends LifecycleCallback {
        private final List<WeakReference<zzr<?>>> zza = new ArrayList();

        public static zza zza(Activity activity) {
            LifecycleFragment lifecycleFragment = com.google.android.gms.tasks.zzu$zza.getFragment((Activity)activity);
            zza zza2 = (zza)lifecycleFragment.getCallbackOrNull("TaskOnStopCallback", zza.class);
            if (zza2 == null) {
                zza2 = new zza(lifecycleFragment);
            }
            return zza2;
        }

        private zza(LifecycleFragment lifecycleFragment) {
            super(lifecycleFragment);
            this.mLifecycleFragment.addCallback("TaskOnStopCallback", (LifecycleCallback)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> void zza(zzr<T> zzr2) {
            List<WeakReference<zzr<?>>> list = this.zza;
            synchronized (list) {
                this.zza.add(new WeakReference<zzr<T>>(zzr2));
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onStop() {
            List<WeakReference<zzr<?>>> list = this.zza;
            synchronized (list) {
                Iterator<WeakReference<zzr<?>>> iterator = this.zza.iterator();
                while (iterator.hasNext()) {
                    zzr zzr2 = (zzr)iterator.next().get();
                    if (zzr2 == null) continue;
                    zzr2.zza();
                }
                this.zza.clear();
                return;
            }
        }
    }
}

