/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Frame;

public abstract class Detector<T> {
    private final Object zzbMN = new Object();
    private Processor<T> zzbMO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzbMN;
        synchronized (object) {
            if (this.zzbMO != null) {
                this.zzbMO.release();
                this.zzbMO = null;
            }
            return;
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Object object = this.zzbMN;
        synchronized (object) {
            if (this.zzbMO == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
            metadata.zzDK();
            SparseArray<T> sparseArray = this.detect(frame);
            boolean bl = this.isOperational();
            Detections<T> detections = new Detections<T>(sparseArray, metadata, bl);
            this.zzbMO.receiveDetections(detections);
            return;
        }
    }

    public void setProcessor(Processor<T> processor) {
        this.zzbMO = processor;
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private SparseArray<T> zzbMP;
        private Frame.Metadata zzbMQ;
        private boolean zzbMR;

        public Detections(SparseArray<T> sparseArray, Frame.Metadata metadata, boolean bl) {
            this.zzbMP = sparseArray;
            this.zzbMQ = metadata;
            this.zzbMR = bl;
        }

        public SparseArray<T> getDetectedItems() {
            return this.zzbMP;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.zzbMQ;
        }

        public boolean detectorIsOperational() {
            return this.zzbMR;
        }
    }
}

