/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Tracker;

public abstract class FocusingProcessor<T>
implements Detector.Processor<T> {
    private Detector<T> zzbMD;
    private Tracker<T> zzbMS;
    private int zzbMT = 3;
    private boolean zzbMU = false;
    private int zzbMV;
    private int zzbMW = 0;

    public FocusingProcessor(Detector<T> detector, Tracker<T> tracker) {
        this.zzbMD = detector;
        this.zzbMS = tracker;
    }

    @Override
    public void release() {
        this.zzbMS.onDone();
    }

    @Override
    public void receiveDetections(Detector.Detections<T> detections) {
        int n;
        Object object;
        SparseArray<T> sparseArray = detections.getDetectedItems();
        if (sparseArray.size() == 0) {
            if (this.zzbMW == this.zzbMT) {
                this.zzbMS.onDone();
                this.zzbMU = false;
            } else {
                this.zzbMS.onMissing(detections);
            }
            ++this.zzbMW;
            return;
        }
        this.zzbMW = 0;
        if (this.zzbMU) {
            Object object2 = sparseArray.get(this.zzbMV);
            if (object2 != null) {
                this.zzbMS.onUpdate(detections, object2);
                return;
            }
            this.zzbMS.onDone();
            this.zzbMU = false;
        }
        if ((object = sparseArray.get(n = this.selectFocus(detections))) == null) {
            Log.w((String)"FocusingProcessor", (String)new StringBuilder(35).append("Invalid focus selected: ").append(n).toString());
            return;
        }
        this.zzbMU = true;
        this.zzbMV = n;
        this.zzbMD.setFocus(this.zzbMV);
        this.zzbMS.onNewItem(this.zzbMV, object);
        this.zzbMS.onUpdate(detections, object);
    }

    public abstract int selectFocus(Detector.Detections<T> var1);

    protected final void zzbJ(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Invalid max gap: ").append(n).toString());
        }
        this.zzbMT = n;
    }
}

