/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Frame;

public abstract class Detector<T> {
    private final Object zzbML = new Object();
    private Processor<T> zzbMM;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzbML;
        synchronized (object) {
            if (this.zzbMM != null) {
                this.zzbMM.release();
                this.zzbMM = null;
            }
            return;
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Object object = this.zzbML;
        synchronized (object) {
            if (this.zzbMM == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
            metadata.zzDN();
            SparseArray<T> sparseArray = this.detect(frame);
            boolean bl = this.isOperational();
            Detections<T> detections = new Detections<T>(sparseArray, metadata, bl);
            this.zzbMM.receiveDetections(detections);
            return;
        }
    }

    public void setProcessor(Processor<T> processor) {
        this.zzbMM = processor;
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private SparseArray<T> zzbMN;
        private Frame.Metadata zzbMO;
        private boolean zzbMP;

        public Detections(SparseArray<T> sparseArray, Frame.Metadata metadata, boolean bl) {
            this.zzbMN = sparseArray;
            this.zzbMO = metadata;
            this.zzbMP = bl;
        }

        public SparseArray<T> getDetectedItems() {
            return this.zzbMN;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.zzbMO;
        }

        public boolean detectorIsOperational() {
            return this.zzbMP;
        }
    }
}

