/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.zzd;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MultiDetector
extends Detector<Object> {
    private List<Detector<? extends Object>> zzkwj = new ArrayList<Detector<? extends Object>>();

    @Override
    public void release() {
        Iterator<Detector<? extends Object>> iterator = this.zzkwj.iterator();
        while (iterator.hasNext()) {
            iterator.next().release();
        }
        this.zzkwj.clear();
    }

    @Override
    public SparseArray<Object> detect(Frame frame) {
        SparseArray sparseArray = new SparseArray();
        Iterator<Detector<? extends Object>> iterator = this.zzkwj.iterator();
        while (iterator.hasNext()) {
            SparseArray<? extends Object> sparseArray2 = iterator.next().detect(frame);
            for (int i = 0; i < sparseArray2.size(); ++i) {
                int n = sparseArray2.keyAt(i);
                if (sparseArray.get(n) != null) {
                    throw new IllegalStateException(new StringBuilder(104).append("Detection ID overlap for id = ").append(n).append("  This means that one of the detectors is not using global IDs.").toString());
                }
                Object object = sparseArray2.valueAt(i);
                sparseArray.append(n, object);
            }
        }
        return sparseArray;
    }

    @Override
    public void receiveFrame(Frame frame) {
        Iterator<Detector<? extends Object>> iterator = this.zzkwj.iterator();
        while (iterator.hasNext()) {
            iterator.next().receiveFrame(frame);
        }
    }

    @Override
    public void setProcessor(Detector.Processor<Object> processor) {
        throw new UnsupportedOperationException("MultiDetector.setProcessor is not supported.  You should set a processor instance on each underlying detector instead.");
    }

    @Override
    public boolean isOperational() {
        Iterator<Detector<? extends Object>> iterator = this.zzkwj.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().isOperational()) continue;
            return false;
        }
        return true;
    }

    private MultiDetector() {
    }

    /* synthetic */ MultiDetector(zzd zzd2) {
        this();
    }

    public static class Builder {
        private MultiDetector zzkwk = new MultiDetector(null);

        public Builder() {
        }

        public Builder add(Detector<? extends Object> detector) {
            this.zzkwk.zzkwj.add(detector);
            return this;
        }

        public MultiDetector build() {
            if (this.zzkwk.zzkwj.size() == 0) {
                throw new RuntimeException("No underlying detectors added to MultiDetector.");
            }
            return this.zzkwk;
        }
    }
}

