/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzef;
import com.google.android.gms.internal.vision.zzga;
import com.google.android.gms.internal.vision.zzge;
import com.google.android.gms.internal.vision.zzhr;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzgt
extends zzef<Long>
implements zzge<Long>,
zzhr,
RandomAccess {
    private static final zzgt zzyq = new zzgt();
    private long[] zzyr;
    private int size;

    zzgt() {
        this(new long[10], 0);
    }

    private zzgt(long[] lArray, int n) {
        this.zzyr = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzcj();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzyr, n2, this.zzyr, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzgt)) {
            return super.equals(object);
        }
        zzgt zzgt2 = (zzgt)object;
        if (this.size != zzgt2.size) {
            return false;
        }
        long[] lArray = zzgt2.zzyr;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzyr[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzga.zzo(this.zzyr[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzaf(n);
        return this.zzyr[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzp(long l) {
        this.zzk(this.size, l);
    }

    private final void zzk(int n, long l) {
        this.zzcj();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzag(n));
        }
        if (this.size < this.zzyr.length) {
            System.arraycopy(this.zzyr, n, this.zzyr, n + 1, this.size - n);
        } else {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzyr, 0, lArray, 0, n);
            System.arraycopy(this.zzyr, n, lArray, n + 1, this.size - n);
            this.zzyr = lArray;
        }
        this.zzyr[n] = l;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzcj();
        zzga.checkNotNull(collection);
        if (!(collection instanceof zzgt)) {
            return super.addAll(collection);
        }
        zzgt zzgt2 = (zzgt)collection;
        if (zzgt2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzgt2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzgt2.size;
        if (n > this.zzyr.length) {
            this.zzyr = Arrays.copyOf(this.zzyr, n);
        }
        System.arraycopy(zzgt2.zzyr, 0, this.zzyr, this.size, zzgt2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzcj();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzyr[i])) continue;
            System.arraycopy(this.zzyr, i + 1, this.zzyr, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzag(n));
        }
    }

    private final String zzag(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzgt zzgt2 = this;
        zzgt2.zzcj();
        zzgt2.zzaf(n);
        long l3 = zzgt2.zzyr[n];
        zzgt2.zzyr[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzgt zzgt2 = this;
        zzgt2.zzcj();
        zzgt2.zzaf(n);
        long l = zzgt2.zzyr[n];
        if (n < zzgt2.size - 1) {
            System.arraycopy(zzgt2.zzyr, n + 1, zzgt2.zzyr, n, zzgt2.size - n);
        }
        --zzgt2.size;
        ++zzgt2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        this.zzk(n, l);
    }

    @Override
    public final /* synthetic */ zzge zzah(int n) {
        int n2 = n;
        zzgt zzgt2 = this;
        if (n2 < zzgt2.size) {
            throw new IllegalArgumentException();
        }
        return new zzgt(Arrays.copyOf(zzgt2.zzyr, n2), zzgt2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzyq.zzci();
    }
}

