/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzex;
import com.google.android.gms.internal.vision.zzgt;
import com.google.android.gms.internal.vision.zzgz;
import com.google.android.gms.internal.vision.zzio;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzhq
extends zzex<Long>
implements zzgz<Long>,
zzio,
RandomAccess {
    private static final zzhq zzyp = new zzhq(new long[0], 0);
    private long[] zzyq;
    private int size;

    zzhq() {
        this(new long[10], 0);
    }

    private zzhq(long[] lArray, int n) {
        this.zzyq = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzdq();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzyq, n2, this.zzyq, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzhq)) {
            return super.equals(object);
        }
        zzhq zzhq2 = (zzhq)object;
        if (this.size != zzhq2.size) {
            return false;
        }
        long[] lArray = zzhq2.zzyq;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzyq[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzgt.zzab(this.zzyq[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzaf(n);
        return this.zzyq[n];
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Long)) {
            return -1;
        }
        long l = (Long)object;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzyq[i] != l) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzac(long l) {
        this.zzdq();
        if (this.size == this.zzyq.length) {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzyq, 0, lArray, 0, this.size);
            this.zzyq = lArray;
        }
        this.zzyq[this.size++] = l;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzdq();
        zzgt.checkNotNull(collection);
        if (!(collection instanceof zzhq)) {
            return super.addAll(collection);
        }
        zzhq zzhq2 = (zzhq)collection;
        if (zzhq2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzhq2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzhq2.size;
        if (n > this.zzyq.length) {
            this.zzyq = Arrays.copyOf(this.zzyq, n);
        }
        System.arraycopy(zzhq2.zzyq, 0, this.zzyq, this.size, zzhq2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzdq();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzyq[i])) continue;
            System.arraycopy(this.zzyq, i + 1, this.zzyq, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzag(n));
        }
    }

    private final String zzag(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzhq zzhq2 = this;
        zzhq2.zzdq();
        zzhq2.zzaf(n);
        long l3 = zzhq2.zzyq[n];
        zzhq2.zzyq[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzhq zzhq2 = this;
        zzhq2.zzdq();
        zzhq2.zzaf(n);
        long l = zzhq2.zzyq[n];
        if (n < zzhq2.size - 1) {
            System.arraycopy(zzhq2.zzyq, n + 1, zzhq2.zzyq, n, zzhq2.size - n - 1);
        }
        --zzhq2.size;
        ++zzhq2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzhq zzhq2 = this;
        zzhq2.zzdq();
        if (n < 0 || n > zzhq2.size) {
            throw new IndexOutOfBoundsException(zzhq2.zzag(n));
        }
        if (zzhq2.size < zzhq2.zzyq.length) {
            System.arraycopy(zzhq2.zzyq, n, zzhq2.zzyq, n + 1, zzhq2.size - n);
        } else {
            long[] lArray = new long[zzhq2.size * 3 / 2 + 1];
            System.arraycopy(zzhq2.zzyq, 0, lArray, 0, n);
            System.arraycopy(zzhq2.zzyq, n, lArray, n + 1, zzhq2.size - n);
            zzhq2.zzyq = lArray;
        }
        zzhq2.zzyq[n] = l2;
        ++zzhq2.size;
        ++zzhq2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Long l = (Long)object;
        this.zzac(l);
        return true;
    }

    @Override
    public final /* synthetic */ zzgz zzah(int n) {
        int n2 = n;
        zzhq zzhq2 = this;
        if (n2 < zzhq2.size) {
            throw new IllegalArgumentException();
        }
        return new zzhq(Arrays.copyOf(zzhq2.zzyq, n2), zzhq2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzyp.zzdp();
    }
}

