/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzfe;
import com.google.android.gms.internal.vision.zzff;
import com.google.android.gms.internal.vision.zzfh;
import com.google.android.gms.internal.vision.zzft;
import com.google.android.gms.internal.vision.zzgb;
import com.google.android.gms.internal.vision.zzgd;
import com.google.android.gms.internal.vision.zzgo;
import com.google.android.gms.internal.vision.zzgt;
import com.google.android.gms.internal.vision.zzgu;
import com.google.android.gms.internal.vision.zzhb;
import com.google.android.gms.internal.vision.zzhc;
import com.google.android.gms.internal.vision.zzhj;
import com.google.android.gms.internal.vision.zzhq;
import com.google.android.gms.internal.vision.zzht;
import com.google.android.gms.internal.vision.zzin;
import com.google.android.gms.internal.vision.zzir;
import com.google.android.gms.internal.vision.zzjs;
import com.google.android.gms.internal.vision.zzka;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

final class zzfg
extends zzfe {
    private final boolean zzsa;
    private final byte[] buffer;
    private int pos;
    private final int zzsb;
    private int limit;
    private int tag;
    private int zzsc;

    public zzfg(ByteBuffer byteBuffer, boolean bl) {
        super(null);
        this.zzsa = true;
        this.buffer = byteBuffer.array();
        this.zzsb = this.pos = byteBuffer.arrayOffset() + byteBuffer.position();
        this.limit = byteBuffer.arrayOffset() + byteBuffer.limit();
    }

    private final boolean zzdt() {
        return this.pos == this.limit;
    }

    @Override
    public final int zzdu() throws IOException {
        if (this.zzdt()) {
            return Integer.MAX_VALUE;
        }
        this.tag = this.zzek();
        if (this.tag == this.zzsc) {
            return Integer.MAX_VALUE;
        }
        return this.tag >>> 3;
    }

    @Override
    public final int getTag() {
        return this.tag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean zzdv() throws IOException {
        if (this.zzdt() || this.tag == this.zzsc) {
            return false;
        }
        switch (this.tag & 7) {
            case 0: {
                zzfg zzfg2 = this;
                if (zzfg2.limit - zzfg2.pos >= 10) {
                    byte[] byArray = zzfg2.buffer;
                    int n = zzfg2.pos;
                    for (int i = 0; i < 10; ++i) {
                        if (byArray[n++] < 0) continue;
                        zzfg2.pos = n;
                        return true;
                    }
                } else {
                    zzfg zzfg3 = zzfg2;
                    for (int i = 0; i < 10; ++i) {
                        if (zzfg3.readByte() >= 0) return true;
                    }
                    throw zzhc.zzgo();
                }
            }
            case 1: {
                this.zzai(8);
                return true;
            }
            case 2: {
                this.zzai(this.zzek());
                return true;
            }
            case 5: {
                this.zzai(4);
                return true;
            }
            case 3: {
                zzfg zzfg4 = this;
                int n = zzfg4.zzsc;
                zzfg4.zzsc = zzfg4.tag >>> 3 << 3 | 4;
                while (zzfg4.zzdu() != Integer.MAX_VALUE && zzfg4.zzdv()) {
                }
                if (zzfg4.tag != zzfg4.zzsc) {
                    throw zzhc.zzgs();
                }
                zzfg4.zzsc = n;
                return true;
            }
        }
        throw zzhc.zzgr();
    }

    @Override
    public final double readDouble() throws IOException {
        this.zzak(1);
        return Double.longBitsToDouble(this.zzeo());
    }

    @Override
    public final float readFloat() throws IOException {
        this.zzak(5);
        return Float.intBitsToFloat(this.zzen());
    }

    @Override
    public final long zzdw() throws IOException {
        this.zzak(0);
        return this.zzel();
    }

    @Override
    public final long zzdx() throws IOException {
        this.zzak(0);
        return this.zzel();
    }

    @Override
    public final int zzdy() throws IOException {
        this.zzak(0);
        return this.zzek();
    }

    @Override
    public final long zzdz() throws IOException {
        this.zzak(1);
        return this.zzeo();
    }

    @Override
    public final int zzea() throws IOException {
        this.zzak(5);
        return this.zzen();
    }

    @Override
    public final boolean zzeb() throws IOException {
        this.zzak(0);
        return this.zzek() != 0;
    }

    @Override
    public final String readString() throws IOException {
        return this.zzj(false);
    }

    @Override
    public final String zzec() throws IOException {
        return this.zzj(true);
    }

    private final String zzj(boolean bl) throws IOException {
        this.zzak(2);
        int n = this.zzek();
        if (n == 0) {
            return "";
        }
        this.zzaj(n);
        if (bl && !zzjs.zzf(this.buffer, this.pos, this.pos + n)) {
            throw zzhc.zzgt();
        }
        String string = new String(this.buffer, this.pos, n, zzgt.UTF_8);
        this.pos += n;
        return string;
    }

    @Override
    public final <T> T zza(Class<T> clazz, zzgd zzgd2) throws IOException {
        this.zzak(2);
        return this.zzb(zzin.zzho().zzf(clazz), zzgd2);
    }

    @Override
    public final <T> T zza(zzir<T> zzir2, zzgd zzgd2) throws IOException {
        this.zzak(2);
        return this.zzb(zzir2, zzgd2);
    }

    private final <T> T zzb(zzir<T> zzir2, zzgd zzgd2) throws IOException {
        int n;
        int n2 = this.zzek();
        this.zzaj(n2);
        int n3 = this.limit;
        this.limit = n = this.pos + n2;
        try {
            T t = zzir2.newInstance();
            zzir2.zza(t, this, zzgd2);
            zzir2.zzh(t);
            if (this.pos != n) {
                throw zzhc.zzgs();
            }
            T t2 = t;
            return t2;
        }
        finally {
            this.limit = n3;
        }
    }

    @Override
    public final <T> T zzb(Class<T> clazz, zzgd zzgd2) throws IOException {
        this.zzak(3);
        return this.zzd(zzin.zzho().zzf(clazz), zzgd2);
    }

    @Override
    public final <T> T zzc(zzir<T> zzir2, zzgd zzgd2) throws IOException {
        this.zzak(3);
        return this.zzd(zzir2, zzgd2);
    }

    private final <T> T zzd(zzir<T> zzir2, zzgd zzgd2) throws IOException {
        int n = this.zzsc;
        this.zzsc = this.tag >>> 3 << 3 | 4;
        try {
            T t = zzir2.newInstance();
            zzir2.zza(t, this, zzgd2);
            zzir2.zzh(t);
            if (this.tag != this.zzsc) {
                throw zzhc.zzgs();
            }
            T t2 = t;
            return t2;
        }
        finally {
            this.zzsc = n;
        }
    }

    @Override
    public final zzfh zzed() throws IOException {
        this.zzak(2);
        int n = this.zzek();
        if (n == 0) {
            return zzfh.zzsd;
        }
        this.zzaj(n);
        zzfh zzfh2 = this.zzsa ? zzfh.zzb(this.buffer, this.pos, n) : zzfh.zza(this.buffer, this.pos, n);
        this.pos += n;
        return zzfh2;
    }

    @Override
    public final int zzee() throws IOException {
        this.zzak(0);
        return this.zzek();
    }

    @Override
    public final int zzef() throws IOException {
        this.zzak(0);
        return this.zzek();
    }

    @Override
    public final int zzeg() throws IOException {
        this.zzak(5);
        return this.zzen();
    }

    @Override
    public final long zzeh() throws IOException {
        this.zzak(1);
        return this.zzeo();
    }

    @Override
    public final int zzei() throws IOException {
        this.zzak(0);
        return zzft.zzav(this.zzek());
    }

    @Override
    public final long zzej() throws IOException {
        this.zzak(0);
        return zzft.zzr(this.zzel());
    }

    @Override
    public final void zza(List<Double> list) throws IOException {
        if (list instanceof zzgb) {
            zzgb zzgb2 = (zzgb)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzek();
                    this.zzal(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgb2.zzc(Double.longBitsToDouble(this.zzeq()));
                    }
                    break;
                }
                case 1: {
                    int n;
                    do {
                        zzgb2.zzc(this.readDouble());
                        if (this.zzdt()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzek() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhc.zzgr();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzek();
                this.zzal(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(Double.longBitsToDouble(this.zzeq()));
                }
                break;
            }
            case 1: {
                int n;
                do {
                    list.add(this.readDouble());
                    if (this.zzdt()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzek() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhc.zzgr();
            }
        }
    }

    @Override
    public final void zzb(List<Float> list) throws IOException {
        if (list instanceof zzgo) {
            zzgo zzgo2 = (zzgo)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzek();
                    this.zzam(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgo2.zzu(Float.intBitsToFloat(this.zzep()));
                    }
                    break;
                }
                case 5: {
                    int n;
                    do {
                        zzgo2.zzu(this.readFloat());
                        if (this.zzdt()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzek() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhc.zzgr();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzek();
                this.zzam(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(Float.valueOf(Float.intBitsToFloat(this.zzep())));
                }
                break;
            }
            case 5: {
                int n;
                do {
                    list.add(Float.valueOf(this.readFloat()));
                    if (this.zzdt()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzek() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhc.zzgr();
            }
        }
    }

    @Override
    public final void zzc(List<Long> list) throws IOException {
        if (list instanceof zzhq) {
            zzhq zzhq2 = (zzhq)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzek();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzhq2.zzac(this.zzel());
                    }
                    this.zzan(n2);
                    return;
                }
                case 0: {
                    int n;
                    do {
                        zzhq2.zzac(this.zzdw());
                        if (this.zzdt()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzek() == this.tag);
                    this.pos = n;
                    return;
                }
            }
            throw zzhc.zzgr();
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzek();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzel());
                }
                this.zzan(n3);
                return;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzdw());
                    if (this.zzdt()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzek() == this.tag);
                this.pos = n;
                return;
            }
        }
        throw zzhc.zzgr();
    }

    @Override
    public final void zzd(List<Long> list) throws IOException {
        if (list instanceof zzhq) {
            zzhq zzhq2 = (zzhq)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzek();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzhq2.zzac(this.zzel());
                    }
                    this.zzan(n2);
                    return;
                }
                case 0: {
                    int n;
                    do {
                        zzhq2.zzac(this.zzdx());
                        if (this.zzdt()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzek() == this.tag);
                    this.pos = n;
                    return;
                }
            }
            throw zzhc.zzgr();
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzek();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzel());
                }
                this.zzan(n3);
                return;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzdx());
                    if (this.zzdt()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzek() == this.tag);
                this.pos = n;
                return;
            }
        }
        throw zzhc.zzgr();
    }

    @Override
    public final void zze(List<Integer> list) throws IOException {
        if (list instanceof zzgu) {
            zzgu zzgu2 = (zzgu)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzek();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgu2.zzbm(this.zzek());
                    }
                    this.zzan(n2);
                    return;
                }
                case 0: {
                    int n;
                    do {
                        zzgu2.zzbm(this.zzdy());
                        if (this.zzdt()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzek() == this.tag);
                    this.pos = n;
                    return;
                }
            }
            throw zzhc.zzgr();
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzek();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzek());
                }
                this.zzan(n3);
                return;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzdy());
                    if (this.zzdt()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzek() == this.tag);
                this.pos = n;
                return;
            }
        }
        throw zzhc.zzgr();
    }

    @Override
    public final void zzf(List<Long> list) throws IOException {
        if (list instanceof zzhq) {
            zzhq zzhq2 = (zzhq)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzek();
                    this.zzal(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzhq2.zzac(this.zzeq());
                    }
                    break;
                }
                case 1: {
                    int n;
                    do {
                        zzhq2.zzac(this.zzdz());
                        if (this.zzdt()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzek() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhc.zzgr();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzek();
                this.zzal(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzeq());
                }
                break;
            }
            case 1: {
                int n;
                do {
                    list.add(this.zzdz());
                    if (this.zzdt()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzek() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhc.zzgr();
            }
        }
    }

    @Override
    public final void zzg(List<Integer> list) throws IOException {
        if (list instanceof zzgu) {
            zzgu zzgu2 = (zzgu)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzek();
                    this.zzam(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgu2.zzbm(this.zzep());
                    }
                    break;
                }
                case 5: {
                    int n;
                    do {
                        zzgu2.zzbm(this.zzea());
                        if (this.zzdt()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzek() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhc.zzgr();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzek();
                this.zzam(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzep());
                }
                break;
            }
            case 5: {
                int n;
                do {
                    list.add(this.zzea());
                    if (this.zzdt()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzek() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhc.zzgr();
            }
        }
    }

    @Override
    public final void zzh(List<Boolean> list) throws IOException {
        if (list instanceof zzff) {
            zzff zzff2 = (zzff)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzek();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzff2.addBoolean(this.zzek() != 0);
                    }
                    this.zzan(n2);
                    return;
                }
                case 0: {
                    int n;
                    do {
                        zzff2.addBoolean(this.zzeb());
                        if (this.zzdt()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzek() == this.tag);
                    this.pos = n;
                    return;
                }
            }
            throw zzhc.zzgr();
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzek();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzek() != 0);
                }
                this.zzan(n3);
                return;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzeb());
                    if (this.zzdt()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzek() == this.tag);
                this.pos = n;
                return;
            }
        }
        throw zzhc.zzgr();
    }

    @Override
    public final void readStringList(List<String> list) throws IOException {
        this.zza(list, false);
    }

    @Override
    public final void zzi(List<String> list) throws IOException {
        this.zza(list, true);
    }

    private final void zza(List<String> list, boolean bl) throws IOException {
        int n;
        if ((this.tag & 7) != 2) {
            throw zzhc.zzgr();
        }
        if (list instanceof zzhj && !bl) {
            int n2;
            zzhj zzhj2 = (zzhj)list;
            do {
                zzhj2.zzc(this.zzed());
                if (this.zzdt()) {
                    return;
                }
                n2 = this.pos;
            } while (this.zzek() == this.tag);
            this.pos = n2;
            return;
        }
        do {
            list.add(this.zzj(bl));
            if (this.zzdt()) {
                return;
            }
            n = this.pos;
        } while (this.zzek() == this.tag);
        this.pos = n;
    }

    @Override
    public final <T> void zza(List<T> list, zzir<T> zzir2, zzgd zzgd2) throws IOException {
        int n;
        if ((this.tag & 7) != 2) {
            throw zzhc.zzgr();
        }
        int n2 = this.tag;
        do {
            list.add(this.zzb(zzir2, zzgd2));
            if (this.zzdt()) {
                return;
            }
            n = this.pos;
        } while (this.zzek() == n2);
        this.pos = n;
    }

    @Override
    public final <T> void zzb(List<T> list, zzir<T> zzir2, zzgd zzgd2) throws IOException {
        int n;
        if ((this.tag & 7) != 3) {
            throw zzhc.zzgr();
        }
        int n2 = this.tag;
        do {
            list.add(this.zzd(zzir2, zzgd2));
            if (this.zzdt()) {
                return;
            }
            n = this.pos;
        } while (this.zzek() == n2);
        this.pos = n;
    }

    @Override
    public final void zzj(List<zzfh> list) throws IOException {
        int n;
        if ((this.tag & 7) != 2) {
            throw zzhc.zzgr();
        }
        do {
            list.add(this.zzed());
            if (this.zzdt()) {
                return;
            }
            n = this.pos;
        } while (this.zzek() == this.tag);
        this.pos = n;
    }

    @Override
    public final void zzk(List<Integer> list) throws IOException {
        if (list instanceof zzgu) {
            zzgu zzgu2 = (zzgu)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzek();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgu2.zzbm(this.zzek());
                    }
                    break;
                }
                case 0: {
                    int n;
                    do {
                        zzgu2.zzbm(this.zzee());
                        if (this.zzdt()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzek() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhc.zzgr();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzek();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzek());
                }
                break;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzee());
                    if (this.zzdt()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzek() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhc.zzgr();
            }
        }
    }

    @Override
    public final void zzl(List<Integer> list) throws IOException {
        if (list instanceof zzgu) {
            zzgu zzgu2 = (zzgu)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzek();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgu2.zzbm(this.zzek());
                    }
                    break;
                }
                case 0: {
                    int n;
                    do {
                        zzgu2.zzbm(this.zzef());
                        if (this.zzdt()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzek() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhc.zzgr();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzek();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzek());
                }
                break;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzef());
                    if (this.zzdt()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzek() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhc.zzgr();
            }
        }
    }

    @Override
    public final void zzm(List<Integer> list) throws IOException {
        if (list instanceof zzgu) {
            zzgu zzgu2 = (zzgu)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzek();
                    this.zzam(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgu2.zzbm(this.zzep());
                    }
                    break;
                }
                case 5: {
                    int n;
                    do {
                        zzgu2.zzbm(this.zzeg());
                        if (this.zzdt()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzek() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhc.zzgr();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzek();
                this.zzam(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzep());
                }
                break;
            }
            case 5: {
                int n;
                do {
                    list.add(this.zzeg());
                    if (this.zzdt()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzek() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhc.zzgr();
            }
        }
    }

    @Override
    public final void zzn(List<Long> list) throws IOException {
        if (list instanceof zzhq) {
            zzhq zzhq2 = (zzhq)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzek();
                    this.zzal(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzhq2.zzac(this.zzeq());
                    }
                    break;
                }
                case 1: {
                    int n;
                    do {
                        zzhq2.zzac(this.zzeh());
                        if (this.zzdt()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzek() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhc.zzgr();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzek();
                this.zzal(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzeq());
                }
                break;
            }
            case 1: {
                int n;
                do {
                    list.add(this.zzeh());
                    if (this.zzdt()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzek() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhc.zzgr();
            }
        }
    }

    @Override
    public final void zzo(List<Integer> list) throws IOException {
        if (list instanceof zzgu) {
            zzgu zzgu2 = (zzgu)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzek();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgu2.zzbm(zzft.zzav(this.zzek()));
                    }
                    break;
                }
                case 0: {
                    int n;
                    do {
                        zzgu2.zzbm(this.zzei());
                        if (this.zzdt()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzek() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhc.zzgr();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzek();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(zzft.zzav(this.zzek()));
                }
                break;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzei());
                    if (this.zzdt()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzek() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhc.zzgr();
            }
        }
    }

    @Override
    public final void zzp(List<Long> list) throws IOException {
        if (list instanceof zzhq) {
            zzhq zzhq2 = (zzhq)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzek();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzhq2.zzac(zzft.zzr(this.zzel()));
                    }
                    break;
                }
                case 0: {
                    int n;
                    do {
                        zzhq2.zzac(this.zzej());
                        if (this.zzdt()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzek() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhc.zzgr();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzek();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(zzft.zzr(this.zzel()));
                }
                break;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzej());
                    if (this.zzdt()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzek() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhc.zzgr();
            }
        }
    }

    @Override
    public final <K, V> void zza(Map<K, V> map, zzht<K, V> zzht2, zzgd zzgd2) throws IOException {
        int n;
        this.zzak(2);
        int n2 = this.zzek();
        this.zzaj(n2);
        int n3 = this.limit;
        this.limit = n = this.pos + n2;
        try {
            int n4;
            Object object = zzht2.zzyt;
            Object object2 = zzht2.zzgd;
            block9: while ((n4 = this.zzdu()) != Integer.MAX_VALUE) {
                try {
                    switch (n4) {
                        case 1: {
                            object = this.zza(zzht2.zzys, null, null);
                            continue block9;
                        }
                        case 2: {
                            object2 = this.zza(zzht2.zzyu, zzht2.zzgd.getClass(), zzgd2);
                            continue block9;
                        }
                    }
                    if (this.zzdv()) continue;
                    throw new zzhc("Unable to parse map entry.");
                }
                catch (zzhb zzhb2) {
                    if (this.zzdv()) continue;
                    throw new zzhc("Unable to parse map entry.");
                }
            }
            map.put(object, object2);
            return;
        }
        finally {
            this.limit = n3;
        }
    }

    private final Object zza(zzka zzka2, Class<?> clazz, zzgd zzgd2) throws IOException {
        switch (zzka2) {
            case zzabz: {
                return this.zzeb();
            }
            case zzacd: {
                return this.zzed();
            }
            case zzabs: {
                return this.readDouble();
            }
            case zzacf: {
                return this.zzef();
            }
            case zzaby: {
                return this.zzea();
            }
            case zzabx: {
                return this.zzdz();
            }
            case zzabt: {
                return Float.valueOf(this.readFloat());
            }
            case zzabw: {
                return this.zzdy();
            }
            case zzabu: {
                return this.zzdx();
            }
            case zzacc: {
                return this.zza(clazz, zzgd2);
            }
            case zzacg: {
                return this.zzeg();
            }
            case zzach: {
                return this.zzeh();
            }
            case zzaci: {
                return this.zzei();
            }
            case zzacj: {
                return this.zzej();
            }
            case zzaca: {
                return this.zzj(true);
            }
            case zzace: {
                return this.zzee();
            }
            case zzabv: {
                return this.zzdw();
            }
        }
        throw new RuntimeException("unsupported field type.");
    }

    private final int zzek() throws IOException {
        int n;
        int n2 = this.pos;
        if (this.limit == this.pos) {
            throw zzhc.zzgm();
        }
        if ((n = this.buffer[n2++]) >= 0) {
            this.pos = n2;
            return n;
        }
        if (this.limit - n2 < 9) {
            return (int)this.zzem();
        }
        if ((n ^= this.buffer[n2++] << 7) < 0) {
            n ^= 0xFFFFFF80;
        } else if ((n ^= this.buffer[n2++] << 14) >= 0) {
            n ^= 0x3F80;
        } else if ((n ^= this.buffer[n2++] << 21) < 0) {
            n ^= 0xFFE03F80;
        } else {
            byte by = this.buffer[n2++];
            n = n ^ by << 28 ^ 0xFE03F80;
            if (by < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0) {
                throw zzhc.zzgo();
            }
        }
        this.pos = n2;
        return n;
    }

    private final long zzel() throws IOException {
        long l;
        int n;
        int n2 = this.pos;
        if (this.limit == n2) {
            throw zzhc.zzgm();
        }
        byte[] byArray = this.buffer;
        if ((n = this.buffer[n2++]) >= 0) {
            this.pos = n2;
            return n;
        }
        if (this.limit - n2 < 9) {
            return this.zzem();
        }
        if ((n ^= byArray[n2++] << 7) < 0) {
            l = n ^ 0xFFFFFF80;
        } else if ((n ^= byArray[n2++] << 14) >= 0) {
            l = n ^ 0x3F80;
        } else if ((n ^= byArray[n2++] << 21) < 0) {
            l = n ^ 0xFFE03F80;
        } else if ((l = (long)n ^ (long)byArray[n2++] << 28) >= 0L) {
            l ^= 0xFE03F80L;
        } else if ((l ^= (long)byArray[n2++] << 35) < 0L) {
            l ^= 0xFFFFFFF80FE03F80L;
        } else if ((l ^= (long)byArray[n2++] << 42) >= 0L) {
            l ^= 0x3F80FE03F80L;
        } else if ((l ^= (long)byArray[n2++] << 49) < 0L) {
            l ^= 0xFFFE03F80FE03F80L;
        } else if ((l = l ^ (long)byArray[n2++] << 56 ^ 0xFE03F80FE03F80L) < 0L && (long)byArray[n2++] < 0L) {
            throw zzhc.zzgo();
        }
        this.pos = n2;
        return l;
    }

    private final long zzem() throws IOException {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            byte by = this.readByte();
            l |= (long)(by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            return l;
        }
        throw zzhc.zzgo();
    }

    private final byte readByte() throws IOException {
        if (this.pos == this.limit) {
            throw zzhc.zzgm();
        }
        return this.buffer[this.pos++];
    }

    private final int zzen() throws IOException {
        this.zzaj(4);
        return this.zzep();
    }

    private final long zzeo() throws IOException {
        this.zzaj(8);
        return this.zzeq();
    }

    private final int zzep() {
        int n = this.pos;
        byte[] byArray = this.buffer;
        this.pos = n + 4;
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    private final long zzeq() {
        int n = this.pos;
        byte[] byArray = this.buffer;
        this.pos = n + 8;
        return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
    }

    private final void zzai(int n) throws IOException {
        this.zzaj(n);
        this.pos += n;
    }

    private final void zzaj(int n) throws IOException {
        if (n < 0 || n > this.limit - this.pos) {
            throw zzhc.zzgm();
        }
    }

    private final void zzak(int n) throws IOException {
        if ((this.tag & 7) != n) {
            throw zzhc.zzgr();
        }
    }

    private final void zzal(int n) throws IOException {
        this.zzaj(n);
        if ((n & 7) != 0) {
            throw zzhc.zzgs();
        }
    }

    private final void zzam(int n) throws IOException {
        this.zzaj(n);
        if ((n & 3) != 0) {
            throw zzhc.zzgs();
        }
    }

    private final void zzan(int n) throws IOException {
        if (this.pos != n) {
            throw zzhc.zzgm();
        }
    }
}

