/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzex;
import com.google.android.gms.internal.vision.zzgt;
import com.google.android.gms.internal.vision.zzgz;
import com.google.android.gms.internal.vision.zzio;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzgb
extends zzex<Double>
implements zzgz<Double>,
zzio,
RandomAccess {
    private static final zzgb zzsz = new zzgb(new double[0], 0);
    private double[] zzta;
    private int size;

    zzgb() {
        this(new double[10], 0);
    }

    private zzgb(double[] dArray, int n) {
        this.zzta = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzdq();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzta, n2, this.zzta, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzgb)) {
            return super.equals(object);
        }
        zzgb zzgb2 = (zzgb)object;
        if (this.size != zzgb2.size) {
            return false;
        }
        double[] dArray = zzgb2.zzta;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzta[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzta[i]);
            n = n * 31 + zzgt.zzab(l);
        }
        return n;
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Double)) {
            return -1;
        }
        double d = (Double)object;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzta[i] != d) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(double d) {
        this.zzdq();
        if (this.size == this.zzta.length) {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzta, 0, dArray, 0, this.size);
            this.zzta = dArray;
        }
        this.zzta[this.size++] = d;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzdq();
        zzgt.checkNotNull(collection);
        if (!(collection instanceof zzgb)) {
            return super.addAll(collection);
        }
        zzgb zzgb2 = (zzgb)collection;
        if (zzgb2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzgb2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzgb2.size;
        if (n > this.zzta.length) {
            this.zzta = Arrays.copyOf(this.zzta, n);
        }
        System.arraycopy(zzgb2.zzta, 0, this.zzta, this.size, zzgb2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzdq();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzta[i])) continue;
            System.arraycopy(this.zzta, i + 1, this.zzta, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzag(n));
        }
    }

    private final String zzag(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzgb zzgb2 = this;
        zzgb2.zzdq();
        zzgb2.zzaf(n);
        double d3 = zzgb2.zzta[n];
        zzgb2.zzta[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzgb zzgb2 = this;
        zzgb2.zzdq();
        zzgb2.zzaf(n);
        double d = zzgb2.zzta[n];
        if (n < zzgb2.size - 1) {
            System.arraycopy(zzgb2.zzta, n + 1, zzgb2.zzta, n, zzgb2.size - n - 1);
        }
        --zzgb2.size;
        ++zzgb2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzgb zzgb2 = this;
        zzgb2.zzdq();
        if (n < 0 || n > zzgb2.size) {
            throw new IndexOutOfBoundsException(zzgb2.zzag(n));
        }
        if (zzgb2.size < zzgb2.zzta.length) {
            System.arraycopy(zzgb2.zzta, n, zzgb2.zzta, n + 1, zzgb2.size - n);
        } else {
            double[] dArray = new double[zzgb2.size * 3 / 2 + 1];
            System.arraycopy(zzgb2.zzta, 0, dArray, 0, n);
            System.arraycopy(zzgb2.zzta, n, dArray, n + 1, zzgb2.size - n);
            zzgb2.zzta = dArray;
        }
        zzgb2.zzta[n] = d2;
        ++zzgb2.size;
        ++zzgb2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Double d = (Double)object;
        this.zzc(d);
        return true;
    }

    @Override
    public final /* synthetic */ zzgz zzah(int n) {
        int n2 = n;
        zzgb zzgb2 = this;
        if (n2 < zzgb2.size) {
            throw new IllegalArgumentException();
        }
        return new zzgb(Arrays.copyOf(zzgb2.zzta, n2), zzgb2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzgb zzgb2 = this;
        zzgb2.zzaf(n);
        return zzgb2.zzta[n];
    }

    static {
        zzsz.zzdp();
    }
}

