/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzex;
import com.google.android.gms.internal.vision.zzgt;
import com.google.android.gms.internal.vision.zzgz;
import com.google.android.gms.internal.vision.zzio;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzgu
extends zzex<Integer>
implements zzgz<Integer>,
zzio,
RandomAccess {
    private static final zzgu zzxl = new zzgu(new int[0], 0);
    private int[] zzxm;
    private int size;

    public static zzgu zzgl() {
        return zzxl;
    }

    zzgu() {
        this(new int[10], 0);
    }

    private zzgu(int[] nArray, int n) {
        this.zzxm = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzdq();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzxm, n2, this.zzxm, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzgu)) {
            return super.equals(object);
        }
        zzgu zzgu2 = (zzgu)object;
        if (this.size != zzgu2.size) {
            return false;
        }
        int[] nArray = zzgu2.zzxm;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzxm[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzxm[i];
        }
        return n;
    }

    public final int getInt(int n) {
        this.zzaf(n);
        return this.zzxm[n];
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Integer)) {
            return -1;
        }
        int n = (Integer)object;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (this.zzxm[i] != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzbm(int n) {
        this.zzdq();
        if (this.size == this.zzxm.length) {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzxm, 0, nArray, 0, this.size);
            this.zzxm = nArray;
        }
        this.zzxm[this.size++] = n;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzdq();
        zzgt.checkNotNull(collection);
        if (!(collection instanceof zzgu)) {
            return super.addAll(collection);
        }
        zzgu zzgu2 = (zzgu)collection;
        if (zzgu2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzgu2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzgu2.size;
        if (n > this.zzxm.length) {
            this.zzxm = Arrays.copyOf(this.zzxm, n);
        }
        System.arraycopy(zzgu2.zzxm, 0, this.zzxm, this.size, zzgu2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzdq();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzxm[i])) continue;
            System.arraycopy(this.zzxm, i + 1, this.zzxm, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzag(n));
        }
    }

    private final String zzag(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzgu zzgu2 = this;
        zzgu2.zzdq();
        zzgu2.zzaf(n);
        int n4 = zzgu2.zzxm[n];
        zzgu2.zzxm[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzgu zzgu2 = this;
        zzgu2.zzdq();
        zzgu2.zzaf(n);
        int n2 = zzgu2.zzxm[n];
        if (n < zzgu2.size - 1) {
            System.arraycopy(zzgu2.zzxm, n + 1, zzgu2.zzxm, n, zzgu2.size - n - 1);
        }
        --zzgu2.size;
        ++zzgu2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzgu zzgu2 = this;
        zzgu2.zzdq();
        if (n < 0 || n > zzgu2.size) {
            throw new IndexOutOfBoundsException(zzgu2.zzag(n));
        }
        if (zzgu2.size < zzgu2.zzxm.length) {
            System.arraycopy(zzgu2.zzxm, n, zzgu2.zzxm, n + 1, zzgu2.size - n);
        } else {
            int[] nArray = new int[zzgu2.size * 3 / 2 + 1];
            System.arraycopy(zzgu2.zzxm, 0, nArray, 0, n);
            System.arraycopy(zzgu2.zzxm, n, nArray, n + 1, zzgu2.size - n);
            zzgu2.zzxm = nArray;
        }
        zzgu2.zzxm[n] = n3;
        ++zzgu2.size;
        ++zzgu2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Integer n = (Integer)object;
        this.zzbm(n);
        return true;
    }

    @Override
    public final /* synthetic */ zzgz zzah(int n) {
        int n2 = n;
        zzgu zzgu2 = this;
        if (n2 < zzgu2.size) {
            throw new IllegalArgumentException();
        }
        return new zzgu(Arrays.copyOf(zzgu2.zzxm, n2), zzgu2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzxl.zzdp();
    }
}

