/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzfj;
import com.google.android.gms.internal.vision.zzfk;
import com.google.android.gms.internal.vision.zzfm;
import com.google.android.gms.internal.vision.zzfy;
import com.google.android.gms.internal.vision.zzgg;
import com.google.android.gms.internal.vision.zzgi;
import com.google.android.gms.internal.vision.zzgt;
import com.google.android.gms.internal.vision.zzgy;
import com.google.android.gms.internal.vision.zzgz;
import com.google.android.gms.internal.vision.zzhg;
import com.google.android.gms.internal.vision.zzhh;
import com.google.android.gms.internal.vision.zzho;
import com.google.android.gms.internal.vision.zzhv;
import com.google.android.gms.internal.vision.zzhy;
import com.google.android.gms.internal.vision.zzis;
import com.google.android.gms.internal.vision.zziw;
import com.google.android.gms.internal.vision.zzjx;
import com.google.android.gms.internal.vision.zzkf;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

final class zzfl
extends zzfj {
    private final boolean zzsj;
    private final byte[] buffer;
    private int pos;
    private final int zzsk;
    private int limit;
    private int tag;
    private int zzsl;

    public zzfl(ByteBuffer byteBuffer, boolean bl) {
        super(null);
        this.zzsj = true;
        this.buffer = byteBuffer.array();
        this.zzsk = this.pos = byteBuffer.arrayOffset() + byteBuffer.position();
        this.limit = byteBuffer.arrayOffset() + byteBuffer.limit();
    }

    private final boolean zzdu() {
        return this.pos == this.limit;
    }

    @Override
    public final int zzdv() throws IOException {
        if (this.zzdu()) {
            return Integer.MAX_VALUE;
        }
        this.tag = this.zzel();
        if (this.tag == this.zzsl) {
            return Integer.MAX_VALUE;
        }
        return this.tag >>> 3;
    }

    @Override
    public final int getTag() {
        return this.tag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean zzdw() throws IOException {
        if (this.zzdu() || this.tag == this.zzsl) {
            return false;
        }
        switch (this.tag & 7) {
            case 0: {
                zzfl zzfl2 = this;
                if (zzfl2.limit - zzfl2.pos >= 10) {
                    byte[] byArray = zzfl2.buffer;
                    int n = zzfl2.pos;
                    for (int i = 0; i < 10; ++i) {
                        if (byArray[n++] < 0) continue;
                        zzfl2.pos = n;
                        return true;
                    }
                } else {
                    zzfl zzfl3 = zzfl2;
                    for (int i = 0; i < 10; ++i) {
                        if (zzfl3.readByte() >= 0) return true;
                    }
                    throw zzhh.zzgp();
                }
            }
            case 1: {
                this.zzai(8);
                return true;
            }
            case 2: {
                this.zzai(this.zzel());
                return true;
            }
            case 5: {
                this.zzai(4);
                return true;
            }
            case 3: {
                zzfl zzfl4 = this;
                int n = zzfl4.zzsl;
                zzfl4.zzsl = zzfl4.tag >>> 3 << 3 | 4;
                while (zzfl4.zzdv() != Integer.MAX_VALUE && zzfl4.zzdw()) {
                }
                if (zzfl4.tag != zzfl4.zzsl) {
                    throw zzhh.zzgt();
                }
                zzfl4.zzsl = n;
                return true;
            }
        }
        throw zzhh.zzgs();
    }

    @Override
    public final double readDouble() throws IOException {
        this.zzak(1);
        return Double.longBitsToDouble(this.zzep());
    }

    @Override
    public final float readFloat() throws IOException {
        this.zzak(5);
        return Float.intBitsToFloat(this.zzeo());
    }

    @Override
    public final long zzdx() throws IOException {
        this.zzak(0);
        return this.zzem();
    }

    @Override
    public final long zzdy() throws IOException {
        this.zzak(0);
        return this.zzem();
    }

    @Override
    public final int zzdz() throws IOException {
        this.zzak(0);
        return this.zzel();
    }

    @Override
    public final long zzea() throws IOException {
        this.zzak(1);
        return this.zzep();
    }

    @Override
    public final int zzeb() throws IOException {
        this.zzak(5);
        return this.zzeo();
    }

    @Override
    public final boolean zzec() throws IOException {
        this.zzak(0);
        return this.zzel() != 0;
    }

    @Override
    public final String readString() throws IOException {
        return this.zzj(false);
    }

    @Override
    public final String zzed() throws IOException {
        return this.zzj(true);
    }

    private final String zzj(boolean bl) throws IOException {
        this.zzak(2);
        int n = this.zzel();
        if (n == 0) {
            return "";
        }
        this.zzaj(n);
        if (bl && !zzjx.zzf(this.buffer, this.pos, this.pos + n)) {
            throw zzhh.zzgu();
        }
        String string = new String(this.buffer, this.pos, n, zzgy.UTF_8);
        this.pos += n;
        return string;
    }

    @Override
    public final <T> T zza(Class<T> clazz, zzgi zzgi2) throws IOException {
        this.zzak(2);
        return this.zzb(zzis.zzhp().zzf(clazz), zzgi2);
    }

    @Override
    public final <T> T zza(zziw<T> zziw2, zzgi zzgi2) throws IOException {
        this.zzak(2);
        return this.zzb(zziw2, zzgi2);
    }

    private final <T> T zzb(zziw<T> zziw2, zzgi zzgi2) throws IOException {
        int n;
        int n2 = this.zzel();
        this.zzaj(n2);
        int n3 = this.limit;
        this.limit = n = this.pos + n2;
        try {
            T t = zziw2.newInstance();
            zziw2.zza(t, this, zzgi2);
            zziw2.zzh(t);
            if (this.pos != n) {
                throw zzhh.zzgt();
            }
            T t2 = t;
            return t2;
        }
        finally {
            this.limit = n3;
        }
    }

    @Override
    public final <T> T zzb(Class<T> clazz, zzgi zzgi2) throws IOException {
        this.zzak(3);
        return this.zzd(zzis.zzhp().zzf(clazz), zzgi2);
    }

    @Override
    public final <T> T zzc(zziw<T> zziw2, zzgi zzgi2) throws IOException {
        this.zzak(3);
        return this.zzd(zziw2, zzgi2);
    }

    private final <T> T zzd(zziw<T> zziw2, zzgi zzgi2) throws IOException {
        int n = this.zzsl;
        this.zzsl = this.tag >>> 3 << 3 | 4;
        try {
            T t = zziw2.newInstance();
            zziw2.zza(t, this, zzgi2);
            zziw2.zzh(t);
            if (this.tag != this.zzsl) {
                throw zzhh.zzgt();
            }
            T t2 = t;
            return t2;
        }
        finally {
            this.zzsl = n;
        }
    }

    @Override
    public final zzfm zzee() throws IOException {
        this.zzak(2);
        int n = this.zzel();
        if (n == 0) {
            return zzfm.zzsm;
        }
        this.zzaj(n);
        zzfm zzfm2 = this.zzsj ? zzfm.zzb(this.buffer, this.pos, n) : zzfm.zza(this.buffer, this.pos, n);
        this.pos += n;
        return zzfm2;
    }

    @Override
    public final int zzef() throws IOException {
        this.zzak(0);
        return this.zzel();
    }

    @Override
    public final int zzeg() throws IOException {
        this.zzak(0);
        return this.zzel();
    }

    @Override
    public final int zzeh() throws IOException {
        this.zzak(5);
        return this.zzeo();
    }

    @Override
    public final long zzei() throws IOException {
        this.zzak(1);
        return this.zzep();
    }

    @Override
    public final int zzej() throws IOException {
        this.zzak(0);
        return zzfy.zzav(this.zzel());
    }

    @Override
    public final long zzek() throws IOException {
        this.zzak(0);
        return zzfy.zzr(this.zzem());
    }

    @Override
    public final void zza(List<Double> list) throws IOException {
        if (list instanceof zzgg) {
            zzgg zzgg2 = (zzgg)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzel();
                    this.zzal(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgg2.zzc(Double.longBitsToDouble(this.zzer()));
                    }
                    break;
                }
                case 1: {
                    int n;
                    do {
                        zzgg2.zzc(this.readDouble());
                        if (this.zzdu()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzel() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhh.zzgs();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzel();
                this.zzal(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(Double.longBitsToDouble(this.zzer()));
                }
                break;
            }
            case 1: {
                int n;
                do {
                    list.add(this.readDouble());
                    if (this.zzdu()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzel() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhh.zzgs();
            }
        }
    }

    @Override
    public final void zzb(List<Float> list) throws IOException {
        if (list instanceof zzgt) {
            zzgt zzgt2 = (zzgt)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzel();
                    this.zzam(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgt2.zzu(Float.intBitsToFloat(this.zzeq()));
                    }
                    break;
                }
                case 5: {
                    int n;
                    do {
                        zzgt2.zzu(this.readFloat());
                        if (this.zzdu()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzel() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhh.zzgs();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzel();
                this.zzam(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(Float.valueOf(Float.intBitsToFloat(this.zzeq())));
                }
                break;
            }
            case 5: {
                int n;
                do {
                    list.add(Float.valueOf(this.readFloat()));
                    if (this.zzdu()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzel() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhh.zzgs();
            }
        }
    }

    @Override
    public final void zzc(List<Long> list) throws IOException {
        if (list instanceof zzhv) {
            zzhv zzhv2 = (zzhv)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzel();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzhv2.zzac(this.zzem());
                    }
                    this.zzan(n2);
                    return;
                }
                case 0: {
                    int n;
                    do {
                        zzhv2.zzac(this.zzdx());
                        if (this.zzdu()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzel() == this.tag);
                    this.pos = n;
                    return;
                }
            }
            throw zzhh.zzgs();
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzel();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzem());
                }
                this.zzan(n3);
                return;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzdx());
                    if (this.zzdu()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzel() == this.tag);
                this.pos = n;
                return;
            }
        }
        throw zzhh.zzgs();
    }

    @Override
    public final void zzd(List<Long> list) throws IOException {
        if (list instanceof zzhv) {
            zzhv zzhv2 = (zzhv)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzel();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzhv2.zzac(this.zzem());
                    }
                    this.zzan(n2);
                    return;
                }
                case 0: {
                    int n;
                    do {
                        zzhv2.zzac(this.zzdy());
                        if (this.zzdu()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzel() == this.tag);
                    this.pos = n;
                    return;
                }
            }
            throw zzhh.zzgs();
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzel();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzem());
                }
                this.zzan(n3);
                return;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzdy());
                    if (this.zzdu()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzel() == this.tag);
                this.pos = n;
                return;
            }
        }
        throw zzhh.zzgs();
    }

    @Override
    public final void zze(List<Integer> list) throws IOException {
        if (list instanceof zzgz) {
            zzgz zzgz2 = (zzgz)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzel();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgz2.zzbm(this.zzel());
                    }
                    this.zzan(n2);
                    return;
                }
                case 0: {
                    int n;
                    do {
                        zzgz2.zzbm(this.zzdz());
                        if (this.zzdu()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzel() == this.tag);
                    this.pos = n;
                    return;
                }
            }
            throw zzhh.zzgs();
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzel();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzel());
                }
                this.zzan(n3);
                return;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzdz());
                    if (this.zzdu()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzel() == this.tag);
                this.pos = n;
                return;
            }
        }
        throw zzhh.zzgs();
    }

    @Override
    public final void zzf(List<Long> list) throws IOException {
        if (list instanceof zzhv) {
            zzhv zzhv2 = (zzhv)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzel();
                    this.zzal(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzhv2.zzac(this.zzer());
                    }
                    break;
                }
                case 1: {
                    int n;
                    do {
                        zzhv2.zzac(this.zzea());
                        if (this.zzdu()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzel() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhh.zzgs();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzel();
                this.zzal(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzer());
                }
                break;
            }
            case 1: {
                int n;
                do {
                    list.add(this.zzea());
                    if (this.zzdu()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzel() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhh.zzgs();
            }
        }
    }

    @Override
    public final void zzg(List<Integer> list) throws IOException {
        if (list instanceof zzgz) {
            zzgz zzgz2 = (zzgz)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzel();
                    this.zzam(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgz2.zzbm(this.zzeq());
                    }
                    break;
                }
                case 5: {
                    int n;
                    do {
                        zzgz2.zzbm(this.zzeb());
                        if (this.zzdu()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzel() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhh.zzgs();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzel();
                this.zzam(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzeq());
                }
                break;
            }
            case 5: {
                int n;
                do {
                    list.add(this.zzeb());
                    if (this.zzdu()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzel() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhh.zzgs();
            }
        }
    }

    @Override
    public final void zzh(List<Boolean> list) throws IOException {
        if (list instanceof zzfk) {
            zzfk zzfk2 = (zzfk)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzel();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzfk2.addBoolean(this.zzel() != 0);
                    }
                    this.zzan(n2);
                    return;
                }
                case 0: {
                    int n;
                    do {
                        zzfk2.addBoolean(this.zzec());
                        if (this.zzdu()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzel() == this.tag);
                    this.pos = n;
                    return;
                }
            }
            throw zzhh.zzgs();
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzel();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzel() != 0);
                }
                this.zzan(n3);
                return;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzec());
                    if (this.zzdu()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzel() == this.tag);
                this.pos = n;
                return;
            }
        }
        throw zzhh.zzgs();
    }

    @Override
    public final void readStringList(List<String> list) throws IOException {
        this.zza(list, false);
    }

    @Override
    public final void zzi(List<String> list) throws IOException {
        this.zza(list, true);
    }

    private final void zza(List<String> list, boolean bl) throws IOException {
        int n;
        if ((this.tag & 7) != 2) {
            throw zzhh.zzgs();
        }
        if (list instanceof zzho && !bl) {
            int n2;
            zzho zzho2 = (zzho)list;
            do {
                zzho2.zzc(this.zzee());
                if (this.zzdu()) {
                    return;
                }
                n2 = this.pos;
            } while (this.zzel() == this.tag);
            this.pos = n2;
            return;
        }
        do {
            list.add(this.zzj(bl));
            if (this.zzdu()) {
                return;
            }
            n = this.pos;
        } while (this.zzel() == this.tag);
        this.pos = n;
    }

    @Override
    public final <T> void zza(List<T> list, zziw<T> zziw2, zzgi zzgi2) throws IOException {
        int n;
        if ((this.tag & 7) != 2) {
            throw zzhh.zzgs();
        }
        int n2 = this.tag;
        do {
            list.add(this.zzb(zziw2, zzgi2));
            if (this.zzdu()) {
                return;
            }
            n = this.pos;
        } while (this.zzel() == n2);
        this.pos = n;
    }

    @Override
    public final <T> void zzb(List<T> list, zziw<T> zziw2, zzgi zzgi2) throws IOException {
        int n;
        if ((this.tag & 7) != 3) {
            throw zzhh.zzgs();
        }
        int n2 = this.tag;
        do {
            list.add(this.zzd(zziw2, zzgi2));
            if (this.zzdu()) {
                return;
            }
            n = this.pos;
        } while (this.zzel() == n2);
        this.pos = n;
    }

    @Override
    public final void zzj(List<zzfm> list) throws IOException {
        int n;
        if ((this.tag & 7) != 2) {
            throw zzhh.zzgs();
        }
        do {
            list.add(this.zzee());
            if (this.zzdu()) {
                return;
            }
            n = this.pos;
        } while (this.zzel() == this.tag);
        this.pos = n;
    }

    @Override
    public final void zzk(List<Integer> list) throws IOException {
        if (list instanceof zzgz) {
            zzgz zzgz2 = (zzgz)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzel();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgz2.zzbm(this.zzel());
                    }
                    break;
                }
                case 0: {
                    int n;
                    do {
                        zzgz2.zzbm(this.zzef());
                        if (this.zzdu()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzel() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhh.zzgs();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzel();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzel());
                }
                break;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzef());
                    if (this.zzdu()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzel() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhh.zzgs();
            }
        }
    }

    @Override
    public final void zzl(List<Integer> list) throws IOException {
        if (list instanceof zzgz) {
            zzgz zzgz2 = (zzgz)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzel();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgz2.zzbm(this.zzel());
                    }
                    break;
                }
                case 0: {
                    int n;
                    do {
                        zzgz2.zzbm(this.zzeg());
                        if (this.zzdu()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzel() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhh.zzgs();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzel();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzel());
                }
                break;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzeg());
                    if (this.zzdu()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzel() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhh.zzgs();
            }
        }
    }

    @Override
    public final void zzm(List<Integer> list) throws IOException {
        if (list instanceof zzgz) {
            zzgz zzgz2 = (zzgz)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzel();
                    this.zzam(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgz2.zzbm(this.zzeq());
                    }
                    break;
                }
                case 5: {
                    int n;
                    do {
                        zzgz2.zzbm(this.zzeh());
                        if (this.zzdu()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzel() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhh.zzgs();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzel();
                this.zzam(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzeq());
                }
                break;
            }
            case 5: {
                int n;
                do {
                    list.add(this.zzeh());
                    if (this.zzdu()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzel() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhh.zzgs();
            }
        }
    }

    @Override
    public final void zzn(List<Long> list) throws IOException {
        if (list instanceof zzhv) {
            zzhv zzhv2 = (zzhv)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzel();
                    this.zzal(n);
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzhv2.zzac(this.zzer());
                    }
                    break;
                }
                case 1: {
                    int n;
                    do {
                        zzhv2.zzac(this.zzei());
                        if (this.zzdu()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzel() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhh.zzgs();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzel();
                this.zzal(n);
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(this.zzer());
                }
                break;
            }
            case 1: {
                int n;
                do {
                    list.add(this.zzei());
                    if (this.zzdu()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzel() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhh.zzgs();
            }
        }
    }

    @Override
    public final void zzo(List<Integer> list) throws IOException {
        if (list instanceof zzgz) {
            zzgz zzgz2 = (zzgz)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzel();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzgz2.zzbm(zzfy.zzav(this.zzel()));
                    }
                    break;
                }
                case 0: {
                    int n;
                    do {
                        zzgz2.zzbm(this.zzej());
                        if (this.zzdu()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzel() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhh.zzgs();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzel();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(zzfy.zzav(this.zzel()));
                }
                break;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzej());
                    if (this.zzdu()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzel() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhh.zzgs();
            }
        }
    }

    @Override
    public final void zzp(List<Long> list) throws IOException {
        if (list instanceof zzhv) {
            zzhv zzhv2 = (zzhv)list;
            switch (this.tag & 7) {
                case 2: {
                    int n = this.zzel();
                    int n2 = this.pos + n;
                    while (this.pos < n2) {
                        zzhv2.zzac(zzfy.zzr(this.zzem()));
                    }
                    break;
                }
                case 0: {
                    int n;
                    do {
                        zzhv2.zzac(this.zzek());
                        if (this.zzdu()) {
                            return;
                        }
                        n = this.pos;
                    } while (this.zzel() == this.tag);
                    this.pos = n;
                    return;
                }
                default: {
                    throw zzhh.zzgs();
                }
            }
            return;
        }
        switch (this.tag & 7) {
            case 2: {
                int n = this.zzel();
                int n3 = this.pos + n;
                while (this.pos < n3) {
                    list.add(zzfy.zzr(this.zzem()));
                }
                break;
            }
            case 0: {
                int n;
                do {
                    list.add(this.zzek());
                    if (this.zzdu()) {
                        return;
                    }
                    n = this.pos;
                } while (this.zzel() == this.tag);
                this.pos = n;
                return;
            }
            default: {
                throw zzhh.zzgs();
            }
        }
    }

    @Override
    public final <K, V> void zza(Map<K, V> map, zzhy<K, V> zzhy2, zzgi zzgi2) throws IOException {
        int n;
        this.zzak(2);
        int n2 = this.zzel();
        this.zzaj(n2);
        int n3 = this.limit;
        this.limit = n = this.pos + n2;
        try {
            int n4;
            Object object = zzhy2.zzzc;
            Object object2 = zzhy2.zzgl;
            block9: while ((n4 = this.zzdv()) != Integer.MAX_VALUE) {
                try {
                    switch (n4) {
                        case 1: {
                            object = this.zza(zzhy2.zzzb, null, null);
                            continue block9;
                        }
                        case 2: {
                            object2 = this.zza(zzhy2.zzzd, zzhy2.zzgl.getClass(), zzgi2);
                            continue block9;
                        }
                    }
                    if (this.zzdw()) continue;
                    throw new zzhh("Unable to parse map entry.");
                }
                catch (zzhg zzhg2) {
                    if (this.zzdw()) continue;
                    throw new zzhh("Unable to parse map entry.");
                }
            }
            map.put(object, object2);
            return;
        }
        finally {
            this.limit = n3;
        }
    }

    private final Object zza(zzkf zzkf2, Class<?> clazz, zzgi zzgi2) throws IOException {
        switch (zzkf2) {
            case zzaci: {
                return this.zzec();
            }
            case zzacm: {
                return this.zzee();
            }
            case zzacb: {
                return this.readDouble();
            }
            case zzaco: {
                return this.zzeg();
            }
            case zzach: {
                return this.zzeb();
            }
            case zzacg: {
                return this.zzea();
            }
            case zzacc: {
                return Float.valueOf(this.readFloat());
            }
            case zzacf: {
                return this.zzdz();
            }
            case zzacd: {
                return this.zzdy();
            }
            case zzacl: {
                return this.zza(clazz, zzgi2);
            }
            case zzacp: {
                return this.zzeh();
            }
            case zzacq: {
                return this.zzei();
            }
            case zzacr: {
                return this.zzej();
            }
            case zzacs: {
                return this.zzek();
            }
            case zzacj: {
                return this.zzj(true);
            }
            case zzacn: {
                return this.zzef();
            }
            case zzace: {
                return this.zzdx();
            }
        }
        throw new RuntimeException("unsupported field type.");
    }

    private final int zzel() throws IOException {
        int n;
        int n2 = this.pos;
        if (this.limit == this.pos) {
            throw zzhh.zzgn();
        }
        if ((n = this.buffer[n2++]) >= 0) {
            this.pos = n2;
            return n;
        }
        if (this.limit - n2 < 9) {
            return (int)this.zzen();
        }
        if ((n ^= this.buffer[n2++] << 7) < 0) {
            n ^= 0xFFFFFF80;
        } else if ((n ^= this.buffer[n2++] << 14) >= 0) {
            n ^= 0x3F80;
        } else if ((n ^= this.buffer[n2++] << 21) < 0) {
            n ^= 0xFFE03F80;
        } else {
            byte by = this.buffer[n2++];
            n = n ^ by << 28 ^ 0xFE03F80;
            if (by < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0 && this.buffer[n2++] < 0) {
                throw zzhh.zzgp();
            }
        }
        this.pos = n2;
        return n;
    }

    private final long zzem() throws IOException {
        long l;
        int n;
        int n2 = this.pos;
        if (this.limit == n2) {
            throw zzhh.zzgn();
        }
        byte[] byArray = this.buffer;
        if ((n = this.buffer[n2++]) >= 0) {
            this.pos = n2;
            return n;
        }
        if (this.limit - n2 < 9) {
            return this.zzen();
        }
        if ((n ^= byArray[n2++] << 7) < 0) {
            l = n ^ 0xFFFFFF80;
        } else if ((n ^= byArray[n2++] << 14) >= 0) {
            l = n ^ 0x3F80;
        } else if ((n ^= byArray[n2++] << 21) < 0) {
            l = n ^ 0xFFE03F80;
        } else if ((l = (long)n ^ (long)byArray[n2++] << 28) >= 0L) {
            l ^= 0xFE03F80L;
        } else if ((l ^= (long)byArray[n2++] << 35) < 0L) {
            l ^= 0xFFFFFFF80FE03F80L;
        } else if ((l ^= (long)byArray[n2++] << 42) >= 0L) {
            l ^= 0x3F80FE03F80L;
        } else if ((l ^= (long)byArray[n2++] << 49) < 0L) {
            l ^= 0xFFFE03F80FE03F80L;
        } else if ((l = l ^ (long)byArray[n2++] << 56 ^ 0xFE03F80FE03F80L) < 0L && (long)byArray[n2++] < 0L) {
            throw zzhh.zzgp();
        }
        this.pos = n2;
        return l;
    }

    private final long zzen() throws IOException {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            byte by = this.readByte();
            l |= (long)(by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            return l;
        }
        throw zzhh.zzgp();
    }

    private final byte readByte() throws IOException {
        if (this.pos == this.limit) {
            throw zzhh.zzgn();
        }
        return this.buffer[this.pos++];
    }

    private final int zzeo() throws IOException {
        this.zzaj(4);
        return this.zzeq();
    }

    private final long zzep() throws IOException {
        this.zzaj(8);
        return this.zzer();
    }

    private final int zzeq() {
        int n = this.pos;
        byte[] byArray = this.buffer;
        this.pos = n + 4;
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    private final long zzer() {
        int n = this.pos;
        byte[] byArray = this.buffer;
        this.pos = n + 8;
        return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
    }

    private final void zzai(int n) throws IOException {
        this.zzaj(n);
        this.pos += n;
    }

    private final void zzaj(int n) throws IOException {
        if (n < 0 || n > this.limit - this.pos) {
            throw zzhh.zzgn();
        }
    }

    private final void zzak(int n) throws IOException {
        if ((this.tag & 7) != n) {
            throw zzhh.zzgs();
        }
    }

    private final void zzal(int n) throws IOException {
        this.zzaj(n);
        if ((n & 7) != 0) {
            throw zzhh.zzgt();
        }
    }

    private final void zzam(int n) throws IOException {
        this.zzaj(n);
        if ((n & 3) != 0) {
            throw zzhh.zzgt();
        }
    }

    private final void zzan(int n) throws IOException {
        if (this.pos != n) {
            throw zzhh.zzgn();
        }
    }
}

